<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: modify.php,v 1.14 2004/02/05 16:31:50 lseeker Exp $
 */

require 'lib/admin.inc'; // 관리자 환경설정
include 'lib/headfoot.inc'; // 페이지 상/하단부
include 'lib/list.inc'; // 글 목록 function
include 'lib/message.inc'; // 메시지 function

PrintHeader();

if(empty($_GET['article_no'])) {
    PrintMessage("<b>게시물 정보가 없습니다.</b><br>modify.php?article_no=[번호] 식으로 입력하세요.", "error");
    PrintFooter();
    exit;
}

$article_no = (int) $_GET['article_no'];
/* 게시물 정보 읽어오기 (...재미있는 기능도 좀 있고 해서 -_-a) */
if ( ($result = &DB::query("SELECT idx, name, email, home, ipaddr, date, cfile, subject, ment, deleted, reply, agent FROM hboard_db_article WHERE idx={$article_no}", $dbconn)) === FALSE) {
    /* TODO 에러메세지 변경 */
    die('글 가져오기 실패');
}

$article = &DB::fetch($result);
DB::free($result);

/* 게시물 삭제여부 체크, 이상없으면 수정폼 보이기 */
if($article['deleted'] == "t") {
    PrintMessage("게시물이 이미 삭제된 상태입니다.", "error");
    PrintFooter();
    exit;
}

/* {{{ 글수정 폼 */
?>
<form method="post" action="post_modify.php" enctype="multipart/form-data" onsubmit="return checkform_article(this, 0);">
<table align="center" cellpadding="1" cellspacing="0">
 <tr>
  <td colspan="2" style="background-image: url('skin/<?php echo $admin_data['skin']; ?>/title_bg.gif'); border: 2px outset; color: <?php echo $skin['sfont2_color']; ?>; font-weight: bold">
   <input type="hidden" name="article_no" value="<?php echo $article_no; ?>" />
   <input type="hidden" name="page" value="<?php echo (int) $_GET['page']; ?>" />
   <img src="skin/<?php echo $admin_data['skin']; ?>/write.gif" width="14" height="20" alt="write.gif" style="border: 0px; vertical-align: middle" />
   <?php echo $article_no; ?>번 게시물 수정하기..
  </td>
 </tr>
 <tr>
  <td style="background-color: <?php echo $skin['image_table_bgcolor']; ?>; border-style: outset; border-width: 0px 1px 1px 1px; padding: 2px 4px">
   <table cellpadding="1" cellspacing="0">
    <tr>
     <td>Name</td>
     <td><input type="text" name="name" size="20" maxlength="30" value="<?php echo htmlspecialchars($article['name']); ?>" /></td>
    </tr>
    <tr>
     <td>Mail</td>
     <td><input type="text" name="email" size="32" maxlength="100" value="<?php echo htmlspecialchars($article['email']); ?>" /></td>
    </tr>
    <tr>
     <td>URL(*)</td>
     <td><input type="text" name="homepage" size="32" maxlength="255" value="<?php echo htmlspecialchars($article['home']); ?>" /></td>
    </tr>
    <tr>
     <td>File</td>
     <td>
      <input type="file" name="picture" size="12" maxlength="255" onchange="preview_upload(this.value);" onblur="preview_upload(this.value);" />
      (파일 수정시에만)
      </span>
     </td>
    </tr>
    <tr>
     <td>Password</td>
     <td>
<?php
if (!$admin['login']) {
    echo '<input type="password" name="passwd" size="9" maxlength="30" /> <span style="font-size: xx-small">(글 작성시 입력하였던 비밀번호)</span>';
} else {
    echo '<span style=\"font-size: xx-small\">(관리자 로그인 상태)</span>';
}
?>
    </tr>
    <tr>
     <td>Title</td>
     <td><input type="text" name="title" size="32" maxlength="255" value="<?php echo htmlspecialchars($article['subject']); ?>" /></td>
    </td>
    <tr>
     <td colspan="2"><textarea name="ne" rows="7" cols="45"><?php echo htmlspecialchars($article['ment']); ?></textarea></td>
    </tr>
    <tr>
     <td colspan="2" align="center">
      <input name="submit_btn" type="submit" value="Submit" accesskey="s" />
      <input type="reset" value="Reset" />
      <a href="list.php?page=<?php echo intval($_GET['page']) . '#' . $article_no; ?>">[되돌아가기]</a>
     </td>
    </tr>
   </table>
  </td>
  <td valign="middle" style="background-color: <?php echo $skin['image_table_bgcolor']; ?>; border-style: outset; border-width: 0px 1px 1px 1px; padding: 2px 4px">
   <div id="d_pic" style="width: 320px; height: 240px; overflow: hidden; text-align: center">
    <img id="pic" src="skin/<?php echo $admin_data['skin']?>/preview.jpg" alt="Preview" style="border: 0px" />
   </div>
  </td>
 </tr>
</table>
</form>
<?php
/* }}} */

PrintArticle($article, FALSE);
DB::close($dbconn);
PrintFooter();
?>
