<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: post_comment.php,v 1.24 2004/02/24 11:03:05 lseeker Exp $
 */

require 'lib/admin.inc'; // 관리자 환경설정
include 'lib/headfoot.inc'; // 페이지 상/하단
include 'lib/message.inc'; // 메시지 function

// 공백 처리: ^^+
$name     = &remove_space($_POST['name']);
$homepage = &remove_space($_POST['homepage']);
$email    = &remove_space($_POST['email']);

/* {{{ */
if (get_magic_quotes_gpc()) {
    $name     = stripslashes($name);
    $email    = stripslashes($email);
    $homepage = stripslashes($homepage);
    $icon     = stripslashes($_POST['icon']);
} else {
    $_POST['ne'] = addslashes($_POST['ne']);
    $icon = $_POST['icon'];
}
/* }}} */

if($name == "" || empty($icon) || empty($_POST['ne']) || empty($_POST['passwd'])) {
    PrintHeader();
    PrintMessage("<b>데이터가 모두 전송되지 않았습니다.</b><br>※ 필요한 폼에 데이터를 모두 채워주세요.", "error");
    PrintFooter();
    exit;
}

/* 전부 정상이라면.. */

$article_no = (int) $_POST['article']; // 메시지 function을 위한..

/* {{{ 쿠키 설정 */
$c_time = time() + 2592000;
setcookie('etchibbs_name', $name,     $c_time);
setcookie('etchibbs_mail', $email,    $c_time);
setcookie('etchibbs_home', $homepage, $c_time);
if (strcmp($icon, 'none.jpg')) {
    setcookie('etchibbs_icon', $icon, $c_time);
} else {
    setcookie('etchibbs_icon', '');
}
/* }}} */

PrintHeader();

if(!strcmp($homepage, 'http://')) {
    $homepage = ''; // http://일 경우 홈페이지 비우기
}

mt_srand(microtime() * 1e6);
$salt = chr(mt_rand(0x21, 0x7E)) . chr(mt_rand(0x21, 0x7E));
$passwd = addslashes(crypt($_POST['passwd'], $salt));
$now_date = date('Y/m/d H:i:s');

/* 커멘트 카운터 읽기/쓰기 */
ignore_user_abort(TRUE);
DB::begin($dbconn, TRUE);
$cmtcount = &DB::result(DB::query("SELECT reply+1 FROM hboard_db_article WHERE idx='{$article_no}' FOR UPDATE", $dbconn), 0, 0);

if ($cmtcount === FALSE) {
    // v1.0.2b 패치 - 해당 게시물에 reply 정보가 없을 경우
    DB::close($dbconn);
    PrintMessage("해당 게시물({$article_no})을 찾을 수 없습니다.<br>해당 게시물이 올바르게 등록되어 있는지 확인해 주세요.", "error");
    PrintFooter();
    exit;
}

DB::query("UPDATE hboard_db_article SET reply=reply+1 WHERE idx='{$article_no}'", $dbconn);
DB::commit($dbconn, TRUE);

// 사용자 agent, IP 주소 구하기
$user_agent = addslashes($_SERVER['HTTP_USER_AGENT']);
$ip_addr    = $_SERVER['REMOTE_ADDR'];

$name     = addslashes($name);
$email    = addslashes($email);
$homepage = addslashes($homepage);
$icon     = addslashes($icon);

// 테이블에 처박기 (hboard_db_comment)
DB::query("INSERT into hboard_db_comment VALUES ('{$cmtcount}', '{$article_no}',
        '{$name}', '{$email}', '{$homepage}', '{$icon}', '{$ip_addr}', '{$passwd}',
        '{$now_date}', '{$_POST['ne']}', 'f', '{$user_agent}')", $dbconn);

$page = (int) $_POST['page'];
PrintMessage("{$article_no}번 게시물에 의견을 추가하였습니다.", "notice");
DB::close($dbconn);

PrintFooter();
?>
