<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: layout.php,v 1.1 2004/03/23 16:41:36 lseeker Exp $
 */

class Layout
{
    var $top;
    var $bottom;
    var $skin_path;
    var $title;
    var $bgimage_css;
    var $top_text;

    function Layout(&$conf)
    {
        if (!file_exists("skin/{$conf['skin']}/style.php")) {
            die("지정하신 스킨을 skin/ 디렉토리에서 찾을 수 없습니다.<br />[<a href=\"config.php?from=./list.php\" target=\"_blank\">관리자 모드에서 스킨을 바꿔주세요.</a>]");
        }

        header("Content-Type: text/html; charset=UTF-8");

        $this->skin_path = "skin/{$conf['skin']}/";
        $this->top       =& $conf['include_top'];
        $this->bottom    =& $conf['include_bottom'];
        $this->top_text  =& $conf['title_text'];

        if (empty($conf['titlebar'])) {
            $this->title = 'EtchiBBS ' . __VERSION__ . ' :: ' . strtoupper(basename($_SERVER['PHP_SELF'], '.php'));
        } else {
            $this->title =& $conf['titlebar'];
        }

        $this->bgimage_css = empty($conf['bgimage']) ? '' : "background-image: url('{$conf['bgimage']}'); ";
    }

    function hideText()
    {
        $this->top_text = '';
    }

    function hideInclude()
    {
        $this->top    = '';
        $this->bottom = '';
    }

    function printHeader()
    {
        include $this->skin_path . 'style.php';

        if (!empty($this->top)) include $this->top;

        echo <<<HEADHTML1
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
 <title>{$this->title}</title>
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
 <link href="etchibbs.css" rel="stylesheet" type="text/css">
 <style type="text/css">
body { {$this->bgimage_css}background-color: {$skin['body_bgcolor']}; color: {$skin['text_color']} }
a:link    { color: {$skin['link_color']} }
a:visited { color: {$skin['link_color']} }
a:active  { color: {$skin['link_color']} }
hr { background-color: {$skin['hr_color']}; color: {$skin['hr_color']} }

.bgTitle { background-image: url('{$this->skin_path}title_bg.gif') }
.bgImage { background-color: {$skin['image_table_bgcolor']} }
.bgText  { background-color: {$skin['text_table_bgcolor']} }
.fgMent  { color: {$skin['ment_fontcolor']} }
.fgSpc1  { color: {$skin['sfont1_color']} }
.fgSpc2  { color: {$skin['sfont2_color']} }
 </style>
HEADHTML1;

        PrintCSS();

    echo <<<HEADHTML2
 <script type="text/javascript">
<!--
var skin_path = '{$this->skin_path}';
//-->
 </script>
 <script type="text/javascript" src="etchibbs.js"></script>
</head>
<body>
{$this->top_text}
HEADHTML2;
    }

    function printFooter()
    {
        $design_data = file($this->skin_path . 'designed_by.txt');
        $designer['name'] = trim($design_data[0]);
        $designer['url']  = trim($design_data[1]);
        $version = __VERSION__;

        echo <<<BBSINFO
 <address id="hbCopyright" class="bgImage">
  EtchiBBS {$version} <a href="LICENSE">&copy;</a> 2004 <a href="http://etchibbs.kldp.net">EtchiBoard Project</a><br />
  Skin designed by <a href="{$designer['url']}">{$designer['name']}</a>
 </address>
BBSINFO;

        if (!empty($this->bottom)) include $this->bottom;

        echo "</body>\n</html>\n";
    }
}

?>
