<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: list.class.php,v 1.9 2004/03/16 02:54:08 lseeker Exp $
 */

/* {{{ ToolBox class */
class ToolBox {
    var $nowpage;
    var $content   = '';
    var $admintool = FALSE;

    function ToolBox() {
        $this->nowpage = rawurlencode($_SERVER['REQUEST_URI']);
    }

    function registerContent($content) {
        $this->content =& $content;
    }

    function showAdminTools() {
        $this->admintool = TRUE;
    }

    function printOut() {
        $TBoxSkin = __SKIN__;

        /* XXX HTML 분리/정리 */
        echo <<<TOOLBOX
<div id="hbTBox">
 <div class="bgImage hbMain">
  <img src="skin/{$TBoxSkin}/info.jpg" alt="Info" class="left" />
  <div class="Tools">
   <a href="#search" title="검색"><img src="skin/{$TBoxSkin}/search.jpg" alt="검색" /></a>\n
TOOLBOX;

        if ($this->admintool) {
            $dblencoded = rawurlencode($this->nowpage);
            echo <<<ADMINTOOLS
   <a href="javascript: Openwindow('hb_config', 'config.php?from={$dblencoded}', 30, 30, 700, 610, 0, 0, 0, 1, 1)" title="게시판 환경 설정"><img src="skin/{$TBoxSkin}/config.jpg" alt="게시판 환경 설정" /></a>
   <a href="javascript:Openwindow('hb_iconman', 'iconman.php', 60, 60, 610, 400, 0, 0, 0, 1, 1)" title="아이콘 관리자"><img src="skin/{$TBoxSkin}/addicon.jpg" alt="아이콘 관리자" /></a>
   <a href="admin.php?from={$this->nowpage}" title="관리자 로그아웃"><img src="skin/{$TBoxSkin}/logout.jpg" alt="관리자 로그아웃" /></a>
ADMINTOOLS;
        } else {
            echo "<a href=\"admin.php?from={$this->nowpage}\" title=\"관리자 로그인\"><img src=\"skin/{$TBoxSkin}/login.jpg\" alt=\"관리자 로그인\" /></a>";
        }

        echo "</div>{$this->content}</div></div>";
    }
}
/* }}} */

/* {{{ SearchForm class */
class SearchForm {
    var $word = '';

    var $name    = '';
    var $subject = '';
    var $content = '';
    var $image   = '';

    function registerWord($word) {
        $this->word = htmlspecialchars($word);
    }

    function registerType($type) {
        if (!isset($this->$type)) trigger_error("Invalid SearchForm check type {$type}", E_USER_ERROR);

        $this->$type = ' selected="selected"';
    }

    function printOut() {
        $SFormSkin = __SKIN__;

        echo <<<SEARCHFORM
<form action="search.php" onsubmit="return checkform_search(this);">
 <div id="search">
  <table align="center" cellpadding="2" cellspacing="2" class="bgImage">
   <tr>
    <td align="right"><img src="skin/{$SFormSkin}/search.jpg" alt="검색" /></td>
    <td>
     <select name="type" size="1">
      <option value="name"{$this->name}>작성자</option>
      <option value="subject"{$this->subject}>글 제목</option>
      <option value="content"{$this->content}>글 내용</option>
      <option value="image"{$this->image}>파일 이름</option>
     </select>
     <input type="text" name="word" value="{$this->word}" maxlength="50" size="15" />
     <input type="submit" value="검색" />
    </td>
   </tr>
  </table>
 </div>
</form>
SEARCHFORM;
    }
}
/* }}} */

/* {{{ Paging class */
class Paging {
    var $total_num = 0;
    var $per_page  = 5;
    var $link_address = NULL;

    var $now_page   = 1;
    var $show_count = 9;
    var $show_stat  = TRUE;

    var $btn_first = '|';
    var $btn_last  = '|';
    var $btn_prev  = '◁';
    var $btn_next  = '▷';

    function registerAddress($address) {
        $this->link_address =& $address;
    }

    function registerTotalNum($total) {
        $this->total_num = (int) $total;
        if ($this->total_num < 0) trigger_error("Invalid Paging TotalNum {$this->total_num}", E_USER_ERROR);
    }

    function registerNumPerPage($app) {
        $this->per_page = (int) $app;
        if ($this->per_page < 1) trigger_error("Invalid Paging NumPerPage {$this->per_page}", E_USER_ERROR);
    }

    function registerNowPage($page) {
        $this->now_page = (int) $page;
    }

    function hideStats() {
        $this->show_stat = FALSE;
    }

    function registerButton($first, $prev, $next, $last) {
        $this->btn_first =& $first;
        $this->btn_prev  =& $prev;
        $this->btn_next  =& $next;
        $this->btn_last  =& $last;
    }

    function registerCount($n) {
        $this->show_count = (int) $n;
    }

    function printOut() {
        /* {{{ 페이지 구하기 */
        if ($this->now_page < 1) $this->now_page = 1;
        $total_p = (int) (($this->total_num + $this->per_page - 1) / $this->per_page);
        if ($total_p <= 0) $total_p = 1;
        if ($this->now_page > $total_p) $this->now_page = $total_p;
        /* }}} */

        echo '<div id="Paging">';

        if ($this->show_stat) echo "현재 <span class=\"StatNow\">{$this->now_page}</span> 페이지 <span class=\"StatDiv\">/</span> 전체 <span class=\"StatTotal\">{$total_p}</span> 페이지<br />";

        echo $this->now_page == 1 ? "<span class=\"BtnNonActive\">{$this->btn_first}</span> <span class=\"BtnNonActive\">{$this->btn_prev}</span> " : "<a href=\"{$this->link_address}1\" title=\"처음 페이지\">{$this->btn_first}</a> <a href=\"{$this->link_address}" . ($this->now_page - 1) . "\" title=\"이전 페이지\">{$this->btn_prev}</a> ";

        if ($total_p >= $this->show_count) {
            $range = (int) ($this->show_count / 2); 
            if ($this->now_page <= $range) {
                for ($i = 1; $i <= $this->show_count; $i++) echo $this->now_page == $i ? "<span class=\"PageNow\">[{$i}]</span> " : "<a href=\"{$this->link_address}{$i}\">[{$i}]</a> ";
            } elseif ($this->now_page >= $total_p - $range) {
                for ($i = $total_p - $this->show_count + 1; $i <= $total_p; $i++) echo $this->now_page == $i ? "<span class=\"PageNow\">[{$i}]</span> " : "<a href=\"{$this->link_address}{$i}\">[{$i}]</a> ";
            } else {
                $end = $this->now_page + $range + 1;
                for ($i = $this->now_page - $this->show_count + $range + 1; $i < $end; $i++) echo $this->now_page == $i ? "<span class=\"PageNow\">[{$i}]</span> " : "<a href=\"{$this->link_address}{$i}\">[{$i}]</a> ";
            }
        } else {
            for ($i = 1; $i <= $total_p; $i++) echo $this->now_page == $i ? "<span class=\"PageNow\">[{$i}]</span> " : "<a href=\"{$this->link_address}{$i}\">[{$i}]</a> ";
        }

        echo $this->now_page == $total_p ? "<span class=\"BtnNonActive\">{$this->btn_next}</span> <span class=\"BtnNonActive\">{$this->btn_last}</span>" : "<a href=\"{$this->link_address}" . ($this->now_page + 1) . "\" title=\"다음 페이지\">{$this->btn_next}</a> <a href=\"{$this->link_address}{$total_p}\" title=\"마지막 페이지\">{$this->btn_last}</a>";

        echo '</div>';
    }
}
/* }}} */

?>
