/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: etchibbs.js,v 1.12 2004/02/05 16:31:50 lseeker Exp $
 */

/* {{{ check form */
function checkform_article(form, is_new) {
    if (form.name.value == '') {
        alert('작성자의 이름을 기입해주세요.');
        form.name.focus();
        return false;
    }

    if (is_new && form.picture.value == '') {
        alert('업로드할 그림을 지정해주세요.');
        form.picture.focus();
        return false;
    }

    if (form.passwd && form.passwd.value == ''){
        alert('비밀번호를 입력해주세요.');
        form.passwd.focus();
        return false;
    }

    if (form.ne.value == ''){
        alert('게시물의 설명이나 글의 내용을 입력해주세요.');
        form.ne.focus();
        return false;
    }

    form.submit_btn.disabled = 'disabled';
    return true;
}

function checkform_comment(form) {
    if (form.name.value == ''){
        alert('작성자의 이름을 기입해 주세요.');
        form.name.focus();
        return false;
    }

    if (form.ne.value == ''){
        alert('의견글의 내용을 입력해 주세요.');
        form.ne.focus();
        return false;
    }

    if (form.passwd.value == ''){
        alert('비밀번호를 입력해 주세요.');
        form.passwd.focus();
        return false;
    }

    form.submit_btn.disabled = 'disabled';
    return true;
}

function checkform_search(form) {
    if (form.search_word.value == ''){
        alert('검색어를 입력해 주세요.');
        form.search_word.focus();
        return false;
    }

    return true;
}
/* }}} */

/* {{{ upload preview */
var preview_before = '';

function preview_upload(file) {
    if (preview_before == file) return;

    preview_before = file;

    document.getElementById('d_pic').innerHTML = '<img alt="Preview" id="pic" src="file://' + file + '" style="border: 0px; visibility: hidden" />';
    window.setTimeout('preview_resize()', 1000);
}

function preview_resize() {
    obj = document.getElementById('pic');
    if (obj.width > 320 && obj.width > obj.height) {
        obj.height = parseInt(320 / obj.width * obj.height);
        obj.width  = 320;
    } else if (obj.height > 240) {
        obj.width  = parseInt(240 / obj.height * obj.width);
        obj.height = 240;
    }
    obj.style.visibility = 'visible';
}
/* }}} */

/* {{{ icon preview */
function preview_icon(src, dst) {
    if (src == 'none.jpg') {
        dst.src = skin_path + src;
    } else {
        dst.src = 'db/ico/' + src;
    }
}
/* }}} */

/* {{{ open new window */
function Openwindow(name, url, left, top, width, height, toolbar, menubar, statusbar, scrollbar, resizable) {
    // script from Namo Webeditor
    toolbar_str = toolbar ? 'yes' : 'no';
    menubar_str = menubar ? 'yes' : 'no';
    statusbar_str = statusbar ? 'yes' : 'no';
    scrollbar_str = scrollbar ? 'yes' : 'no';
    resizable_str = resizable ? 'yes' : 'no';
    window.open(url, name, 'left='+left+',top='+top+',width='+width+',height='+height+',toolbar='+toolbar_str+',menubar='+menubar_str+',status='+statusbar_str+',scrollbars='+scrollbar_str+',resizable='+resizable_str);
}
/* }}} */

