/*
 * Decompiled with CFR 0.152.
 */
package org.archi.tools.excatj;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import java.util.HashMap;
import java.util.Map;
import org.archi.tools.excatj.Env;
import org.archi.tools.excatj.EventNotifier;
import org.archi.tools.excatj.MessageOutput;
import org.archi.tools.excatj.ThreadInfo;
import org.archi.tools.excatj.ThreadTrace;
import org.archi.tools.excatj.TraceOutput;

public class ApplicationTrace
implements EventNotifier {
    static String nextBaseIndent = "";
    private final TraceOutput appTraceLog;
    private Map traceMap = new HashMap();

    public ApplicationTrace() {
        this.appTraceLog = new TraceOutput(this);
        this.appTraceLog.println("ExCatJLogo", new Object[]{"ExCatJ", 0, 3, "Yi, Chai-Sung"});
        this.appTraceLog.printDirectln(Env.connection().description());
    }

    public void applicationResume() {
        if (ThreadInfo.getCurrentThreadInfo() == null) {
            MessageOutput.printDirectln("Nothing suspended.");
            return;
        }
        ThreadInfo.invalidateAll();
        Env.vm().resume();
    }

    public void breakpointEvent(BreakpointEvent event) {
        Thread.yield();
        this.threadTrace(event.thread()).breakpointEvent(event);
    }

    public void classPrepareEvent(ClassPrepareEvent event) {
    }

    public void classUnloadEvent(ClassUnloadEvent event) {
        this.appTraceLog.printDirectln("-- Class Unload Event --");
    }

    private ThreadReference eventThread(Event event) {
        if (event instanceof ClassPrepareEvent) {
            return ((ClassPrepareEvent)event).thread();
        }
        if (event instanceof LocatableEvent) {
            return ((LocatableEvent)event).thread();
        }
        if (event instanceof ThreadStartEvent) {
            return ((ThreadStartEvent)event).thread();
        }
        if (event instanceof ThreadDeathEvent) {
            return ((ThreadDeathEvent)event).thread();
        }
        if (event instanceof VMStartEvent) {
            return ((VMStartEvent)event).thread();
        }
        return null;
    }

    public void exceptionEvent(ExceptionEvent event) {
        Thread.yield();
        ThreadTrace trace = this.threadTrace(event.thread());
        if (trace != null) {
            trace.exceptionEvent(event);
        }
    }

    public void fieldWatchEvent(WatchpointEvent event) {
    }

    public void methodEntryEvent(MethodEntryEvent event) {
        Thread.yield();
        this.threadTrace(event.thread()).methodEntryEvent(event);
    }

    public void methodExitEvent(MethodExitEvent event) {
        Thread.yield();
        this.threadTrace(event.thread()).methodExitEvent(event);
    }

    public void receivedEvent(Event event) {
        this.setCurrentThread(this.eventThread(event));
    }

    private void setCurrentThread(EventSet set) {
        ThreadReference thread;
        if (set.size() > 0) {
            Event event = (Event)set.iterator().next();
            thread = this.eventThread(event);
        } else {
            thread = null;
        }
        this.setCurrentThread(thread);
    }

    private void setCurrentThread(ThreadReference thread) {
        ThreadInfo.invalidateAll();
        ThreadInfo.setCurrentThread(thread);
    }

    public void stepEvent(StepEvent event) {
    }

    public void threadDeathEvent(ThreadDeathEvent event) {
        ThreadInfo.removeThread(event.thread());
        ThreadTrace trace = (ThreadTrace)this.traceMap.get(event.thread());
        if (trace != null) {
            trace.threadDeathEvent(event);
            this.traceMap.remove(event.thread());
        }
    }

    public void threadStartEvent(ThreadStartEvent event) {
        ThreadInfo.addThread(event.thread());
        this.threadTrace(event.thread());
    }

    ThreadTrace threadTrace(ThreadReference thread) {
        ThreadTrace trace = (ThreadTrace)this.traceMap.get(thread);
        if (trace == null) {
            trace = new ThreadTrace(thread, nextBaseIndent, this.appTraceLog);
            ThreadInfo.addThread(thread);
            this.traceMap.put(thread, trace);
        }
        return trace;
    }

    public void vmDeathEvent(VMDeathEvent event) {
        this.appTraceLog.printDirectln("-- The application exited --");
    }

    public void vmDisconnectEvent(VMDisconnectEvent event) {
        this.appTraceLog.printDirectln("-- The application has been disconnected --");
    }

    public void vmInterrupted(EventSet eventSet) {
        this.setCurrentThread(eventSet);
    }

    public void vmStartEvent(VMStartEvent event) {
        Thread.yield();
        this.appTraceLog.printDirectln("-- VM Started --");
    }
}

