/*
 * Decompiled with CFR 0.152.
 */
package org.archi.tools.excatj.eventspec;

import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.archi.tools.excatj.MessageOutput;
import org.archi.tools.excatj.eventspec.AccessWatchpointSpec;
import org.archi.tools.excatj.eventspec.BreakpointSpec;
import org.archi.tools.excatj.eventspec.EventRequestSpec;
import org.archi.tools.excatj.eventspec.ExceptionSpec;
import org.archi.tools.excatj.eventspec.ModificationWatchpointSpec;
import org.archi.tools.excatj.eventspec.PatternReferenceTypeSpec;
import org.archi.tools.excatj.exception.MalformedMemberNameException;

public class EventRequestSpecList {
    private static final int statusResolved = 1;
    private static final int statusUnresolved = 2;
    private static final int statusError = 3;
    private List eventRequestSpecs = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolve(ClassPrepareEvent event) {
        boolean failure = false;
        List list = this.eventRequestSpecs;
        synchronized (list) {
            for (EventRequestSpec spec : this.eventRequestSpecs) {
                if (spec.isResolved()) continue;
                try {
                    EventRequest eventRequest = spec.resolve(event);
                    if (eventRequest == null) continue;
                    MessageOutput.println("Set deferred", spec.toString());
                }
                catch (Exception e) {
                    MessageOutput.println("Unable to set deferred", new Object[]{spec.toString(), spec.errorMessageFor(e)});
                    failure = true;
                }
            }
        }
        return !failure;
    }

    public void resolveAll() {
        for (EventRequestSpec spec : this.eventRequestSpecs) {
            try {
                EventRequest eventRequest = spec.resolveEagerly();
                if (eventRequest == null) continue;
                MessageOutput.println("Set deferred", spec.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean addEagerlyResolve(EventRequestSpec spec) {
        try {
            this.eventRequestSpecs.add(spec);
            EventRequest eventRequest = spec.resolveEagerly();
            if (eventRequest != null) {
                MessageOutput.println("Set", spec.toString());
            }
            return true;
        }
        catch (Exception exc) {
            MessageOutput.println("Unable to set", new Object[]{spec.toString(), spec.errorMessageFor(exc)});
            return false;
        }
    }

    public EventRequestSpec createBreakpoint(String classPattern, int line) throws ClassNotFoundException {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new BreakpointSpec(refSpec, line);
    }

    public EventRequestSpec createBreakpoint(String classPattern, String methodId, List methodArgs) throws MalformedMemberNameException, ClassNotFoundException {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new BreakpointSpec(refSpec, methodId, methodArgs);
    }

    public EventRequestSpec createExceptionCatch(String classPattern, boolean notifyCaught, boolean notifyUncaught) throws ClassNotFoundException {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new ExceptionSpec(refSpec, notifyCaught, notifyUncaught);
    }

    public EventRequestSpec createAccessWatchpoint(String classPattern, String fieldId) throws MalformedMemberNameException, ClassNotFoundException {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new AccessWatchpointSpec(refSpec, fieldId);
    }

    public EventRequestSpec createModificationWatchpoint(String classPattern, String fieldId) throws MalformedMemberNameException, ClassNotFoundException {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new ModificationWatchpointSpec(refSpec, fieldId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(EventRequestSpec proto) {
        List list = this.eventRequestSpecs;
        synchronized (list) {
            block4: {
                int inx = this.eventRequestSpecs.indexOf(proto);
                if (inx == -1) break block4;
                EventRequestSpec spec = (EventRequestSpec)this.eventRequestSpecs.get(inx);
                spec.remove();
                this.eventRequestSpecs.remove(inx);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eventRequestSpecs() {
        List list = this.eventRequestSpecs;
        synchronized (list) {
            return new ArrayList(this.eventRequestSpecs);
        }
    }
}

