/*
 * Decompiled with CFR 0.152.
 */
package org.archi.tools.excatj.eventspec;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.StringTokenizer;
import org.archi.tools.excatj.Env;
import org.archi.tools.excatj.eventspec.ReferenceTypeSpec;

public class PatternReferenceTypeSpec
implements ReferenceTypeSpec {
    final String classId;
    String stem;

    public PatternReferenceTypeSpec(String classId) throws ClassNotFoundException {
        this.classId = classId;
        this.stem = classId;
        if (classId.startsWith("*")) {
            this.stem = this.stem.substring(1);
        } else if (classId.endsWith("*")) {
            this.stem = this.stem.substring(0, classId.length() - 1);
        }
        this.checkClassName(this.stem);
    }

    public boolean isUnique() {
        return this.classId.equals(this.stem);
    }

    public boolean matches(ReferenceType refType) {
        if (this.classId.startsWith("*")) {
            return refType.name().endsWith(this.stem);
        }
        if (this.classId.endsWith("*")) {
            return refType.name().startsWith(this.stem);
        }
        return refType.name().equals(this.classId);
    }

    public ClassPrepareRequest createPrepareRequest() {
        ClassPrepareRequest request = Env.vm().eventRequestManager().createClassPrepareRequest();
        request.addClassFilter(this.classId);
        request.addCountFilter(1);
        return request;
    }

    public int hashCode() {
        return this.classId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PatternReferenceTypeSpec) {
            PatternReferenceTypeSpec spec = (PatternReferenceTypeSpec)obj;
            return this.classId.equals(spec.classId);
        }
        return false;
    }

    private void checkClassName(String className) throws ClassNotFoundException {
        StringTokenizer tokenizer = new StringTokenizer(className, ".");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (this.isJavaIdentifier(token)) continue;
            throw new ClassNotFoundException();
        }
    }

    private boolean isJavaIdentifier(String s) {
        if (s.length() == 0) {
            return false;
        }
        int cp = s.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            return false;
        }
        int i = Character.charCount(cp);
        while (i < s.length()) {
            cp = s.codePointAt(i);
            if (!Character.isJavaIdentifierPart(cp)) {
                return false;
            }
            i += Character.charCount(cp);
        }
        return true;
    }

    public String toString() {
        return this.classId;
    }
}

