/*
 * @(#) ThreadTrace.java 0.1
 * $Rev: 72 $ 
 * $Date: 2009-06-03 21:01:18 +0900 (수, 03 6월 2009) $
 * Author: Yi, Chai-Sung      
 */
/*
 * Copyright 2009 the original author or authors.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * doPrint callϴ  dumpObject false ϴ  date Type  
 *    Ѵ   
 *  today = "Tue Jun 02 11:47:15 KST 2009"^M
 * ׷  , suspend ,  α׷ ٴ  ߻Ͽ
 * ̴ ؼ  Ǯ Ѵ.
 *  ⼭ ¿   true ϰ ȴ. 
 *    today = {
 *     	gcal: instance of sun.util.calendar.Gregorian(id=380)
 *     	jcal: null
 *     	fastTime: 1243931021140
 *     	cdate: instance of sun.util.calendar.Gregorian$Date(id=381)
 *     	defaultCenturyStart: 0
 *     	serialVersionUID: 7523967970034938905
 *     	wtb: instance of java.lang.String[32] (id=382)
 *     	ttb: instance of int[32] (id=383)
 * 	  }
 */
package org.archi.tools.excatj;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;

import org.archi.tools.excatj.Commands.AsyncExecution;
import org.archi.tools.excatj.expr.ExpressionParser;
import org.archi.tools.excatj.expr.ParseException;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.WatchpointEvent;

/**
 * This class keeps context on events in one thread. In this implementation,
 * context is the indentation prefix.
 */
class ThreadTrace {
	static final String threadDelta = "                     ";
	final TraceOutput appTraceLog;
	final String baseIndent;
	final boolean dumpObject = false;
	StringBuffer indent;
	final int catchDepth;

	final ThreadReference thread;
	static int execepCount = 0;

	abstract class AsyncExecution {
		abstract void action();

		AsyncExecution() {
			execute();
		}

		void execute() {
			/*
			 * Save current thread and stack frame. (BugId 4296031)
			 */
			final ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
			final int stackFrame = threadInfo == null ? 0 : threadInfo.getCurrentFrameIndex();
			try {
				action();
			} catch (UnsupportedOperationException uoe) {
				// (BugId 4453329)
				MessageOutput
						.println("Operation is not supported on the target VM");
			} catch (Exception e) {
				MessageOutput.println("Internal exception during operation:", e.getMessage());
			} finally {
				/*
				 * This was an asynchronous command. Events may have been
				 * processed while it was running. Restore the thread and stack
				 * frame the user was looking at. (BugId 4296031)
				 */
				if (threadInfo != null) {
					ThreadInfo.setCurrentThreadInfo(threadInfo);
					try {
						threadInfo.setCurrentFrameIndex(stackFrame);
					} catch (IncompatibleThreadStateException e) {
						MessageOutput.println("Current thread isnt suspended.");
					} catch (ArrayIndexOutOfBoundsException e) {
						MessageOutput.println(
								"Requested stack frame is no longer active:",
								new Object[] { new Integer(stackFrame) });
					}
				}
			}
		}
	}

	public ThreadTrace(ThreadReference thread, String nextBaseIndent,
			TraceOutput appTraceLog) {
		this.thread = thread;
		this.baseIndent = nextBaseIndent;
		this.appTraceLog = appTraceLog;
		indent = new StringBuffer(baseIndent);
		nextBaseIndent += threadDelta;
		// println("====== " + thread.name() + " ======");

		catchDepth = Env.getCatchDepth();
	}

	void breakpointEvent(BreakpointEvent event) {
		MessageOutput
				.printDevTrace("breakpointEvent(BreakpointEvent event) called");
		printCurrentVariables(event);
	}

	void doPrint(StringTokenizer t, boolean dumpObject) {
		if (!t.hasMoreTokens()) {
			println("No objects specified.");
			return;
		}

		while (t.hasMoreTokens()) {
			String expr = t.nextToken("");
			Value val = evaluate(expr);
			if (val == null) {
				println("expr is null", expr.toString());
			} else if (dumpObject && (val instanceof ObjectReference)
					&& !(val instanceof StringReference)) {
				ObjectReference obj = (ObjectReference) val;
				ReferenceType refType = obj.referenceType();
				println("expr is value", new Object[] { expr.toString(),
						MessageOutput.format("grouping begin character") });
				dump(obj, refType, refType);
				println("grouping end character","");
			} else {
				String strVal = getStringValue();
				if (strVal != null) {
					println("expr is value", new Object[] { expr.toString(),
							strVal });
				}
			}
		}
	}

	private void dump(ObjectReference obj, ReferenceType refType,
			ReferenceType refTypeBase) {
		for (Iterator it = refType.fields().iterator(); it.hasNext();) {
			StringBuffer o = new StringBuffer();
			Field field = (Field) it.next();
			o.append("    ");
			if (!refType.equals(refTypeBase)) {
				o.append(refType.name());
				o.append(".");
			}
			o.append(field.name());
			o.append(MessageOutput.format("colon space"));
			o.append(obj.getValue(field));
			println(o.toString()); // Special case: use
		}
		if (refType instanceof ClassType) {
			ClassType sup = ((ClassType) refType).superclass();
			if (sup != null) {
				dump(obj, sup, refTypeBase);
			}
		} else if (refType instanceof InterfaceType) {
			List sups = ((InterfaceType) refType).superinterfaces();
			for (Iterator it = sups.iterator(); it.hasNext();) {
				dump(obj, (ReferenceType) it.next(), refTypeBase);
			}
		} else {
			/* else refType is an instanceof ArrayType */
			if (obj instanceof ArrayReference) {
				StringBuffer out = new StringBuffer();
				for (Iterator it = ((ArrayReference) obj).getValues()
						.iterator(); it.hasNext();) {
					out.append(it.next().toString());
					if (it.hasNext()) {
						out.append(", ");// Special case: use
					}
				}
				println(out.toString());
			}
		}
	}

	private void dumpFrame(int frameNumber, boolean showPC, StackFrame frame) {
		Location loc = frame.location();
		long pc = -1;
		if (showPC) {
			pc = loc.codeIndex();
		}
		Method meth = loc.method();

		long lineNumber = loc.lineNumber();
		String methodInfo = null;
		if (meth instanceof Method && ((Method) meth).isNative()) {
			methodInfo = MessageOutput.format("native method");
		} else if (lineNumber != -1) {
			try {
				methodInfo = loc.sourceName()
						+ MessageOutput.format("line number",
								new Object[] { new Long(lineNumber) });
			} catch (AbsentInformationException e) {
				methodInfo = MessageOutput.format("unknown");
			}
		}
		if (pc != -1) {
			println("stack frame dump with pc", new Object[] {
					new Integer(frameNumber + 1), meth.declaringType().name(),
					meth.name(), methodInfo, new Long(pc) });
		} else {
			println("stack frame dump", new Object[] {
					new Integer(frameNumber + 1), meth.declaringType().name(),
					meth.name(), methodInfo });
		}
	}

	private void dumpStack(ThreadInfo threadInfo, boolean showPC) {
		List stack = null;
		try {
			stack = threadInfo.getStack();
		} catch (IncompatibleThreadStateException e) {
			println("Current thread isnt suspended.");
			return;
		}
		if (stack == null) {
			println("Thread is not running (no stack).");
		} else {
			int nFrames = stack.size();
			for (int i = threadInfo.getCurrentFrameIndex(); i < nFrames; i++) {
				StackFrame frame = (StackFrame) stack.get(i);
				dumpFrame(i, showPC, frame);
			}
		}
	}

	private Value evaluate(String expr) {
		Value result = null;
		ExpressionParser.GetFrame frameGetter = null;
		try {
			final ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
			if ((threadInfo != null) && (threadInfo.getCurrentFrame() != null)) {
				frameGetter = new ExpressionParser.GetFrame() {
					public StackFrame get()
							throws IncompatibleThreadStateException {
						return threadInfo.getCurrentFrame();
					}
				};
			}
			result = ExpressionParser.evaluate(expr, Env.vm(), frameGetter);
		} catch (InvocationException ie) {
			println("Exception in expression:", ie.exception().referenceType()
					.name());
		} catch (Exception ex) {
			String exMessage = ex.getMessage();
			if (exMessage == null) {
				MessageOutput.printException(exMessage, ex);
			} else {
				String s;
				try {
					s = MessageOutput.format(exMessage);
				} catch (MissingResourceException mex) {
					s = ex.toString();
				}
				MessageOutput.printDirectln(s);// Special case: use
			}
		}
		return result;
	}

	/*
	 * Exception  ߻Ͽ  ó
	 */
	void exceptionEvent(ExceptionEvent event) {
		MessageOutput
				.printDevTrace("exceptionEvent(ExceptionEvent event) called");
		execepCount = execepCount + 1;
//		println("exceptionEvent(ExceptionEvent event) called :" + execepCount);
//		println(thread.name() + " suspend cnd : " +  event.thread().suspendCount());
		if (event.thread().isSuspended()) {
			println("");
			println("");
			println("/******************************************************");
			println(" * Exception: " + event.exception());
			println("     location   : " + event.location());
			println("     catch loc. : " + event.catchLocation());
			println("     thread name: " + thread.name());
			println(" ******************************************************/");
			printCurrentVariables(event);
		} else {
			MessageOutput.printDevTrace(thread.name() + " is not suspended");
		}
	}

	void fieldWatchEvent(WatchpointEvent event) {
		// 
	}

	// FIXME: ⿡ suspend õ  ߻Ǵ  δ. 
	private String getStringValue() {
		Value val = null;
		String valStr = null;

		try {
			val = ExpressionParser.getMassagedValue();
			valStr = val.toString();
		} catch (ParseException e) {
			String msg = e.getMessage();
			if (msg == null) {
				MessageOutput.printException(msg, e);
			} else {
				String s;
				try {
					s = MessageOutput.format(msg);
				} catch (MissingResourceException mex) {
					s = e.toString();
				}
				MessageOutput.printDevTrace(s);
			}
		}
		return valStr;
	}

	public void methodEntryEvent(MethodEntryEvent event) {
		MessageOutput.printDevTrace("methodEntryEvent(MethodEntryEvent event)");
		println(event.method().name() + "  --  "
				+ event.method().declaringType().name());
		indent.append("| ");
	}

	public void methodExitEvent(MethodExitEvent event) {
		MessageOutput.printDevTrace("methodExitEvent(MethodExitEvent event)");
		if (indent.length() > 2)
			indent.setLength(indent.length() - 2);
	}

	private void printCurrentVariables(LocatableEvent event) {
		// MessageOutput.printDevTrace("printCurrentVariables:Breakpoint");
		int nLevel;
		StackFrame frame;
		StringBuffer oldIndent;

		oldIndent = new StringBuffer(indent);

		ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();

		if (threadInfo == null) {
			MessageOutput.println("No default thread specified:");
			return;
		}

		try {
			nLevel = event.thread().frameCount() - 1;
			if (nLevel >= catchDepth - 1) {
				nLevel = catchDepth - 1;
			}
			for (; nLevel >= 0; nLevel--) {
				threadInfo.setCurrentFrameIndex(nLevel);
				frame = threadInfo.getCurrentFrame();
				println("");
				println("**** " + frame.location().method().name() + " in "
						+ frame.location().sourceName() + ":"
						+ frame.location().lineNumber() + " ****");
				printFields(frame);
				printLocals(frame);
				indent.append("| ");
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			indent = new StringBuffer(oldIndent);
		}
	}

	/* Print all local variables in stack frame. */
	private void printFields(StackFrame frame) {
		StringBuffer oldIndent;
		oldIndent = new StringBuffer(indent);

		try {
			List<Field> fieldList = frame.thisObject().referenceType()
					.visibleFields();
			if (fieldList.size() == 0) {
				println("* No field variables");
				return;
			}
			println("* Fields");

			indent.append("  ");
			for (Field field : fieldList) {
				Value value = frame.thisObject().getValue(field);
				printVar(field.name(), value, frame);
				// println("\t" + field.name() + " = " + value);
			}
		} catch (Exception e) {
			println("* Field information not available");
		} finally {
			indent = new StringBuffer(oldIndent);
		}
	}

	private void println(String str) {
		appTraceLog.printDirectln(indent + str);
	}

	private void println(String key, Object[] arguments) {
		appTraceLog.printDirectln(indent + appTraceLog.format(key, arguments));
	}

	private void println(String key, String argument) {
		appTraceLog.printDirectln(indent + appTraceLog.format(key, argument));
	}

	/* Print all local variables in stack frame. */
	private void printLocals(StackFrame frame) {
		ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
		StringBuffer oldIndent;
		oldIndent = new StringBuffer(indent);

		if (threadInfo == null) {
			MessageOutput.println("No default thread specified:");
			return;
		}

		try {
			frame = threadInfo.getCurrentFrame();
			if (frame == null) {
				throw new AbsentInformationException();
			}
			List vars = frame.visibleVariables();

			if (vars.size() == 0) {
				println("* No local variables/method arguments");
				return;
			}
			Map values = frame.getValues(vars);

			println("* Method arguments");
			indent.append("  ");
			for (Iterator it = vars.iterator(); it.hasNext();) {
				LocalVariable var = (LocalVariable) it.next();
				if (var.isArgument()) {
					Value val = (Value) values.get(var);
					printVar(var.name(), val, frame);
				}
			}
			indent = new StringBuffer(oldIndent);
			println("* Local variables");
			indent.append("  ");
			for (Iterator it = vars.iterator(); it.hasNext();) {
				LocalVariable var = (LocalVariable) it.next();
				if (!var.isArgument()) {
					Value val = (Value) values.get(var);
					printVar(var.name(), val, frame);
				}
			}
		} catch (AbsentInformationException aie) {
			println("* Local variable information not available.");
		} catch (IncompatibleThreadStateException exc) {
			println("Current thread isnt suspended.");
		} finally {
			indent = new StringBuffer(oldIndent);
		}
	}

	private void printVar(final String name, Value value, StackFrame frame) {
		// MessageOutput.printDevTrace("printVar called:" + name);
		try {
			if ((value instanceof PrimitiveValue)
					|| (value instanceof StringReference)) {
				println("expr is value",
						new Object[] { name, value.toString() });
			} else {
				new AsyncExecution() {
					void action() {
						doPrint(new StringTokenizer(name), true);
					}
				};
			}
		} catch (Exception e) {
			println("expr is NA", name);
		}
	}

	void threadDeathEvent(ThreadDeathEvent event) {
		indent = new StringBuffer(baseIndent);
		println("====== " + thread.name() + " end ======");
	}
}
