#include <memory.h>

class me2api_supportor {
private:
	// Member Variables
	char m_auth[44];
	char m_b64ed_auth[128];
	char m_trackinfo[512];
	bool m_trackinfo_set;

	const char * get_nonce ();
	int authcode_gen();

public:
	// Constructor & Destructor
	me2api_supportor () {
		memset (m_auth, 0, sizeof (char) * 44);
		memset (m_b64ed_auth, 0, sizeof (char) * 128);
		memset (m_trackinfo, 0, sizeof (char) * 512);
		
		m_trackinfo_set = false;
	}
	~me2api_supportor () {
		// Do Nothing.
	}
	// URL Decoder Interfaces
	int url_encode (const char *src, char *dest, int src_len, int dest_len);
	// base64 encoder interfaces
	void base64_encode(char *dst, const char *src, unsigned int len);
	// Create Authentication.
	int make_authentication ();
	// Set Track Information.
	void set_trackinfo (const char *desc, int length);
	// Shooting!
	int send_description ();

	// Calling Convention? :p, no.
	void call_me (const char *desc, int length);
};