/* foo_me2day : Preferences Page implementation & Registration

Never contain any obfuscated/encrypted strings. :-)

Licensed under zlib/libpng license.

Copyright (c) 2007 Shin Jong hun (LunApapa, http://me2day.net/lunapapa)

Feel free to email me: luna.jetch _at_ gmail.com

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.

2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.

3. This notice may not be removed or altered from any source
distribution.

*/

#include "../SDK/foobar2000.h"
#include "../helpers/helpers.h"
#include "../shared/shared.h"

#include "resource.h"

// Track Information Sending Function Enable/Disable : {A532F2C6-D52B-4e51-A088-C128202DC5A2}
static const GUID guid_bp_trackinfo_send_func_enable = 
{ 0xa532f2c6, 0xd52b, 0x4e51, { 0xa0, 0x88, 0xc1, 0x28, 0x20, 0x2d, 0xc5, 0xa2 } };
static cfg_bool bp_trackinfo_send_func_enabled (guid_bp_trackinfo_send_func_enable, true);

// Me2day.net(TM) User ID Storing : {8B1E56BB-5148-4964-84CB-7AFB6B396CD6}
static const GUID guid_bp_me2day_id = 
{ 0x8b1e56bb, 0x5148, 0x4964, { 0x84, 0xcb, 0x7a, 0xfb, 0x6b, 0x39, 0x6c, 0xd6 } };
static cfg_string bp_me2day_id (guid_bp_me2day_id, "me2day.net ID");

// Me2day.net(TM) Userkey Storing : {8C5CAC23-BFD4-4302-88D2-A572906D2ABF}
static const GUID guid_bp_me2day_userkey = 
{ 0x8c5cac23, 0xbfd4, 0x4302, { 0x88, 0xd2, 0xa5, 0x72, 0x90, 0x6d, 0x2a, 0xbf } };
static cfg_string bp_me2day_userkey (guid_bp_me2day_userkey, "00000000");

// Track information formatting - Radio button selection : {84D0C479-D55B-479e-BBB9-96700AEF5A69}
static const GUID guid_trackinfo_radios = 
{ 0x84d0c479, 0xd55b, 0x479e, { 0xbb, 0xb9, 0x96, 0x70, 0xa, 0xef, 0x5a, 0x69 } };
static cfg_int trackinfo_radio_btn (guid_trackinfo_radios, 1);

// Track information formatting - Custom Format Storing : {8613FD90-AAAE-4b89-9091-4A6044893F92}
static const GUID guid_trackinfo_custom_format = 
{ 0x8613fd90, 0xaaae, 0x4b89, { 0x90, 0x91, 0x4a, 0x60, 0x44, 0x89, 0x3f, 0x92 } };
static cfg_string trackinfo_custom_format (guid_trackinfo_custom_format, "[%artist% - ]%title%");

// Turn Off Plug-in automatically after sending failure : {8A31513F-E0F9-4ec5-ABE5-A2252E45BF5B}
static const GUID guid_turnoff_plugin_automatically = 
{ 0x8a31513f, 0xe0f9, 0x4ec5, { 0xab, 0xe5, 0xa2, 0x25, 0x2e, 0x45, 0xbf, 0x5b } };
static cfg_bool turnoff_plugin_automatically (guid_turnoff_plugin_automatically, false);

// Warning to User after sending failure : {08B62D74-13B6-45ee-871C-F54FE35ACC3E}
static const GUID guid_warn_send_failure = 
{ 0x8b62d74, 0x13b6, 0x45ee, { 0x87, 0x1c, 0xf5, 0x4f, 0xe3, 0x5a, 0xcc, 0x3e } };
static cfg_bool warn_send_failure (guid_warn_send_failure, false);

// Cool-down time after send() process : {34FB9971-EF60-45a0-8064-5EA060008726}
static const GUID guid_cool_down_time = 
{ 0x34fb9971, 0xef60, 0x45a0, { 0x80, 0x64, 0x5e, 0xa0, 0x60, 0x0, 0x87, 0x26 } };
static cfg_int cool_down_time (guid_cool_down_time, 20);


/* Stored Data Retrieving Interface */
bool get_bp_ti_send_func_enable () {
	return bp_trackinfo_send_func_enabled;
}

const char * get_me2day_id () {
	return (const char *) bp_me2day_id;
}

const char * get_me2day_userkey () {
	return (const char *) bp_me2day_userkey;
}

int get_trackformat_radio_num () {
	return trackinfo_radio_btn;
}

const char * get_trackinfo_custom_format () {
	return trackinfo_custom_format;
}

bool get_turnoff_plugin_automatically () {
	return turnoff_plugin_automatically;
}

bool get_warn_send_failure () {
	return warn_send_failure;
}

int get_cool_down_time () {
	return cool_down_time;
}

/* Preferences Page Implementation. */
static BOOL CALLBACK Me2PrefConfigProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg) {
	case WM_INITDIALOG:
		// Track Information Sending Function Check-box Init
		if (true == bp_trackinfo_send_func_enabled)
			SendDlgItemMessageW (hWnd, IDC_CHECK1, BM_SETCHECK, BST_CHECKED, 0);
		else
			SendDlgItemMessageW (hWnd, IDC_CHECK1, BM_SETCHECK, BST_UNCHECKED, 0);
		
		// Init Me2day.net(TM) User ID / Userkey
		{
			HWND t_ef_userid = GetDlgItem (hWnd, IDC_EDIT1);
			HWND t_ef_userkey = GetDlgItem (hWnd, IDC_EDIT2);
			
			// limit edit control length
			SendMessage (t_ef_userid, EM_LIMITTEXT, 20, 0);
			SendMessage (t_ef_userkey, EM_LIMITTEXT, 8, 0);

			uSetWindowText (t_ef_userid, (const char *) bp_me2day_id);
			uSetWindowText (t_ef_userkey, (const char *) bp_me2day_userkey);
		}
		
		// Init Custom Format Edit box
		{
			HWND t_ef_custom = GetDlgItem (hWnd, IDC_EDIT3);
			// limit edit control input length, to 512.
			SendMessage (t_ef_custom, EM_LIMITTEXT, 512, 0);

			uSetWindowText (t_ef_custom, (const char *) trackinfo_custom_format);
			SendMessage (t_ef_custom, EM_SETREADONLY, ES_READONLY, 0);
		}

		// Init Radio buttons
		if (4 == trackinfo_radio_btn) {
			SendDlgItemMessageW (hWnd, IDC_RADIO4, BM_SETCHECK, BST_CHECKED, 0);
			SendDlgItemMessageW (hWnd, IDC_EDIT3, EM_SETREADONLY, FALSE, 0);
		}
		else if (3 == trackinfo_radio_btn)
			SendDlgItemMessageW (hWnd, IDC_RADIO3, BM_SETCHECK, BST_CHECKED, 0);
		else if (2 == trackinfo_radio_btn)
			SendDlgItemMessageW (hWnd, IDC_RADIO2, BM_SETCHECK, BST_CHECKED, 0);
		else // (1 == trackinfo_radio_btn)
			SendDlgItemMessageW (hWnd, IDC_RADIO1, BM_SETCHECK, BST_CHECKED, 0);
		
		// Init Automatic Plug-in shutdown
		if (true == turnoff_plugin_automatically)
			SendDlgItemMessageW (hWnd, IDC_CHECK2, BM_SETCHECK, BST_CHECKED, 0);
		else
			SendDlgItemMessageW (hWnd, IDC_CHECK2, BM_SETCHECK, BST_UNCHECKED, 0);

		// Init Warn to user after Sending Failure function check-box
		if (true == warn_send_failure)
			SendDlgItemMessageW (hWnd, IDC_CHECK3, BM_SETCHECK, BST_CHECKED, 0);
		else
			SendDlgItemMessageW (hWnd, IDC_CHECK3, BM_SETCHECK, BST_UNCHECKED, 0);

		// Init Cool-down time
		{
			HWND t_ef_cooldown = GetDlgItem (hWnd, IDC_EDIT5);
			
			// limit edit control input length, to 2.
			SendMessage (t_ef_cooldown, EM_LIMITTEXT, 2, 0);
			char s_tmp_cd[4];
			memset (s_tmp_cd, 0, sizeof (char) * 4);
			_itoa_s (get_cool_down_time(), s_tmp_cd, 4, 10);
			uSetWindowText (t_ef_cooldown, s_tmp_cd);
		}

		break;
	case WM_COMMAND:
		switch (LOWORD (wParam)) {
			case IDC_CHECK1:	// Track Information Sending Function Enabling Check-box
				{	
					if (BST_CHECKED == SendDlgItemMessageW (hWnd, IDC_CHECK1, BM_GETCHECK, 0, 0)) {
						bp_trackinfo_send_func_enabled = true;
					}
					else {
						//SendDlgItemMessageW (hWnd, IDC_CHECK1, BM_SETCHECK, BST_UNCHECKED, 0); // Useless!
						bp_trackinfo_send_func_enabled = false;
					}
				}
			break;
			case IDC_CHECK2:	// Turn-off Plug-in Automatically Function Enabling Check-box
				{
					if (BST_CHECKED == SendDlgItemMessageW (hWnd, IDC_CHECK2, BM_GETCHECK, 0, 0)) {
						turnoff_plugin_automatically = true;
					}
					else {
						turnoff_plugin_automatically = false;
					}
				}
			break;
			case IDC_CHECK3:	// Warn to user after sending failure Check-box
				{
					if (BST_CHECKED == SendDlgItemMessageW (hWnd, IDC_CHECK3, BM_GETCHECK, 0, 0)) {
						warn_send_failure = true;
					}
					else {
						warn_send_failure = false;
					}
				}
			break;
			case IDC_EDIT1:		// me2day.net(TM) User ID (max-length: 20)
				switch (HIWORD (wParam)) {
					case EN_CHANGE:
						{	
							HWND t_ef_userid = GetDlgItem (hWnd, IDC_EDIT1);
							uGetWindowText (t_ef_userid, bp_me2day_id);
						}
					break;
				}
			break;
			case IDC_EDIT2:		// me2day.net(TM) User key (max-length: 8)
				switch (HIWORD (wParam)) {
					case EN_CHANGE:
						{	
							HWND t_ef_userkey = GetDlgItem (hWnd, IDC_EDIT2);
							uGetWindowText (t_ef_userkey, bp_me2day_userkey);
						}
					break;
				}
			break;
			case IDC_RADIO1:	// Chase Window Title Bar Output Format
				{
					if (BST_CHECKED == SendDlgItemMessageW (hWnd, IDC_RADIO1, BM_GETCHECK, 0, 0)) {
						trackinfo_radio_btn = 1;
						SendDlgItemMessageW (hWnd, IDC_EDIT3, EM_SETREADONLY, ES_READONLY, 0);
					}
				}
			break;
			case IDC_RADIO2:	// Chase Status Bar Output Format
				{
					if (BST_CHECKED == SendDlgItemMessageW (hWnd, IDC_RADIO2, BM_GETCHECK, 0, 0)) {
						trackinfo_radio_btn = 2;
						SendDlgItemMessageW (hWnd, IDC_EDIT3, EM_SETREADONLY, ES_READONLY, 0);
					}
				}
			break;
			case IDC_RADIO3:	// Chase Tray Icon Output Format
				{
					if (BST_CHECKED == SendDlgItemMessageW (hWnd, IDC_RADIO3, BM_GETCHECK, 0, 0)) {
						trackinfo_radio_btn = 3;
						SendDlgItemMessageW (hWnd, IDC_EDIT3, EM_SETREADONLY, ES_READONLY, 0);
					}
				}
			break;
			case IDC_RADIO4:	// Custom Formatting
				{
					if (BST_CHECKED == SendDlgItemMessageW (hWnd, IDC_RADIO4, BM_GETCHECK, 0, 0)) {
						trackinfo_radio_btn = 4;
						SendDlgItemMessageW (hWnd, IDC_EDIT3, EM_SETREADONLY, FALSE, 0);
					}
				}
			break;
			case IDC_EDIT3:		// Custom Format Edit box
				switch (HIWORD (wParam)) {
					// Execute EN_SETFOCUS Automatically After Receiving EN_CHANGE Messages, don't _brake_ it.
					case EN_CHANGE:
						{	
							HWND t_ef_cusedit = GetDlgItem (hWnd, IDC_EDIT3);
							uGetWindowText (t_ef_cusedit, trackinfo_custom_format);
						}
					case EN_SETFOCUS:
						{
							// * FIXME : at stopping state, preview doesn't work.
							HWND t_ef_preview = GetDlgItem (hWnd, IDC_EDIT4);
							static_api_ptr_t <play_control> pc;
							static_api_ptr_t<titleformat_compiler> tf_compiler;
							metadb_handle_ptr handle;
							pfc::string8 text;
						
							if (pc->get_now_playing (handle)) {
								service_ptr_t <titleformat_object> script;
								if (tf_compiler->compile (script, (const char *) trackinfo_custom_format)) {
									pc->playback_format_title_ex (handle, NULL, text, script, NULL, play_control::display_level_titles);
									uSetWindowText (t_ef_preview, text);
								}
							}
						}
					break;
				}
			break;
			case IDC_EDIT5:
				switch (HIWORD (wParam)) {
					case EN_CHANGE:
						{
							HWND t_ef_cd_edit = GetDlgItem (hWnd, IDC_EDIT5);
							pfc::string8 tmp_cdedit_str;
							uGetWindowText (t_ef_cd_edit, tmp_cdedit_str);
							cool_down_time = (int) atoi ((const char *) tmp_cdedit_str);
						}
					break;
				}
			break;
		}
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

/* Now Implements Preferences Linkages ;D */
class preferences_me2day_plugin : public preferences_page {
	virtual HWND create (HWND p_parent) {
		return uCreateDialog(IDD_PROPS, p_parent, Me2PrefConfigProc, 0);
	}

	virtual const char * get_name () {
		return "Me2day.net Linking";
	}

	virtual GUID get_guid () {
		// {DEB6C0CF-E73D-4194-AC61-637A6FFB4991}
		static const GUID guid_preferences_me2day = 
		{ 0xdeb6c0cf, 0xe73d, 0x4194, { 0xac, 0x61, 0x63, 0x7a, 0x6f, 0xfb, 0x49, 0x91 } };

		return guid_preferences_me2day;
	}

	// See also foobar2k-sdk\SDK\guids.cpp file.
	virtual GUID get_parent_guid () {
		return preferences_page::guid_tools;
	}

	virtual bool reset_query () {
		//    ȸϱ false س.
		return false;
	}

	virtual void reset () {
		// Activates "reset page" feature. see preferences_page.h
		// TODO : Do Nothing, at least, right now.
	}

	// TODO:  ڵ foobar2k wiki  ̵.
	//virtual bool get_help_url (pfc::string_base & p_out);
};

/* Now Registering Preferences Page ;) */
static preferences_page_factory_t <preferences_me2day_plugin> foo_preferences;