﻿/* foo_me2day : Main

Never contain any obfuscated/encrypted strings. :-)

Licensed under zlib/libpng license.

Copyright (c) 2007 Shin Jong hun (LunApapa, http://me2day.net/lunapapa)

Feel free to email me: luna.jetch _at_ gmail.com

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.

2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.

3. This notice may not be removed or altered from any source
distribution.

*/

#include "../SDK/foobar2000.h"
#include "../helpers/helpers.h"

#include "foo_me2day_title_grabber.h"
#include "resource.h"

DECLARE_COMPONENT_VERSION (
	"foo_me2day - foobar2k me2day plugin",
	"0.2.0",
	"Plugin to play with me2day.net. :p\n"
	"Creator: Shin Jong hun, aka LunApapa, LunA_J`etch or DalGarak.\n"
	"me2day : http://me2day.net/lunapapa , e-mail : luna.jetch _at_ gmail.com\n\n"
	"Thanks to contributors:\n\n"
	" * RedBaron (http://me2day.net/redbaron) - for v0.1.0\n"
	" * Silsol (http://me2day.net/silsol) - for v0.2.0\n"
	"\n");

// Plug-in Enable Toggling : {2C9091AD-6E93-475d-91AE-B5A982112DF0}
static const GUID guid_plugin_enable = 
{ 0x2c9091ad, 0x6e93, 0x475d, { 0x91, 0xae, 0xb5, 0xa9, 0x82, 0x11, 0x2d, 0xf0 } };
static cfg_bool plugin_enabled (guid_plugin_enable, false);

// Get/Set Outer Interfaces.
bool get_plugin_enabled () {
	return plugin_enabled;
}

void set_plugin_enabled (bool status)  {
	plugin_enabled = status;
}

/* Component Initialization : Everything starts here :-p */
class initquit_me2day : public initquit {
	virtual void on_init () {
		// Init : Title_grabber, playback_cb class.
		static Title_grabber tg;
	}

	virtual void on_quit () {
		// do nothing.
	}
};
static initquit_factory_t <initquit_me2day> foo_initquit;

/* Menu Command Addition : Plug-in Enabling Implementation */
class mainmenu_commands_enable_me2day : public mainmenu_commands {
	virtual t_uint32 get_command_count () { 
		return 1; 
	}

	virtual GUID get_command (t_uint32 p_index) {
		// {D77097E9-8050-4532-A007-1AD20A19502F}
		static const GUID guid_enable_me2day_plugin = 
		{ 0xd77097e9, 0x8050, 0x4532, { 0xa0, 0x7, 0x1a, 0xd2, 0xa, 0x19, 0x50, 0x2f } };
		
		if (0 == p_index)
			return guid_enable_me2day_plugin;

		return pfc::guid_null;
	}

	virtual void get_name (t_uint32 p_index, pfc::string_base & p_out) {
		if (0 == p_index)
			p_out = "Enable Me2day(TM) Plug-in";
	}

	virtual bool get_description (t_uint32 p_index, pfc::string_base & p_out) {
		if (p_index == 0)
			p_out = "Toggles me2day.net sync plug-in. if it disables, all functions will not be executed.";
		else
			return false;

		return true;
	}

	virtual GUID get_parent () {
		return mainmenu_groups::playback;
	}

	virtual void execute (t_uint32 p_index, service_ptr_t <service_base> p_callback) {
		if (0 == p_index && core_api::assert_main_thread ()) {
			if (plugin_enabled)
				plugin_enabled = false;
			else
				plugin_enabled = true;
		}
	}

	virtual bool get_display (t_uint32 p_index, pfc::string_base & p_text, t_uint32 & p_flags) {
		p_flags = 0;
		if (is_checked (p_index))
			p_flags |= flag_checked;
		get_name (p_index, p_text);

		return true;
	}

	bool is_checked (t_uint32 p_index) {
		if (0 == p_index)
			return plugin_enabled;
		return false;
	}
};

/* Registering Menu Item Implementation */
static mainmenu_commands_factory_t <mainmenu_commands_enable_me2day> foo_menu;
