/* License : GPL
 * Author  : Lee Jeong Ho
 * Notice  : If you want to modify this source or take part in this 
 *           project, contact me. Thanks!
 * Contact : fp33@naver.com
 */


import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

class extension_list{
	private String title = null;
	private String document= null;
	private String movie_and_music= null;
	private String picture= null;


	private Vector vc_title = new Vector();
	private Vector vc_document = new Vector();
	private Vector vc_movie_and_music = new Vector();
	private Vector vc_picture = new Vector();
	private Vector vc_etc = new Vector();
	private Vector<String> vc_all = new Vector<String>();
	private Vector<Vector> vc_all_v = new Vector<Vector>();
	
	private BufferedReader br;
	extension_list() throws IOException{
		try{
			File file = new File(".\\extension.txt");
			FileReader fr = new FileReader(file);
			br = new BufferedReader(fr);
			
			while((title = br.readLine())!=null){
				vc_title.add(title);
				if(title.equals("ϸ")){
					document = br.readLine();
				
				}
				else if(title.equals("̵ϸ")){
					movie_and_music = br.readLine();
				}
				else if(title.equals("׸ϸ")){
					picture = br.readLine();
				}
			}
			vc_title.add("Ÿϸ");
		}catch(FileNotFoundException e){
			System.out.println("ã ");
		};
		
		token_process_document();
		token_process_movie_and_music();
		token_process_picture();
		token_process_all();
		token_process_all_v();
		br.close();
	}

	private void token_process_all_v() {
		vc_all_v.add(vc_document);
		vc_all_v.add(vc_movie_and_music);
		vc_all_v.add(vc_picture);
		vc_all_v.add(vc_etc);
	}

	public void token_process_document(){           // tokenizer document
		StringTokenizer token = new StringTokenizer(document, ";", false);
		while(token.hasMoreTokens()){
			vc_document.add(token.nextToken());
		}
	}
	public void token_process_movie_and_music(){      // tokenizer movie and music
		StringTokenizer token = new StringTokenizer(movie_and_music, ";", false);
		while(token.hasMoreTokens()){
			vc_movie_and_music.add(token.nextToken());
		}

	}
	public  void token_process_picture(){            // tokenizer picture
		StringTokenizer token = new StringTokenizer(picture, ";", false);
		while(token.hasMoreTokens()){
			vc_picture.add(token.nextToken());
		}
		
	}
	

	public void token_process_all(){                 // obtain all of extention list
		StringTokenizer token1 = new StringTokenizer(document, ";", false);
		while(token1.hasMoreTokens()){
			vc_all.add(token1.nextToken());
		}
		StringTokenizer token2 = new StringTokenizer(movie_and_music, ";", false);
		while(token2.hasMoreTokens()){
			vc_all.add(token2.nextToken());
		}
		StringTokenizer token3 = new StringTokenizer(picture, ";", false);
		while(token3.hasMoreTokens()){
			vc_all.add(token3.nextToken());
		}
		
	}
	public Vector getTitle(){
		return vc_title;
	}
	public Vector getDocument(){                     // return document extention list
		return vc_document;
	}
	public Vector getMovie_And_Music(){   			// return movie and music extention list
		return vc_movie_and_music;
	}
	public Vector getPicture(){                     // return picture extention list
		return vc_picture;
	}
	public Vector getEtc(){
		return vc_etc;
	}
	public Vector getAll(){
		return vc_all;
	}
	public Vector<Vector> getAll_v(){
		return vc_all_v;
	}
}
