#!/usr/bin/env python
"""
gdick.py by ddt<ddt@mirstyle.org>
license: GPL
"""
import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade
import gobject
import pango
import gconf

import os.path
import webbrowser

import YahooView
from Utils import listUniq
from Utils import sleeper

class GDick:
    def __init__(self):
        self.history = []
        self.lang = 0
        self.sameWordsShow = False
        self.hovering_over_link = False

        self.conf = gconf.client_get_default()
        self.conf.add_dir("/apps/gdick",
                          gconf.CLIENT_PRELOAD_NONE)
        self.conf.notify_add("/apps/gdick/speaker",
                             self.on_gconf_speaker_key_changed)
        
        self.speaker = self.conf.get_string("/apps/gdick/speaker")
        if not self.speaker:
            self.conf.set_string("/apps/gdick/speaker", "mplayer")
        
        self.xml = gtk.glade.XML("/usr/share/gdick/gdick.glade")
        
        self.win = self.xml.get_widget('window')
        self.win.drag_dest_set(gtk.DEST_DEFAULT_ALL,
                               [('STRING',0,0),('text/plain',0,0)],
                               gtk.gdk.ACTION_COPY)
        
        self.combo = self.xml.get_widget('combo')

        self.sb = self.xml.get_widget('statusbar')

        self.buffer = gtk.TextBuffer()
        textview = self.xml.get_widget('textview')
        textview.set_buffer(self.buffer)

        self.treeview = self.xml.get_widget('treeview')
        model = gtk.ListStore(gobject.TYPE_STRING)
        self.treeview.set_model(model)
        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn("words", renderer, text=0)
        self.treeview.append_column(column)

        self.paned = self.xml.get_widget("hpaned1")
        size = self.win.get_size()
        self.paned.set_position(size[0])

        # cursor
        self.DEFAULT_CURSOR = gtk.gdk.Cursor(gtk.gdk.LEFT_PTR)
        self.LINK_CURSOR = gtk.gdk.Cursor(gtk.gdk.HAND2)
        self.WAIT_CURSOR = gtk.gdk.Cursor(gtk.gdk.WATCH)
        
        # signal connect
        signals = {}
        for key in dir(self.__class__):
            if key[:3] == 'on_':
                signals[key] = getattr(self, key)
        self.xml.signal_autoconnect(signals)

    def status_update(self, msg):
        id = self.sb.get_context_id("gdick status")
        self.sb.pop(id)
        self.sb.push(id, msg)

    def cursor_change(self, cursor, widget = None):
        if not widget:
            widget = self.win.window
        widget.set_cursor(cursor)

    def set_cursor_if_appropriate(self, tv, x, y):
        hovering = False
        buffer = tv.get_buffer()
        iter = tv.get_iter_at_location(x,y)
        for tag in iter.get_tags():
            url = tag.get_data("url")
            if url and url != "":
                hovering = True
                break
        if hovering != self.hovering_over_link:
            self.hovering_over_link = hovering
            if self.hovering_over_link:
                self.hovering_over_link_tag = tag
                self.hovering_over_link_tag.set_property("underline",
                                                         pango.UNDERLINE_SINGLE)
                self.hovering_over_link_tag.set_property("foreground",
                                                         "red")
                self.cursor_change(self.LINK_CURSOR,
                                   tv.get_window(gtk.TEXT_WINDOW_TEXT))
            else:
                self.hovering_over_link_tag.set_property("underline",
                                                         pango.UNDERLINE_NONE)
                tv.get_default_attributes().fg_color
                self.hovering_over_link_tag.set_property("foreground-gdk",
                                                         tv.get_default_attributes().fg_color)
                self.cursor_change(self.DEFAULT_CURSOR,
                                   tv.get_window(gtk.TEXT_WINDOW_TEXT))

    def search_wrap(self):
        word = self.combo.entry.get_text()
        self.search(word)
    
    def search(self, word):
        if not word or word == "":
            return
        start, end = self.buffer.get_bounds()
        self.buffer.delete(start, end)
        
        word = word.lower()
        self.history.insert(0,word)
        self.history = listUniq(self.history, sort=False)
        self.history = self.history[:10]
        self.combo.set_popdown_strings(self.history)
        self.win.set_title(word + ' - gdick')
        
        if word.isalpha() or self.lang == 0:
            lang = 'en'
        else:
            lang = 'ko'
        if isinstance(word, unicode):
            word = word.encode('euc-kr')
        else:
            word = word.decode('utf-8').encode('euc-kr')
        YahooView.YahooView(self, word, lang).start()
        self.win.present()

    ###################
    # signal handlers #
    ###################
    def on_gconf_speaker_key_changed(self, client, cnxn_id, entry, *args):
        self.speaker = entry.value.to_string()
    
    def on_textview_motion_notify_event(self, textview, event):
        x, y = textview.window_to_buffer_coords(gtk.TEXT_WINDOW_WIDGET,
                                                int(event.x),
                                                int(event.y))
        self.set_cursor_if_appropriate(textview, x, y)
        textview.window.get_pointer()

    def on_textview_visibility_notify_event(self, textview, event):
        x, y, m = textview.window.get_pointer()
        bx, by = textview.window_to_buffer_coords(gtk.TEXT_WINDOW_WIDGET,
                                                  x, y)
        self.set_cursor_if_appropriate(textview, bx, by)
    
    def on_textview_event_after(self, textview, event):
        if (event.type != gtk.gdk.BUTTON_RELEASE or event.button != 1):
            return gtk.FALSE
        buffer = textview.get_buffer()
        x, y = textview.window_to_buffer_coords(gtk.TEXT_WINDOW_WIDGET,
                                                int(event.x),
                                                int(event.y))
        iter = textview.get_iter_at_location(x,y)
        for tag in iter.get_tags():
            url = tag.get_data("url")
            if url:
                if not url[-1].isdigit():
                    self.search(url)
                else:
                    sound = "http://msrv.yahoo.co.kr/engdic/sound/"
                    sound += url[0]
                    sound += "/" + url + ".wma"
                    if self.speaker == 'browser':
                        webbrowser.open_new(sound)
                    else:
                        os.system("mplayer "+sound)
            break
    
    def on_window_size_request(self, widget, requisition, *args):
        if self.sameWordsShow:
            size = self.win.get_size()
            self.paned.set_position(size[0]-100)
            
    def on_treeview_row_activated(self, treeview, path, view_column, *args):
        model = treeview.get_model()
        iter = model.get_iter(path)
        self.search(model.get_value(iter, 0))
    
    def on_english_activate(self, widget):
        self.lang = 0

    def on_korean_activate(self, widget):
        self.lang = 1

    def on_preferences_activate(self, widget):
        if self.speaker == "mplayer":
            toggle = self.xml.get_widget("mplayer_button")
        else:
            toggle = self.xml.get_widget("browser_button")
        toggle.set_active(gtk.TRUE)
        self.xml.get_widget('preferences_dialog').show()

    def on_okbutton_clicked(self, widget):
        self.xml.get_widget('preferences_dialog').hide()

    def on_browser_button_toggled(self, widget):
        if widget.get_active():
            self.conf.set_string("/apps/gdick/speaker", "browser")
        else:
            self.conf.set_string("/apps/gdick/speaker", "mplayer")
    
    def on_about_activate(self, widget):
        self.xml.get_widget('about').show()

    ## about dialog bug
    #def on_about_delete_event(self, widget, *args):
    #    self.xml.get_widget('about').hide()
    #    return gtk.TRUE

    def on_combo_entry_activate(self, entry):
        self.search_wrap()
    
    def on_button_clicked(self, *args):
        self.search_wrap()

    def on_window_drag_data_received(self, widget, context, x, y, data, info, timestamp):
        if data and data.format == 8:
            self.search(data.data)
        context.finish(gtk.TRUE,gtk.FALSE, timestamp)

def Main():
    gtk.timeout_add(33, sleeper)
    d = GDick()
    d.xml.signal_connect('on_window_destroy',lambda w:gtk.main_quit())
    d.xml.signal_connect('on_quit_activate',lambda w:gtk.main_quit())
    gtk.mainloop()
