/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.module.sentence;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import kr.ac.kaist.swrc.jhannanum.module.Module;

public class SentenceSplitter
implements Module {
    private BufferedReader in = null;
    private PrintWriter out = null;
    private static final String MODULE_NAME = "SentenceSplitter";

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public void initialize(Reader in, Writer out, String configFile) {
        this.in = in != null ? new BufferedReader(in) : null;
        this.out = out != null ? new PrintWriter(out) : null;
    }

    private boolean isSym(char c) {
        switch (c) {
            case ')': {
                return true;
            }
            case ']': {
                return true;
            }
            case '}': {
                return true;
            }
            case '?': {
                return true;
            }
            case '!': {
                return true;
            }
            case '.': {
                return true;
            }
            case '\'': {
                return true;
            }
            case '\"': {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() throws Exception {
        String line = "";
        String[] words = null;
        boolean isBOS = true;
        while ((line = this.in.readLine()) != null) {
            isBOS = true;
            if (line.equals("EOF")) {
                if (!isBOS) {
                    this.out.write("EOS\n");
                }
                this.out.write("EOF\n\n");
                continue;
            }
            words = line.split("\\s");
            int i = 0;
            while (i < words.length) {
                block22: {
                    block21: {
                        if (words[i].matches(".*(\\.|\\!|\\?).*")) break block21;
                        if (isBOS) {
                            this.out.write("BOS " + words[i] + " ");
                        } else {
                            this.out.write(String.valueOf(words[i]) + " ");
                        }
                        isBOS = false;
                        break block22;
                    }
                    int beginIndex = 0;
                    boolean isEOS = false;
                    int j = 0;
                    while (j < words[i].length()) {
                        block23: {
                            char c = words[i].charAt(j);
                            switch (c) {
                                case '.': {
                                    if (!(j > 0 && (Character.isLowerCase(words[i].charAt(j - 1)) || Character.isUpperCase(words[i].charAt(j - 1)) || words[i].charAt(j - 1) == '.' && j != words[i].length() - 1) || j < words[i].length() - 1 && (Character.isDigit(words[i].charAt(j + 1)) || words[i].charAt(j + 1) == '.'))) {
                                        isEOS = true;
                                        break;
                                    }
                                    break block23;
                                }
                                case '!': {
                                    isEOS = true;
                                    break;
                                }
                                case '?': {
                                    isEOS = true;
                                }
                            }
                            if (isEOS) {
                                while (j < words[i].length() - 1) {
                                    if (!this.isSym(words[i].charAt(j + 1))) break;
                                    ++j;
                                }
                                int k = j;
                                while (k >= 0) {
                                    if (!this.isSym(words[i].charAt(k))) break;
                                    --k;
                                }
                                if (isBOS) {
                                    this.out.write("BOS " + words[i].substring(beginIndex, k + 1) + " " + words[i].substring(k + 1, j + 1) + " EOS\n");
                                } else {
                                    this.out.write(String.valueOf(words[i].substring(beginIndex, k + 1)) + " " + words[i].substring(k + 1, j + 1) + " EOS\n");
                                }
                                isBOS = true;
                                beginIndex = j + 1;
                                isEOS = false;
                                this.out.flush();
                            }
                        }
                        ++j;
                    }
                    if (beginIndex < words[i].length()) {
                        if (isBOS) {
                            this.out.write("BOS " + words[i].substring(beginIndex, words[i].length()) + " ");
                        } else {
                            this.out.write(String.valueOf(words[i].substring(beginIndex, words[i].length())) + " ");
                        }
                        isBOS = false;
                        this.out.flush();
                    }
                }
                ++i;
            }
            if (isBOS || words == null) continue;
            this.out.write(" EOS\n");
            this.out.flush();
        }
    }

    @Override
    public void setReader(Reader in) {
        this.in = in != null ? new BufferedReader(in) : null;
    }

    @Override
    public void setWriter(Writer out) {
        this.out = out != null ? new PrintWriter(out) : null;
    }

    @Override
    public void shutdown() {
    }
}

