/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.module.tagger;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.StringTokenizer;
import kr.ac.kaist.swrc.jhannanum.module.Module;
import kr.ac.kaist.swrc.jhannanum.module.tagger.PhraseTag;
import kr.ac.kaist.swrc.jhannanum.module.tagger.ProbabilityDBM;

public class HMMTagger
implements Module {
    public static int MAXLINE = 10000;
    public static int TRUE = 1;
    public static int FALSE = 0;
    public static double SF = -4.605170185988092;
    public static String EOS = "eos";
    public static String BNK = "bnk";
    private static final String MODULE_NAME = "HMMTagger";
    public WPhead[] wp = null;
    public int wp_end = 0;
    public MNode[] mn = null;
    public int mn_end = 0;
    public ProbabilityDBM pwt_tf = null;
    public ProbabilityDBM ptt_tf = null;
    public ProbabilityDBM pph_tf = null;
    public String PWT_TDBM_FILE;
    public String PTT_TDBM_FILE;
    public String PPH_TDBM_FILE;
    public int org_pos = 0;
    public String[] org_eojeol;
    public boolean view = false;
    public String wtag = null;
    static final double PCONSTANT = -20.0;
    static final double LAMBDA = 0.9;
    static final double Lambda1 = 0.9;
    static final double Lambda2 = 0.09999999999999998;
    private BufferedReader in = null;
    private PrintWriter out = null;

    public double compute_wt(String str) {
        double current = 0.0;
        int pos = 1;
        while (pos < str.length() && (str.charAt(pos - 1) == '\\' || str.charAt(pos) != '+')) {
            ++pos;
        }
        String morphtag = str.substring(0, pos);
        if (pos >= str.length()) {
            pos = str.length() - 1;
        }
        int tmp = pos + 1;
        pos = morphtag.length() - 1;
        while (morphtag.charAt(pos) != '/') {
            --pos;
        }
        String tag = morphtag.substring(pos + 1);
        String bitag = "bnk-" + tag;
        double[] prob = null;
        prob = this.ptt_tf.get(bitag);
        double tbigram = prob != null ? prob[0] : -20.0;
        prob = this.ptt_tf.get(tag);
        double tunigram = prob != null ? prob[0] : -20.0;
        prob = this.pwt_tf.get(morphtag);
        double lexicon = prob != null ? prob[0] : -20.0;
        current = lexicon + tbigram;
        String oldtag = tag;
        while (tmp < str.length()) {
            pos = 1;
            while (pos < str.length() - tmp && (str.charAt(tmp + pos - 1) == '\\' || str.charAt(tmp + pos) != '+')) {
                ++pos;
            }
            morphtag = str.substring(tmp, tmp + pos);
            if (pos >= str.length() - tmp) {
                pos = str.length() - tmp - 1;
            }
            tmp = tmp + pos + 1;
            pos = morphtag.length() - 1;
            while (morphtag.charAt(pos) != '/') {
                --pos;
            }
            tag = morphtag.substring(pos + 1);
            bitag = String.valueOf(oldtag) + "-" + tag;
            prob = this.ptt_tf.get(bitag);
            tbigram = prob != null ? prob[0] : -20.0;
            prob = this.pwt_tf.get(morphtag);
            lexicon = prob != null ? prob[0] : -20.0;
            prob = this.ptt_tf.get(tag);
            tunigram = prob != null ? prob[0] : -20.0;
            current += lexicon + tbigram;
            oldtag = tag;
        }
        bitag = "-bnk";
        prob = this.ptt_tf.get(bitag);
        tbigram = prob != null ? prob[0] : -20.0;
        prob = this.ptt_tf.get("bnk");
        tunigram = prob != null ? prob[0] : -20.0;
        return current += 0.0 + tbigram;
    }

    public void end_sentence() {
        int k;
        String sep = "+";
        String[] outStack = new String[5000];
        int pos = 0;
        boolean strNo = false;
        int i = this.new_wp(" ");
        this.wp[i].mnode = this.new_mnode(" ", "SF", 0.0);
        i = 1;
        while (i < this.wp_end - 1) {
            int j = this.wp[i].mnode;
            while (j != 0) {
                k = this.wp[i + 1].mnode;
                while (k != 0) {
                    this.update_prob_score(j, k);
                    k = this.mn[k].sibling;
                }
                j = this.mn[j].sibling;
            }
            ++i;
        }
        k = this.wp[i].mnode;
        while (k != 0) {
            outStack[pos++] = this.mn[k].mout_str;
            k = this.mn[k].backptr;
        }
        k = pos -= 2;
        while (pos > -1) {
            this.out.format("%s\n%s\n\n", this.org_eojeol[k - pos], outStack[pos + 1]);
            this.out.flush();
            --pos;
        }
        this.out.write(10);
        this.out.flush();
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public void initialize(Reader in, Writer out, String configFile) throws Exception {
        this.wp = new WPhead[10000];
        int i = 0;
        while (i < 10000) {
            this.wp[i] = new WPhead();
            ++i;
        }
        this.wp_end = 1;
        this.mn = new MNode[10000];
        i = 0;
        while (i < 10000) {
            this.mn[i] = new MNode();
            ++i;
        }
        this.mn_end = 1;
        this.org_eojeol = new String[5000];
        this.PWT_TDBM_FILE = "data/stat/PWT.pos";
        this.PTT_TDBM_FILE = "data/stat/PTT.pos";
        this.PPH_TDBM_FILE = "data/stat/Ptt.pos";
        this.pwt_tf = new ProbabilityDBM(this.PWT_TDBM_FILE);
        this.pph_tf = new ProbabilityDBM(this.PPH_TDBM_FILE);
        this.ptt_tf = new ProbabilityDBM(this.PTT_TDBM_FILE);
        this.in = in != null ? new BufferedReader(in) : null;
        this.out = out != null ? new PrintWriter(out) : null;
    }

    public int new_mnode(String str, String wp_tag, double prob) {
        this.mn[this.mn_end].mout_str = str;
        this.mn[this.mn_end].wp_tag = wp_tag;
        this.mn[this.mn_end].prob_wt = prob;
        this.mn[this.mn_end].backptr = 0;
        this.mn[this.mn_end].sibling = 0;
        return this.mn_end++;
    }

    public int new_wp(String str) {
        this.wp[this.wp_end].word = str;
        this.wp[this.wp_end].mnode = 0;
        return this.wp_end++;
    }

    public String phrase_tag(String str) {
        String words = null;
        Object morph = null;
        Object tag = null;
        String tags = null;
        StringTokenizer st = new StringTokenizer(str, " \t");
        if (!st.hasMoreTokens()) {
            System.err.println("HMMTagger: phrase_tag: wrong parameter");
        }
        words = st.nextToken();
        int p = 0;
        tags = "";
        int flag = 0;
        p = 0;
        while (p < words.length()) {
            if (words.charAt(p) == '\\') {
                ++p;
            } else if (words.charAt(p) == '+') {
                flag = 0;
                tags = String.valueOf(tags) + ' ';
            } else if (words.charAt(p) == '/') {
                flag = 1;
            } else if (flag != 0) {
                tags = String.valueOf(tags) + words.charAt(p);
                if (++flag > 10) {
                    flag = 0;
                }
            }
            ++p;
        }
        this.wtag = PhraseTag.phtag(tags);
        return this.wtag;
    }

    private void reset() {
        this.wp_end = 1;
        this.mn_end = 1;
    }

    @Override
    public void run() throws Exception {
        String line = null;
        boolean state = false;
        while ((line = this.in.readLine()) != null) {
            if (line.length() == 0 || line.equals("BOS")) continue;
            if (line.equals("EOS")) {
                this.end_sentence();
                this.reset();
                this.org_pos = 0;
                continue;
            }
            if (line.equals("EOF")) {
                this.out.write("EOF\n\n");
                this.out.flush();
                continue;
            }
            if (line.length() <= 0) continue;
            int v = 0;
            int prev_v = 0;
            int w = 0;
            switch (line.charAt(0)) {
                case ' ': {
                    break;
                }
                case '@': {
                    break;
                }
            }
            this.org_eojeol[this.org_pos++] = line.substring(1);
            w = this.new_wp(line.substring(1));
            boolean is_first = true;
            while ((line = this.in.readLine()) != null && line.length() != 0) {
                line = line.substring(1);
                String now_tag = this.phrase_tag(line);
                double probability = this.compute_wt(line);
                v = this.new_mnode(line, now_tag, probability);
                if (is_first) {
                    this.wp[w].mnode = v;
                    is_first = false;
                    prev_v = v;
                    continue;
                }
                this.mn[prev_v].sibling = v;
                prev_v = v;
            }
        }
    }

    @Override
    public void setReader(Reader in) {
        this.in = in != null ? new BufferedReader(in) : null;
    }

    @Override
    public void setWriter(Writer out) {
        this.out = out != null ? new PrintWriter(out) : null;
    }

    @Override
    public void shutdown() {
    }

    public void update_prob_score(int from, int to) {
        short[] data = new short[256];
        Object TTS = null;
        short[] wtS = new short[256];
        double PTT = SF;
        if (this.mn[from].backptr == 0) {
            this.mn[from].prob = this.mn[from].prob_wt;
        }
        double P = this.mn[from].prob + PTT + this.mn[to].prob_wt;
        if (this.view) {
            System.out.format("%s(%d:%s) : %f -> %f -> %s(%d:%s) : %f\n", this.mn[from].mout_str, from, this.mn[from].wp_tag, this.mn[from].prob, PTT, this.mn[to].mout_str, to, this.mn[to].wp_tag, this.mn[to].prob_wt);
        }
        if (this.mn[to].backptr == 0 || P > this.mn[to].prob) {
            this.mn[to].backptr = from;
            this.mn[to].prob = P;
        }
    }

    class MNode {
        String mout_str;
        String wp_tag;
        double prob_wt;
        double prob;
        int backptr;
        int sibling;

        MNode() {
        }
    }

    class WPhead {
        String word;
        int mnode;

        WPhead() {
        }
    }
}

