/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import kr.ac.kaist.swrc.jhannanum.hannanum.Workflow;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.ChartMorphAnalyzer;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.PosTagger.HmmPosTagger.HMMTagger;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.MorphemeProcessor.KaistTagMappingLevel1.KaistTagMappingLevel1;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.MorphemeProcessor.KaistTagMappingLevel2.KaistTagMappingLevel2;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.MorphemeProcessor.KaistTagMappingLevel3.KaistTagMappingLevel3;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.MorphemeProcessor.KaistTagMappingLevel4.KaistTagMappingLevel4;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.MorphemeProcessor.UnknownMorphProcessor.UnknownProcessor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.InformalSentenceFilter.InformalSentenceFilter;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.SentenceSegmentor.SentenceSegmentor;
import kr.ac.kaist.swrc.jhannanum.share.JSONReader;
import org.json.JSONException;

public class WorkflowWithGUI {
    private JFrame mainFrame = null;
    private JMenuBar menuBar = null;
    private JMenu menuFile = null;
    private JMenuItem menuItemFileOpen = null;
    private JTree tree;
    private HashMap<String, String> pluginInfoMap = null;
    private JList listPluginMajor2 = null;
    private JList listPluginMajor3 = null;
    private JList listPluginSupplement1 = null;
    private JList listPluginSupplement2 = null;
    private JList listPluginSupplement3 = null;
    private DefaultListModel listModelMajor2 = null;
    private DefaultListModel listModelMajor3 = null;
    private DefaultListModel listModelSupplement1 = null;
    private DefaultListModel listModelSupplement2 = null;
    private DefaultListModel listModelSupplement3 = null;
    private JTextArea areaPluginInfo = null;
    private JTextArea inputTextArea = null;
    private JTextArea outputTextArea = null;
    private JSplitPane splitPaneTop = null;
    private JSplitPane splitPaneBottom = null;
    private JRadioButton radioMultiThread = null;
    private JRadioButton radioSingleThread = null;
    private JButton buttonActivate = null;
    private JButton buttonAnalysis = null;
    private JButton buttonReset = null;
    private PluginInfo selectedPlugin = null;
    private PluginInfo tempPlugin = null;
    private boolean multiThreadMode = true;
    private boolean activated = false;
    private Workflow workflow = null;

    public static void main(String[] args) {
        WorkflowWithGUI demo = new WorkflowWithGUI();
        demo.run();
    }

    public void run() {
        this.mainFrame = new JFrame();
        Toolkit kit = this.mainFrame.getToolkit();
        Dimension windowSize = kit.getScreenSize();
        this.mainFrame.setBounds(windowSize.width / 20, windowSize.height / 20, windowSize.width * 18 / 20, windowSize.height * 18 / 20);
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.setTitle("HanNanum Korean Morphological Analyzer - A Plug-in Component based System (GUI Demo)");
        Font font = new Font("MonoSpaced", 0, 12);
        UIManager.put("TextArea.font", font);
        this.mainFrame.setLayout(new BorderLayout());
        this.mainFrame.getContentPane().add((Component)this.createPaneCenter(), "Center");
        this.mainFrame.getContentPane().add((Component)this.createPaneNorth(), "North");
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuItemFileOpen = new JMenuItem("Open", 79);
        this.menuItemFileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        this.menuBar.add(this.menuFile);
        this.menuFile.add(this.menuItemFileOpen);
        this.mainFrame.setJMenuBar(this.menuBar);
        this.menuItemFileOpen.addActionListener(new SharedActionHandler());
        this.buttonActivate.addActionListener(new SharedActionHandler());
        this.buttonAnalysis.addActionListener(new SharedActionHandler());
        this.buttonReset.addActionListener(new SharedActionHandler());
        this.radioMultiThread.addActionListener(new SharedActionHandler());
        this.radioSingleThread.addActionListener(new SharedActionHandler());
        this.listPluginMajor2.addMouseListener(new PluginListMouseListener(this.listPluginMajor2, this.listModelMajor2));
        this.listPluginMajor3.addMouseListener(new PluginListMouseListener(this.listPluginMajor3, this.listModelMajor3));
        this.listPluginSupplement1.addMouseListener(new PluginListMouseListener(this.listPluginSupplement1, this.listModelSupplement1));
        this.listPluginSupplement2.addMouseListener(new PluginListMouseListener(this.listPluginSupplement2, this.listModelSupplement2));
        this.listPluginSupplement3.addMouseListener(new PluginListMouseListener(this.listPluginSupplement3, this.listModelSupplement3));
        this.listPluginMajor2.setTransferHandler(new PluginTransferHandler(2, 1));
        this.listPluginMajor3.setTransferHandler(new PluginTransferHandler(3, 1));
        this.listPluginSupplement1.setTransferHandler(new PluginTransferHandler(1, 2));
        this.listPluginSupplement2.setTransferHandler(new PluginTransferHandler(2, 2));
        this.listPluginSupplement3.setTransferHandler(new PluginTransferHandler(3, 2));
        this.listPluginSupplement1.setDropMode(DropMode.ON_OR_INSERT);
        this.listPluginSupplement2.setDropMode(DropMode.ON_OR_INSERT);
        this.listPluginSupplement3.setDropMode(DropMode.ON_OR_INSERT);
        this.listPluginMajor2.setDropMode(DropMode.ON_OR_INSERT);
        this.listPluginMajor3.setDropMode(DropMode.ON_OR_INSERT);
        this.listPluginMajor2.getSelectionModel().setSelectionMode(0);
        this.listPluginMajor3.getSelectionModel().setSelectionMode(0);
        this.listPluginSupplement1.getSelectionModel().setSelectionMode(0);
        this.listPluginSupplement2.getSelectionModel().setSelectionMode(0);
        this.listPluginSupplement3.getSelectionModel().setSelectionMode(0);
        this.listPluginMajor2.setDragEnabled(true);
        this.listPluginMajor3.setDragEnabled(true);
        this.listPluginSupplement1.setDragEnabled(true);
        this.listPluginSupplement2.setDragEnabled(true);
        this.listPluginSupplement3.setDragEnabled(true);
        this.tree.setDragEnabled(true);
        this.tempPlugin = new PluginInfo("", 0, 0);
        this.workflow = new Workflow();
        this.mainFrame.setVisible(true);
        this.splitPaneTop.setDividerLocation(0.3);
        this.splitPaneBottom.setDividerLocation(0.5);
    }

    private JComponent createPaneNorth() {
        this.splitPaneTop = new JSplitPane(1);
        this.splitPaneTop.setLeftComponent(this.createPluginPool());
        this.splitPaneTop.setRightComponent(this.createWorkflow());
        this.splitPaneTop.setOneTouchExpandable(true);
        return this.splitPaneTop;
    }

    private JComponent createPluginPool() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("HanNanum Plug-in Pool");
        this.createPluginNodes(top);
        this.loadPluginInformation();
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new PluginTreeSelectionListener());
        this.tree.putClientProperty("JTree.lineStyle", "Horizontal");
        JScrollPane treeView = new JScrollPane(this.tree);
        return treeView;
    }

    private void createPluginNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode phase = null;
        DefaultMutableTreeNode type = null;
        phase = new DefaultMutableTreeNode("Phase1 Plug-in. Plain Text Processing");
        type = new DefaultMutableTreeNode("Supplement Plugin");
        type.add(new DefaultMutableTreeNode(new PluginInfo("InformalSentenceFilter", 1, 2)));
        type.add(new DefaultMutableTreeNode(new PluginInfo("SentenceSegmentor", 1, 2)));
        phase.add(type);
        top.add(phase);
        phase = new DefaultMutableTreeNode("Phase2 Plug-in. Morphological Analysis");
        type = new DefaultMutableTreeNode("Major Plug-in");
        type.add(new DefaultMutableTreeNode(new PluginInfo("ChartMorphAnalyzer", 2, 1)));
        phase.add(type);
        type = new DefaultMutableTreeNode("Supplement Plug-in");
        type.add(new DefaultMutableTreeNode(new PluginInfo("UnknownMorphProcessor", 2, 2)));
        type.add(new DefaultMutableTreeNode(new PluginInfo("KaistTagMappingLevel1", 2, 2)));
        type.add(new DefaultMutableTreeNode(new PluginInfo("KaistTagMappingLevel2", 2, 2)));
        type.add(new DefaultMutableTreeNode(new PluginInfo("KaistTagMappingLevel3", 2, 2)));
        type.add(new DefaultMutableTreeNode(new PluginInfo("KaistTagMappingLevel4", 2, 2)));
        phase.add(type);
        top.add(phase);
        phase = new DefaultMutableTreeNode("Phase3 Plug-in. Part Of Speech Tagging");
        type = new DefaultMutableTreeNode("Major Plug-in");
        type.add(new DefaultMutableTreeNode(new PluginInfo("HmmPosTagger", 3, 1)));
        phase.add(type);
        top.add(phase);
    }

    private void loadPluginInformation() {
        try {
            this.pluginInfoMap = new HashMap();
            this.pluginInfoMap.put("InformalSentenceFilter", this.getPluginAbstarct("conf/plugin/SupplementPlugin/PlainTextProcessor/InformalSentenceFilter.json"));
            this.pluginInfoMap.put("SentenceSegmentor", this.getPluginAbstarct("conf/plugin/SupplementPlugin/PlainTextProcessor/SentenceSegmentor.json"));
            this.pluginInfoMap.put("ChartMorphAnalyzer", this.getPluginAbstarct("conf/plugin/MajorPlugin/MorphAnalyzer/ChartMorphAnalyzer.json"));
            this.pluginInfoMap.put("UnknownMorphProcessor", this.getPluginAbstarct("conf/plugin/SupplementPlugin/MorphemeProcessor/UnknownMorphProcessor.json"));
            this.pluginInfoMap.put("KaistTagMappingLevel1", this.getPluginAbstarct("conf/plugin/SupplementPlugin/MorphemeProcessor/KaistTagMappingLevel1.json"));
            this.pluginInfoMap.put("KaistTagMappingLevel2", this.getPluginAbstarct("conf/plugin/SupplementPlugin/MorphemeProcessor/KaistTagMappingLevel2.json"));
            this.pluginInfoMap.put("KaistTagMappingLevel3", this.getPluginAbstarct("conf/plugin/SupplementPlugin/MorphemeProcessor/KaistTagMappingLevel3.json"));
            this.pluginInfoMap.put("KaistTagMappingLevel4", this.getPluginAbstarct("conf/plugin/SupplementPlugin/MorphemeProcessor/KaistTagMappingLevel4.json"));
            this.pluginInfoMap.put("HmmPosTagger", this.getPluginAbstarct("conf/plugin/MajorPlugin/PosTagger/HmmPosTagger.json"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getPluginAbstarct(String filePath) throws JSONException, IOException {
        JSONReader json = new JSONReader(filePath);
        String res = null;
        res = String.format("* Name: %s\n* Type: %s\n* Version: %s\n* Author: %s\n* Description: %s\n", json.getName(), json.getType(), json.getVersion(), json.getAuthor(), json.getDescription());
        return res;
    }

    private JComponent createWorkflow() {
        JPanel workflowPanel = new JPanel(new GridLayout(1, 3));
        this.listModelMajor2 = new DefaultListModel();
        this.listModelMajor3 = new DefaultListModel();
        this.listModelSupplement1 = new DefaultListModel();
        this.listModelSupplement2 = new DefaultListModel();
        this.listModelSupplement3 = new DefaultListModel();
        this.listPluginMajor2 = new JList(this.listModelMajor2);
        this.listPluginMajor3 = new JList(this.listModelMajor3);
        this.listPluginSupplement1 = new JList(this.listModelSupplement1);
        this.listPluginSupplement2 = new JList(this.listModelSupplement2);
        this.listPluginSupplement3 = new JList(this.listModelSupplement3);
        JPanel phasePanel = new JPanel(new GridLayout(1, 1));
        phasePanel.setBorder(BorderFactory.createTitledBorder("Phase1. Plain Text Processing"));
        JPanel listPanel = new JPanel(new GridLayout(1, 1));
        listPanel.setBorder(BorderFactory.createTitledBorder("Supplement Plug-in"));
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.listPluginSupplement1);
        listPanel.add(scroll);
        phasePanel.add(listPanel);
        workflowPanel.add(phasePanel);
        phasePanel = new JPanel(new GridLayout(1, 2));
        phasePanel.setBorder(BorderFactory.createTitledBorder("Phase2. Morphological Analysis"));
        listPanel = new JPanel(new GridLayout(1, 1));
        listPanel.setBorder(BorderFactory.createTitledBorder("Major Plug-in"));
        scroll = new JScrollPane();
        scroll.setViewportView(this.listPluginMajor2);
        listPanel.add(scroll);
        phasePanel.add(listPanel);
        listPanel = new JPanel(new GridLayout(1, 1));
        listPanel.setBorder(BorderFactory.createTitledBorder("Supplement Plug-in"));
        scroll = new JScrollPane();
        scroll.setViewportView(this.listPluginSupplement2);
        listPanel.add(scroll);
        phasePanel.add(listPanel);
        workflowPanel.add(phasePanel);
        phasePanel = new JPanel(new GridLayout(1, 2));
        phasePanel.setBorder(BorderFactory.createTitledBorder("Phase3. Part Of Speech Tagging"));
        listPanel = new JPanel(new GridLayout(1, 1));
        listPanel.setBorder(BorderFactory.createTitledBorder("Major Plug-in"));
        scroll = new JScrollPane();
        scroll.setViewportView(this.listPluginMajor3);
        listPanel.add(scroll);
        phasePanel.add(listPanel);
        listPanel = new JPanel(new GridLayout(1, 1));
        listPanel.setBorder(BorderFactory.createTitledBorder("Supplement Plug-in"));
        scroll = new JScrollPane();
        scroll.setViewportView(this.listPluginSupplement3);
        listPanel.add(scroll);
        phasePanel.add(listPanel);
        workflowPanel.add(phasePanel);
        JPanel controlPanel = new JPanel(new GridLayout(4, 1));
        controlPanel.setBorder(BorderFactory.createTitledBorder("Workflow Control"));
        this.buttonActivate = new JButton("Activate the workflow");
        this.buttonAnalysis = new JButton("Analyze Text");
        this.buttonReset = new JButton("Close the workflow");
        JPanel threadPanel = new JPanel(new GridLayout(1, 1));
        this.radioMultiThread = new JRadioButton("Mutli-thread Mode", true);
        this.radioSingleThread = new JRadioButton("Single-thread Mode", false);
        threadPanel.setBorder(BorderFactory.createTitledBorder("Thread Mode"));
        threadPanel.add(this.radioMultiThread);
        threadPanel.add(this.radioSingleThread);
        ButtonGroup groupThread = new ButtonGroup();
        groupThread.add(this.radioMultiThread);
        groupThread.add(this.radioSingleThread);
        controlPanel.add(threadPanel);
        controlPanel.add(this.buttonActivate);
        controlPanel.add(this.buttonAnalysis);
        controlPanel.add(this.buttonReset);
        this.buttonAnalysis.setEnabled(false);
        this.buttonReset.setEnabled(false);
        JPanel pluginInfoPanel = new JPanel(new GridLayout(1, 1));
        pluginInfoPanel.setBorder(BorderFactory.createTitledBorder("Plug-in Information"));
        this.areaPluginInfo = new JTextArea();
        this.areaPluginInfo.setLineWrap(true);
        scroll = new JScrollPane();
        scroll.setViewportView(this.areaPluginInfo);
        pluginInfoPanel.add(scroll);
        JPanel infoPanel = new JPanel(new GridLayout(1, 2));
        infoPanel.add(pluginInfoPanel);
        infoPanel.add(controlPanel);
        JPanel panel = new JPanel(new GridLayout(2, 1));
        workflowPanel.setBorder(BorderFactory.createTitledBorder("HanNanum Workflow"));
        panel.add(workflowPanel);
        panel.add(infoPanel);
        return panel;
    }

    private JComponent createPaneCenter() {
        this.splitPaneBottom = new JSplitPane(1);
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setBorder(BorderFactory.createTitledBorder("Input Text"));
        this.inputTextArea = new JTextArea();
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.inputTextArea);
        panel.add(scroll);
        this.splitPaneBottom.setLeftComponent(panel);
        panel = new JPanel(new GridLayout(1, 1));
        panel.setBorder(BorderFactory.createTitledBorder("Result"));
        this.outputTextArea = new JTextArea();
        scroll = new JScrollPane();
        scroll.setViewportView(this.outputTextArea);
        panel.add(scroll);
        this.splitPaneBottom.setRightComponent(panel);
        this.splitPaneBottom.setOneTouchExpandable(true);
        return this.splitPaneBottom;
    }

    private class PluginInfo {
        public static final int PHASE1 = 1;
        public static final int PHASE2 = 2;
        public static final int PHASE3 = 3;
        public static final int MAJOR = 1;
        public static final int SUPPLEMENT = 2;
        public String name;
        public int phase = 0;
        public int type = 0;

        public PluginInfo(String name, int phase, int type) {
            this.name = name;
            this.phase = phase;
            this.type = type;
        }

        public String toString() {
            return this.name;
        }
    }

    private class PluginListMouseListener
    implements MouseListener {
        private JList list = null;
        private DefaultListModel listModel = null;

        public PluginListMouseListener(JList list, DefaultListModel listModel) {
            this.list = list;
            this.listModel = listModel;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.listModel.remove(this.list.locationToIndex(e.getPoint()));
            } else {
                try {
                    WorkflowWithGUI.this.areaPluginInfo.setText((String)WorkflowWithGUI.this.pluginInfoMap.get((String)this.listModel.get(this.list.locationToIndex(e.getPoint()))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class PluginTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;
        private int phase = 0;
        private int type = 0;

        public PluginTransferHandler(int phase, int type) {
            this.phase = phase;
            this.type = type;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return !WorkflowWithGUI.this.activated && WorkflowWithGUI.this.selectedPlugin != null && this.phase == ((WorkflowWithGUI)WorkflowWithGUI.this).selectedPlugin.phase && this.type == ((WorkflowWithGUI)WorkflowWithGUI.this).selectedPlugin.type;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            if (!info.isDrop()) {
                return false;
            }
            if (!info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            JList.DropLocation dl = (JList.DropLocation)info.getDropLocation();
            DefaultListModel listModel = null;
            int index = dl.getIndex();
            switch (((WorkflowWithGUI)WorkflowWithGUI.this).selectedPlugin.phase) {
                case 1: {
                    listModel = (DefaultListModel)WorkflowWithGUI.this.listPluginSupplement1.getModel();
                    break;
                }
                case 2: {
                    if (((WorkflowWithGUI)WorkflowWithGUI.this).selectedPlugin.type == 1) {
                        listModel = (DefaultListModel)WorkflowWithGUI.this.listPluginMajor2.getModel();
                        listModel.clear();
                        index = 0;
                        break;
                    }
                    if (((WorkflowWithGUI)WorkflowWithGUI.this).selectedPlugin.type != 2) break;
                    listModel = (DefaultListModel)WorkflowWithGUI.this.listPluginSupplement2.getModel();
                    break;
                }
                case 3: {
                    if (((WorkflowWithGUI)WorkflowWithGUI.this).selectedPlugin.type == 1) {
                        listModel = (DefaultListModel)WorkflowWithGUI.this.listPluginMajor3.getModel();
                        listModel.clear();
                        index = 0;
                        break;
                    }
                    if (((WorkflowWithGUI)WorkflowWithGUI.this).selectedPlugin.type != 2) break;
                    listModel = (DefaultListModel)WorkflowWithGUI.this.listPluginSupplement3.getModel();
                }
            }
            if (listModel == null) {
                return false;
            }
            try {
                Transferable t = info.getTransferable();
                String data = (String)t.getTransferData(DataFlavor.stringFlavor);
                int pIndex = listModel.indexOf(data);
                listModel.add(index, data);
                if (pIndex != -1) {
                    if (pIndex >= index) {
                        ++pIndex;
                    }
                    listModel.remove(pIndex);
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JList list = (JList)c;
            Object[] values = list.getSelectedValues();
            StringBuffer buff = new StringBuffer();
            if (values.length >= 0) {
                Object val = values[0];
                buff.append(val);
            }
            ((WorkflowWithGUI)WorkflowWithGUI.this).tempPlugin.name = buff.toString();
            ((WorkflowWithGUI)WorkflowWithGUI.this).tempPlugin.phase = this.phase;
            ((WorkflowWithGUI)WorkflowWithGUI.this).tempPlugin.type = this.type;
            WorkflowWithGUI.this.selectedPlugin = WorkflowWithGUI.this.tempPlugin;
            return new StringSelection(buff.toString());
        }
    }

    private class PluginTreeSelectionListener
    implements TreeSelectionListener {
        private PluginTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)WorkflowWithGUI.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                WorkflowWithGUI.this.selectedPlugin = null;
                return;
            }
            Object nodeInfo = node.getUserObject();
            if (node.isLeaf()) {
                WorkflowWithGUI.this.selectedPlugin = (PluginInfo)nodeInfo;
                WorkflowWithGUI.this.areaPluginInfo.setText((String)WorkflowWithGUI.this.pluginInfoMap.get(((WorkflowWithGUI)WorkflowWithGUI.this).selectedPlugin.name));
            } else {
                WorkflowWithGUI.this.selectedPlugin = null;
            }
        }
    }

    private class SharedActionHandler
    implements ActionListener {
        private SharedActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Object source = e.getSource();
                if (source == WorkflowWithGUI.this.menuItemFileOpen) {
                    this.fileOpen();
                } else if (source == WorkflowWithGUI.this.buttonActivate) {
                    this.initWorkflow();
                    this.activateWorkflow();
                } else if (source == WorkflowWithGUI.this.buttonAnalysis) {
                    this.analyzeText();
                } else if (source == WorkflowWithGUI.this.buttonReset) {
                    this.reset();
                } else if (source == WorkflowWithGUI.this.radioMultiThread) {
                    WorkflowWithGUI.this.multiThreadMode = true;
                } else if (source == WorkflowWithGUI.this.radioSingleThread) {
                    WorkflowWithGUI.this.multiThreadMode = false;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }

        private void fileOpen() {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File("."));
            chooser.setFileSelectionMode(0);
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(WorkflowWithGUI.this.mainFrame) == 0) {
                File selectedFile = chooser.getSelectedFile();
                try {
                    BufferedReader br = new BufferedReader(new FileReader(selectedFile));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        WorkflowWithGUI.this.inputTextArea.append(String.valueOf(line) + "\n");
                    }
                    br.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private void initWorkflow() {
            WorkflowWithGUI.this.workflow.clear();
            String pluginName = null;
            int i = 0;
            while (i < WorkflowWithGUI.this.listModelSupplement1.size()) {
                pluginName = (String)WorkflowWithGUI.this.listModelSupplement1.get(i);
                if (pluginName.equals("InformalSentenceFilter")) {
                    WorkflowWithGUI.this.workflow.appendPlainTextProcessor(new InformalSentenceFilter(), null);
                } else if (pluginName.equals("SentenceSegmentor")) {
                    WorkflowWithGUI.this.workflow.appendPlainTextProcessor(new SentenceSegmentor(), null);
                }
                ++i;
            }
            if (WorkflowWithGUI.this.listModelMajor2.size() > 0) {
                pluginName = (String)WorkflowWithGUI.this.listModelMajor2.get(0);
                if (pluginName.equals("ChartMorphAnalyzer")) {
                    WorkflowWithGUI.this.workflow.setMorphAnalyzer(new ChartMorphAnalyzer(), "conf/plugin/MajorPlugin/MorphAnalyzer/ChartMorphAnalyzer.json");
                }
            } else {
                return;
            }
            i = 0;
            while (i < WorkflowWithGUI.this.listModelSupplement2.size()) {
                pluginName = (String)WorkflowWithGUI.this.listModelSupplement2.get(i);
                if (pluginName.equals("UnknownMorphProcessor")) {
                    WorkflowWithGUI.this.workflow.appendMorphemeProcessor(new UnknownProcessor(), null);
                } else if (pluginName.equals("KaistTagMappingLevel1")) {
                    WorkflowWithGUI.this.workflow.appendMorphemeProcessor(new KaistTagMappingLevel1(), null);
                } else if (pluginName.equals("KaistTagMappingLevel2")) {
                    WorkflowWithGUI.this.workflow.appendMorphemeProcessor(new KaistTagMappingLevel2(), null);
                } else if (pluginName.equals("KaistTagMappingLevel3")) {
                    WorkflowWithGUI.this.workflow.appendMorphemeProcessor(new KaistTagMappingLevel3(), null);
                } else if (pluginName.equals("KaistTagMappingLevel4")) {
                    WorkflowWithGUI.this.workflow.appendMorphemeProcessor(new KaistTagMappingLevel4(), null);
                }
                ++i;
            }
            if (WorkflowWithGUI.this.listModelMajor3.size() > 0) {
                pluginName = (String)WorkflowWithGUI.this.listModelMajor3.get(0);
                if (pluginName.equals("HmmPosTagger")) {
                    WorkflowWithGUI.this.workflow.setPosTagger(new HMMTagger(), "conf/plugin/MajorPlugin/PosTagger/HmmPosTagger.json");
                }
            } else {
                return;
            }
            i = 0;
            while (i < WorkflowWithGUI.this.listModelSupplement3.size()) {
                pluginName = (String)WorkflowWithGUI.this.listModelSupplement3.get(i);
                ++i;
            }
        }

        private void activateWorkflow() {
            try {
                WorkflowWithGUI.this.workflow.activateWorkflow(WorkflowWithGUI.this.multiThreadMode);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            WorkflowWithGUI.this.buttonAnalysis.setEnabled(true);
            WorkflowWithGUI.this.buttonReset.setEnabled(true);
            WorkflowWithGUI.this.buttonActivate.setEnabled(false);
            WorkflowWithGUI.this.radioMultiThread.setEnabled(false);
            WorkflowWithGUI.this.radioSingleThread.setEnabled(false);
            WorkflowWithGUI.this.listPluginSupplement1.setEnabled(false);
            WorkflowWithGUI.this.listPluginSupplement2.setEnabled(false);
            WorkflowWithGUI.this.listPluginSupplement3.setEnabled(false);
            WorkflowWithGUI.this.listPluginMajor2.setEnabled(false);
            WorkflowWithGUI.this.listPluginMajor3.setEnabled(false);
            WorkflowWithGUI.this.activated = true;
        }

        private void analyzeText() {
            String text = WorkflowWithGUI.this.inputTextArea.getText();
            if (text != null && text.length() > 0) {
                WorkflowWithGUI.this.workflow.analyze(WorkflowWithGUI.this.inputTextArea.getText());
                WorkflowWithGUI.this.outputTextArea.setText(WorkflowWithGUI.this.workflow.getResultOfDocument());
                WorkflowWithGUI.this.buttonReset.setEnabled(true);
                WorkflowWithGUI.this.buttonActivate.setEnabled(false);
            } else {
                WorkflowWithGUI.this.outputTextArea.setText("");
            }
        }

        private void reset() {
            WorkflowWithGUI.this.workflow.clear();
            WorkflowWithGUI.this.buttonActivate.setEnabled(true);
            WorkflowWithGUI.this.buttonAnalysis.setEnabled(false);
            WorkflowWithGUI.this.buttonReset.setEnabled(false);
            WorkflowWithGUI.this.radioMultiThread.setEnabled(true);
            WorkflowWithGUI.this.radioSingleThread.setEnabled(true);
            WorkflowWithGUI.this.listPluginSupplement1.setEnabled(true);
            WorkflowWithGUI.this.listPluginSupplement2.setEnabled(true);
            WorkflowWithGUI.this.listPluginSupplement3.setEnabled(true);
            WorkflowWithGUI.this.listPluginMajor2.setEnabled(true);
            WorkflowWithGUI.this.listPluginMajor3.setEnabled(true);
            WorkflowWithGUI.this.activated = false;
        }
    }
}

