<?php
/**
 * RSS 2.0 출력기
 *
 * 기본적으로 module/rss/index.php 와 동일하다.
 * 차이점은 output_compress 의 영향을 받지 않는다는 것이며, 내용을 생략해서 전달한다.
 * 즉, 제목만 출력해 줌으로서 서버로 연결을 자주, 여러번 읽어도 용량을 적게 먹는다.
 * 이것의 용도는 새글의 제목만 출력해주고 클릭시 홈페이지로 이동하는 RSS 리더기를 제작하기 위해서이다.
 *
 * @param string $ui[id]				정보(카테고리) 아이디
 * @param string $ui[idx]				정보(카테고리) 번호
 * @todo string $ui[hourago]		시간 단위. 이 시간 이전에 기록된 정보는 추출하지 않는다.
 *	예를 들면, 48 의 값을 입력하면, 48 시간 이전의 정보는 추출하지 않는다.
 *
 * 입력이 생략되면, 전체에서 새로운 정보를 보여준다.
 * 정보를 보여줄 때에는 권한 체크를 한다.
 *
 * @todo dateTime_firstwrite		기준으로 정보를 추출
 */
/**
 *
 *
 */
$dirRoot = "..";
$install = include_once("$dirRoot/lib/default.php");
lib('string');
if ( empty($ui['id']) && empty($ui['idx']) ) { $_cate = array(); }
else if ( !empty($ui['id']) ) { $_cate[] = $ui['id']; }
/**
 * idx 는 게시물 번호일 수도 카테고리 번호 일수도있다.
 */
else if ( !empty($ui['idx']) )
{
	lib('category');
	$_c = getCategory($ui['idx']);
	if ( empty($_c) )
	{
		lib('post');
		$_p = getPost($ui['idx']);
		if ( empty($_p) )
		{
			goBack(wrongIndex, "module::rs you have submitted wrong category (or data) index.");
		}
		$_c = getCategory($_p['idx_category']);
	}
	$_cate[] = $_c['idx'];
}

$urlHomepage = str_replace("etc/", "", urlHomepage);


lib('post');
$kvs['idx_category_type']				= CATE_BBS;
$kvs['idx_category_type cond']	= "=";
$limit['toNumber']							= 10;
$order['dateTime_firstwrite']		= 'DESC';

$_posts = articles($_cate, $kvs, $limit, $order);
faultCode($_posts) and goBack(wrongIndex, "module::rss::articles something happens on searchPost");


if (!isset($system['name']) || empty($system['name'])) $system['name'] = '이름없음 by 장난홈툴즈';
if (!isset($system['description'])) $system['description'] = '설명없음 by 장난홈툴즈';

//
headers("Content-Type: text/xml");

$_message  = "<?xml version=\"1.0\" ?>".rn;
$_message .= "<!--  RSS generated by Jangnan RSS Module v0.1 on ".date("d/m/Y; h:i:s A P")." -->".rn;
$_message .= "<rss version=\"2.0\">".rn;
$_message .= "<channel>".rn;
$_message .= "<title>$system[name] </title>".rn;
$_message .= "<link>".$urlHomepage."</link>".rn;
$_message .= "<description><![CDATA["." $system[description] "."]]></description>".rn;
$_message .= "<lastBuildDate>".date("r")."</lastBuildDate>".rn;
$_message .= "<generator>Jangnan RSS Module v0.1</generator>".rn;
if ( isset($system['mail']) ) $_message .= "<webMaster>$system[mail] ($system[admin_id])</webMaster>".rn;
$_message .= "<ttl>60</ttl>".rn;


foreach( $_posts as $post )
{
	$_message .= "<item>".rn;
	$_message .= "<title><![CDATA["."$post[title] $post[name]"."]]></title>".rn;
	$_message .= "<author>$post[name]</author>".rn;
	$_message .= "<link>".$urlHomepage.htmlentities($post['url'])."</link>".rn;
	$_message .= "<description><![CDATA[".strcut($post['description'],128)."]]></description>".rn;
	$_message .= "<pubDate>".date("r", toStamp($post['dateTime']))."</pubDate>".rn;
	$_message .= "<guid>".$urlHomepage.htmlentities($post['url'])."</guid>".rn;
	$_message .= "</item>".rn;
}

// 사용자 정보 출력
lib('user');
$kvs = array();
$users = searchUser($kvs, array('toNumber'=>5), array('dateTime_signup'=>'DESC'));
foreach( $users as $user )
{
	$_message .= "<item>".rn;
	$_message .= "<title>회원 가입: $user[nick]($user[id])</title>".rn;
	$_message .= "<author>$user[email]</author>".rn;
	$_message .= "<link>".$urlHomepage.htmlentities("?cate=user&mode=read&idx=$user[idx]")."</link>".rn;
	$_message .= "<description><![CDATA[".strcut($user['memo'],128)."]]></description>".rn;
	$_message .= "<pubDate>".date("r", toStamp($user['dateTime']))."</pubDate>".rn;
	$_message .= "<guid>".$urlHomepage.htmlentities("?cate=user&mode=read&idx=$user[idx]")."</guid>".rn;
	$_message .= "</item>".rn;
}

$_message .= "</channel>".rn;
$_message .= "</rss>".rn;


echo $_message;

unset($_message);
unset($_cate);
exit;
//return array('0000000');
?>
