<?php
/**
 * 카테고리 자체의 정보를 관리한다.
 *
 * 카테고리 관련 작업에서 직접 적으로 DB 액세스를 해서는 안된다. 이것은 모든 DB 관련 작업에서 마찬가지이다.
 * 준비된 라이브러리를 통해서 DB 작업을 해야 일관성이 유지가 된다.
 * @note 카테고리 종류는 상수로 정의된 값이 사용되어야한다. 이 외의 값을 사용할 경우, 데이터 일관성의 유지가 어렵다.
 *
 *
 * @package library
 */





lib('db');




/**
 * 새 카테고리 정보를 입력한다.
 *
 * @param associative-array $post SQL 의 INSERT 구문에 그대로 사용될 필드와 값을 가지는 연관 배열
 * @return faultCode
 */
function insertCategory($post)
{
	global $db;
	
	// 기본값 지정
	if ( ! isset($post['dateTime']) ) $post['dateTime'] = dateTime();
	
	$rc = $db->insert('category', $post);
	return faultDb($rc);
}
/**
 * 이 함수는 곧 사라질 것이다.
 *
 * @deprecated since 0.1 잘못된 함수명
 * @see insertCategory
 */
function _insertCategory($post) { return insertCategory($post); }
/**
 * {@link insertCategory} 와 같은 것이다.
 *
 * @see insertCategory
 */
function addCategory($post) { return insertCategory($post); }


/**
 * category.idx 를 기반으로 카테고리 정보를 수정(업데이트)한다. 따라서 입력 변수에는 idx 값이 들어있어야한다.
 *
 * 카테고리 아이디의 변경이 가능하다.
 * @see 개발자노트.정보의 수정
 * @param associative-array $post 카테고리 정보를 가지고 있는 연관 배열.
 * @return faultCode
 * @note 명칭 변경 categoryUpdate -> updateCategory
 */
function updateCategory($post)
{
	if ( empty($post['idx']) ) return faultEx(wrongIndex, "category.idx 정보가 없습니다.");
	
	global $db;

	$rc = $db->update('category', $post, array('idx'=>$post['idx']));
	return faultDb($rc);
}


/**
 * 카테고리 삭제
 *
 * 카테고리를 삭제한다.
 * 게시판, 쇼핑몰, 블로그 등, ... 이러한 정보는 하나의 카테고리이다.
 * 카테고리를 삭제할 때에는 카테고리와 관련된 정보를 같이 삭제한다.
 *
 * @since 2007/01/31 카테고리를 삭제할 때, 하위 카테고리의 idx_parent 를 0 으로 해서, 최상위 카테고리로 만든다.
 * @param int $idx 카테고리 번호
 * @return faultCode
 *
 * @todo 카테고리와 관련된 정보 파일 삭제
 */
function deleteCategory($idx)
{
	$cat = category($idx);
	if ( !$cat ) return faultCode(wrongIndex, "No category by that idx");
	
	global $db;
	$db->query("UPDATE category SET idx_parent=0 WHERE idx_parent = $cat[idx]");
	
	
	// deleteCategoryFile($idx);
	return faultDb( $db->query("DELETE FROM category WHERE idx=$idx") );
}


/**
 * 카테고리 리스트를 연관 배열로 리턴한다.
 *
 *
 * @note 카테고리 내용은 많아야 100개 200개, 보통 20개~30개이다. 따라서 그냥 한번에 연관 배열로 리턴한다.
 * @param string $type 카테고리 타입. CATE_XXXX 상수.
 * @return array of associative-array 카테고리 레코드 정보 전체를 하나의 연관 배열로 해서 요소를 가지는 배열
 * @example src/ex/categorylist.php
 */
function getCategoryList($type=NULL)
{
	global $db;
	
	$qCond = NULL;
	
	if ( $type )
		$qCond = "WHERE type=$type";
	
	$db->query("SELECT * FROM category $qCond");
	$ar = array();
	while ( $row = $db->row() ) $ar[] = $row;

	return $ar;
}
/**
 * alias of getCategoryList
 *
 * @see getCategoryList
 */
function getCategories($type) { return getCategoryList($type); }
/**
 * alias of getCategories
 */
function categories($type) { return getCategories($type); }

/**
 * 카테고리 아이디 또는 카테고리 번호를 입력받아 카테고리 정보(레코드)를 리턴한다.
 *
 *
 * @param mixed $idx 이 값이 numeric 이면 category.idx 를 기준으로 값을 추출한다. 아니면 아이디를 기준으로 값을 추출한다.
 * @return associative-array 카테고리 정보를 리턴한다. 결과 값이 없으면, empty 가 리턴된다.
 */
function getCategory($idx)
{
	global $db;
	if ( is_numeric($idx) )	$q = "SELECT * FROM category WHERE idx=$idx";
	else $q = "SELECT * FROM category WHERE id='$idx'";
	/**
	 * @todo 여기서 에러가 발생할 일은 없겠지만, faultDb 로 점검을 해야하는 것 아닌가?
	 */
	$db->query($q);
	return $db->row();
}
/**
 * This is an alias of getCategory
 */
function category($idx) { return getCategory($idx); }

/**
 * returns the result-set of the category records which has owned by the user.
 *
 * @param int $type category type
 * @param int $idx user index
 */
function userCategory($type, $idx)
{
	global $db;
	$q = "SELECT * FROM category WHERE type=$type AND idx_user=$idx";
	$db->query($q);
	return $db->row();
}


/**#@+
 * 카테고리 번호를 리턴한다.
 *
 * @since 2001/01/31 존재하지 않는 카테고리에 대해서 null 을 리턴한다.
 * @param string $id 카테고리 아이디
 * @return int 카테고리 번호. 존재하지 않는 카테고리 아이디에 대해서 null 를 리턴한다.
 */
function getCategoryIndex($id) {
	$c = category($id);
	if ( empty($c) ) return null;
	return $c['idx'];
}
function getCategoryIdx($id) { return getCategoryIndex($id); }
function categoryIndex( $id ) { return getCategoryIndex($id); }
/**#@-*/

/**
 * 카테고리 이름을 리턴한다.
 *
 * @param mixed $idx 카테고리 아이디 또는 카테고리 번호
 * @return string
 */
function getCategoryName($idx)
{
	$c = getCategory($idx);
	return $c['name'];
}



/**
 * lib/post.php 의 searchPost 와 같은 맥락의 함수이다.
 *
 * searchPost 와 다른 점은 결과 레코드의 수를 얻기 위한 카운팅을 하지 않는다는 것이다.
 *
 * @param array $search searchPost 와 동일
 * @param array $limit searchPost 와 동일
 * @param array $orderby searchPost 와 동일
 * @param int $count searchPost 와 동일 
 * <code> 
 *	if ( isset($ui['key']) && !empty($ui['key']))
 *	{
 *		$search['exp cond'] = 'OR';
 *		$search['name'] = $ui['key'];
 *		$search['id'] = $ui['key'];
 *	}
 *	else $search = array();
 *	$users = searchUser($search, array('toNumber'=>20), array('dateTime'=>'DESC'));
 * </code>
 * @since 2007/03/16 $count 변수를 추가해서 검색의 레코드 수만 리턴받을 수 있게 했다.
 */
function searchCategory($kvs=array(), $limit=array(), $orderby=array(), $count = 0)
{
	
	$where			= NULL;
	
	$date				= qDateTime($limit);				// 변수 위치 주의
	$limit			= qLimit($limit);
	$order			= qOrder($orderby);
	$fields			= qFields($kvs);

	$cond = array();
	if ( !empty($date) )		$cond[] = $date;
	if ( !empty($fields) )	$cond[] = $fields;

	if ( !empty($cond) )
	{
		$where = "WHERE " . implode(" AND ", $cond);
	}

	global $db;
	
	//
	if ( $count )
	{
		$q = "SELECT COUNT(*) FROM category $where";
		$rows = $db->result($q);
		if ( $count == 2 ) return $rows;
	}

	
	$q = "SELECT * FROM category $where $order $limit";
	
	$db->query( $q );
	$asAr = array();
	while ($row = $db->row())
	{
		$asAr[] = $row;
	}
	return $asAr;
}

/**
 * countPost 와 같은 역활을 한다.
 */
function countCategory($kvs=array(), $limit=array())
{
	return searchCategory($kvs, $limit, array(), 2);
}
?>
