<?php
/**
 * MySQL 데이터베이스 덤프 관련 함수
 *
 * MySQL 데이터베이스에 이미 연결이 되어 있다고 가정을 한다.
 * @package library
 *
 */



/**
 * 입력된 문자열에서 MySQL 표현으로 잘못된 문자들을 바로 고친다.
 *
 * @param string $strTemp
 * @param string
 */
function mysql_format($strTemp)
{
	//Format sql sentence for insert
	$bad_chars= array("\\", "'", "\"");
	$good_chars = array("\\\\", "''", "\"\"");
	return str_replace($bad_chars, $good_chars, $strTemp);
}


/**
 * 테이블의 구조와 데이터를 배열로 리턴한다.
 *
 * 본 함수를 통해서 하나의 테이블을 완전히 백업하는 SQL 문장을 얻을 수 있다.
 *
 * @param string $strTblName 테이블 이름
 * @return array 첫 번째 요소에 테이블 구조, 두번째 요소 부터 데이터가 저장된다.
 */
function mysql_dump_table($strTblName)
{
	$ar = mysql_dump_data($strTblName, "*");
	array_unshift($ar, mysql_dump_schema($strTblName));
	return $ar;
}
/**
 * 테이블 별로 레코드를 덤프한다.
 *
 * 이 함수는 {@link mysql_dump_table}와 달리, 원하는 필드만 지정한 레코드(들)만 추출이 가능하다.
 * @note 각 레코드 별로 데이터를 가공해서 리턴한다. 용량이 많은 경우 메모리 관리에 신경을 써야한다.
 * @param string $strTblName 테이블 이름
 * @param string $strFields 필드. 기본 값은 * 이며, 원할 경우, "idx,name,title" 과 같이 지정을 하면된다.
 * @return array 각 요소는 INSERT 구문을 가진다.
 */
function mysql_dump_data($strTblName, $strFields='*')
{
	$result = mysql_query("SELECT $strFields FROM $strTblName") or die ("mysql_query (table: $strTblName) fialed: check the connect, table name, and fields");
	$nbRecord = 0;
	$arrReturn = array();
	while ($row = mysql_fetch_assoc($result))
	{
		$strFieldsNames = "";
		$strFieldsValues = "";
		
		foreach ($row as $field_name => $field_value)
		{
			if ($strFieldsNames) $strFieldsNames .= ", ";
			$strFieldsNames .= "`$field_name`";
			
			if($strFieldsValues) $strFieldsValues .= ", ";
			$strFieldsValues .= "'" . mysql_format($field_value) . "'";
		}
		/**
		 * @todo "여기서 Allowed memory size of 20971520 bytes exhausted" 에러가 터진다. 수정이 필요하다.
		 * 파일 이름을 입력 받든지 해서 실시간으로 저장을 해버린다.
		 */
		$arrReturn[$nbRecord++] = "INSERT INTO $strTblName($strFieldsNames) values($strFieldsValues);";
	}
	mysql_free_result($result);
	return $arrReturn;
}

/**
 * 테이블 구조를 추출
 *
 * @param string $table 테이블 이름
 * @return string 테이블 구조를 표현하는 문자열
 * <code>
 * echo mysql_dump_schema('user');
 * </code>
 */
function mysql_dump_schema($table)
{
	$str = "CREATE TABLE ". $table ." ( ";
	
	$result = mysql_query("SHOW FIELDS FROM $table") or die("mysql_query failed: ...");
	while( $row = mysql_fetch_array($result) )
	{
		$field = " $row[Field] $row[Type]";
		if( isset($row['Default']) && (!empty($row['Default']) || $row['Default']=="0") )
			$field .=" DEFAULT '$row[Default]'";
		if( $row['Null']!="YES")
			$field .=" NOT NULL";
		if( $row['Extra']!="" )
			$field .=" $row[Extra]";
		$fields[] = $field;
	}
	
	$str .= implode(", ", $fields);
	
	$result = mysql_query("SHOW KEYS FROM $table") or die ("mysql_query failed: .. show keys...");
	
	$index = array();
	while( $row = mysql_fetch_array($result) )
	{
		$key_name = $row['Key_name'];
		if( ($key_name != 'PRIMARY') && ($row['Non_unique'] == 0))
			$key_name = "UNIQUE|$key_name";
		if( ! isset($index[$key_name]) )
			$index[$key_name] = array();
		$index[$key_name][] = $row['Column_name'];
	}
	foreach ( $index as $index_name => $columns )
	{
		$str .=",\n";
		if( $index_name == "PRIMARY" )
			$str .=" PRIMARY KEY (".implode($columns,", ").")";
		else if( substr($index_name,0,6) == "UNIQUE" )
			$str .=" UNIQUE ".substr($index_name,7)." (".implode($columns, ", ").")";
		else
			$str .=" KEY $index_name (".implode($columns, ", ").")";
	}

	$str .=" );";

	return $str;
}

?>
