<?php
/**
 * 문자열, HTML/XML TAG, 기타... 모든 string 관련 함수 라이브러리
 *
 *
 * @package library
 *
 *
 */
/**
 * 태그의 내용을 리턴한다.
 *
 * @param string $tag 태그
 * @param string &$html_content HTML 내용
 * @return string 태그 내용. 검색 실패이면 NULL 을 리턴한다.
 */
function tagContent($tag, &$html_content)
{
	if ( preg_match("/<$tag>(.*)<\/$tag>/i", $html_content, $match) )
	{
		return $match[1];
	}
	else return NULL;
}

function strcut($message, $size=14, $tag='...') { return cutstr($message, $size, $tag); }
/**
 * 문자열 자르기
 *
 * $message 가 empty 이면 $tag 만 리턴된다.
 * @param string $message 자르고자하는 원본 문자열
 * @param int $size 문자열의 길이
 * @param string $tag $message의 길이가 $size 보다 클 경우 문자열 뒤에 붙일 꼬릿말
 * @return string
 * <code>
 *	<td>
 *		<a href='<?=$post[url]?>' title="<?=$post[fname]?> <?=$post[dt]?>">
 *						<?=cutStr($post[title])?> <!--제목 출력-->
 *		</a>
 *	</td>
 * </code>
 * @since 2007/01/28 문자열 자르기를 하는데 자꾸글이 깨진다. 따라서 iconv 가 사용가능한 환경이면, 시스템 문자열에 맞추어서 사용을 한다.
 */
function cutStr($message, $size=14, $tag='...')
{
	if ( empty($message) ) return NULL;
	
	/**@since 2007/01/28 사용가능한 함수가 존재할 경우 사용한다. */
	if ( isset($GLOBALS['system']['charset']) && !empty($GLOBALS['system']['charset']) )
	{
		$syscode = strtoupper($GLOBALS['system']['charset']);
		if ( strstr($syscode, 'UTF') && function_exists('iconv') )
		{
			$conv = iconv("UTF-8", "UCS-2", $message);
      if( strlen($conv) < $size*2) return $message;
      $retstr	= substr($conv, 0, $size*2);
      return iconv("UCS-2", "UTF-8", $retstr).$tag;
		}
	}
	
	//
	$message = trim($message);
	$message = strip_tags($message);
	$message = stripslashes($message);
	if ( empty($message) ) return $tag;
	$han=$eng=0;
	for($i = 0; $i < $size; $i++ )
		if( @ord( $message[$i] ) > 127 ) $han++;
		else $eng++;
	$size = $size + (int) $han * 0.6;
	$wordsize = 1;
	$retstr='';
	for ( $i = 0; $i < strlen($message); $i++ ) {
		if ( $wordsize > $size ) return $retstr.$tag;
		if ( ord( $message[$i] ) <= 127 ) {
			$retstr.= $message[$i];
			if ( $wordsize % $size == 0 ) return $retstr.$tag; 
		} else {
			if ( $wordsize % $size == 0 ) return $retstr.$tag;
			$retstr .= $message[$i].$message[++$i];
			$wordsize++;
		}
		$wordsize++;
	}
	return $retstr;
}
?>
