<?php
/**
 *
 *
 * @package library
 */
/**
 *
 *
 */
lib('db');

/**
 * 사용자 정보 추가
 *
 * @return faultCode
 */
function insertUser($data)
{
	global $db;
	if ( ! isset($data['dateTime']) ) $data['dateTime'] = dateTime();
	if ( ! isset($data['ip']) ) $data['ip'] = $_SERVER['REMOTE_ADDR'];
	return faultDb($db->insert('user', $data));
}

/**
 *
 * 이 함수가 호출될 때 마다 dateTime, ip 가 갱신된다.
 * ip 는 사용자 정보 수정시 마다 변경이된다. 마지막 로그인시의 IP 를 기록할 때에는 제외한다.
 * @param associative-array $data 만약 생략되면, dateTime, ip 정보만 갱신된다.
 */
function updateUser($data=array())
{
	
	if ( empty($data['idx']) ) return faultEx(wrongIndex, "user.idx 정보가 없습니다.");
	
	/** 로그인을 하는가? */
	if ( isset($data['ip_lastlogin']) ) {}
	else
	{
		if ( ! isset($data['dateTime']) ) $data['dateTime'] = dateTime();
		if ( ! isset($data['ip']) ) $data['ip'] = $_SERVER['REMOTE_ADDR'];
	}
	
	global $db;
	$rc = $db->update('user', $data, array('idx'=>$data['idx']));
	return faultDb($rc);
}


/**
 * 사용자 정보 삭제
 *
 * 이 함수가 호출되기 전에 권한이 체크되어야한다.
 * 지금은 간단히 사용자 정보만 삭제하지만, 차후에 사용자 관련된 정보가 추가되면 관련 정보도 삭제되어야한다.
 * 사용자의 글이나 글과 관련된 정보에 대해서 같이 삭제할지 여부는 아직 결정이 안되었다.
 *
 * @param int $idx user idx 사용자 번호(아이디는 안된다. 정확히 사용자 번호가 입력되어야한다.)
 *
 */
function deleteUser($idx)
{
	$q = "DELETE FROM user WHERE idx=$idx";
	global $db;
	return faultDb($db->query($q));
}



/**
 * 사용자 정보를 리턴한다.
 *
 * 입력값은 인덱스번호 또는 아이디.
 *
 * 입력된 값이 숫자이면 사용자 번호를 기준으로, 문자열이면 아이디를 기준으로 정보를 검색한다.
 * @note 사용자 아이디가 전부 숫자로만 된 경우는 주의가 필요하다.
 *
 */
function userData($id)
{
	global $db;
	if ( is_numeric($id) ) $q = "SELECT * FROM user WHERE idx='$id'";
	else $q = "SELECT * FROM user WHERE id='$id'";
	$db->query($q);
	
	$user = $db->row();
	return $user;
}
/**
 * This is an alias of userData
 */
function user($id) { return userdata($id); }


function getUser($idx) { return userData($idx); }

/**
 * 사용자 아이디와 필드를 입력받아 그 값을 리턴한다.
 *
 * @return string 사용자 정보
 */
function userAttr($id, $field)
{
	$user = userData($id);
	return $user[$field];
}

/**
 * 사용자 번호를 리턴한다.
 *
 * @param string $id 사용자 아이디.
 * @return string
 */
function getUserIdx($id) { return userAttr($id, 'idx'); }





/**
 * 사용자 수 리턴
 *
 * 이 함수는 searchUser() 와 함께 사용되어야한다. 뿐만 아니라 searchPost, searchCategory 등의 함수와 매칭이 되어 Site Open API 의 메소드 처리에 사용되어야한다.
 * @return int 사용자 수
 */
function countUser($search=array(), $limit=array())
{
	return searchUser($search, $limit, array(), 2);
}


/**
 * lib/post.php 의 searchPost 와 같은 맥락의 함수이다.
 *
 * @param array $search searchPost 와 동일
 * @param array $limit searchPost 와 동일
 * @param array $orderby searchPost 와 동일
 * @param int $count searchPost 와 동일
 * <code> 
 *	if ( isset($ui['key']) && !empty($ui['key']))
 *	{
 *		$search['exp cond'] = 'OR';
 *		$search['name'] = $ui['key'];
 *		$search['id'] = $ui['key'];
 *	}
 *	else $search = array();
 *	$users = searchUser($search, array('toNumber'=>20), array('dateTime'=>'DESC'));
 * </code>
 */
function searchUser($search=array(), $limit=array(), $orderby=array(), $count=0)
{
	
	$where			= NULL;
	
	$date				= qDateTime($limit);				// 변수 위치 주의
	$limit			= qLimit($limit);
	$order			= qOrder($orderby);
	$fields			= qFields($search);

	$cond = array();
	if ( !empty($date) )		$cond[] = $date;
	if ( !empty($fields) )	$cond[] = $fields;

	if ( !empty($cond) )
	{
		$where = "WHERE " . implode(" AND ", $cond);
	}

	global $db;

	if ( $count )
	{
		$q = "SELECT COUNT(*) FROM user $where";
		$rows = $db->result($q);
		if ( $count == 2 ) return $rows;
	}
	
	$q = "SELECT * FROM user $where $order $limit";
	//g($q);
	$db->query( $q );
	$asAr = array();
	while ($row = $db->row())
	{
		$asAr[] = $row;
	}
	return $asAr;
}


/**
 * 최근 가입한 순서로 사용자 정보를 리턴한다.
 *
 * 리턴되는 정보는 사용하기 쉽게 기본 정보가 가공되어서 리턴된다.
 * 내부적으로 searchUser 를 사용한다.
 *
 */
function users($number=10)
{
	$arr = searchUser(array(), array("toNumber"=>$number), array("dateTime_signup"=>"DESC"));
	$users = array();
	foreach( $arr as $e )
	{
		$users[] = userinfo($e);
	}
	return $users;
}

/**
 * 사용자 정보를 추가해서 리턴한다.
 *
 * 추가되는 정보에는 url, age, url_image_4x5, sexKr 등에 적당한 값이 추가된다.
 *
 * @param associative-array $e 사용자 데이터베이스 레코드
 * @return associative-array 사용자 레코드에 추가된 정보
 * @code $users[] = userinfo($e);
 */
function userinfo($e)
{
	$e['url'] = "?cate=user&mode=read&idx=$e[idx]";
	$e['age'] = age($e);
	if ( $e['sex'] ) $e['sexKr'] = sexKr($e['sex']);
	else $e['sexKr'] = sexKr($e['jumin2']);
	
	if ( $e['image_4x5'] )
		$e['url_image_4x5'] = "?cate=download&idx=".$e['image_4x5'];
	else
		$e['url_image_4x5'] = NULL;
		
	return $e;
}


/**
 * 로그인 상태로 만든다.
 *
 * 사용자 인증(또는 가입)을 마친 후, 해당 사용자를 로그인된 상태로 표시하기 위한 함수이다.
 *
 * @param associative-array $user 사용자 데이터베이스 레코드
 * @param int $last 로그인을 유지할 시간. 0 이면 현제 세션. 이 값에는 현제 time() 값을 기준으로 앞으로 유지될 시간 값이나 과거값을 입력한다.
 * <code>
 * lib('user');
 * $user = userData($ui['id']);
 * doLogin($user);
 * </code>
 * @todo doLogout 함수도 작성을 할 것.
 * @since 2007/01/29 default.php 에서 user.php 로 이동되었다. 그리고 DB 관련 작업을 추가했다.
 * @since 2007/03/10 사용자 로그인에 대한 DB 조정작업은 login_submit.php 로 이동되었다.
 */
function doLogin($user, $last=0)
{
	session('id', $user['id'], $last);
	session('name', $user['name'], $last);
}


/**@#+
 * 사용자의 세션 정보를 저장한다.
 *
 * 자바스크립트에서만 사용되는 쿠키 전용 값. PHP 스크립트에서는 사용되지 않는 값이다.
 *
 * @see buildguide#login
 */
function set_user_session($user, $last)
{
	session("co_name", $user['name'], $last);
	session("co_nick", $user['nick'], $last);
	session("co_grade", $user['grade'], $last);
	session("co_point", $user['point'], $last);
}
function unset_user_session()
{
	deleteSession("co_name");
	deleteSession("co_nick");
	deleteSession("co_grade");
	deleteSession("co_point");
}
/**@#-*/
?>
