<?php
/**
 * 이 함수는 스킨에서만 사용이 가능한 유틸리티 함수들이다.
 *
 * 여러가지 반복되는 작업(소스 코드)을 간추려서 묶어 놓은 라이브러리.
 * 모든 내용이 함수 처리되어있어서 스킨 파일 뿐만 아니라, 시스템(모듈) 스크립트에서도 사용이 가능하다.
 *
 * @package library
 */

/**
 * 글 쓴이를 나타낸다.
 * @param associative-array $post 글 레코드
 */
function postname($post)
{
	if ( $post['idx_user'] )
	{
		lib('user');
		$writer = user($post['idx_user']);
		$ret = "<a href='?cate=user&mode=read&idx=$writer[idx]'>";
		if($writer['image_nick'])
			$ret .= "<img src='".mkurl($writer['image_nick'])."' border=0 width=46 height=14>";
		else
		{
			if ( empty($writer['nick']) ) $name = $writer['name'];
			else $name = $writer['nick'];
			
			if ( empty($name) ) $name = "&nbsp;";
			
			$ret .= $name;
		}
		$ret .= "</a>";
	}
	else
		$ret = $post['name'];
	
	if (empty($ret)) $ret = "&nbsp;";
	
	return $ret;
}
/**
 * 정보를 화면으로 출력한다.
 */
function info()
{
	
	echo "skin: " . skin() . "\r\n";
}

/**
 * A 시작태그(링크)를 리턴합니다.
 *
 * @param string $url 페이지를 보여줄 URL
 * @param int $type 페이지 보여줄 형식 none=0, popup=1, link=2, newwindow=3 이다.
 * @param string $option 추가 옵션
 */
function a($url, $type=0, $option="width=400,height=300,scrollbars=yes,status=yes,resizable=yes")
{
	if ( $type == 0 ) return;
	
	if ( $type == 1 )
	{
	}
	
	$tag = "<A HREF=\"$url\"";
	
	if ( $type == 1 )
	{
		$time = time();
		$tag .= " onclick=\"window.open('$url','$time', '$option'); return false;\"";
	}
	
	if ( $type == 2 )
	{
	}
	
	if ( $type == 3 )
	{
		$tag .= " target=\"_blank\"";
	}
	
	
	
	$tag .= ">";
	return $tag;
}

/**
 * 사용자 이미지 URL 을 리턴한다.
 *
 * 입력된 file.idx 번호의 이미지 URL 경로를 리턴한다.
 * 사용자 이미지의 경우, 기본적으로 몇 가지는 user 테이블에 file.idx 를 기록을 한다.
 * 이 file.idx 의 URL 을 리턴한다.
 *
 * 이 함수는 이미지 파일이 없을 경우, 기본 이미지를 사용하는데에 알맞다.
 *
 * @param string $type 이미지 타입
 * @param int $idx 파일 번호. 생략시 자신의 파일 번호를 사용한다. 즉, 생략하면 자신의 이미지를 보여주고,
 * 값을 지정하면 해당 사용자의 이미지를 보여준다.
 *
 * $type 값은 'nick', '5x7', '3x4' 와 같이 입력을 할 수 있다. 해당 값이 없을 때에는 기본 이미지를 이용한다.
 * $idx 는 file.idx 이다. user.image_nick, user.image_5x7 과 같은 필드에는 file.idx 가 저장되며 이 값을 입력값으로 받는다.
 *
 *
 * @return string URL. 만약 값이 없으면 기본 이미지가 리턴된다. 따라서 이미지가 있는지 체크를 하기 위해서는 user.image_xxx 항목의 값을 직접 체크해야한다.
 * @code <img width=46 height=14 src="<?=userImage('nick', $member['image_nick'])?>" alt="<?=$nick?>님의 닉네임 로고">
 */
function userImage($type='nick', $idx=NULL)
{
	if ( $idx === NULL)
	{
		global $user;
		$idx = $user["image_$type"];
	}
	
	if ( empty($idx) )
	{
		return "skin/default/image/$type.gif";
	}
	else return mkurl($idx);
}

/**
 * $type 규격의 이미지가 있는 사용자만 리스트를 한다.
 */
function usersImage($type, $number=5)
{
	lib('user');
	
	$kvs["image_$type"]					= "0";
	$kvs["image_$type cond"]	= "<>";
	
	$limit['toNumber']	= $number;
	$order['dateTime_signup']	= "DESC";

	$rows = searchUser($kvs, $limit, $order);
	$users = array();
	foreach($rows as $row)
	{
		$row['url_image'] = "?cate=download&idx=".$row["image_$type"];
		$users[] = $row;
	}
	return $users;
}


/**
 * 업로드된 파일의 경로를 리턴한다.
 */
function mkurl($idx)
{
	return "?cate=download&idx=$idx";
}


/**
 * 첨부 파일
 *
 * 특정 글의 첨부 파일(들) 전체를 배열로 리턴한다.
 *
 * @param int $type NULL 이면 전체 파일을 꺼집어낸다.
 * @note idx_category=NULL 으로 해서 전체 첨부 파일 정보를 끄집어낸다.
 * @return array of associative-array 각 요소는 기본 정보 처리가된 파일 정보 배열이다.
 * @code <?$files=attachment($ui[idx])?>
 * @code <?$files=attachment($ui[idx],CATE_BBS)?> 게시판 형식으로 첨부된 파일만 끄집어낸다. API 를 통해서 첨부된 파일은 제외
 */
function attachment($idx, $type=NULL)
{
	lib('filesystem');
	$ar = files($idx, $type);
	$files = array();
	foreach ( $ar as $file )
	{
		$files[] = array_merge( $file, getFileLink($file) );
	}
	return $files;
}

/**
 * 총 글 수를 리턴
 * 쇼핑몰, 블로그, 쪽지, 메모 할 것 없이 전체 레코드의 수를 리턴한다.
 */
function postTotal($kvs=array())
{
	lib('post');
	return countPost(array(), $kvs);
}
/**
 * postFrom 과 같은 역활을 한다. 다만, 사용자 수를 리턴한다.
 *
 * <code>
 *	총회원 : <?=countUser()?><br>
 *	오늘 : <?=userFrom()?><br>
 *	일주일 : <?=userFrom(-7)?><br>
 * </code>
 */
function userFrom($ago=0)
{
	$dateTime = mktime(0, 0, 0, date("m"), date("d")+$ago,   date("Y"));
	$fromDate = dateTime($dateTime);
	return countUser(array(), array('fromDate'=>$fromDate));
}

/**
 * 특정 일부터 현제까지의 글 수를 리턴한다.
 * @param int $ago 특정 일부터 현제까지의 글을 리턴한다.
 * @param int $type 카테고리 타입
 *
 * @code postfrom(-7); // 일주일 간의 글 수
 * @ex 총 상품의 수를 구하기 위해서는 postFrom(-3650, CATE_MALL); 과 같이하면된다. 이렇게하면 10년 전의 정보부터 구하므로 10년이 지나지 않은 이상, 전체의 정보를 얻을 수 있다.
 * <code>
 * <div id="tkey" style="margin-left:6;">총 상 품</div><div id="tvalue"><?=postFrom(-3650, CATE_MALL)?></div>
 * <div id="tkey" style="margin-left:6;">신 상 품</div><div id="tvalue"><?=postFrom(-7, CATE_MALL)?></div>
 * <div id="tkey" style="margin-left:6;">총 글 수</div><div id="tvalue"><?=postTotal()?></div>
 * <div id="tkey" style="margin-left:6;">새 글 수</div><div id="tvalue"><?=postFrom(-7)?></div>
 * </code>
 * @since 2007/03/16 $kvs 에 검색 조건을 입력할 수 있다. 입력 양식은 searchPost 와 동일하다.
 * <code>
 *	g(postTotal());
 *	g(postWeek());
 *	g(postYesterday());
 *	g(postToday());

 *	// 답변글 통계
 *	$kvs = array('idx_parent'=>0, 'idx_parent cond'=>'<>');
 *	g(postTotal($kvs));
 *	g(postWeek($kvs));
 *	g(postYesterday($kvs));
 *	g(postToday($kvs));
 * </code>
 */
function postFrom($ago=0, $type=NULL, $kvs=array())
{
	$lastweek = mktime(0, 0, 0, date("m"), date("d")+$ago,   date("Y"));
	$fromDate = dateTime($lastweek);
	if ($type)
	{
		$kvs['idx_category_type'] = $type;
		$kvs['idx_category_type cond'] = "=";
	}
	lib('post');
	return countPost(array(), $kvs, array('fromDate'=>$fromDate));
}
/**
 * 오늘 총 글 수를 리턴한다.
 */
function postToday($kvs=array())
{
	return postFrom(0, NULL, $kvs);
}
/**
 * 어제의 글의 수를 리턴.
 */
function postYesterday($kvs=array())
{
	$lastweek = mktime(0, 0, 0, date("m"), date("d")-1,   date("Y"));
	$fromDate = dateTime($lastweek);
	$lastweek = mktime(0, 0, 0, date("m"), date("d"),   date("Y"));
	$toDate = dateTime($lastweek);
	lib('post');
	return countPost(array(), $kvs, array('fromDate'=>$fromDate, 'toDate'=>$toDate));
}
function postWeek($kvs=array())
{
	return postFrom(-7, NULL, $kvs);
}

/**
 * 게시물의 내용을 직접 웹 브라우저로 출력한다.
 *
 * 스킨에서 사용되는 함수로서 LINK 속성에 대한 필요한 처리는 직접 스킨에서 스타일시트로 해야한다.
 *
 * @param mixed $category same as articles
 * @param int $number same as articles
 * @param string $target A 태그의 target 속성 값이다.
 * @code <?=writeArticles('qna', 5, 24, '_blank')?>
 */
function writeArticles($category, $number=5, $length=24, $target=NULL)
{
	lib('post');
	lib('string');
	$posts = articles($category, $number);
	foreach($posts as $post)
	{
		$post['title'] = cutstr($post['title'], $length);
		echo "<A HREF=$post[url]";
		if ( $target ) echo " target='$target'";
		echo ">$post[title]</A><br>";
	}
}

/**
 * 스킨에서 사용하기 좋도록 URL 링크를 걸어서 리턴한다.
 *
 */
function categoryLinks($type=CATE_BBS)
{
	lib('category');
	$ar = categories($type);
	
	$re = array();
	foreach( $ar as $c )
	{
		$re[] = "<a href='?cate=bbs&mode=list&idx=$c[idx]'>$c[name]</a>";
	}
	return $re;
}

/**
 * returns site name
 *
 */
function site_name()
{
	global $system;
	if ( !isset($system['name']) || empty($system['name']) ) return "YOUR SITE NAME";
	return $system['name'];
}
/**
 * returns site description
 */
function site_description()
{
	global $system;
	if ( !isset($system['description']) || empty($system['description']) ) return "YOUR SITE DESCRIPTION";
	return $system['description'];
}

/**
 * 스킨을 변경할 수 있는 셀렉션 박스가 화면에 나타난다.
 */
function form_skin_change()
{
	global $system;
	
	$ret =<<<EOH
<script language="javascript">
<!--
function change_skin(form) {
  var i = form.skin.selectedIndex;
  location.href='?skin='+form.skin[i].value;
}
//-->
</script>
	<form>

	<select name='skin' style='width:70px;' onchange="change_skin(this.form)">
EOH;

	lib('file');
	$dirs = getDirs(dirRoot."/skin");
	foreach ($dirs as $dir)
	{
		$file		= dirRoot."/skin/$dir/README";
		$index	= dirRoot."/skin/$dir/index.html";
		if ( file_exists( $file ) && file_exists($index) )
			$skins[] = $dir;
	}
	
	$ret .= "<option value='$system[skin]'>$system[skin]</option>".rn;
	foreach ($skins as $skin)
	{
		$ret .= "<option value='$skin'>$skin</option>".rn;
	}

	$ret .= "</select>".rn;
	$ret .= "</form>".rn;

	return $ret;
}
?>
