<?php
/**
 *
 * 데이터베이스의 용량이 클 수 있다. 잘게 나누어서 처리를 하기 위해서 다음과 같이 한다.
 * 진행 순서:
 * - 테이블 단위로 데이터베이스에서 레코드를 추출 후 임시 파일의 끝에 추가.
 * - 모든 테이블을 임시 파일에 넣었으면, zlib 를 지원하면 해당 형식으로 압축.
 * - passthru 를 이용해서 데이터를 전송한다.
 *
 * @doc 여기서 다운 받는 파일은 phpMyAdmin 으로 바로 사용이 가능하다. 압축된 파일 자체를 바로 사용해도된다.
 */


//
root() or goBack("슈퍼 관리자 이상의 권한이 필요합니다.");



// ============================================================================
//
// 임시 백업 파일 생성. 데이터베이스에서 백업할 용량이 클 경우를 대비, 조금씩
// DB 에서 꺼집어 내서 파일에 보관을 한다.
//
lib('db');
lib('mysql_dump');
lib('file');
lib('filesystem');
makevar();
$file = tmpname('sql') . ".sql";




// ============================================================================
//
// 
//
// 
//
/**
 * DB(파일)에 존재하는 테이블을 백업
 *
 * $ui['attr'] == 'jangnan_tables' 의 경우 필요한 테이블만 백업한다.
 */
$tables = array();
// 1단, 존재하는 모든 테이블을 얻는다.
$db->query("SHOW TABLES FROM $system[db_database]");
while ( $row = $db->row('row') )
{
	$tables[] = $row[0];
}
// 2단, 필요한 것만 사용한다.
if( isset($ui['attr']) && $ui['attr'] == 'jangnan_tables' )
{
	$jt = array('user','category','post','file','group','etc');
	$tables = array_intersect($jt, $tables);
}
else
{
}


foreach ( $tables as $table )
{
	$arr = mysql_dump_table($table);
	attachString($file, implode("\n", $arr));
}




// ============================================================================
//
// 백업 파일 압축
//
// @todo 용량이 큰 파일을 압축할 때에 문제가 발생할 수 있다. http://kr.php.net/manual/en/ref.zlib.php 페이지의 사용자 노트를 참고한다.
// 
if (function_exists('gzclose')) {
	$filename = $file . '.gz';
	$zp = gzopen($filename, "w7");
	if ( $zp )
	{
		$contents = readfileEx($file);
		$len = strlen($contents);
		$wrote = gzwrite($zp, $contents);
		
		// 압축 성공
		if ( $len == $wrote )
		{
			// 기존 파일 삭제
			unlink($file);
			$file = $filename;
		}
		gzclose($zp);
	}
}



// ============================================================================
//
// 출력
//
$size = filesize($file);
$name = basename($file);
headers("Content-Type: application/x-zip-compressed");
Headers("Content-Disposition: attachment; filename=$name");
headers("Content-Transfer-Encoding: binary");
Headers("Content-Length: $size");
Headers("Cache-Control: cache, must-revalidate");
headers("Pragma: no-cache");
headers("Expires: 0");


$fp = fopen($file, "rb");
fpassthru($fp);
fclose ($fp);



// ============================================================================
//
// 뒷 처리 (백업된 파일 삭제를 해서 정보 누출의 기회를 없앤다.)
//

unlink($file);
exit;
?>
