<?php
/**
 * 답변글 작성
 *
 * 답변글은 코멘트 형태로 이루어진다. 하지만 완전한 하나의 글이다.
 * 답변글은 부모글을 기록해야한다.
 *
 * $post 는 현재 작성하는 글의 원래글(부모글, 한칸 위 글)의 정보를 가지고 있다.
 */

$data = $ui;

unset($data['idx']);
unset($data['cate']);
unset($data['mode']);
unset($data['pageNo']);

if ( login() )
{
	$data['idx_user']			= $user['idx'];
	$data['id']						= $user['id'];
	$data['name']					= $user['nick'];
	$data['email']				= $user['email'];
	$data['homepage']			= $user['homepage'];
	$data['sex']					= $user['sex'];
	$data['birth']				= $user['jumin1'];
}

if ( isset($ui['password']) )
	$data['password']				= md5($ui['password']);



/**
 *
 * 부모글의 정보를 넣는다.
 * - 카테고리: 부모의 것
 * - 글의 구조에서 부모,자식 관계는 1단계 뿐이다. 따라서 부모글이 존재하는 경우, 그 부모가 현재글의 부모가된다.
 * @todo 현재 글을 저장할 때에, depth 표시는 하지 않는다. 따라서 글 타래 전체가 들여쓰기 없이 한번에 리스트가된다.
 */
$data['idx_category'] 	= $post['idx_category'];
$data['idx_category_type'] 	= CATE_BBS;

/** access */
if ( isset($ui['r']) && $ui['r'] > $category['r'] ) $data['r'] = $ui['r'];
else $data['r']							= $category['r'];


if ( $post['idx_parent'] )
{
	$data['idx_parent']			= $post['idx_parent'];
}
else
{
	$data['idx_parent']			= $post['idx'];
}


if ( faultCode(insertPost($data)) ) goBack(wrongParam, "bbs::write_submit 글 작성 양식의 입력 항목이 잘 못되었습니다.");

// 부모글에 자식글이 1개 추가되었다는 표시
updateParent($data['idx_parent'], 'children', +1);

/**
 * 답변글이 작성될 경우, 부모글의 시간을 갱신한다. 즉, 자식글 대신 부모글이 최신글로 나타나게한다.
 *
 * 이 코드는 충분히 스킨에서 작성될 수 있다. 답변 글이 등록될 때, 부분이 문제가 된다면, 스킨에서 처리를 하도록한다.
 * @todo 현제, reply_submit 행동에 대해서 스킨을 사용하지 않고 있다. 스킨을 사용하도록 한다.
 */

updatePostField($data['idx_parent'], 'dateTime', dateTime());



// 부모글 읽기로 이동.
$idx = $data['idx_parent'];


$url_read = "?cate=bbs&mode=read&idx=$idx$hvPageNo";
?>
