<?php
/**
 * 플러그인 스킨 적용
 *
 * 스킨에 기록(배치)되어 있는 각 플러그인-위치에 플러그인을 적용할 수 있도록 해 주는 설정 페이지이다.
 *
 * 위치와 플러그인을 화면에 표현할 때에 아래의 표현 형식대로 한다.
 *
 * @note 표현 형식: 플러그인이름 (디렉토리이름)
 *
 * @todo 위치에 플러그인이 변경되면, 해당 정보가 삭제되어야한다.
 * @see BUILDGUIDE
 *
 */

/**
 * 권한 인증
 */
admin('plugin') or goBack(accessDenied, "you don't have permission for this");
lib('plugin');



/**
 * 플러그인 위치 이름 검출
 *
 * - 현제 스킨 디렉토리의 모든 스킨 파일을 읽어서
 * - 파일 내부에 존재하는 plugin() 코드의 값을 검출한다.
 *
 */
$area = array();
$htmls = array();

// 전체 스킨 디렉토리에서 HTML 파일만 선택
$files = getFiles($sd);
foreach( $files as $file )
{
	if ( strstr($file, ".html") == ".html" )
		$htmls[] = $file;
}

// HTML 파일에서 plugin 위치 이름을 선택
// @since 2007/03/24 plugin 의 위치 이름 추출을 느슨하게 변경을 했다. 따라서 잘못 추출할 가능성이 있다.
foreach( $htmls as $html )
{
	$text = readfileEx($html);
	$p = "/plugin\(('|\")+(.*)('|\")+\)*/";
	preg_match_all($p, $text, $out);
	$area = array_merge($area, $out[2]);
}


/** PHP 특성에 따라 변수명에 . 이 있으면 _ 로 변경 */
$area = str_replace(".", "_", $area);

// 정렬
sort($area);


$countArea = count($area);
?>
<html>
<head>
	<link rel="stylesheet" type="text/css" href="skin/default/default.css">
	<meta http-equiv="Content-Type" content='text/html;charset=utf-8'>
	<style>
	body {margin:10;}
	</style>
</head>

<div id="title">스킨 "<?=$dirSkin?>" 에 플러그인 적용</div>
<div id="note">
	현제 선택된 스킨 디렉토리(<?=$dirSkin?>)에 존재하는 모든 plugin 의 위치 이름을 검색하여서<br>
	플러그인을 설정합니다.
</div>
<div id="note">
	현제 스킨 디렉토리(<?=$dirSkin?>)에 총 <?=$countArea?>개의 플러그인이 존재합니다.
</div>
<div id="note">
	하나의 플러그인을 여러곳에 지정할 수 있습니다.
</div>

<?
	if ( empty($countArea) ) {
		echo "<br><br>
			<div id='note'>
				현제 스킨 디렉토리($dirSkin)에는 지정된 플러그인이 없습니다.<br>
				따라서 플러그인을 지정할 수 없습니다.
			</div>";
		return noskin();
	}
?>








<script>
function openBox(name) {
  var left = 500;
  var top  = 300;
  var properties = 'top=' + top + ',left=' + left + ',width=400,height=120';
  
  var obj_window = window.open('?cate=plugin&mode=select&form_name='+name,'openBox',properties);
    if (parseInt(navigator.appVersion) >= 4) {
      obj_window.window.focus();
    }
}
function openCopy(name) {
  var left = 500;
  var top  = 300;
  var properties = 'top=' + top + ',left=' + left + ',width=500,height=220';
  
  var obj_window = window.open('?cate=plugin&mode=copy_config&form_name='+name,'openBox',properties);
    if (parseInt(navigator.appVersion) >= 4) {
      obj_window.window.focus();
    }
}

function saveConfig(url) {
  var left = 400;
  var top  = 300;
  var properties = 'top=' + top + ',left=' + left + ',width=450, height=250';

  var obj_window = window.open(url,'saveConfig',properties);
    if (parseInt(navigator.appVersion) >= 4) {
      obj_window.window.focus();
    }
}


function openConfig(url) {
  var left = 400;
  var top  = 200;
  var properties = 'top=' + top + ',left=' + left + ',width=400, height=400, scrollbars=yes, resizable=yes';
  
  var obj_window = window.open(url,'openConfig',properties);
    if (parseInt(navigator.appVersion) >= 4) {
      obj_window.window.focus();
    }
}
</script>




<form action='?' method='post' name='apply'>
<input type='hidden' name='cate' value='plugin'>
<input type='hidden' name='mode' value='apply_submit'>

<style>
	.in { border-style:dotted;border-left-width:0;border-right-width:0;border-top-width:0;border-bottom-width:0;border-bottom-color:gray;}
	a { text-decoration: none; color: black; }
	a:hover { text-decoration: underline; color: darkblue; }
</style>

<?

$file = module_repository."/plugin.$system[skin].php";

$var = config($file);

include script('plugins');



echo "<table cellpadding=3 cellspacing=1 bgcolor='gray'>";
echo "
	<tr bgcolor=white>
		<td>위치</td><td>적용</td><td>플러그인</td>
		<td>설정</td>
		<td>저장</td>
		<td>복사</td>
		<td>캐쉬</td>
		<td>제목</td>
	</tr>
";
foreach( $area as $name )
{
	
	// 플러그인 위치 별 설정 로드 및 초기화
	$cfg = config(cfgfile($name));
	if ( ! $cfg ) $cfg = array();
	if ( !isset($cfg['cache']) ) $cfg['cache'] = NULL;
	if ( !isset($cfg['header']) ) $cfg['header'] = NULL;

	
	
	$value = "";
	$mark  = "선택";
	$omark = "";
	if ( isset($var[$name]) && !empty($var[$name]) ) {
		$value	= $var[$name];	// 위치 설정 파일에 위치 이름에 해당하는 플러그인
		$mark		= "변경";
		$omark	= "<a href='#' title='$name 설정하기' onclick=\"openConfig('?cate=plugin&mode=plugin&dir=$value&areaname=$name&action=config');return false;\">
								<img src='./etc/res/icon/tool.gif' border=0>
								</a>";
	}
	else
	{
		$omark	= "<a href='#' title='$name 설정하기' onclick=\"openConfig('?cate=plugin&mode=set_plugin&areaname=$name');return false;\">
								<img src='./etc/res/icon/tool_gray.gif' border=0>
								</a>";
	}
	
	$cmark	= "<a href='#' title='다른 설정을 $name 으로 가져오기(설정 복사)' onclick=\"openCopy('$name');return false;\">
								<img src='./etc/res/icon/copy.gif' border=0>
								</a>";
	
	echo "
		<tr bgcolor=white>
			<td><a href='#' onclick=\"openBox('$name');return false;\">$name</a></a></td>
			<td><a href='#' onclick=\"openBox('$name');return false;\">[$mark]</a></a></td>
			<td><input type='text' name='$name' class='in' value='";
	
	if ( $value ) {
		$i = &$dirplugins[$value];
		
		echo $i['name'];
		if ( isset($i['version']) ) echo " v$i[version]";
		if ( isset($i['author']) ) echo " by $i[author]";
		echo " ($value)";
	}
	
	echo "' readonly size='40'></td>
	
			<td align=center>$omark</td>
			<td><a href=\"#\" onclick=\"saveConfig('?cate=plugin&mode=save_config&areaname=$name');return false;\">저장</a></td>
			<td align=center>$cmark</td>
			<td>$cfg[cache]</td>
			<td>$cfg[header]</td>
		</tr>
	";
}
echo "<tr bgcolor=white><td></td><td></td><td colspan=6><input type=submit value=' 설정 저장 '></td></tr>";

echo "</table>";
echo "</form>";

return noskin()
?>
