<?php
/**
 * 회원 정보 읽기
 *
 * 사용자가 로그인을 한 경우에는 이미 $user 에 관련 정보가 들어가있다.
 * 그러나 타인의 정보를 보는 경우, 즉, $myinfo = 0 인 경우에는 $user 변수에는 타인의 정보가 들어가 있다.
 *
 * @since 2007/02/15 타인의 정보를 액세스할 수 있다.
 * @note 주의 $member 변수에 자신의 정보가 아닌 현제 사용자 정보를 담는다.
 * 원래 $member 변수는 $user 변수를 참조한다. 하지만, 본 스크립트에서는 $member 에 현제 사용자, $user 에 자신의 정보를 담도록 했다.
 *
 */

$myinfo = 0;


/**
 * HTTP GET 방식으로 user.idx 의 값이 들어오지 않았으면, user.id 의 값을 체크한다.
 */
if (!isset($ui['idx']) || empty($ui['idx']))
{
	if (!isset($ui['id']) || empty($ui['id']))
	{
		$id = NULL;
	}
	else $id = $ui['id'];
}
else $id = $ui['idx'];


/**
 * 다른 사용자 아이디 정보가 없으면,
 */
if ( $id === NULL )
{
	// 로그인 했으면 자신의 정보를 보여준다.
	if ( login() )
		$myinfo = 1;
	// 로그인도 안했고, 다른 사용자 정보 보기도 아니면, 에러
	else
		goBack(wrongIndex, "user::read what do you want to do?");
}

else
{
	// 로그인 했고, 입력된 사용자 정보가 자신의 것이면,
	if ( login() && ( $id == $user['idx'] || $id == $user['id'] ) )
	{
		$myinfo = 1;
	}
	// 아니면,
	else
	{
		unset($member);
		$member = user($id);
		if ( empty($member) ) goBack(wrongIndex, "No user by that number");
	}
}



// 사용자 정보를 보여줄 때라면, 조회수를 업데이트한다.
{
	$update['idx']				= $member['idx'];
	$update['hits']				= $member['hits'] + 1;
	$rc = updateUser($update);
	if ( faultcode($rc) ) goBack();
}



foreach ( $member as $k=>$v )
{
	$$k = $v;
}

	

?>
