<?php
/**
 * 위치별 플러그인 설정 스크립트
 *
 * 최근글 제목을 리스트하기 위한 옵션 설정을 한다.
 *
 *
 */


lib('utility');
lib('plugin');

/**
 * 플러그인 정보
 */
$pd = dirRoot."/plugin/$ui[dir]";
include $pd."/info.php";
$cfg = config(cfgfile());

if ( !isset($cfg['no'])  ) $cfg['no'] = NULL;
if ( !isset($cfg['header'])  ) $cfg['header'] = NULL;
if ( !isset($cfg['length_title']) ) $cfg['length_title'] = 20;
if ( !isset($cfg['length_description']) ) $cfg['length_description'] = 0;


$price_checked = $recommend_checked = $hit_checked = NULL;
if ( isset($cfg['price']) && $cfg['price'] == 'checked' ) $price_checked = "checked";
if ( isset($cfg['recommend']) && $cfg['recommend'] == 'checked' ) $recommend_checked = "checked";
if ( isset($cfg['hit']) && $cfg['hit'] == 'checked' ) $hit_checked = "checked";

$hide_checked = NULL;
if ( isset($cfg['hide']) && $cfg['hide'] == 'checked' ) $hide_checked = "checked";



if ( !isset($cfg['cache']) ) $cfg['cache'] = "0";

/**
 * 캐쉬 정보를 저장할 경우, 캐쉬 옵션이 0 이면, 기존의 캐쉬 파일을 여기서 지운다.
 */
if ( empty($cfg['cache']) )
{
	$cache_file = tmp_repository . "/cache/plugin.$ui[areaname].php";
	@unlink($cache_file);
}
?>
<? include "etc/res/php/plugin_config_header.php" ?>

<form action="?" method="post" style="display:inline;">
<input type="hidden" name="cate" value="plugin">
<input type="hidden" name="mode" value="plugin">
<input type="hidden" name="action" value="config_submit">
<input type="hidden" name="dir" value="<?=$ui['dir']?>">
<input type="hidden" name="areaname" value="<?=$ui['areaname']?>">
<!--eo //-->

상품 번호 또는 카테고리 아이디를 입력하십시오.<br>



<table>
	<tr>
		<td>번호/아이디</td>
		<td>
			<input class="in" type="text" name="no" size=5 value="<?=$cfg['no']?>">
			&nbsp; &nbsp; &nbsp; &nbsp; 선택
			<select name="selectId" onchange="no.value = this.options[this.selectedIndex].value;">
				<option>카테고리 아이디 선택</option>
				<?php
					lib('mall');
					$cats = mall_categories();
					foreach( $cats as $cat )
					{
						$parent = NULL;
						if ( $cat['idx_parent'] )
						{
							$p = category($cat['idx_parent']);
							$pname = ":$p[name]";
						}
						echo "<option value='$cat[id]'>$cat[name] ($cat[id]$pname)</option>\r\n";
					}
				?>
			</select>
		</td>
	</tr>
	<tr>
		<td>헤더(타이틀)</td><td><input class="in" name="header" size=30 value="<?=$cfg['header']?>"></td>
	</tr>

	<tr>
		<td>제목 길이</td><td><input class="in" name="length_title" size=3 value="<?=$cfg['length_title']?>"></td>
	</tr>
	<tr>
		<td>내용 길이</td><td><input class="in" name="length_description" size=3 value="<?=$cfg['length_description']?>"></td>
	</tr>
	
	<tr>
		<td>표시</td><td>
		
			<input type="checkbox" name="price" value="checked" <?=$price_checked?>>가격
			<input type="checkbox" name="recommend" value="checked" <?=$recommend_checked?>>추천
			<input type="checkbox" name="hit" value="checked" <?=$hit_checked?>>인기
		</td>
	</tr>
	<tr>
		<td><div id="name">숨기기</div></td><td><input class="in" type="checkbox" name="hide" value="checked" <?=$hide_checked?>> 화면에 나타내지 않기</td>
	</tr>
	<tr>
		<td>스킨</td>
		<td>
			<select name='skin'>
			<?
				$dirs = getdirs($pd."/skin");
				foreach( $dirs as $dir )
				{
					echo "<option value='$dir'";
					if ( isset($cfg['skin']) && $cfg['skin'] == $dir ) echo " selected";
					echo ">$dir</option>";
				}
			?>
			</select>
		</td>
	</tr>
	<tr valign="top">
		<td><div id="name">캐쉬</div></td>
		<td>
			<select name="cache">
				<?=@plugin_cache_options($cfg['cache'])?>
			</select>
			분 <div id="comment">설정(변경) 작업시에는 캐쉬안함으로 체크를 해야합니다.</div>
		</td>
	</tr>
	<tr>
		<td></td><td><input class="button_blue" type="submit" value=" 적 용 [저장] "></td>
	</tr>
</table>


</form>

<script>
	window.resizeTo(500,600);
</script>

<br>
<div id="key">미리보기</div><div id="value">위의 저장(변경)된 내용이 아래 바로 적용이됩니다.</div>

<?
	plugin($ui['areaname']);
?>
