<?php
/**
 * 위치별 플러그인 설정 스크립트
 *
 * 본 스크립트는 articles 플러그인의 설정 스크립트(또는 복사된)이다.
 * 본 스크립트는 설정의 작업 처리를 위한 표준적인 방법을 제시한다. 따라서 설정 스크립트를 작성할 때에는
 * 본 스크릡트를 참조하는 것이 도움이 될 것이다.
 *
 * 현제 위치에 해당하는 현제 플러그인의 설정을 한다.
 * HTML FORM 을 submit 하면 config_submit.php 에 의해서 설정 내용이 저장이될 것이다.
 * 대부분의 경우 config_submit.php 는 변경을 하지 않아도된다.
 * config.php 에서만 수정을 하고 사용하면된다.
 *
 *
 */

/**
 * 필요한 라이브러리 로드
 */
lib('plugin');

/**
 * 플러그인 정보
 */
$pd = dirRoot."/plugin/$ui[dir]";
include $pd."/info.php";
$cfg = config(cfgfile());





/**
 * 초기값 체크
 */
if ( !isset($cfg['category'])  ) $cfg['category'] = NULL;
if ( !isset($cfg['header'])  ) $cfg['header'] = NULL;
if ( !isset($cfg['number']) ) $cfg['number'] = 10;
//if ( !isset($cfg['length_title']) ) $cfg['length_title'] = 30;


$name_checked = $date_checked = $new_checked = $reply_checked = $file_checked = $cname_checked = NULL;


if ( !isset($cfg['width']) || empty($cfg['width']) ) $cfg['width'] = 600;

$hide_checked = NULL;
if ( isset($cfg['hide']) && $cfg['hide'] == 'checked' ) $hide_checked = "checked";



if ( !isset($cfg['cache']) ) $cfg['cache'] = "0";



/**
 * 캐쉬 정보를 저장할 경우, 캐쉬 옵션이 0 이면, 기존의 캐쉬 파일을 여기서 지운다.
 */
if ( empty($cfg['cache']) )
{
	$cache_file = tmp_repository . "/cache/plugin.$ui[areaname].php";
	@unlink($cache_file);
}












?>
<? include "etc/res/php/plugin_config_header.php" ?>

<form action="?" method="post" style="display:inline;">
<input type="hidden" name="cate" value="plugin">
<input type="hidden" name="mode" value="plugin">
<input type="hidden" name="action" value="config_submit">
<input type="hidden" name="dir" value="<?=$ui['dir']?>">
<input type="hidden" name="areaname" value="<?=$ui['areaname']?>">
<!--eo //-->


<table>
	<tr valign=top>
		<td><div id="name">카테고리</div></td>
		<td>
			<input class="in" type="text" name="category" value="<?=$cfg['category']?>"><br>

				<div id="comment">
					카테고리 아이디는 카테고리 관리에서 메뉴를 위해서 작성한 카테고리 아이디를 입력하셔야합니다.<br>
					기본적으로 2단 카테고리가 사용이 가능합니다.
				</div>

		</td>
	</tr>
	
	<tr>
		<td><div id="name">너비</div></td><td><input class="in" type="text" name="width" value="<?=$cfg['width']?>" size=3></td>
	</tr>
	
	<tr>
		<td><div id="name">숨기기</div></td><td><input class="in" type="checkbox" name="hide" value="checked" <?=$hide_checked?>> 화면에 나타내지 않기</td>
	</tr>
	<tr>
		<td><div id="name">스킨</div></td>
		<td>
			<select name='skin'>
			<?
				$dirs = getdirs($pd."/skin");
				foreach( $dirs as $dir )
				{
					echo "<option value='$dir'";
					if ( isset($cfg['skin']) && $cfg['skin'] == $dir ) echo " selected";
					echo ">$dir</option>";
				}
			?>
			</select>
		</td>
	</tr>
	<!--
	<tr valign="top">
		<td><div id="name">캐쉬</div></td>
		<td>
			<select name="cache">
				<?=@plugin_cache_options($cfg['cache'])?>
			</select>
			분 <div id="comment">설정(변경) 작업시에는 캐쉬안함으로 체크를 해야합니다.</div>
		</td>
	</tr>
	//-->
	<tr>
		<td></td><td><input class="button_blue" type="submit" value=" 적 용 [저장] "></td>
	</tr>
</table>


</form>

<script>
	window.resizeTo(800,650);
</script>

<br>
<div id="key">미리보기</div><div id="value">위의 저장(변경)된 내용이 아래 바로 적용이됩니다.</div>
<br>
<?
	plugin($ui['areaname']);
?>
</body>
</html>

