<?php
/**
 * 장난 시작 스크립트
 *
 * 설치형 홈페이지 정보 관리 툴 '장난'의 시작 스크립트이다.
 * 이 파일(시작 스크립트)의 명칭은 변경이 가능하다. 자세한 것은 'test_changing_index.php' 파일을 참고하기 바란다.
 * @since 2007/01/12 index.html 에서 jangnan.php 로 메인 스크립트 내용이 이동되었다.
 * @todo 스킨(템플릿)별로 캐쉬가 가능하므로 전역 캐쉬 기능을 제거하는 것에 대한 검토.
 * @todo 디버깅 시간 관련 함수를 다른 곳에 넣고, SQL 쿼리 시간을 측정.
 */








/** include_once 로 인클루드를 해야한다. 테스트 작업을 할 때, 내부적으로 include_once("../default.php"); 가 여러번 호출 될 수 있다. */
if ( empty($dirRoot) ) $dirRoot = "."; $install = include_once("$dirRoot/lib/default.php");


/** @since 2007/01/19 주소 변환이 환경 설정 파일을 로드한 다음에 일어난다. 환경 설정 파일이 설치 여부를 판단하므로, 설치시 주소 변환을 사용하면 안된다.*/
$install or go('?cate=install');

// 시간 체크 시작. @note lib/default/php 를 로드하는 시간은 빠진다.
$time_start = microtime_float();

// startup 스크립트(들) 실행
beginScript();



/**
 * 로그 파일 기록.
 *
 * 관리자 모드에서 옵션 처리. 로그 파일은 압축하는 형태로 진행이 되어야할 것 같다.
 * 로그 기록에는 문제가 많다. 우선 로그 파일의 막대한 용량이 그것이고, 로그 파일의 처리(가공, 뷰) 등 많은 문제가 산재해 있다. 여기서는 일단, 범용적인 로그 형식으로 기록만한다. 관리자 모드에서 옵션을 체크하면 기록이된다. default.php 인클루드 다음에 로그가 기록이 되어야 매번 스크립트 실행마다 로그가 기록 된다는 보장이 된다. (스크립트에서는 자체적으로 종료될 수 있어서 ...)
 * @see 개발자노트
 * @see accesslog
 * @since 2007년 1월 22일 다운로드를 할 때에 로그가 기록되지 않도록 했다.
 * @since 2007년 04월 01일 로그 처리는 전담 모듈로 변경했다. 따라서 본 메세지는 08월 이후 삭제한다.
 */
/**
if ( !empty($system['log']) )
{
	$rc = accesslog();
	if ( !$rc ) javascriptAlert("failed to log");
}
*/


	/**
	 * 스크립트 실행
	 *
	 * @since 2006년 12월 12일 begin.php 와 end.php 를 인클루드할 때, @ 연산을 통해서 에러 메세지가 나타나지 않도록 했다.
	 *	파일이 존재하지 않을 경우, 그냥 무시되도록 했다. 하지만, 에러(워닝)가 나면 표현을 하지 않으니 조심해야한다.
	 * @since 2007/02/13 디버깅 모드에서는 에러를 출력하도록 변경.
	 */
	error_reporting(E_ALL);
	if(debug()) include(module_begin()); else @include(module_begin());
	$skinLayout = include module();
	if(debug()) include(module_end()); else @include(module_end());
	error_reporting(E_ALL^E_NOTICE);
	
	/**
	 * 스킨 로드(포함, 실행)
	 *
	 * @done 스킨 레이아웃을 직접 사용자들에게 맡기려면, lib/skin.php 를 인클루드해서 안되고, skin/default/layout.html 과 같이 직접 스킨의 레이아웃 파일을 로드하게 해야한다.
	 * @since 2006/12/15 스킨 관리를 lib/skin.php 에서 각 스킨 파일의 layout.html 로 변경을 했다.
	 * @since 2007/01/17 layout.html 스킨과 디버깅 처리를 할지 옵션을 추가했다.
	 * @since 2007/03/11 버젼 2.0 부터 메인스크립트에서 리턴하는 값이 달라졌다. V2 파일을 참고한다.
	 * @since 2007/03/31 버젼 2.2 부터 스킨 체계가 달라졌다. V2.2 파일 참고
	 */
	if ( is_array($skinLayout) )
	{
		if ( !isset($skinLayout['skin']) || empty($skinLayout['skin']) ) include skin('layout');
		else if ( $skinLayout['skin'] == 'mainskin' ) include skin();
		else if ( $skinLayout['skin'] == 'noskin' ) { }
	}
	else
	{
		include skin('layout');
	}






$time_end = microtime_float();
$time = round($time_end - $time_start, 4);
if ( !(isset($arSkin['debug'])) || $arSkin['debug'] ) debugPrint($time);

// endup 스크립트는 맨 나중에 실행
endScript();
?>
