<?php


/**
 * 현제 스크립트가 캐쉬 대상인지 체크를 한다.
 * @note 설정 값에서 공백을 제거하고 비교를 한다.
 */
function in_category()
{
	global $ui, $system;
	
	if ( isset($system['cache_category']) && !empty($system['cache_category']) )
	{
		$str_config = str_replace(" ", "", $system['cache_category']);
		$cates = explode(",", $str_config);
		return in_array("$ui[cate].$ui[mode]", $cates);
	}
	else
		return false;
}

/**
 * @done 파일 이름의 중복. http://jangnans.com/ 과 http://jangnans.com/soa 가 하나의 파일 저장 공간을 사용하면
 * 충돌이 발생한다. 여기에서 파일 이름을 바꿔서 지정하기만 하면 해결이된다.
 */
function cache_filename()
{
	global $ui, $cache_filename;
	if ( isset($cache_filename) ) return $cache_filename;


	
	
	$cache_filename = "{$ui[cate]}.{$ui[mode]}.{$ui[idx]}.{$ui[id]}";
	if ( $ui['mode'] == "list" )
		$cache_filename .= ".{$ui[pageNo]}";
	
	$p = explode("/", $_SERVER["PHP_SELF"]);
	$lp = $p[count($p)-2];
	if ($lp) $cache_filename = "$lp.$cache_filename";
	
	return $cache_filename;
}

/**
 * 캐시 내용을 리턴한다.
 *
 * $ui['cache'] = 'again' 이면 다시 캐싱을 한다.
 *
 * @return mixed 에러시 false, 아니면 캐시 파일 내용.
 *	캐시 파일의 유효 시간 경과시에 false 를 리턴한다.
 *	따라서 캐시 파일만 생성해 놓고, 사용을 전혀하지 못하는 의미 없는 경우가 발생할 수 있다.
 *	이와 같은 경우가 발생할 것 같으면, 캐시 유효 기간을 크게 잡는다.
 */
function cache_data()
{
	
	if ( ! in_category() ) return false;
	
	$file = tmp_repository . "/cache/".cache_filename().".php";
	
	
	/** 캐시 파일 다시 생성 */
	if ( $GLOBALS['ui']['cache'] == 'again' )
	{
		$file = tmp_repository."/cache/index.index...php";
		@unlink($file);
		return false;
	}
	
	$data = @readfileEx($file);

	if ( !$data ) return $data;

	$time = substr($data, 4, 10);
	$expire = $GLOBALS['system']['cache'] * 60 + $time;
	
	/**
	 * 유효 시간 경과
	 */
	if ( $expire < time() )
	{
		return false;
	}
	
	return $data;
}

function cache_save(&$content)
{
	global $system;
	if ( ! in_category() ) return false;
	
	$data = "<!--".time()." cached at ".date("y/m/d h:i:s")." and will be expire on ".date("y/m/d h:i:s", time()+$system['cache']*60)."-->\r\n";
	$data .= $content;
	
	
	$file = tmp_repository . "/cache/".cache_filename().".php";
	
	
	$rc = @writeString($file, $data);
	if ( $rc ) return $rc;
	$rc = mkdirEx(tmp_repository."/cache");
	if ( ! $rc ) return $rc;
	return writeString($file, $data);
}


/**
 * 스킨(또는 템플릿 등과 같이 조각 파일별 출력)에서 캐쉬
 *
 * 캐쉬 파일이 있는지 체크를 해서 있으면, 캐쉬 파일을 출력한다. 없으면 캐쉬를 시작한다.
 *
 * skin_cache_start 와 skin_cache_end 함수는 쌍으로 사용이되어야한다. 중첩되어서도 안된다.
 * 뿐만아니라, 스킨의 맨 위와 맨 아래가 아닌, 중간에서 사용될 경우, 스킨 파일의 명칭으로 캐쉬 파일을 만듬으로 올바른 결과가 나타나지 않을 수 있다.
 * 잘못 사용될 경우, 어떤일이 일어날지 예측하지 않는다.
 *
 * @param int $minute 분단위의 숫자 값이 들어온다. 해당 값에 따라서 캐쉬 파일의 내용을 갱신한다.
 *	기본값은 10분마다 캐시 파일을 갱신한다.
 * @return mixed 캐쉬된 데이터가 있으면, true.
 *	true 가 리턴되면, 캐쉬된 데이터를 출력한 것이다. 따라서 그냥 함수를 호출한 다음 리턴하면된다.
 *
 * @note 반드시 skin_cache_data() 를 (스킨의) 맨 처음에 호출하고 스킨의 맨 마지막에 skin_cache_save() 를 호출해야한다.
 * 만약 중간에 사용할 경우, return 문과 같은 것에 의해서 제대로 표현이 되지 않을 수 있다.
 * @code <? lib('cache'); if ( skin_cache_start(30) ) return; ?>
 *
 * <code>
 *	<? lib('cache'); if ( skin_cache_start() ) return; ?>
 *	... HTML 코드 ...
 *	<? skin_cache_end() ?>
 * </code>
 *
 * @note $skin_cache_file 은 캐시 파일의 경로, $skin_cache_file_base_name 은 스킨 파일의 이름, $skin_cache_file_last 는 몇 분동안 캐쉬 내용을 유지할지의 값을 가지고 있다.
 * @example skin/template/stats.database.pink.html
 * @note "?cache=again" 와 같은 HTTP 변수 지정에 의해서 영향을 받지 않는다.
 * @note 시스템 관리자 모드에서 캐쉬 파일 전체를 삭제하는 경우, 영향을 받는다.
 */
function skin_cache_start($minute=10)
{
	global $skin_cache_file, $skin_cache_file_base_name, $skin_cache_file_last;
	$skin_cache_file_last = $minute;
	$back = debug_backtrace();
	$p = $back[0]['file'];
	$pp = pathinfo($p);
	$skin_cache_file_base_name = $pp['basename'];
	
	$skin_cache_file = tmp_repository . "/cache/skin.$skin_cache_file_base_name";
	
	
	$data = @readfileEx($skin_cache_file);
	if ( $data )
	{
		$time = substr($data, 4, 10);
		$expire = $skin_cache_file_last * 60 + $time;
		/** * 유효 시간 경과하지 않은 경우, 캐쉬 내용을 출력하고 true 리턴 */
		if ( $expire > time() )
		{
			echo $data;
			return true;
		}
	}
	
	/**
	 * 캐쉬 파일이 없거나 유효시간이 경과한 경우,
	 */
	ob_start();
	return false;
}

/**
 * skin_cache_start 에서 ob_start 한 것을 여기서 종료한다.
 *
 * @return same as writeString
 */
function skin_cache_end()
{
	$data = ob_get_contents();
	ob_end_flush();
	
	$b = "<!--".time()." $GLOBALS[skin_cache_file_base_name] cached at ".date("y/m/d h:i:s")." and will be expire on ".date("y/m/d h:i:s", time()+$GLOBALS['skin_cache_file_last']*60)."-->\r\n";
	$e = "\r\n<!--end of cache $GLOBALS[skin_cache_file_base_name]-->\r\n";
	$data = $b . $data . $e;
	return writeStringEx($GLOBALS['skin_cache_file'], $data);
}
?>
