<?php
/**
 * 데이터베이스 라이브러리
 *
 * MySQL 데이터베이스 사용을 위한 클래스를 로드하고, 중복 DB 연결을 막기 위해서 객체를 만들어 $db 변수에 보관한다.
 * 그 외에 필요한 기본 함수를 관리한다.
 *
 * @copyright thruthesky 11/27/2006
 * @version 0.2
 * @see mysql.php
 * @note 전역변수 $_db_user, $_db_password, $_db_database, $_db_host 에 필요한 값이 미리 들어가있어야한다.
 * @package library
 * <code>
 * $_db_user						= &$ui['db_user'];
 * $_db_password				= &$ui['db_password'];
 * $_db_database				= &$ui['db_database'];
 * $_db_host						= &$ui['db_host'];
 * lib('db');
 * </code>
 */
/**
 * 데이터베이스 접속
 *
 * @note 데이터베이스 접속에 에러가 발생하면 goBack() 으로 메세지를 표현하고 이전 페이지로 돌아간다.
 */
 
global $system, $lang;

// ========================================
lib('mysql');
if ( isset($db) && is_object($db) ) return;
$db = new MySQL();

if ( isQuiet() ) $rc = @$db->connect($system['db_user'], $system['db_password'], $system['db_database'], $system['db_host']);
else $rc = $db->connect($system['db_user'], $system['db_password'], $system['db_database'], $system['db_host']);

if ( ! $rc ) goBack(databaseQuery, "lib/db:: database connection failed. ($rc)".$db->error());
if ( is_null($db->errno()) ) goBack(databaseQuery, "lib/db:: database connection failed. ".$lang[databaseInfo]);

$GLOBALS['db'] = $db;
/**
 * 문자셋 설정
 *
 * set names 쿼리가 실패할 경우, $GLOBALS['database_version']	= 'old'; 의 값을 지정한다. 나중에 설치할 때에 사용을 할 수 있다.
 * @note 문자셋 지정은 처음 설치시와 관리자 모드에서 결정을 할 수 있다.
 * @note 문자셋 지정에 실패하는 경우, MySQL 버젼 4.0.1 등과 같은 옛날 버젼이다. 이와 같은 경우에는 문자셋 관련 작업을 아예하지 않는다.
 */
if ( $db->query("set names $system[charset]", false) === FALSE )
{
	$GLOBALS['database_version']	= 'old';
}

/**
 * 데이터베이스 버젼을 리턴한다.
 *
 *
 */
function database_version() {return $GLOBALS['db']->result("SELECT VERSION()");}

/**
 * mysql_insert_id 의 역활
 *
 * 이전의 INSERT 질의로부터 AUTO_INCREMENT 컬럼에 의해 생성된 ID를 반환한다. 
 * mysql_insert_id()는 최근 수행한 질의에 대해서 동작하기 때문에, 생성된 값은 질의 직후에 mysql_insert_id()를 호출해야 된다
 *
 * @note MySQL SQL 함수인 LAST_INSERT_ID()는 가장 최근에 생성된 AUTO_INCREMENT 값을 담고 있으며, 질의 간에 지워지지는 않는다
 * @return 성공하면 이전의 INSERT 질의에 의한 AUTO_INCREMENT 컬럼으로부터 생성된 ID를, 이전 질의로부터 AUTO_INCREMENT 값이 생성되지 않았다면, 0을, MySQL 접속이 되지 않은 상태였다면 FALSE를 반환한다. 
 */
function getInsertID()
{
	return $GLOBALS['db']->insert_id();
}
/**
 * alias of getInsertID
 */
function insertID() { return getInsertID(); }



/**
 * 입력값을 바탕으로 WHERE 조건 절을 만들어 리턴한다.
 *
 * 함수의 입력값 전달이나 기타 요건으로 인해서 SQL 조건 구문을 동적으로 생성해야하는 경우가 있다. 그럴 때 이 함수가 제격이다.
 * 기본 검색은 AND 연산으로 이루어진다.
 *
 * @todo OR, <, >, = 등의 연산도 가능하게 변경한다.
 * @todo 이 함수의 사용이 필요가 있나? qMakeField 함수를 사용하면 되는 것 아닌가?
 * @param associative-array $as SQL 조건 절에 검색 조건으로 사용될 항목과 값을 쌍으로하는 연관 배열
 * <code>
 * 	$qCond = qMakeWhere ( array('id'=>$id) );
 *	dbg($qCond);
 * </code>
 */
function qMakeWhere ( $as )
{
	$ar = array();
	foreach ( $as as $k=>$v )
	{
		$ar[] = "$k='$v'";
	}
	if ( count($ar) )
	{
		return " WHERE " . implode(" AND ", $ar );
	}
}
//@see qMakeWhere
function qWhere ( $a ) { return qMakeWhere($a); }


function dberrstr()
{
	return "error code: " . $GLOBALS['db']->errno() . " " . $GLOBALS['db']->error();
}

/**
 * 모든 DB 관련 함수에서 DB 쿼리 후, 쿼리가 올바로 수행이 되었는가에 대한 결과를 리턴할 때에는 반드시 이 함수를 이용해야한다.
 * 
 * mysql_ 함수군은 질의 결과에 에러가 있으면 FALSE 를 리턴한다. 즉, mysql 함수에서 에러가 있으면 0을 리턴하는 것이다. 시스템의 에러 코드에서 0은 성공을 나타낸다. 이 함수는 모든 mysql 함수군의 쿼리를 수행 후 그 결과 값을 입력하면 된다. mysql 함수의 결과에 에러가 없을 경우 이 함수는 ok 를 리턴한다.
 * 단, 결과 값을 리턴하는 경우에는 이 함수를 사용하면 안된다. INSERT, DELETE 등에서는 사용을 해도 SELECT 와 같은 질의에서 사용을 하면 결과 값이 올바르지 않게된다. 이 함수는 입력값에 상관 없이 faultCode 를 리턴한다.
 * 따라서, 아래의 코드는 올바르지 않다.
 * <code>
 * $db->query("SELECT * FROM post WHERE idx=$idx");
 * return faultDb($db->row()); // 잘 못 되었음. fualtDb 는 faultCode 를 리턴한다.
 * </code>
 *
 * @param resource $rc MySQL DB 쿼리 후 resource. 이 값으로 faultCode 를 넘기지 않도록 조심한다.
 * @return faultCode
 * @note 마지막 에러를 기록한다.
 * <code> return faultDb($GLOBALS['db']->insert('post', $post)); </code>
 */
function faultDb($rc)
{
	if ( $rc ) return ok;
	return faultEx(databaseQuery, "db message: " . dberrstr());
}





///////////////////////////////////////////////////////////////////////////////
/**
 * SQL LIMIT 구문을 만들어 리턴한다.
 *
 * 입력 값 $limit 연관 배열 변수를 바탕으로 SQL 질의 결과의 (검색) 갯수 제한을 할 수 있는 SQL LIMIT  구문을 만든다.
 *
 * @param associative-array $limit LIMIT 조건
 * @return string 검색 갯수 제한을 하는 SQL LIMIT 구문
 * @note $limit['fromNumber'] 와 $limit['toNumber'] 두개의 키를 바탕으로 LIMIT 구문을 만든다.
 * 
 */
function qLimit($limit)
{
	if ( empty($limit) ) return;
	
	if ( ! isset( $limit['fromNumber'] ) )		$limit['fromNumber'] = 0;
	if ( ! isset( $limit['toNumber'] ) )			$limit['toNumber']	 = numberOfRecords;

	if ( $limit['toNumber'] == -1 )
	{
		$qLimit = '';
	}
	else if ( $limit['fromNumber'] || $limit['toNumber'] )
	{
		$qLimit = "LIMIT $limit[fromNumber], $limit[toNumber]";
	}
	else
	{
		$qLimit = "LIMIT 0, " . numberOfRecords;
	}
	return $qLimit;
}


/**
 * 글 검색을 위한 SQL 조건 문장을 만들어 리턴한다.
 *
 *
 * fromDate, toDate 키에 날짜 값을 입력받아서 비교 구문을 생성해 리턴한다.
 * qField 함수로는 동일한 키를 중복시킬 수 없어서 날짜 범위 비교가 힘들다.
 * 
 * @param associative-array $limit 날짜 검색을 위한 조건 값을 가지는 연관배열. $limit['fromDate'] 와 $limit['toDate'] 두가지의 키가 있을 수 있다. 이 키들에 대한 값은 기본 날짜 시간 형식의 값이어야한다. {@link search}를 참고하기 바란다.
 * @param string $field 날짜를 가지는 필드 이름
 * @return string 입력된 조건에 따라 날짜 제한을 하는 SQL 구문을 리턴
 *
 * @since 2007/03/04 기본적으로 dateTime 항목으로 날짜 정렬을 하는데, 입력값 $limit[field] 에 항목을 기록하여 해당 항목에 따라 날자 값을 비교할 수 있다.
 * @example post.php
 * <code>
 *	if ( isset($begin) ) $limit['fromDate']	= $begin;
 *	if ( isset($end) ) $limit['toDate']			= $end;
 * 	$limit['field'] = 'dateTime_firstwrite';
 * </code>
 *
 * @note 아럐와 같이 빈 값을 비교할 경우, 그대로 적용이된다.
 *	$kvs['email']							= "";
 *	$kvs['email cond']				= "<>";
 * 위 코드는 email <> '' 과 같은 SQL 구문을 만든다.
 * @note 날짜 값이 숫자형이라면, 비교하는 형식이 기본 날짜형식이든, unix-timestamp 형식이든 상관없지 않나?
 */
function qDateTime($limit, $field='dateTime')
{
	
	//
	if ( isset($limit['field']) && !empty($limit['field']) ) $field = $limit['field'];
	
	
	$cond = NULL;
	if ( isset($limit['fromDate']) )
	{
		$cond[] = "($field>='$limit[fromDate]')";
	}
	if ( isset($limit['toDate']) )
	{
		$cond[] = "($field<='$limit[toDate]')";
	}
	
	if ( isset($cond) )
		return "(" . implode(" AND ", $cond) . ")";
}



/**
 * 검색 결과를 정렬하기 위한 SQL 구문을 리턴한다.
 *
 *
 * @param associative-array $order 정렬을 하고자 하는 항목을 키로 하고 그 값에 'AS' 혹은 'DESC' 를 전달하면된다.
 * @see searchPost
 */
function qOrder($order)
{
	
	if ( empty($order) ) return '';
	
	foreach( $order as $field => $how )
	{
		if ( ! $field ) continue;						//@note 검색하고자 하는 키(항목) 값이 올바르지 않으면 패스
		$q[] = "$field $how";
	}
	$qs = '';
	if ( isset($q) )
	{
		$qs = implode(",", $q);
		$qs = "ORDER BY $qs";
	}
	return $qs;
}










///////////////////////////////////////////////////////////////////////////////
/**
 * SQL 검색 조건 구문을 만든다.
 *
 * 입력 변수 $kvs 는 {@link qFields}와 같은 값을 가지는 변수이다.
 *
 *
 * 검색 가능한 조건 연산 AND, OR 와 그 외 사용자 직접 지정. =, <=, >=, <,>,LIKE 등
 * string 은 전체 문자열을 그대로 검색한다.
 * @uses qFields
 * @see searchPost
 * @param associativ-array $kvs 검색 항목과 검색어, 검색 항목의 검색 조건(들)을 가지는 연관 배열이다.
 * @param string $field 입력 변수 $kvs 에서 어떤 항목을 검색할지 항목 이름이 입력된다.
 * @return string 한 항목(입력값 $field 항목)에 대해서 검색을 할 수 있는 조건(구)이 리턴된다.
 * @since 2007/01/08 string 조건 구문 추가. 이 조건은 문자열 자체를 그대로 검색한다.
 * key_name LIKE '%검색어(공백 포함)%' 와 동일하며, 조건 검색이 생략된 경우, 기본 값과 동일하다.
 * @since 2007/03/27 case '' 구문을 제거했다. 따라서 더 이상 기본 값으로 string 비교를 하지 않는다.
 */
function qField($field, $value, $cond)
{
	// 검색 항목에서 검색할 검색어(값)가 없는 경우, 검색 조건을 만들지 않고, 그냥 리턴한다.
	// 실제로 클라이언트에서 입력값을 생략할 경우, 이런 경우가 발생할 수 있다.
	// @see siteapi_client.php
	
	
	$string = trim($value);

	switch ( $cond )
	{
		case 'string'	:
		/*case ''				:*/
			$rs = "$field LIKE '%".$string."%'";
			break;
		case 'OR'			:
			$words = explode(' ', $string);
			foreach ( $words as $word )
			{
				$ar[] = "($field LIKE '%$word%')";
			}
			$rs = implode (' OR ', $ar);
			$rs = "($rs)";
			break;
		case 'AND'		:
			$words = explode(' ', $string);
			foreach ( $words as $word )
			{
				$ar[] = "($field LIKE '%$word%')";
			}
			$rs = implode (' AND ', $ar);
			$rs = "($rs)";
			break;
		default 			:
			$rs = "$field $cond '$string'";
			break;
	}	
	return $rs;
}

/**
 * DB 쿼리에서 검색할 필드(항목), 값, 조건을 입력 받아서 SQL 쿼리 가능한 문장을 만든다.
 *
 * 입력 변수 $kvs[exp cond] 를 통해서 전체 AND, OR 연산을 할 수 있다.
 * 입력 값 $kvs 는 site.search() 의 struct keys_values 검색 조건 값과 동일하다. 이 값은 Site API 의 규격에 맞는 입력 값이 들어있다.
 * 
 * 
 * @param associative-array $kvs 검색 항목과 검색어, 검색 항목의 검색 조건(들)을 가지는 연관 배열이다. 예를 들면, $kvs['name'] = '길동 명수'; 와 같을 때, $kvs['name cond'] = 'OR' 로 검색 조건을 지정할 수 있다. 그렇다면 '길동' OR '명수' 와 같이 검색을 한다. 'cond' 의 값이 생략되면 LIKE  검색 조건 구문을 만든다.
 * @return string 입력된 검색 항목과 조건들에 대해서 실제 검색을 할 수 있는 SQL 쿼리 조건을 리턴한다.
 * @since 2007/01/15 $kvs['exp cond'] 에 값을 'OR' 나 'AND' 와 같이 해서, 항목 사이의 연산을 해 줄 수 있다.
 * 이전에는 기본적으로 AND 연산만 가능해서, $kvs['name'] = 'a'; $kvs['age'] = 1;  의 경우 name='a' AND age=1 과 같은 표현만 가능했는데, name='a' OR age=1 과 같은 표현이 가능해진다.
 * @see searchPost
 * @since 2007/02/16 $kvs['exp cond']="OR" 와 같은 처리만으로 복잡한 쿼리를 수행할 수 없는 경우가 발생한다.
 *	이와 같은 경우 'exp extra' 를 통해서 추가 쿼리를 직접 지정할 수 있다.
 *	다음의 예와 같다.
 * <code>
 *	if ( login() )
 *	{
 *		$extra = "(idx_user=$user[idx] OR r<=$user[grade])";
 *	}
 *	else
 *	{
 *		$extra = "r=0";
 *	}
 *	$search['exp extra'] = $extra;
 * </code>
 *
 * @since 2007/03/27 cond 에러 연산자 제거. cond 가 지정되지 않았을 경우, = 연산을 하도록 했다.
 *	이에 따라 기존에는 cond 연산자를 지정하지 않고 검색을 하면,
 *	SELECT * FROM category WHERE (type LIKE '%5%' AND idx_parent LIKE '%96%') 와 같은 쿼리 문장이 수행되었다.
 *	변경된 후로는 아애롸 같이 수행이된다.
 *	SELECT * FROM category WHERE (type = '5' AND idx_parent = '96')
 */
function qFields($kvs)
{
	$cond = array();
	
	// qField 를 통해서 각 필드별로 쿼리 표현을 새성해서 배열에 보관
	foreach ( $kvs as $k => $v )
	{
		if ( empty($k) ) continue;										//
		if ( strstr($k, ' ') ) continue;							// 필드(항목 이름)에 공백이 있으면 통과
		
		
		
		/** @since 2007/03/27 cond 에러 연산자 제거. cond 가 지정되지 않았을 경우, = 연산을 하도록 했다. */
		if ( isset($kvs["$k cond"]) ) $kvs_cond = $kvs["$k cond"];
		else $kvs_cond = '=';
		$cond[] = qField($k, $v, $kvs_cond);
	}
	
	// 'exp extra' 처리
	if ( isset($kvs['exp extra']) ) $cond[] = $kvs['exp extra'];
	
	// 쿼리가 있으면,
	if ( !empty($cond) )
	{
		// "exp cond" 에 따라 OR , AND 처리
		if ( isset($kvs['exp cond']) ) return "(" . implode(" ".$kvs['exp cond']." ", $cond) . ")";
		else return "(" . implode(" AND ", $cond) . ")";
	}
}

/**
 * SQL 쿼리에서 카테고리 별 검색을 위한 조건 구문을 만든다.
 *
 * category.php 라이브러리에 포함되어야할 것 같아 보일 수도 있다만, 여기에 위치하는 것이 맞는것 같다.
 *
 * @note 입력 변수 $categories 의 요소에는 카테고리 아이디와 카테고리 번호가 혼합되어 기록될 수 있다.
 * @param mixed $categories 숫자, 문자열, 배열의 형태를 가질 수 있다. 문자열이 입력되면 아이디로 인식을 하고 그 하나에 대한 카테고리를 검색한다. 숫자가 입력되면 숫자에 대한 카테고리 번호를 검색하며, 배열 내에서도 문자열 또는 숫자가 기록될 수 있으며 마찬가지로 해당 카테고리 정보를 검색하기 위한 쿼리 구문을 만든다.
 * @return string 카테고리 검색이 가능한 SQL 조건 구문. 값이 없는 경우는 empty 를 리턴한다. 즉, 검색 조건 구문을 만들지 않는다.
 *
 */
function qCategories($categories=array())
{
	if ( is_numeric($categories) )
	{
		$idxs = "(idx_category=$categories)";
	}
	else if ( is_string($categories) )
	{
		$idx_category = getCategoryIdx($categories);
		if ( empty($idx_category) )
		{
			return faultEx(wrongIndex, "db::qCategories you have submitted wrong category index. the id '$categories' does not exists.");
		}
		$idxs = "(idx_category=$idx_category)";
	}
	else if ( is_array($categories) && !empty($categories) )
	{
		lib('category');
		$idx = array();
		foreach ( $categories as $id )
		{
			//@note 입력 값이 숫자이면 카테고리 번호로 인식
			if ( is_numeric($id) )
			{
				$idx[] = "(idx_category=$id)";
			}
			/**
			 * @since 2007/03/03 아래에서 else 키워드가 빠져 있었다. 추가를 했다.
			 */
			else 
			{
				$idx_category = getCategoryIdx($id);
				if ( empty($idx_category) ) return faultEx(wrongIndex, "post::searchPost you have submitted wrong category index. the id '$id' does not exists.");
				$idx[] = "(idx_category=" . $idx_category . ")";
			}
		}
		if ( !empty($idx) )
		{
			$idxs = "(" . implode(" OR ", $idx) . ")";
		}
	}
	if ( isset($idxs) ) return $idxs;
}




// ////////////////////////////////////////////////////////////////////////////
//
//
//
// ////////////////////////////////////////////////////////////////////////////
/**
 * 해당 테이블의 최고 인덱스 번호를 리턴한다.
 *
 * @param string $table
 * @return int
 * @code g(maxidx());
 */
function maxidx($table='post')
{
	return $GLOBALS['db']->result("SELECT MAX(idx) FROM $table");
}
?>
