<?php
/**
 * 시스템 파일 함수 라이브러리
 *
 * file 라이브러리는 범용 함수군의 모음이다.
 * 이 라이브러리 파일은 시스템과 관련된 함수 묶음이다.
 *
 * @copyright		2006 by ky 본 라이브러리(본 스크립트 또는 소스 파일)는 저작자와 링크를 표기하는한 그대로 복사하여서 사용할 수 있습니다. 수정된 내용은 알려주셔야합니다.
 * @license			http://www.opensource.org/licenses/gpl-license.php GPL
 * @example			module/massposting/submit.php
 * @example			module/upload/submit.php
 * @author			ky (thruthesky) <thruthesky@yahoo.co.kr>
 * @see					README 참조
 * @link				http://thruthesky.webzero.co.kr/etc/jangnan/
 * @link				http://thruthesky.webzero.co.kr/etc/jangnan/docs/hometools/
 * @package			library
 * @filesource
 */
/**#@+
 * 상수 정의
 *
 * PHP 4.2.0 에는 error code 만 정의되어있고 관련된 constants 는 PHP 4.3.0 부터 시작된다.
 * @see PHP Manual Chapter 38. Handling file uploads
 */
if (!defined('UPLOAD_ERR_OK')) define('UPLOAD_ERR_OK', 0);
if (!defined('UPLOAD_ERR_INI_SIZE')) define('UPLOAD_ERR_INI_SIZE', 1);
if (!defined('UPLOAD_ERR_FORM_SIZE')) define('UPLOAD_ERR_FORM_SIZE', 2);
if (!defined('UPLOAD_ERR_PARTIAL')) define('UPLOAD_ERR_PARTIAL', 3);
if (!defined('UPLOAD_ERR_NO_FILE')) define('UPLOAD_ERR_NO_FILE', 4);
if (!defined('UPLOAD_ERR_INTERNAL')) define('UPLOAD_ERR_INTERNAL', 9);
/**#@-*/
/**
 * This function uploads a file with the given http variable.
 *
 * @since 2007/02/11 리턴값이 UPLOAD_ERR_OK 일때, $GLOBALS['insertID'] 에 파일 번호(file.idx)가 기록된다.
 * 
 * @param int $idx_post the data index number which this file should be attached.
 * @param string $name HTML FORM NAME
 * @return int UPLOAD_ERR_OK (that is, 0) when successfully uploaded. otherwise one of the error code above.
 * $GLOBALS['insertID'] 에 파일 번호가 저장된다.
 *
 * if no file has uploaded, then it returns UPLOAD_ERR_NO_FILE
 * @code upload($idx, "file2", "checked");
 * @deprecated @since 2007/02/01 입력 변수 $idx_post 가 참조 변수로의 역활.
 *
 */
function upload($idx_post, $name, $inline='', $categoryType = CATE_BBS)
{
	// if no idx has been specified, return UPLOAD_ERR_INTERNAL.
	if ( $idx_post === NULL ) return UPLOAD_ERR_INTERNAL;
	if ( ! isset($_FILES[$name]) ) return UPLOAD_ERR_NO_FILE;
	if ( $_FILES[$name]['error'] ) return $_FILES[$name]['error'];

	// check the repository.
	$dir = data_repository . '/' . date("y/m/d");
	if ( ! is_dir($dir) )
	{
		if ( ! mkdirEx($dir) ) goBack(diskAccess, 'failed to create the repository.');
	}
	
	// insert file info into database.
	$info['idx_post']				= $idx_post;
	$info['name']						= $_FILES[$name]['name'];
	$info['size']						= $_FILES[$name]['size'];
	$info['type']						= $_FILES[$name]['type'];
	$info['dateTime']				= date("YmdHis");
	$info['ip']							= inet_addr($_SERVER['REMOTE_ADDR']);
	$info['user_agent']					= $_SERVER['HTTP_USER_AGENT'];
	$info['inline']							= $inline;
	$info['idx_category_type']	= $categoryType;
	
	if ( faultCode(insertFile($info)) ) return UPLOAD_ERR_INTERNAL;
	$idx = getInsertID();
	$to = "$dir/$idx";
	
	if (move_uploaded_file($_FILES[$name]['tmp_name'], $to))
	{
		lib('post');
		updatePostField($idx_post, 'files', "files+1");
		$GLOBALS['insertID'] = $idx;
		return UPLOAD_ERR_OK;
	}
	else
	{
		deleteFile($idx);
		return UPLOAD_ERR_NO_FILE;
	}
}


/**
 * file 테이블에 정보를 입력한다.
 *
 * @see 개발자노트
 * @return faultCode
 */
function insertFile($file)
{
	if ( ! positive($file['idx_post']) ) return faultEx(wrongParam, 'No data index has specified. To insert a file data, you must give a data index number which this file information is associated, like post.idx, user.idx, category.idx');
	if ( ! isset($file['dateTime']) ) $file['dateTime'] = dateTime();
	if ( ! isset($file['ip']) ) $file['ip'] = inet_addr($_SERVER['REMOTE_ADDR']);
	$file['user_agent']		= $_SERVER['HTTP_USER_AGENT'];
	
	return faultDb($GLOBALS['db']->insert('file', $file));
}

/**
 * 파일 정보 삭제
 *
 * 디스크에 기록된 파일과 데이터베이스에 존재하는 파일 정보를 삭제한다.
 *
 * 첨부된 파일 삭제 루틴은 이 함수를 이용해서 작업을 하면된다.
 *
 * @param mixed $idx 숫자형이면 파일 인덱스 번호이다. 이때는 file 테이블에서 정보 레코드를 구하고, 배열형이면 그냥 그 배열을 파일 정보로 이용한다.
 * @return faultCode 입력된 file.idx 가 존재하지 않는다면, wrongIndex 가 리턴된다.
 * <code>
 * 글과 연관된 전체 파일을 삭제하는 루틴.
 *	lib('filesystem');
 *	$files = files($idx, CATE_BLOG);
 *	foreach( $files as $file )
 *	{
 *		deleteFile($file);
 *	}
 * </code>
 * 
 */
function deleteFile($idx)
{
	if ( is_numeric($idx) )
		$info = getFile($idx);
	else if ( is_array($idx) ) $info = $idx;
	else return faultEx(wrongParam, 'library::filesystem::deleteFile 입력값이 잘 못되었습니다.');
	if ( empty($info) )
		return faultEx(wrongIndex, 'library::filesystem::deleteFile 입력값이 잘 못되었습니다.');
	
	
	
	$file = getfilepath($info);
	if ( ! @unlink( $file ) )
	{
		// 파일 삭제 실패
		// 파일이 존재하는데 삭제를 못한 경우, 에러
		if ( is_file( $file ) )
			return faultEx(diskAccess, "filesystem::deleteFile - $file 삭제 실패");
		// 파일이 존재하지 않는 경우, 그냥 통과
	}
	return faultDb($GLOBALS['db']->query("DELETE FROM file WHERE idx=$info[idx]"));
}


/**
 * 글(레코드)과 연관되어 첨부된 파일의 정보를 배열로 리턴
 *
 * 빌드가이드의 첨부 파일 항목을 참고한다.
 *
 * @since 2007/02/11 첨부된 파일의 형태를 입력 변수 $type 에 지정하면,
 *	나중에 $type 을 이용하여 해당 첨부물에 대해서만 정보를 리턴한다.
 *
 * @param int $idx 글(레코드) 번호
 * @param int $type 정보의 분류. 첨부된 파일의 형태를 지정해서 특정 첨부 파일만 가져올 수 있다.
 * @return mixed 에러시 faultCode, array 각 배열의 요소는 associative-array 로서 하나의 파일 정보를 가진다.
 * @note 함수명이 getFiles 정도 되어야 올바르다. 그러나 file 라이브러리와 충돌이 생긴다. 따라서 그냥 files 로 했다.
 * @since 2007/03/01 파일은 나중에 첨부된 것이 먼저 나오는 순서로 정렬된다.
 */
function files($idx, $type=NULL)
{
	if ( ! positive($idx) ) return faultEx(wrongParam, '파일 데이터의 정보를 가지는 글 번호 post.idx 가 지정되지 않았습니다.');

	if ( $type === NULL ) $condType = "";
	else $condType = "AND idx_category_type=$type";

	global $db;
	$db->query("SELECT * FROM file WHERE idx_post=$idx $condType ORDER BY idx DESC");
	$ar = array();
	while ( $row = $db->row() ) $ar[] = $row;
	return $ar;
}


/**
 * 정보의 이미지 배열을 리턴한다.
 *
 * 기본적으로 동작은 files 과 같다. 입력값과 리턴값이 동일하다.
 * 다만, 리턴되는 값에 url 과 같은 추가 정보가 더해진다.
 * 따라서 이 함수를 사용하도록 한다.
 *
 * @param int $idx 정보 번호. file.idx_post 의 값.
 * @param int $type 카테고리 상수
 * @return 글(정보)에 첨부된 이미지(들)의 레코드를 배열로 리턴.
 * @code $images	= fileImages($it['idx'], NULL); 와 같이하면, 전체 파일이 불려진다.
 */
function fileImages($idx, $type=CATE_BBS)
{
	$files = files($idx, $type);
	if ( faultCode($files) ) return array();
	$ar = array();
	foreach($files as $file)
	{
		if ( strstr($file['type'],"image") )
		{
			$ar[] = getfilelink($file);
		}
	}
	return $ar;
}


/**
 * 파일 정보 읽기
 *
 *
 * @param int $idx 파일 번호( file.idx 이다. )
 * @return associative-array mysql_fetch_assoc 의 결과값으로서 file.idx 의 레코드를 연관 배열로 리턴한다.
 */
function getFile($idx)
{
	lib('db');
	global $db;
	$db->query("SELECT * FROM file WHERE idx=$idx");
	return $db->row();
}

/**
 * 파일 다운로드 카운트를 증가 시킨다.
 */
function updateFileHit($idx, $hit=1)
{
	return faultDb($GLOBALS['db']->query("UPDATE file SET hits=hits+$hit WHERE idx=$idx"));
}



/**
 * 특정 글과 연관이 있는 파일의 갯수를 리턴
 *
 * @param int $idx 글 번호
 * @return int 없으면 0
 */
function countFile($idx)
{
	return faultDb($GLOBALS['db']->result("SELECT COUNT(*) FROM file WHERE idx_post=$idx"));
}

/**
 * 파일의 정보를 바탕으로 LINK 를 만들어 리턴한다.
 *
 * @param associative-array 파일 레코드
 * @return associative-array link=URL 링크, title=표시 제목, url=URL 주소, url_delete=파일 삭제 링크
 * @note 파일 삭제를 위한 경로는 url_delete 이다. 이것은 다른 모듈로 연결이 된다.
 * @note 이 함수는 범용적이지 못하다. url_delete 에서 특정 모듈을 사용하는데, 이렇게되면 다른 모듈에서는 사용할 수 없다. 수정이 필요하다.
 * @since 2007/01/16 다른 모듈에서 사용이 가능하도록 $cate, $mode 를 참고한다.
 * @since 2007/03/03 입력된 파일 레코드 정보에 추가로 LINK 정보를 포함해서 리턴한다. 즉, 이 함수의 리턴 값으로 기존의 레코드 정보를 그대로 이용할 수 있다.
 */
function getFileLink($file)
{
	if ( empty($file) ) return;
	global $cate;
	$kb = kbsize($file['size']);

	$file['title']	= "$file[name] $kb down: $file[hits]";
	$file['url']		= urlHomepage . "?cate=download&idx=$file[idx]";
	$file['url_delete']						= "?cate=$cate&mode=deletefile&idx=$file[idx]";
	$file['url_delete_submit']		= "?cate=$cate&mode=deletefile_submit&idx=$file[idx]";
	$file['link']		= "<a href='?cate=download&idx=$file[idx]'>$file[title]</a>";

	return $file;
}

/**
 * 입력된 file 테이블의 레코드를 바탕으로 파일 경로를 리턴한다.
 *
 * @param assoacitaive-array 파일 정보
 * @return string 파일 경로
 */
function getFilePath($info)
{
	$dir = data_repository . '/' . date("y/m/d", toStamp($info['dateTime']));
	return "$dir/$info[idx]";
}

/**
 * 
 *
 * @return associative-array 파일을 정보를 담고이 있는 배열
 */
function fileChecked($idx_post)
{
	return fileMark($idx_post, 'checked');
}
/**
 * file.inline 필드에 표시된 값(1개의 레코드)을 골라낸다.
 *
 * 파일에 링크 표시를 해서 리턴한다.
 *
 * @return associative-array 선택된 레코드의 정보를 배열로 리턴.
 * @example module/mall/modify_submit.php
 */
function fileMark($idx_post, $mark)
{
	global $db;
	$db->query("SELECT * FROM file WHERE idx_post=$idx_post AND inline='$mark'");
	return getFileLink($db->row());
}



/**
 * 파일 데이터 영역에 임시 공간을 만든다.
 *
 * @see 개발자노트
 * @return boolean 임시 공간이 이미 존재하거나 생성을 햇으면 true, 아니면 false
 */
function makevar()
{
	if ( is_dir(tmp_repository) ) return true;
	else
	{
		lib('file');
		return mkdirEx(tmp_repository) ;
	}
}
/**
 * 임시 파일 이름을 만든다.
 *
 * @param string $name 파일 명칭의 앞에 붙을 문자열
 * @return 파일 이름 (경로 포함하여, 전체. 확장자는 없다.)
 */
function tmpname($name)
{
	return tmp_repository . "/". $name . ".". dateTime();
}


/**
 * 파일의 크기를 리턴한다.
 *
 * @param string $name HTML FORM 의 file 속성의 name 값
 * @return int 파일의 크기를 리턴한다. 에러가 있으면 false
 */
function checkSize($name)
{
	if ( isset($_FILES[$name] ) )
	{
		if ( empty($_FILES[$name]['size']) ) return false;
		return $_FILES[$name]['size'];
	}
	else return false;
}


?>
