<?php
/**
 * 정보 리스트와 관련된 라이브러리
 *
 * 사용자 목록 리스트, 게시판, 메모장 목록 리스트 등, 각 종 리스트와 관련된 함수 라이브러리이다.
 *
 * @since 2006/12/15 페이지 번호를 나타내는 HTTP 변수 pno 를 pageNo 로 변경
 * @package library
 */
/**
 * 리스트 변수 설정을 편리하게 하는 함수
 *
 * HTTP 변수 입력과, 시스템 설정, 카테고리 설정 등의 값들을 조합해서 리스트를 하기 위한 정보를 리턴한다.
 * @param associative-array $ui URL 변수 값
 * @param associative-array $info 카테고리(글의 영역) 정보 (게시판 설정 정보 등)
 * @return associative-array 리스트 정보를 가지는 연관 배열
 * <code>
 * lib('list');
 * $page = infoPaging($ui, $info);
 * $res = searchPost($ui['idx'], array(), $page, array('dateTime'=>'DESC'));
 * </code>
 * @changed $ui[idx] 는 경우에 따라 글번호 또는 영역번호를 가진다. 이 함수에서 필요한 값은 영역 글번호이다.
 * 따라서 $info[idx] 를 글 영역 번호로 사용을 한다.
 * @since 2007/02/22 $ar['id'] 를 추가했다. 리스트를 할 때에 카테고리 번호 보다 카테고리 아이디를 사용한다.
 */
function infoPaging($ui = array(), $info = array() )
{
	$ar['idx']											= $info['idx'];						// 글 영역(카테고리) 번호
	$ar['id']												= $info['id'];						// 카테고리 아이디
	if ( isset( $ui['pageNo'] ) )
		$ar['pageNo']									= $ui['pageNo'];						// 페이지 번호
	else $ar['pageNo'] = 0;
	if ( !positive($ar['pageNo']) ) $ar['pageNo'] = 1;
	$ar['pagesInBlock']							= pagesInBlock;					// 한 블럭에 페이지 수
	if ( empty( $info['number_list'] ) )
		$ar['articles']								= numberOfRecords;			// 한 페이지 글 수
	else
		$ar['articles']								= $info['number_list'];
	
	$ar['fromNumber']	= ($ar['pageNo'] - 1) * $ar['articles'];		// DB 에서 나타낼 글의 시작
	$ar['toNumber']		= $ar['articles'];			// 끝
	return $ar;
}


/**
 * lib/pager.php 라이브러리를 쉽게 사용하게 하는 함수. 페이징을 쉽게 하는 함수이다.
 *
 * 만약 $ar 변수가 empty 일 경우, 전역 변수 $pageinfo 를 입력 값으로 사용한다. 따라서 필요한 곳에서는 항상 전역 변수의 값을 세팅해 놓아야한다.
 * 입력 변수 $ar( 또는 전역 변수 $pageinfo )에 들어 가야하는 항목은 기본적으로 {@link pager}의 것과 동일하다.
 * {@link infoPaging}를 통해서 기본적인 페이징 값을 얻는다. 거기에다 총 게시물 수를 검색한 값을 추가하고 그 외 옵션값을 추가하면된다.
 *
 * @param string $type pages, block, all 세가지 중 하나를 사용할 수 있다.
 * @param associative-array $ar 페이징 링크를 표현할 값들을 가지고 있다. 자세한 내용은 {@link pager} 클래스를 참고하기 바란다.
 * @return string 입력 값이 잘못 되었을 경우 '...wrong-input...' 이 리턴된다.
 * @note 따로 DB 접속과 같은 작업은 하지 않는다.
 */
function getLinkPaging($type, $ar=array())
{
	/**
	 * 입력값 체크
	 */
	/**
	 * @since 2007/01/29 입력값이 없어도 처리가 되록 한다.
	if ( (!is_array($ar) || empty($ar) ) && (!is_array($GLOBALS['pageinfo']) || empty($GLOBALS['pageinfo']))) return '...wrong-input...';
	if ( !is_array($ar) || empty($ar) ) $ar = $GLOBALS['pageinfo'];
	 */
	
	if ( empty($ar) && isset($GLOBALS['pageinfo']) ) $ar = $GLOBALS['pageinfo'];

	if ( !isset($ar['idx']) ) $ar['idx'] = 0;
	
	lib('pager');
	/**
	 * 기본 값 처리
	 *
	 */
	if ( empty($ar['pageNo']) )					$ar['pageNo'] = 0;						// 페이지 번호 변수
	if ( empty($ar['pagesInBlock']) )		$ar['pagesInBlock'] = pagesInBlock;
	if ( empty($ar['articles']) )				$ar['articles'] = numberOfRecords;
	if ( empty($ar['pageVar']) )				$ar['pageVar'] = 'pageNo';
	if ( empty($ar['pageTextPrev']) )		$ar['pageTextPrev'] = '[';
	if ( empty($ar['pageTextNext']) )		$ar['pageTextNext'] = ']';
	if ( !isset($ar['pageTextLink']) )	$ar['pageTextLink'] = 1;
	if ( empty($ar['pageTextSep']) )		$ar['pageTextSep'] = '&nbsp;-&nbsp;';
	if ( empty($ar['extraVar']) )				$ar['extraVar'] ="cate=bbs&mode=list&id=$ar[id]";
	if ( empty($ar['extraAttr']) )			$ar['extraAttr'] = "";
	if ( empty($ar['prevText']) ) 			$ar['prevText']	= "<< 이전";
	if ( empty($ar['nextText']) )			$ar['nextText'] = "다음 >>";
	if ( empty($ar['firstPageText']) ) $ar['firstPageText'] = "맨처음";
	if ( empty($ar['lastPageText']) )	$ar['lastPageText'] = "맨끝";

	
	$nav = new Pager($ar);
	if ( $nav->parse() === false ) goBack("페이징을 하지 못했습니다." . $nav->error() );
	switch( $type )
	{
		case 'pages'			: return $nav->getLink();
		case 'block'			: return $nav->getLinkBlock();
		case 'all'				: return $nav->getLinkBlockAll();
		case 'object'			: return $nav;
	}
}


?>
