<?php
/**
 * 쇼핑몰 라이브러리
 *
 * 아이템(상품)에 대해서 회원 전용 쓰기(상품 등록)가된다.
 */
 
/**
 * 키 매칭을 한다.
 *
 * 아이템 값을 DB 에 넣기 위해서 post 테이블 정보로 변환한다.
 * @note $data[idx_user] 에는 사용자 번호의 값이 미리 기록되어있어야한다.
 */
function convToPost($data)
{
	$r = array();
	if ( isset($data['idx']) ) $r['idx'] = $data['idx'];
	if ( isset($data['idx_parent']) ) $r['idx_parent'] = $data['idx_parent'];
	if ( isset($data['idx_category']) ) $r['idx_category'] = $data['idx_category'];
	if ( isset($data['idx_category_type']) ) $r['idx_category_type'] = $data['idx_category_type'];
	if ( isset($data['idx_user']) ) $r['idx_user'] = $data['idx_user'];
	if ( isset($data['id']) ) $r['id'] = $data['id'];
	if ( isset($data['name']) ) $r['name'] = $data['name'];
	if ( isset($data['title']) ) $r['title'] = $data['title'];
	if ( isset($data['description']) ) $r['description'] = $data['description'];
	if ( isset($data['tags']) ) $r['tags'] = $data['tags'];
	if ( isset($data['recommend']) ) $r['recommend'] = $data['recommend'];
	if ( isset($data['created']) ) $r['birth'] = $data['created'];
	if ( isset($data['origin']) ) $r['homepage'] = $data['origin'];
	if ( isset($data['maker']) ) $r['email'] = $data['maker'];
	if ( isset($data['hit']) ) $r['sex'] = $data['hit'];
	if ( isset($data['origin_price']) ) $r['password'] = $data['origin_price'];
	if ( isset($data['price']) ) $r['password_type'] = $data['price'];
	if ( isset($data['delivery']) ) $r['user_agent'] = $data['delivery'];
	if ( isset($data['size']) ) $r['secret'] = $data['size'];
	if ( isset($data['stock']) ) $r['point'] = $data['stock'];
	if ( isset($data['etc']) ) $r['license'] = $data['etc'];
	return $r;
}
/**
 * 정보를 아이템의 것으로 변환해서 리턴한다.
 *
 * post 테이블 정보를 아이템으로 변환한다.
 * price 에 콤마를 없앤다.
 * @note hit 는 인기 정도. hits 는 상품의 조회 수이다.
 */
function convToItem($data)
{
	$r = array();
	/*
	$r['idx_parent'] = $data['idx_parent'];
	$r['idx_category'] = $data['idx_category'];
	$r['idx_user'] = $data['idx_user'];
	$r['id'] = $data['id'];
	$r['name'] = $data['name'];
	$r['title'] = $data['title'];
	$r['description'] = $data['description'];
	$r['tags'] = $data['tags'];
	$r['recommend'] = $data['recommend'];
	*/
	
	$r = $data;
	
	$r['created'] = $data['birth'];
	$r['origin'] = $data['homepage'];
	$r['maker'] = $data['email'];
	$r['hit'] = $data['sex'];
	$r['origin_price'] = $data['password'];
	$r['price'] = $data['password_type'];
	$r['delivery'] = $data['user_agent'];
	$r['size'] = $data['secret'];
	$r['stock'] = $data['point'];
	$r['etc'] = $data['license'];
	//@since 2007/03/26 url 이 게시물 읽기가 아니라, 쇼핑몰 정보 읽기로 변경
	$r['url'] = "?cate=mall&mode=read&idx=$data[idx]";
	
	$r['price'] = str_replace(",","",$r['price']);
	return $r;
}

/**
 * 글(들)을 입력받아서 상품 정보로 변환 후 리턴
 *
 * 상품 정보에 더해서, 기본 이미지 등의 링크를 추가해서 리턴한다.
 * convToItem 함수보다 더 많은 정보를 추가해서 리턴한다.
 * @param array $arr array of associative-array 로서 searchPost 와 같은 결과(정보)를 가지는 레코드
 * @return array of associative-array
 *	- 'image' 에는 체크된 이미지 정보가 연관 배열로 들어있다.
 *	- 'url' 에는 아이템의 주소
 * <code>
 *	lib('post');
 *	$rows = searchPost($categories, $kvs, array('toNumber'=>$cfg['number']), $order);
 *	$items = convToItems($rows);
 * </code>
 */
function convToItems($rows, $url_default_image='skin/default/noimage.gif')
{
	lib('filesystem');
	$items = array();
	foreach($rows as $row)
	{
		$item		= convToItem($row);
		$image	= fileChecked($item['idx']);
		if ( empty($image) )
		{
			$image['url']		= $url_default_image;
		}
		$item['image'] = $image;
		$item['url'] = "?cate=mall&mode=read&idx=$item[idx]";
		$items [] = $item;
	}

	return $items;
}


/**
 * 상품의 필드 이름에 해당하는 데이터베이스 필드 이름을 리턴한다.
 *
 */
function mall_fieldname($field)
{
	switch($field)
	{
		case 'hit'					: return 'sex';
		case 'price'				: return 'password_type';
		default: return NULL;
	}
}


/**
 * 상품 정보를 기록한다.
 */
function saveItem($data)
{
	lib('post');
	return insertPost(convToPost($data));
}

/**
 * 쇼핑몰 아이템 정보를 가져온다.
 *
 * 실제로는 글 정보를 읽어서 쇼핑몰의 데이터 규격으로 변경을 한 후 리턴한다.
 *
 * @param $idx 글 번호
 * @return associative-array
 */
function item($idx)
{
	lib('post');
	return convToItem(post($idx));
}



/**
 * 상품 정보를 업데이트한다.
 *
 * @retrun faultCode
 */
function updateItem($data)
{
	lib('post');
	return updatePost(convToPost($data));
}


/**
 * 아이템의 (첨부된) 이미지를 배열로 리턴
 *
 * 상품 정보를 나타날때, 이미지를 보여주기 위해 사용.
 * inline = '' 인 파일(이미지)들을 리턴한다.
 */
function itemimages($idx)
{
	lib('filesystem');
	$files = files($idx, CATE_MALL);
	$ar = array();
	foreach($files as $file)
	{
		if ( empty($file['inline']) ) $ar[] = getFileLink($file);
	}
	return $ar;
}

/**
 * 정보를 주문 정보로 변환
 *
 * @since 2007/03/04 post 의 레코드를 그대로 리턴하며, 추가 정보를 포함해서 리턴한다.
 *
 * $r['idx']												주문번호(글 번호이자 주문번호이다.)
 * $r['payway']											결재방식. README 파일 참고
 * $r['items'][상품번호]['number']					수량
 * $r['items'][상품번호]['option']					옵션,선택사항
 * $r['items'][상품번호]['price']					1개당 가격
 * $r['items'][상품번호]['subtotal']				현재 수량에 대한 서브 토탈
 */
function postToOrder($post)
{
	/*
	$r['idx']									= $post['idx'];
	$r['idx_user']						= $post['idx_user'];
	$r['id']									= $post['id'];
	$r['dateTime']						= $post['dateTime'];
	$r['state']								= $post['state'];
	*/
	
	$r = $post;
	
	
	
	$r['payer']								= $post['name'];
	list($r['buyer_name'], $r['buyer_phone'], $r['buyer_cphone'],$r['buyer_address'],$r['buyer_zipcode'],$r['buyer_email']) = explode("|", $post['email']);
	list($r['recv_name'],$r['recv_phone'],$r['recv_cphone'],$r['recv_address'],$r['recv_zipcode'],$r['recv_email']) = explode("|", $post['homepage']);
	$r['etc']									= $post['secret'];
	$r['total']								= $post['recommend'];
	$r['payway']							= $post['password_type'];
	$items = explode("|", $post['password']);
	
	foreach($items as $item)
	{
		@list($itemno,$vars) = explode("=", $item);
		@list($number,$option,$price) = explode(",", $vars);
		$subtotal = $number * $price;
		
		$as = array();
		$as['number'] = $number;
		$as['option']	= $option;
		$as['price']	= $price;
		$as['subtotal']	= $subtotal;
		
		$ar[$itemno] = $as;
	}
	$r['items']								= $ar;
	
	return $r;
}


/**
 * 선택 사항을 HTML FORM 의 OPTION 태그로 출력
 *
 * 상품의 정보 설정에서 사이즈, 색상 등의 선택 사항을 지정한 경우, 이를 선택할 수 있도록 HTML 태그를 작성해서 리턴한다.
 * 콤마로 구분되어 있다.
 *
 * @return string HTML 태그의 OPTION 으로 리턴한다. 따라서 함수를 호출하는 지점에서 SELECT 의 사용이 필요하다.
 */
function option($opt)
{
	$ar = explode(",", $opt);
	$r = NULL;
	foreach($ar as $e)
	{
		$e = trim($e);
		$r .= "<option value='$e'>$e</option>";
	}
	return $r;
}






/**
 * 주문 상태 변경과 관련된 option 태그들을 리턴한다.
 *
 * @param string $value 선택할 option. 현제 단계를 입력하면된다. ex) payway_online_submit_fail
 *
 * @param string $pw 결제방식. 해당 결제 방식의 관련 데이터(단계)만 출력하려면 이 값을 입력한다.
 */
function option_order_state($value='', $pw=NULL)
{
	$$value = " selected";
	if ( $pw ) $pw_name = pw_name($pw);
	
	$html = "
		<option></option>
		<option value='order_confirm_submit' $order_confirm_submit>주문완료 -> $pw_name 결제 진행 중</option>
	";
	
	$offline = "
			<option value='payway_offline_submit' $payway_offline_submit>주문완료 -> ".pw_name("offline")." 결제 확인 필요</option>
			<option value='payway_done' $payway_done>입금완료 -> ".pw_name("offline")." 결제 확인. 배송 요망</option>
		";
	
	$online = "
			<option value='payway_online_submit_success' $payway_online_submit_success>주문완료 -> ".pw_name("online")." 결제완료. 배송요망</option>
			<option value='payway_online_submit_fail' $payway_online_submit_fail>결제실패 -> ".pw_name("online")." 결제 실패.</option>
		";
	$cp = "
			<option value='payway_cp_submit_success' $payway_cp_submit_success>주문완료 -> ".pw_name("cp")." 결제 완료. 배송 요망</option>
			<option value='payway_cp_submit_fail' $payway_cp_submit_fail>결제실패 -> ".pw_name("cp")." 결제 실패.</option>
	";
	if ( $pw == "offline" )
	{
		$html .= $offline;
	}
	else if ( $pw == "online" )
	{
		$html .= $online;
	}
	else if ( $pw == "cp" )
	{
		$html .= $cp;
	}
	else if ( $pw == NULL )
	{
		$html .= $offline . $online . $cp;
	}
	
	$html .= "
		<option value='delivery_prepare' $delivery_prepare>배송준비</option>
		<option value='delivery_sent' $delivery_sent>배송완료</option>
		<option value='delivery_take' $delivery_take>인수완료</option>
	";
	
	return $html;
}



function pw_process_name($pw)
{
	switch ($pw)
	{
		case 'payway_offline_submit'	:		return "결제방식: 무통장입금, 단계: 주문완료, 상태: 입금확인 중";
	}
}

function pw_name($pw)
{
	switch ($pw)
	{
		case 'offline'				: return "무통장입금";
		case 'card'						: return "카드결제";
		case 'online'					: return "계좌이체";
		case 'ars'						: return "ARS";
		case 'cp'							: return "휴대폰";
	}
}

/**
 * 쇼핑몰의 카테고리를 리턴한다.
 *
 * @return array of associative-array categories 와 동일
 */
function mall_categories()
{
	lib('category');
	return categories(CATE_MALL);
}
?>
