<?php
/**
 * 모듈 관련 라이브러리
 *
 * 모듈이 설치되었는지 여부를 알 수 있으며, 모듈 설치 함수도 제공한다.
 *
 * 모듈은 정보 영역은 카테고리이다. 즉, 직접적으로 카테고리를 다루는 것이다.
 * 모듈의 설정과 관련한 함수들은 모두 내부적으로 카테고리 라이브러리를 이용한다.
 * 이용의 편리를 위해서 module 라이브러리를 작성한 것일 뿐, 실제로  category 라이브러리를 직접 이용해도 상관이 없다.
 *
 * @note category.etc 를 모듈 버젼 필드로 활용한다.
 * @package library
 */

/**
 * library required.
 */
lib('category');



/**
 * 모듈 정보를 설정한다.
 *
 *
 * @see insertCategory
 * @param string $id	모듈의 아이디.
 * @param string $name 이름
 * @param string $type 정보의 데이터 타입이다. category.php 파일 상단을 참고한다.
 * @param string $version 버젼. empty 의 값은 안된다.
 * @param string $r 모듈의 정보 접근 영역. 회원 등급과 같은 방식.
 * @param string $description 설명
 * @return same as insertCategory
 * <code>
 * $rc = setModule(module_id, $info['name'], CATE_MEMO, $info['version'], GRADE_USER, $info['description']);
 * </code>
 * <code>
 *	lib('module');
 *	include script('info');
 *	$rc = setModule(module_id, $info['name'], CATE_LOG, $info['version'], GRADE_PRIVATE, $info['description']);
 *	if ( faultcode($rc) ) goBack("failed to install log-module");
 * </code>
 */
function setModule($id, $name, $type, $version, $r, $description)
{
	if ( empty($version) ) return faultEx(wrongParam, "setModule() 버젼의 입력이 틀렸습니다.");
	
	$category['id']					= $id;
	$category['name']				= $name;
	$category['type']				= $type;
	$category['etc']				= $version;
	$category['r']					= $r;
	$category['description']= $description;
	
	return insertCategory($category);
}
/**
 * 모듈의 삭제
 *
 * 단순히 deleteCategory 의 다른 이름이다.
 * @param mixed $idx int 형이면 카테고리 번호로 인식. string 형이면 카테고리 아이디로 인식한다.
 * return faultCode same as deleteCategory
 */
function delModule($idx) { return deleteModule($idx); }
function deleteModule($idx) { return deleteCategory($idx); }

/**
 * 설치된 모듈의 버젼을 리턴한다.
 *
 * @param string $id 모듈 아이디.
 * @return string 결과 값이 없으면(모듈이 추가가 안된 경우) NULL 이 리턴된다.
 * 모듈이 설치되었는지 이 변수로 체크를 한다.
 * <code>
 *	lib('module');
 *	$version = getModuleVersion(module_id);
 * </code>
 */
function getModuleVersion($id)
{
	$c = getCategory($id);
	if ( empty($c) ) return NULL;
	return $c['etc'];
}









/**#@+
 * 추가 스크립트 실행
 *
 * @see 개발자노트#추가 스크립트
 * @return boolean 성공시 true, 실패시 false
 * @see module/backup/admin.php
 * @see module/backup/install.php
 * <code>
 * lib('module');
 * installBegin('my_script');
 * installEnd('list2');
 * uninstallBegin('block');
 * installBegin('robot');
 * installBegin('zlib');
 * uninstallEnd('list2');
 * installBegin('test');
 * </code>
 */
function installBegin($mode) { return attachString(file_scripts, "begin module/$GLOBALS[cate]/$mode.php\n"); }
function installEnd($mode) { return attachString(file_scripts, "end module/$GLOBALS[cate]/$mode.php\n"); }
/**#@-*/
/**
 * 추가 스크립트에 등록된 스크립트 파일을 삭제한다.
 *
 *
 * @see 개발자노트
 * @param boolean true on success. otherwise false.
 */
function uninstallScript($mode, $type)
{
	$file = "module/$GLOBALS[cate]/$mode.php";
	$ar = readParse(file_scripts, "\n", " ", 1);

	if ( ! isset($ar['begin']) ) $ar['begin'] = array();
	if ( ! isset($ar['end']) ) $ar['end'] = array();

	$begin = array_unique($ar['begin']);
	$end = array_unique($ar['end']);
	if ( $type == 'begin' ) $begin = array_remove($begin, $file);
	else if ( $type == 'end' ) $end = array_remove($end, $file);
	
	$str = null;
	foreach( $begin as $v )
	{
		$str .= "begin $v\n";
	}
	foreach( $end as $v )
	{
		$str .= "end $v\n";
	}
	return writeString(file_scripts, $str);
}

function uninstallBegin($mode) { return uninstallScript($mode, 'begin'); }
function uninstallEnd($mode) { return uninstallScript($mode, 'end'); }

/**
 *
 * @return boolean TRUE on installed. otherwise FALSE.
 * <code>
 * <? if ( ! hasScriptInstalled('check', 'begin') ) { ?>
 * [ <a href=?cate=block&mode=install>설치</a> ]
 * <? } else { ?>
 * [ <a href=?cate=block&mode=uninstall>제거</a> ]
 * <? } ?>
 * </code>
 */
function hasScriptInstalled($mode,$type='begin')
{
	$file = "module/$GLOBALS[cate]/$mode.php";
	$ar = readParse(file_scripts, "\n", " ", 1);
	if ( $ar === FALSE ) return FALSE;
	if ( ! isset($ar['begin']) ) $ar['begin'] = array();
	if ( ! isset($ar['end']) ) $ar['end'] = array();

	$ar2 = array();
	if ( $type == 'begin' ) $ar2 = array_unique($ar['begin']);
	else if ( $type == 'end' ) $ar2 = array_unique($ar['end']);



	//
	return in_array($file, $ar2);
}

?>
