<?php
/**
 * 페이징을 한다.
 *
 * @package library
 *
 *
 *
 *
 *
 * @note 용어 설명
 *	page			한 웹 페이지를 말한다.
 *	block			<< 이전 [1] [2] [3] [4] [5] 다음 >> 와 같을 때, 1 에서 5까지의 페이지를 한 블럭이라한다.
 *							5개 페이지가 1 블럭을 구성할 때, 4 개의 블럭이라면, 최소한 16개 이상 ~ 20개 이하의 페이지를 말한다.
 *							이와 같은 경우 block 은 5개의 페이로 구성이된다.
 *							pagesInBlock 변수는 block 에 몇개의 페이지로 구성되는지 값을 가지고 있다.
 */
/**
 * 페이징(네비게이터, 페이지별로 이동하게 하는 HTML 소스)을 한다.
 *
 * 게시판의 하단에 나타나는 << 이전 [1] [2] [3] ...[10] 다음 >> 과 같은 페이지를 옮겨다니는 링크를 만든다.
* PEAR 의 pager 기능을 기본 바탕으로 하는 비슷한 pager 를 만드다.
 *
 * @note 총 게시물의 수가 0 일 경우, 파싱을 하지 않으며 모든 리턴 값이 null 이다.
 * @package library
 *
 * @example ../module/memo/index.php
 * <code>
 * lib('pager');
 * unset($ar);
 * // 문자열 대신 태그가능하다.
 * $ar['totalItem']			= $memo_number;
 * $ar['pagesInBlock']		= 10;							// 페이징을 할 때, (한 네비게이터에) 몇개의 페이지를 나타낼지 지정
 * $ar['articles']				= 5;										// 한 페이지에 나타낼 글의 수
 * $ar['pageNo']					= 11;										// 현제 페이지 번호
 * $ar['pageVar']				= "pageNo";								// 페이지 변수
 * $ar['pageTextPrev']		= '[';									// 페이지 번호 앞에 나타날 문자열
 * $ar['pageTextNext']		= ']';									// 페이지 번호 다음에 나타날 문자열
 * $ar['pageTextLink']		= 1;										// 페이지 번호 앞,뒤에 나타나는 문자열에 URL 링크를 걸지 말지 결정한다.
 * // 1 이면, 전체가 링크가 걸리고, 0 이면 페이지 번호만 링크가 걸린다.
 * $ar['pageTextSep']		= '&nbsp;-&nbsp;';									// 페이지 번호 사이를 구문할 문자열
 * $ar['extra']					= "cate=memo";					// URL 에 추가될 문자열
 * $ar['prevText']				= "<< 이전";						// 이전 블럭을 나타낼 텍스트(이미지 태그 가능)
 * $ar['nextText']				= "다음 >>";						// 다음 페이징을 나타낼 테스트(이미지 태그 가능)
 * $ar['firstPageText']	= "맨처음";							// 맨 나중을 나타낼 문자열 (이미지 태그 가능)
 * $ar['lastPageText']		= "맨끝";								//  맨 처음을 나타낼 문자열
 * 
 * $nav = new Pager($ar);
 * if ( $nav->parse() === false ) goBack("페이징을 하지 못했습니다." . $nav->error() );
 * echo $nav->getLink();
 *
 *
 *
 *
 *
 *
lib('pager');
unset($ar);
// 문자열 대신 태그가능하다.
$ar['totalItem']			= $memo_number;
$ar['pagesInBlock']		= $pagesInBlock;							// 페이징을 할 때, (한 네비게이터에) 몇개의 페이지를 나타낼지 지정
$ar['articles']				= $articles;										// 한 페이지에 나타낼 글의 수
$ar['pageNo']					= $pageNo;										// 현제 페이지 번호
$ar['pageVar']				= "pageNo";								// 페이지 변수
$ar['pageTextPrev']		= '[';									// 페이지 번호 앞에 나타날 문자열
$ar['pageTextNext']		= ']';									// 페이지 번호 다음에 나타날 문자열
$ar['pageTextLink']		= 1;										// 페이지 번호 앞,뒤에 나타나는 문자열에 URL 링크를 걸지 말지 결정한다.
			// 1 이면, 전체가 링크가 걸리고, 0 이면 페이지 번호만 링크가 걸린다.
$ar['pageTextSep']		= '&nbsp;-&nbsp;';									// 페이지 번호 사이를 구문할 문자열
$ar['extraVar']				= "cate=memo";					// URL 에 추가될 문자열
$ar['extraAttr']			= "title='링크 테스트 가나다라'";										// HTML A 태그에 추가될 속성. 스타일, 타이틀 등이 복합적으로 사용될 수 있다.
$ar['prevText']				= "<< 이전";						// 이전 블럭을 나타낼 텍스트(이미지 태그 가능)
$ar['nextText']				= "다음 >>";						// 다음 페이징을 나타낼 테스트(이미지 태그 가능)
$ar['firstPageText']	= "맨처음";							// 맨 나중을 나타낼 문자열 (이미지 태그 가능)
$ar['lastPageText']		= "맨끝";								//  맨 처음을 나타낼 문자열

$nav = new Pager($ar);
if ( $nav->parse() === false ) goBack("페이징을 하지 못했습니다." . $nav->error() );
echo $nav->getLink();
 *
 
 * 페이징 작업
 *
 *
 * <code>
 *
 * lib('pager');
 * $total = countPost($ui['idx'], array());
 * 
 * // 문자열 대신 태그가능하다.
 * $ar['totalItem']			= $total;									// 총 페이지
 * $ar['pagesInBlock']		= $page['pagesInBlock'];	// 블럭의 페이지 갯 수
 * $ar['articles']				= $page['articles'];			// 목록 수
 * $ar['pageNo']					= $page['pageNo'];						// 페이지 번호 변수
 * $ar['pageVar']				= "pageNo";								// 페이지 변수
 * $ar['pageTextPrev']		= '[';									// 페이지 번호 앞에 나타날 문자열
 * $ar['pageTextNext']		= ']';									// 페이지 번호 다음에 나타날 문자열
 * $ar['pageTextLink']		= 1;										// 페이지 번호 앞,뒤에 나타나는 문자열에 URL 링크를 걸지 말지 결정한다.
 * 			// 1 이면, 전체가 링크가 걸리고, 0 이면 페이지 번호만 링크가 걸린다.
 * $ar['pageTextSep']		= '&nbsp;-&nbsp;';									// 페이지 번호 사이를 구문할 문자열
 * $ar['extraVar']				= "cate=bbs&mode=list&idx=$ui[idx]";					// URL 에 추가될 문자열
 * $ar['extraAttr']			= "title='링크 테스트 가나다라'";										// HTML A 태그에 추가될 속성. 스타일, 타이틀 등이 복합적으로 사용될 수 있다.
 * $ar['prevText']				= "<< 이전";						// 이전 블럭을 나타낼 텍스트(이미지 태그 가능)
 * $ar['nextText']				= "다음 >>";						// 다음 페이징을 나타낼 테스트(이미지 태그 가능)
 * $ar['firstPageText']	= "맨처음";							// 맨 나중을 나타낼 문자열 (이미지 태그 가능)
 * $ar['lastPageText']		= "맨끝";								//  맨 처음을 나타낼 문자열
 * 
 * $nav = new Pager($ar);
 * if ( $nav->parse() === false ) goBack("페이징을 하지 못했습니다." . $nav->error() );
 * 
 * $pages = $nav->getLink();
 * $block = $nav->getLinkBlock();
 * $block_all = $nav->getLinkBlockAll();
 * </code>
 *
 * @added prevTextLinkOut, nextTextLinkOut 변수가 추가되었다. 이 두 변수는 << 이전, 다음 >> 에서 링크가 걸리지 않았을 경우 출력하는 내용이다.
 * <code>
 * $ar['prevTextLinkOut']	= "<img src=$dirSkin/pprev1.gif>";
 * $ar['nextTextLinkOut'] = "<img src=$dirSkin/pnext1.gif border=0>";
 * </code>	
 */


class Pager {
	/**
	 * 생성자
	 *
	 * {@link set}을 통해서 데이터를 설정한다.
	 */
	function Pager($params = array())
	{
		if ( !empty($params) ) $this->set($params);
		$this->pbNo = NULL;
		$this->nbNo = NULL;

	}
	/**
	 * 파싱을 할 데이터를 설정한다.
	 *
	 *
	 */
	function set($params) { $this->params = $params; }
	function error() { return $this->errstr; }
	/**
	 * 링크를 만들기 위해서 입력 데이터를 파싱한다.
	 *
	 * @return 에러가 있으면 false 를 리턴한다. 에러 문자열은 error() 함수를 통해서 얻을 수 있다.
	 *
	 */
	function parse()
	{
		// 총 게시물 수가 0 일 경우, 페이징 할 게 없다. 그냥 리턴한다.
		if ( empty($this->params['totalItem']) ) return true;
		
		$pbNo = null;
		$nbNo = null;
		$urlPrevBlock = null;
		$urlNextBlock = null;
		
		foreach ( $this->params as $k => $v ) { $$k = $v; }
		
		if ( empty($pageNo) || $pageNo < 0 ) $pageNo = 1;
		//g("totalItem = $totalItem");
		//g("currPage = $pageNo");
		
		// 총 페이지 수
		$totalPage		= ceil($totalItem/$articles);
		//g("totalPage = $totalPage");
		if ( $pageNo > $totalPage )
		{
			$this->errstr = "입력된 페이지 번호가 총 페이지 번호의 수 보다 큽니다.";
			return false;
		}
		
		// 총 블럭 수
		$totalBlock		= ceil($totalPage/$pagesInBlock);
		//g("totalBlock = $totalBlock");
		
		// 현제 블럭 번호
		$currBlock		= ceil($pageNo/$pagesInBlock);
		//g("currBlock = $currBlock");
		
		

		// 현제 블럭이 첫번째 블럭이 아니면, 이전 블럭으로 이동할 수 있는 URL 을 만든다.
		if ( $currBlock > 1 )
		{
			$pbNo	= ( $currBlock - 2 ) * $pagesInBlock + 1;
			$urlPrevBlock = "$_SERVER[PHP_SELF]?$pageVar=$pbNo&".$extraVar;
			//g($urlPrevBlock);
		}
		
		// 현재 페이지 번호 부터 현제 블럭의 끝 페이지 번호까지 링크를 만든다.
		$linkPages = array();
		for ( $i = ($currBlock - 1) * $pagesInBlock;
					$i < $currBlock * $pagesInBlock && $i < $totalPage; $i ++ )
		{
			$ic = $i + 1;
			if ( $ic == $pageNo ) {
				$link = "$pageTextPrev$ic$pageTextNext";
			}
			else {
				$urlPage = "$_SERVER[PHP_SELF]?$pageVar=$ic&".$extraVar;
				if ( $pageTextLink )
					$link = "<a href='$urlPage' $extraAttr>$pageTextPrev$ic$pageTextNext</a>";
				else
					$link = "$pageTextPrev<a href='$urlPage' $extraAttr>$ic</a>$pageTextNext";
			}
			$arLink[] = $link;
		}
		if ( ! empty( $arLink ) ) $linkPages = implode($pageTextSep, $arLink);

		// 현제 블럭이 총 블럭 수보다 적을 경우, 다음 블럭으로 이동할 수 있는 URL 을 만든다.
		if ( $currBlock < $totalBlock )
		{
			$nbNo	= $currBlock * $pagesInBlock + 1;
			$urlNextBlock = "$_SERVER[PHP_SELF]?$pageVar=$nbNo&".$extraVar;
		}
		
		
		$this->totalPage = $totalPage;
		$this->totalBlock = $totalBlock;
		$this->currBlock = $currBlock;
		$this->pbNo = $pbNo;
		$this->nbNo = $nbNo;
		$this->urlPrevBlock = $urlPrevBlock;
		$this->linkPages = $linkPages;
		$this->urlNextBlock = $urlNextBlock;
		$this->link = $linkPages;
		return true;
	}
	/**
	 * 총 페이지 수를 리턴한다.
	 *
	 *
	 */
	function getTotalPage()
	{
		if ( empty($this->totalPage) ) return 0;
		else return $this->totalPage;
	}
	function getTotalBlock() { return $this->totalBlock; }
	function getBlockNo() { return $this->currBlock; }
	// 이전 블럭의 첫번째 페이지 번호를 리턴한다.
	function getFirstPageNumberOfPrevBlock(){ return $this->pbNo; }
	// 다음 블럭의 첫번째 페이지 번호를 리턴한다.
	function getFirstPageNumberOfNextBlock(){ return $this->nbNo; }
	
	// 이전 블럭으로 이동하는 URL 을 리턴한다.
	function getUrlPrevBlock() { return $this->urlPrevBlock; }
	// 다음 블럭으로 이동하는 URL 을 리턴한다.
	function getUrlNextBlock() { return $this->urlNextBlock; }
	
	/**#@+
	 * 이전, 이후 블럭의 링크를 리턴한다.
	 *
	 * 만약, 블럭이 하나 뿐이라서 이전, 이후 블럭이 없으면 옵션에 따라 입력된 항목을 그대로 리턴하거나 empty 를 리턴한다.
	 */
	/**
	 * "<< 이전" 링크에 해당하는 내용을 리턴한다.
	 *
	 * @param boolean b 참 일경우, "<< 이전"에 해당하는 링크가 없을 경우, "<< 이전" 텍스트만 그대로 리턴한다.
	 */
	function getLinkPrevBlock($b=false) {
		if ( !empty($this->pbNo) )
			return "<a href='" . $this->getUrlPrevBlock() . "'".$this->params['extraAttr'].">" . $this->params['prevText'] . "</a>";
		if ( $b )
		{
			
			if ( empty($this->params['prevTextLinkOut']) )
			return $this->params['prevText'];
			else
				return $this->params['prevTextLinkOut'];
		}
	}
	
	
	function getLinkNextBlock($b=false) {
		if ( !empty($this->nbNo) )
			return "<a href='" . $this->getUrlNextBlock() . "'".$this->params['extraAttr'].">" . $this->params['nextText'] . "</a>";
		if ( $b )
		{
			if ( empty($this->params['nextTextLinkOut']) )
				return $this->params['nextText'];
			else
				return $this->params['nextTextLinkOut'];
		}
	}
	/**#@-*/
	// 현재 블럭에 속한 페이지들의 링크를 리턴한다.
	function getLinkPages() { return @$this->linkPages; }
	
	/**
	 *
	 *
	 * URL 이 연결된 전체 하나의 블럭이 리턴된다. << 이전 [1] - [2] - [3] 다음 >> 과 같은 문자열이다.
	 *
	 *
   * @return string
   */
	function getLinkBlock() {
		$link = $this->getLinkPrevBlock();
		$link .= $this->getLinkPages();
		$link .= $this->getLinkNextBlock();
		return $link;
	}
	// 
	// @return string URL 이 연결된 링크 페이지(들)를 리턴한다. [141] - [142] - [143] - [144] 와 같은 문자열이 리턴된다.
	function getLink() { return @$this->link; }
	/**
	 * 가능한 모든 표현을 해서 리턴한다.
	 *
	 * 이 함수는 {@link getLinkBlock}에 추가적인 표현을 한다.
	 * 차이점:
	 * - "<< 이전", "다음 >>" 에 링크가 걸리지 않아도 입력 표시를 그대로 표시한다.
	 * - << 이전[1]-[2]-[3]다음 >> 에서 "<< 이전" 과 "다음 >>" 사이에 구분자를 넣는다. 즉, << 이전 - [1] - [2] - [3] - 다음 >> 과 같이 표현이 된다.
	 * - 맨 처음 페이지 번호 [1] 과 맨 끝 페이지 번호가 추가된다. 이 표시는 항상 나타나는 것이 아니라 링크가 필요한 부분에서만 나타난다.
	 * @return string 페이지 링크
	 */
	function getLinkBlockAll()
	{
		$link[] = $this->getLinkPrevBlock(true);
		
		if ( $this->getFirstPageNumberOfPrevBlock() > 1 )
			$link[] = $this->getLinkFirstPage();
		
		$link[] = $this->getLinkPages();
		$no = $this->getFirstPageNumberOfNextBlock();

		if ( !empty($no) && $no < $this->getTotalPage()  )
			$link[] = $this->getLinkLastPage();

		$link[] = $this->getLinkNextBlock(true);
		$link = implode($this->params['pageTextSep'], $link);
		return $link;
	}
	/**
	 * '맨 마지막' 마지막 페이지에 링크를 걸어서 리턴
	 */
	function getLinkLastpage()
	{
		$no = $this->getTotalPage();

		$text = $this->params['lastPageText'];
		if ( empty($text) ) $text = $no;

		$pageVar = $this->params['pageVar'];
		$extraAttr = $this->params['extraAttr'];
		$extraVar = $this->params['extraVar'];
		$pageTextPrev = $this->params['pageTextPrev'];
		$pageTextNext = $this->params['pageTextNext'];
		$pageTextLink = $this->params['pageTextLink'];
		
		$urlPage = "$_SERVER[PHP_SELF]?$pageVar=$no&".$extraVar;
		if ( $pageTextLink )
			$link = "<a href='$urlPage' $extraAttr>$pageTextPrev"."$text$pageTextNext</a>";
		else
			$link = "$pageTextPrev<a href='$urlPage' $extraAttr>$text</a>$pageTextNext";
		return $link;
	}
	/**
	 * 첫 페이지에 링크를 리턴
	 *
	 *
	 */
	function getLinkFirstPage()
	{
		
		$text = $this->params['firstPageText'];
		if ( empty($text) ) $text = $no;
		
		$pageVar = $this->params['pageVar'];
		$extraAttr = $this->params['extraAttr'];
		$extraVar = $this->params['extraVar'];
		$pageTextPrev = $this->params['pageTextPrev'];
		$pageTextNext = $this->params['pageTextNext'];
		$pageTextLink = $this->params['pageTextLink'];
		
		$urlPage = "$_SERVER[PHP_SELF]?$pageVar=1&".$extraVar;
		if ( $pageTextLink )
			$link = "<a href='$urlPage' $extraAttr>$pageTextPrev"."$text$pageTextNext</a>";
		else
			$link = "$pageTextPrev<a href='$urlPage' $extraAttr>$text</a>$pageTextNext";
		return $link;
	}
}
?>
