<?php
/**
 * skin library.
 *
 * @note before version 0.4, this file (as script) was used to layout. now since version 1.0, this file is used as skin library.
 *
 *
 * @package library
 *
 */
/**
 * This function returns the skin list of the given module in an associative-array.
 *
 * if module name is given, it checks some skin files with the given module. if skin files exist, then includes the skin name(directory)
 *
 * @param string $module module name.
 * @return associative-array key as skin name and value as skin information.
 * @see BUILDGUIDE
 * @since 2007/02/10 module 값이 입력될 경우, module.index.html 을 체크한다. 즉, bbs 모듈의 스킨이 존재하는지는 bbs.index.html 로 체크를 한다.
 */
function getSkinList($module=NULL)
{
	// check skin directories.
	$dirs = getDirs(dirRoot."/skin");
	foreach ($dirs as $dir)
	{
		$file = dirRoot."/skin/$dir/README";
		if ( file_exists( $file ) )
		{
			$ar = readParse($file);
			$skins[$dir] = "$ar[title] by $ar[author]";
		}
	}
	
	// if no module name has given, return every skin.
	if ( $module === NULL ) return $skins;
	
	
	
	//
	{
		foreach($skins as $dir => $info)
		{
			$file = dirRoot."/skin/$dir/$module.index.html";
			if ( file_exists( $file ) )
			{
				$skin_blog[$dir] = $skins[$dir];
			}
		}
		return $skin_blog;
	}
}


?>
