<?php
/**
 * 글 리스트
 *
 * begin.php 에서 왠만한 전처리 작업이 이루어졌다
 * 이 스크립트는 글 목록을 리스트하기 위한 준비 작업을 한다.
 * 처리:
 * - 페이징을 위해서 $pageinfo 변수에 기본 값을 설정해 준다.
 * - $posts 변수에 글 내용 리스트를 담는다. 내용이 없다면 empty 배열이다. 
 *
 * @since 2006/12/15 페이지 번호를 나타내는 HTTP 변수 pno 를 pageNo 로 변경
 *
 */

/**
 *
 *
 *
 *
 */
// 게시판 리스트의 경우, 게시판 구분자로 인덱스 번호 또는 아이디가 넘어온다. 인덱스 번호에 우선 순위가 있다.
if ( empty($ui['idx']) && empty($ui['id']) )
	goBack(wrongIndex, "bbs::list post.idx_category(=category.idx) or category.id must be specified.");

////////////////

/**
 * 글 목록 & 페이징 관련 정보 세팅
 */
lib('list');
$pageinfo = infoPaging($ui, $category);

$search['idx_parent'] = 0;
$search['idx_parent cond'] = '=';

/**
 * @since 2007/01/11 권한에 맞는 글만 리스한다.
 * @since 2007/02/16 자신의 글도 리스트를 한다.
 */
if ( login() )
{
	$extra = "(idx_user=$user[idx] OR r<=$user[grade])";
}
else
{
	$extra = "r=0";
}
/**
 * @since 2007/02/17 권한에 상관없이 리스트는 전체가 되도록 한다.
 * @todo 관리자 모드에서 옵션으로 처리를 하도록 한다.
 */
// $search['exp extra'] = $extra;


$res = searchPost($category['idx'], $search, $pageinfo, array('dateTime'=>'DESC', 'idx'=>'DESC'));
faultCode($res) and goBack("bbs::list->getPosts at " . __FILE__ . " line: " . __LINE__);



/**
 * 전처리
 *
 * 제목이 없는 경우...
 */
$ar = array();
foreach( $res as $post )
{
	if ( empty($post['title']) )
	{
		lib('string');
		$title = tagContent("title", $post['description']);
		if ( empty($title) ) $post['title'] = $lang['emptyTitle'];
		else $post['title'] = $title;
	}
	$post['url'] = "?cate=bbs&mode=read&idx=$post[idx]$hvPageNo";
	$post['title'] = stripslashes($post['title']);
	$post['description'] = stripslashes($post['description']);

	$ar[] = $post;
}
$res = $ar;

/**
 *
 * @changed $list 변수는 사용하지 않는다. 대신 $posts 를 사용한다.
 *
 */
//$list = &$res;
$posts = &$res;


// 페이징을 하기 위함 초기 값을 지정해준다.
$total = countPost($category['idx'], $search);
$pageinfo['totalItem'] = $total;

/**
 * 중요(공지)사항을 $readmes 변수에 담아준다.
 */
$readmes = articles($category['id'], array('state'=>'R', 'state cond'=>'='));
?>
