<?php
/**
 * 주문 내역 리스트
 *
 * 첫 접속시 날짜 정보가 없으면 오늘 날짜 정보를 보여준다.
 * 검색을 할 때에는 날짜 정보가 없어야하는 경우가 있다.
 *
 * @package mall
 */
/**
 *
 *
 *
 */

admin('mall') or goBack(accessDenied, $lang['accessDeined']."(You are not an admin)");

lib('filesystem');

$limit = $kvs = array();


$kvs['idx_category_type']				= CATE_MALL_ORDER;
$kvs['idx_category_type cond']	= "=";


/**
 * 상품 번호 검색
 */
if ( isset($ui['idx']) && !empty($ui['idx']) )
{
	$kvs['idx']				= $ui['idx'];
	$kvs['idx cond']	= "=";
}

/**
 * 사용자 아이디 검색
 */
if ( isset($ui['id']) && !empty($ui['id']) )
{
	lib('user');
	$u = user($ui['id']);
	if ( empty($u) ) goBack(wrongID, $lang['wrongID']);
	$kvs['idx_user'] = $u['idx'];
	$kvs['idx_user cond'] = "=";
}


/**
 * 상태 검색
 */
if ( isset($ui['state']) && !empty($ui['state']) )
{
	$kvs['state']				= $ui['state'];
	$kvs['state cond']	= "=";
}

//g($kvs);

/**
 * 첫 접속시 날짜 정보가 없으면, 오늘 날짜 정보를 입력해준다.
 */
if ( !isset($ui['action'])  && !isset($ui['date']) ) $ui['date'] = date("y/m/d");


if ( isset($ui['date']) && !empty($ui['date']) )
{
	$date = sdate($ui['date']);
	
	if ( isset($date['date']) )
	{
		$begin	= dateTime( mktime(0, 0, 0, $date['date']['m'], $date['date']['d'], $date['date']['y']) );
		$end		= dateTime( mktime(0, 0, 0, $date['date']['m'], $date['date']['d'] + 1, $date['date']['y']) );
	}
	else
	{
		
		if ( isset($date['begin']) && !empty($date['begin']) )
		{
			$begin	= dateTime( mktime(0, 0, 0, $date['begin']['m'], $date['begin']['d'], $date['begin']['y']) );
		}
		if ( isset($date['end']) && !empty($date['end']) )
		{
			$end	= dateTime( mktime(0, 0, 0, $date['end']['m'], $date['end']['d'], $date['end']['y']) );
		}
		
	}
	
	if ( isset($begin) ) $limit['fromDate']	= $begin;
	if ( isset($end) ) $limit['toDate']			= $end;
	$limit['field'] = 'dateTime_firstwrite';
}


$rn		= countPost(array(), $kvs, $limit);
$rows = searchPost(array(), $kvs, $limit, array('idx'=>'DESC'));



$orders = array();



//
foreach($rows as $row)
{
	$ar = postToOrder($row);
	if ( empty($ar['items']) ) continue;
	$orders[]	= $ar;
}


?>

<!--
변수
	
	$rn					결과물의 갯수
	$orders			검색된 주문건수
-->
<html>
<head>
<meta http-equiv=Content-Type content='text/html;charset=utf-8'>
<link rel="stylesheet" type="text/css" href="skin/default/default.css">
	
<style>
#sk { float: left; width: 100;}

#calendar {
	font-size: 10pt;
}
#calendar a {
	color: black;
	text-decoration: none;
}

#calendar a:hover {
	background: black;
	color: white;
	text-decoration: none;
}

</style>
<script language="JavaScript">
function ymd(y,m,d)
{
	date = y + "/" + m + "/" + d ;
	location.href="?cate=mall&mode=admin_order_list&date="+date;
}
function showCalendar(y, m) {
    var text = '<table id="calendar">\n<tr><td colspan=7 style="text-align:center">';
    text += '<a href=# onclick="showCalendar('+(y-1)+','+m+')"> 년- </a>';
    text += '<a href=# onclick="showCalendar('+(m==1?(y-1)+','+12:y+','+(m-1))+')"> 월- </a>';
    text += '[' + y + '/' + ((m < 10) ? ('0' + m) : m) + ']';
    text += '<a href=# onclick="showCalendar('+(m==12?(y+1)+','+1:y+','+(m+1))+')"> 월+ </a>';
    text += '<a href=# onclick="showCalendar('+(y+1)+','+m+')"> 년+ </a>';
    text += '</td>';

    var d1 = (y+(y-y%4)/4-(y-y%100)/100+(y-y%400)/400
          +m*2+(m*5-m*5%9)/9-(m<3?y%4||y%100==0&&y%400?2:3:4))%7;
    for (i = 0; i < 42; i++) {
        if (i%7==0) text += '</tr>\n<tr>';
        if (i < d1 || i >= d1+(m*9-m*9%8)/8%2+(m==2?y%4||y%100==0&&y%400?28:29:30))
            text += '<td> </td>';
        else
            text += "<td" + (i%7 ? '' : ' style="color:red;"') + "><a href='#' onclick='ymd("+y+","+m+","+ (i+1-d1) +")'>" + (i+1-d1) + '</a></td>';
    }
    document.getElementById('calendarDiv').innerHTML = text + '</tr>\n</table>';
}
</script>
</head>

<body onload="showCalendar(2007,3)" style="margin: 10;">


<?php
	if (!isset($ui['idx'])) $ui['idx'] = NULL;
	if (!isset($ui['id'])) $ui['id'] = NULL;
?>

<table border=0 width="100%">
	<tr valign="top">
		<td width="400">

			<div id="title">쇼핑몰 관리자 기능::주문 내역 페이지</div>
			<div id="note">달력을 클릭하시면, 일별 주문 내역을 확인할 수 있습니다.</div>
			<div id="note">검색을 하시면 달력과 상관없이 정보를 찾을 수 있습니다.</div>
			<br>
			
			<form action="?" method="get" style="display:inline;">
			<input type="hidden" name=cate value=mall>
			<input type=hidden name=mode value=admin_order_list>
			<input type=hidden name=action value=search>
				<div id="sk">주문번호</div><div><input name="idx" size=10 value="<?=$ui['idx']?>"></div>
				<div id="sk">아이디</div><div><input name="id" value="<?=$ui['id']?>"></div>
				<div id="sk">상태</div><div><select name="state">
				<?=option_order_state($ui['state'])?>
					</select></div>
				<div id="sk">날짜</div><div><input type="text" name="date" size=20 value="<?=$ui['date']?>"></div>
				<div id="sk"></div><div>2007/03/05-2007/04/01 또는 07/3/5-07/4/1</div>
				<div id="sk"></div><div><input type="submit" value=" 검 색 "></div>
			</form>
	
		</td>
		<td>&nbsp;&nbsp;&nbsp;</td>
		<td>
			<div style="border: 1 solid; width: 200; padding: 5; text-align: center; font: bold;"> 일별 리스트를 위한 달력 </div>
			<div style="padding: 4; color: gray;">오늘은 <?=date("y년 m월 d일")?>입니다.</div>
			<br>
			<div style="border: 1 dotted; width: 200; padding: 8;">
				<div id="calendarDiv" style="font-family:Gulim;font-size:9pt;"></div>
			</div>
		</td>
	</tr>
</table>








<br>
<br>
<br>



<div id="title">주문 내역 리스트 (결과: <?=$rn?>개)</div>
<br>

<!--시작:상품리스트----------------------------------------------------------->

<? if ( empty($orders) ) { ?>

	<div id=note>주문 내역이 없습니다.</div>

<? return noskin(); } ?>





<? foreach ( $orders as $order ) { ?>

<div style="border: 1 blue dotted; margin-bottom:2;">
	<div>주문 번호: <?=$order['idx']?></div>
	<div>주문 날짜: <?=day($order['dateTime_firstwrite'])?></div>
</div>



<?$user = user($order['idx_user'])?>


<div style="border: 1 solid; padding: 4;">

<div style="border-bottom: 1 solid;">
주문회원 정보<br>

회원번호 <?=$order['idx_user']?>,
아이디 <?=$user['id']?>,
이름 <?=$user['name']?>,
닉네임 <?=$user['nick']?>,
전화 <?=$user['phone']?>,
핸드폰 <?=$user['cphone']?>,
이메일 <?=$user['email']?>,
</div>
<br>


<div style="border-bottom: 1 blue dotted;">
주문자 정보<br>

이름: <?=$order['buyer_name']?>
전화: <?=$order['buyer_phone']?>
휴대폰: <?=$order['buyer_cphone']?>
메일: <?=$order['buyer_email']?>
주소: <?=$order['buyer_address']?> 우편번호: <?=$order['buyer_zipcode']?>

<?if($order['payer']){?><br>입금자명: <?$order['payer']?><?}?>
</div>

<br>
<div style="border-bottom: 1 darkred dotted;">
받는이 정보<br>
이름: <?=$order['recv_name']?>
전화: <?=$order['recv_phone']?>
휴대폰: <?=$order['recv_cphone']?>
메일: <?=$order['recv_email']?>
주소: <?=$order['recv_address']?> 우편번호: <?=$order['recv_zipcode']?>
</div>
<BR>
비고: <?=$order['etc']?><br>
금액: <?=$order['total']?><br>
결제방식: <?=pw_name($order['payway'])?>

<br>

	<form action="?" method="post" style="display:inline;">
		<input type=hidden name=cate value=mall>
		<input type=hidden name=mode value=admin_order_list_submit>
		<input type=hidden name=idx value=<?=$order['idx']?>>
		현제 상태 : 
		<select name=state>
		
		<?=option_order_state($order['state'],$order['payway'])?>
		
		</select>
		<input type=submit value='주문 상태 변경'>
	</form>
	
	
	<br>
	<br>
	
	주문 삭제 : <a href="?cate=mall&mode=admin_order_delete_submit&idx=<?=$order['idx']?>" onclick="return confirm('정말 현제 주문건( 주문번호: <?=$order[idx]?>, 주문회원: <?=$user['id']?>(<?=$user['name']?>) )을 삭제하시겠습니까?');">현제 주문 내역을 삭제합니다.</a>
</div>



	
	<div style="border:1 solid; margin-top: 2;">
		<?include skin('order_info')?>
	</div>
	
	
	<br><br>
	<hr style="border: 1 darkred dotted;">
	<br><br>
	
	

<? } ?><!--eo foreach-->

<?return noskin()?>
