<?php
/**
 * 플러그인 설정을 저장한다.
 *
 * 플러그인 형식에서 디렉토리 이름만 구한다.
 *
 * @see V2#설정 저장 형식
 * @since 2007/03/22 위치-플러그인 설정 변경 시, 기존의 설정 파일은 삭제를 한다.
 */
admin('plugin') or goBack(accessDenied, "you don't have permission for this");

lib('plugin');



$re = array();
foreach( $ui as $k => $v )
{
	if ( preg_match("/\(([^\)]+)\)$/", $v, $m) )
	{
		$re[$k] = $m[1];
	}
}


$old = config(plugin_areaname_file());
config(plugin_areaname_file(), $re);


// 위치에서 더 이상 플러그인을 사용하지 않는다면, 이전 설정 파일을 삭제
$result = array_diff_assoc($old, $re);


foreach( $result as $k => $v )
{
	@unlink(cfgfile($k));
}

return move("?cate=plugin&mode=apply")
?>
