<?php
/**
 * 위치별 플러그인 설정 스크립트
 *
 * 본 스크립트는 articles 플러그인의 설정 스크립트(또는 복사된)이다.
 * 본 스크립트는 설정의 작업 처리를 위한 표준적인 방법을 제시한다. 따라서 설정 스크립트를 작성할 때에는
 * 본 스크릡트를 참조하는 것이 도움이 될 것이다.
 *
 * 특정 위치에 최근글(들)의 제목을 리스트하기 위한 옵션 설정을 한다.
 *
 *
 *
 */

/**
 * 필요한 라이브러리 로드
 */
lib('plugin');

/**
 * 플러그인 정보
 */
$pd = dirRoot."/plugin/$ui[dir]";
include $pd."/info.php";
$cfg = config(cfgfile());

$hide_checked = NULL;
if ( isset($cfg['hide']) && $cfg['hide'] == 'checked' ) $hide_checked = "checked";

if ( !isset($cfg['header']) ) $cfg['header'] = NULL;

?>
<? include "etc/res/php/plugin_config_header.php" ?>

<form action="?" method="post" style="display:inline;">
<input type="hidden" name="cate" value="plugin">
<input type="hidden" name="mode" value="plugin">
<input type="hidden" name="action" value="config_submit">
<input type="hidden" name="dir" value="<?=$ui['dir']?>">
<input type="hidden" name="areaname" value="<?=$ui['areaname']?>">

<table>
	<tr>
		<td><div id="name">제목</div></td><td><input class="in" name="header" size=30 value="<?=$cfg['header']?>"></td>
	</tr>
	<tr>
		<td><div id="name">숨기기</div></td><td><input class="in" type="checkbox" name="hide" value="checked" <?=$hide_checked?>> 화면에 나타내지 않기</td>
	</tr>
	<tr>
		<td><div id="name">스킨</div></td>
		<td>
			<select name='skin'>
			<?
				$dirs = getdirs($pd."/skin");
				foreach( $dirs as $dir )
				{
					echo "<option value='$dir'";
					if ( isset($cfg['skin']) && $cfg['skin'] == $dir ) echo " selected";
					echo ">$dir</option>";
				}
			?>
			</select>
		</td>
	</tr>
	<tr>
		<td></td><td><input class="button_blue" type="submit" value=" 적 용 [저장] "></td>
	</tr>
</table>


</form>

<script>
	window.resizeTo(500,650);
</script>

<br>
<div id="key">미리보기</div><div id="value">위의 저장(변경)된 내용이 아래 바로 적용이됩니다.</div>
<br>
<?
	plugin($ui['areaname']);
?>
