<?php
/**
 * 위치별 플러그인 설정 스크립트
 *
 * 본 스크립트는 articles 플러그인의 설정 스크립트(또는 복사된)이다.
 * 본 스크립트는 설정의 작업 처리를 위한 표준적인 방법을 제시한다. 따라서 설정 스크립트를 작성할 때에는
 * 본 스크릡트를 참조하는 것이 도움이 될 것이다.
 *
 * 특정 위치에 최근글(들)의 제목을 리스트하기 위한 옵션 설정을 한다.
 *
 *
 *
 */

/**
 * 필요한 라이브러리 로드
 */
lib('plugin');

/**
 * 플러그인 정보
 */
$pd = dirRoot."/plugin/$ui[dir]";
include $pd."/info.php";
$file = cfgfile($ui['areaname']); // 설정파일
$cfg = config($file);





/**
 * 초기값 체크
 */
if ( !isset($cfg['category'])  ) $cfg['category'] = NULL;
if ( !isset($cfg['header'])  ) $cfg['header'] = NULL;
if ( !isset($cfg['number']) ) $cfg['number'] = 10;
if ( !isset($cfg['length_title']) ) $cfg['length_title'] = 30;


$name_checked = $date_checked = $new_checked = $reply_checked = $file_checked = $cname_checked =
	$print_description_checked = NULL;

if ( isset($cfg['cname']) && $cfg['cname'] == 'checked' ) $cname_checked = "checked";
if ( isset($cfg['name']) && $cfg['name'] == 'checked' ) $name_checked = "checked";
if ( isset($cfg['date']) && $cfg['date'] == 'checked' ) $date_checked = "checked";
if ( isset($cfg['new']) && $cfg['new'] == 'checked' ) $new_checked = "checked";
if ( isset($cfg['reply']) && $cfg['reply'] == 'checked' ) $reply_checked = "checked";
if ( isset($cfg['file']) && $cfg['file'] == 'checked' ) $file_checked = "checked";
if ( isset($cfg['print_description']) && $cfg['print_description'] == 'checked' ) $print_description_checked = "checked";


$hide_checked = NULL;
if ( isset($cfg['hide']) && $cfg['hide'] == 'checked' ) $hide_checked = "checked";


if ( !isset($cfg['cache']) ) $cfg['cache'] = "0";



/**
 * 캐쉬 정보를 저장할 경우, 캐쉬 옵션이 0 이면, 기존의 캐쉬 파일을 여기서 지운다.
 */
if ( empty($cfg['cache']) )
{
	$cache_file = tmp_repository . "/cache/plugin.$ui[areaname].php";
	@unlink($cache_file);
}












?>
<? include "etc/res/php/plugin_config_header.php" ?>

<form action="?" method="post" style="display:inline;">
<input type="hidden" name="cate" value="plugin">
<input type="hidden" name="mode" value="plugin">
<input type="hidden" name="action" value="config_submit">
<input type="hidden" name="dir" value="<?=$ui['dir']?>">
<input type="hidden" name="areaname" value="<?=$ui['areaname']?>">
<!--eo //-->
<table>
	<tr valign=top>
		<td><div id="name">카테고리</div></td>
		<td>
			<input class="in" type="text" name="category" value="<?=$cfg['category']?>"><br>

				<div id="comment">
					카테고리를 여러개 지정할 수 있습니다.<br>
					콤마로 구분, 생략시 전체 카테고리에서 리스트
				</div>

		</td>
	</tr>
	<tr>
		<td><div id="name">헤더(타이틀)</div></td><td><input class="in" name="header" size=30 value="<?=$cfg['header']?>"></td>
	</tr>
	<tr>
		<td><div id="name">목록 수</div></td><td><input class="in" name="number" size=3 value="<?=$cfg['number']?>"></td>
	</tr>
	<tr>
		<td><div id="name">줄의 글자 수</div></td>
		<td>
			<input class="in" name="length_title" size=3 value="<?=$cfg['length_title']?>">
			<input type="checkbox" name="print_description" value="checked" <?=$print_description_checked?>>제목대신 내용출력
		</td>
	</tr>
	<tr>
		<td><div id="name">표시</div></td><td>
			<input type="checkbox" name="cname" value="checked" <?=$cname_checked?>>카테고리
			<input type="checkbox" name="name" value="checked" <?=$name_checked?>>이름
			<input type="checkbox" name="date" value="checked" <?=$date_checked?>>날짜
			<input type="checkbox" name="new" value="checked" <?=$new_checked?>>새글
			<input type="checkbox" name="reply" value="checked" <?=$reply_checked?>>답변수
			<input type="checkbox" name="file" value="checked" <?=$file_checked?>>파일수
		</td>
	</tr>
	<tr>
		<td><div id="name">숨기기</div></td><td><input class="in" type="checkbox" name="hide" value="checked" <?=$hide_checked?>> 화면에 나타내지 않기</td>
	</tr>
	<tr>
		<td><div id="name">스킨</div></td>
		<td>
			<select name='skin'>
			<?
				$dirs = getdirs($pd."/skin");
				foreach( $dirs as $dir )
				{
					echo "<option value='$dir'";
					if ( isset($cfg['skin']) && $cfg['skin'] == $dir ) echo " selected";
					echo ">$dir</option>";
				}
			?>
			</select>
		</td>
	</tr>
	<tr>
		<td><div id="name">캐쉬</div></td>
		<td>
			<select name="cache">
				<?=@plugin_cache_options($cfg['cache'])?>
			</select>
			분 <div id="comment">설정(변경) 작업시에는 캐쉬안함으로 체크를 해야합니다.</div>
		</td>
	</tr>
	<tr>
		<td></td><td><input class="button_blue" type="submit" value=" 적 용 [저장] "></td>
	</tr>
</table>


</form>

<script>
	window.resizeTo(500,650);
</script>

<br>
<div id="key">미리보기</div><div id="value">위의 저장(변경)된 내용이 아래 바로 적용이됩니다.</div>
<br>
<?
	plugin($ui['areaname']);
?>
