/*
 * Decompiled with CFR 0.152.
 */
package iiixzu.b2b.taxinvoice;

import iiixzu.b2b.taxinvoice.TaxInvoice;
import iiixzu.b2b.taxinvoice.TaxInvoiceException;
import iiixzu.b2b.taxinvoice.schema.DefaultTaxInvoiceDetailsSchema;
import iiixzu.b2b.taxinvoice.schema.DefaultTaxInvoiceSchema;
import iiixzu.b2b.taxinvoice.schema.ITaxInvoiceDetailsSchema;
import iiixzu.b2b.taxinvoice.schema.ITaxInvoiceSchema;
import java.sql.Connection;

public class TaxInvoiceManager {
    private ITaxInvoiceSchema taxInvoiceSchema;
    private ITaxInvoiceDetailsSchema taxTradeListSchema;

    public TaxInvoiceManager() {
        this.taxInvoiceSchema = new DefaultTaxInvoiceSchema();
        this.taxTradeListSchema = new DefaultTaxInvoiceDetailsSchema();
    }

    public TaxInvoiceManager(ITaxInvoiceSchema taxInvoiceSchema, ITaxInvoiceDetailsSchema taxTradeListSchema) {
        this.setTaxInvoiceSchema(taxInvoiceSchema);
        this.setTaxTradeListSchema(taxTradeListSchema);
    }

    public TaxInvoice getTaxInvoice(String taxInvoiceNumber, Connection con) throws TaxInvoiceException {
        TaxInvoice taxInvoice = new TaxInvoice(taxInvoiceNumber, this.taxInvoiceSchema, this.taxTradeListSchema, con);
        if (taxInvoice.isExist()) {
            return taxInvoice;
        }
        return null;
    }

    public void setTaxInvoiceSchema(ITaxInvoiceSchema schema) {
        if (schema == null) {
            throw new NullPointerException("#ITaxInvoiceSchema is null");
        }
        this.taxInvoiceSchema = schema;
    }

    public void setTaxTradeListSchema(ITaxInvoiceDetailsSchema schema) {
        if (schema == null) {
            throw new NullPointerException("#ITaxTradeListSchema is null");
        }
        this.taxTradeListSchema = schema;
    }
}

