/*
    sayclubaccount.h - Kopete Sayclub Protocol

    Copyright (c) 2006      by Park J. K.		 <nemesis@planetmono.org>
    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include "sayclubutilities.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>

#include <qcstring.h>
#include <qstring.h>
#include <kmdcodec.h>

#define DECODE64(c) (isascii(c) ? base64Table[c]:BAD)
#define BAD -1

static const char base64Digits[] =
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

static const char base64Table[] = {
	BAD,BAD,BAD,BAD, BAD,BAD,BAD,BAD, BAD,BAD,BAD,BAD, BAD,BAD,BAD,BAD,
	BAD,BAD,BAD,BAD, BAD,BAD,BAD,BAD, BAD,BAD,BAD,BAD, BAD,BAD,BAD,BAD,
	BAD,BAD,BAD,BAD, BAD,BAD,BAD,BAD, BAD,BAD,BAD, 62, BAD,BAD,BAD, 63,
	 52, 53, 54, 55,  56, 57, 58, 59,  60, 61,BAD,BAD, BAD,BAD,BAD,BAD,
	BAD,  0,  1,  2,   3,  4,  5,  6,   7,  8,  9, 10,  11, 12, 13, 14,
	 15, 16, 17, 18,  19, 20, 21, 22,  23, 24, 25,BAD, BAD,BAD,BAD,BAD,
	BAD, 26, 27, 28,  29, 30, 31, 32,  33, 34, 35, 36,  37, 38, 39, 40,
	 41, 42, 43, 44,  45, 46, 47, 48,  49, 50, 51,BAD, BAD,BAD,BAD,BAD
};

QCString SayclubUtilities::base64Encode(const QCString in)
{
	unsigned int inlen = in.length();
	int idx = 0;
	QCString out;
	
	for (; inlen >= 3; inlen -= 3) {
		out += base64Digits[(unsigned char)in[idx+0] >> 2];
		out += base64Digits[(((unsigned char)in[idx+0] << 4) & 0x30) | ((unsigned char)in[idx+1] >> 4)];
		out += base64Digits[(((unsigned char)in[idx+1] << 2) & 0x3c) | ((unsigned char)in[idx+2] >> 6)];
		out += base64Digits[(unsigned char)in[idx+2] & 0x3f];
		idx += 3;
	}
	
	if (inlen > 0) {
		char fragment;
		
		out += base64Digits[(unsigned char)in[idx+0] >> 2];
		fragment = ((unsigned char)in[idx+0] << 4) & 0x30;
		if (inlen > 1)
			fragment |= (unsigned char)in[idx+1] >> 4;
		out += base64Digits[(int)fragment];
		out += (inlen < 2) ? '=' : base64Digits[((unsigned char)in[idx+1] << 2) & 0x3c];
		out += '=';
	}
	
	out += '\0';
	
	return out;
}

int SayclubUtilities::base64Decode(QCString &out, const QCString &in)
{
	int idx = 0;
	register char digit1, digit2, digit3, digit4;
	
	if(in[idx+0] == '+' && in[idx+1] == ' ')
		idx += 2;
	if(in[idx] == '\r') return 0;
	
	do {
		digit1 = in[idx+0];
		if(DECODE64((int)digit1) == BAD) return -1;
		digit2 = in[idx+1];
		if(DECODE64((int)digit2) == BAD) return -1;
		digit3 = in[idx+2];
		if(digit3 != '=' && DECODE64((int)digit3) == BAD) return -1; 
		digit4 = in[idx+3];
		if(digit4 != '=' && DECODE64((int)digit4) == BAD) return -1;
		idx += 4;
		
		out += (DECODE64((int)digit1) << 2) | (DECODE64((int)digit2) >> 4);
		if(digit3 != '=') {
			out += ((DECODE64((int)digit2) << 4) & 0xf0) | (DECODE64((int)digit3) >> 2);
			if(digit4 != '=')
				out += ((DECODE64((int)digit3) << 6) & 0xc0) | DECODE64((int)digit4);
		}
	} while(in[idx] && in[idx] != '\r' && digit4 != '=');
	out += '\0';
	
	return 1;
}

QCString SayclubUtilities::pseudoUUID()
{
	QCString str = QString( "%1:%2:%3" ).arg( time( (time_t *)NULL ) ).arg( rand() ).arg( rand() ).latin1();
	KMD5 context( str );
	
	return context.hexDigest().insert( 8, '-' ).insert( 13, '-' ).insert( 18, '-' ).insert( 23, '-' );
}

SayclubUtilities::ifInterf::ifInterf()
{
	FILE *fp;
	char buffer[100];
	QCString cmd;
	struct stat buf;
	
	m_mac = QString(); m_ip = QString();
	
	if(stat("/sbin/ifconfig", &buf) == 0)
		cmd = "/sbin/ifconfig eth0";
	else if(stat("/usr/sbin/ifconfig", &buf) == 0)
		cmd = "/usr/sbin/ifconfig eth0";
	else if(stat("/bin/ifconfig", &buf) == 0)
		cmd = "/bin/ifconfig eth0";
	else if(stat("/usr/bin/ifconfig", &buf) == 0)
		cmd = "/usr/bin/ifconfig eth0";
	else {
		m_done = FALSE;
		return;
	}
	
	fp = popen( cmd, "r" );
	while( !feof( fp ) ) {
		fgets( buffer, 100, fp );
		QString line = QString( buffer ).stripWhiteSpace();
		if( line.contains( "HWaddr" ) )
			m_mac = line.right( line.length()-line.find( "HWaddr" ) ).section( ' ', 1 ).replace( ":", "" ).lower();
		else if( line.contains( "inet addr" ) )
			m_ip = line.right( line.length()-line.find( "inet addr" )-10 ).section( ' ', 0, 0 );	
	}
	pclose( fp );
	
	if(!m_mac || !m_ip)
		m_done = FALSE;
	else
		m_done = TRUE;
}

QCString SayclubUtilities::urlQuote( QCString in )
{
	QCString out;
	unsigned char t;
	
	for( int i=0; i<(int)in.length(); i++ ) {
		t = in[i];
		if( (t >= '0' && t <= '9') || (t >= 'a' && t <= 'z') || (t >= 'A' && t <= 'Z') )
			out += t;
		else if( t == ' ' )
			out += '+';
		else
			out += QString( "%" )+QString::number( (unsigned int)t, 16 ).upper();
	}
	out += '\0';
	
	return out;
}

QCString SayclubUtilities::urlUnquote( QCString in )
{
	QCString out;
	unsigned char t;
	
	for( int i=0; i<(int)in.length(); ) {
		t = in[i];
		if( t == '+' ) {
			out += ' ';
			i++;
		}
		else if( in[i] == '%' && i+3<=(int)in.length() && isHex(in[i+1]) && isHex(in[i+2]) ) {
			out += (getHex(in[i+1]))*16+getHex(in[i+2]);
			i += 3;
		}
		else {
			out += in[i];
			i++;
		}
	}
	out += '\0';
	
	return out;
}

char SayclubUtilities::getHex(char c)
{
	if( c >= '0' && c <= '9' )
		return c-'0';
	else if( c >= 'A' && c <= 'F' )
		return c-'A'+10;
	else if( c >= 'a' && c <= 'f' )
		return c-'a'+10;
	else
		return 0;
}

bool SayclubUtilities::isHex(char c)
{
	if( c >= '0' && c <= '9' )
		return true;
	else if( c >= 'A' && c <= 'F' )
		return true;
	else if( c >= 'a' && c <= 'f' )
		return true;
	else
		return false;
}

