/*
    sayclubaddcontactpage.cpp - Kopete Sayclub Protocol

    Copyright (c) 2006      by Park J. K.		 <nemesis@planetmono.org>
    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include "sayclubaddcontactpage.h"

#include <qlayout.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qcstring.h>
#include <qtextcodec.h>
#include <kdebug.h>

#include <kopeteaccount.h>
#include <kopetemetacontact.h>

#include "sayclubaddui.h"

#include <iostream>
using namespace std;

SayclubAddContactPage::SayclubAddContactPage( QWidget* parent, const char* name ) : AddContactPage(parent, name)
{
	kdDebug(14210) << k_funcinfo << endl;
	( new QVBoxLayout( this ) )->setAutoAdd( true );
	m_sayclubAddUI = new SayclubAddUI( this );
}

SayclubAddContactPage::~SayclubAddContactPage()
{
}

bool SayclubAddContactPage::apply( Kopete::Account* a, Kopete::MetaContact* m )
{
	m_account = static_cast<SayclubAccount *>(a);
	m_id = m_sayclubAddUI->m_name->text();
	m_memo = m_sayclubAddUI->m_memo->text();
	
	if ( validateData() ) {
		bool ok = false;
		QString name;
		
		if ( ok )
			return m_account->addContact( m_id, m, Kopete::Account::ChangeKABC );
		else
			return false;
	}
	return false;
}

bool SayclubAddContactPage::validateData()
{
	if( m_id.length() > 12 )
		return false;
	else if( m_memo.length() != 0 )
		if( m_account->getCodec()->fromUnicode( m_memo ).length() > 200 )
			return false;
	
	return true;
}

#include "sayclubaddcontactpage.moc"

