/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.AtomicLockEvent;
import org.netbeans.editor.AtomicLockListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.fold.api.Fold;
import org.netbeans.editor.fold.api.FoldHierarchy;
import org.netbeans.editor.fold.api.FoldHierarchyEvent;
import org.netbeans.editor.fold.api.FoldHierarchyIterator;
import org.netbeans.editor.fold.api.FoldHierarchyListener;

public class BaseCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener,
PropertyChangeListener,
DocumentListener,
ActionListener,
SettingsChangeListener,
AtomicLockListener,
FoldHierarchyListener {
    public static final String BLOCK_CARET = "block-caret";
    public static final String LINE_CARET = "line-caret";
    public static final String THIN_LINE_CARET = "thin-line-caret";
    private static final boolean debugCaretFocus = Boolean.getBoolean("netbeans.debug.editor.caret.focus");
    private static final boolean debugCaretFocusExtra = Boolean.getBoolean("netbeans.debug.editor.caret.focus.extra");
    protected JTextComponent component;
    Point magicCaretPosition;
    MarkFactory.DrawMark caretMark = new MarkFactory.CaretMark();
    MarkFactory.DrawMark selectionMark = new MarkFactory.DrawMark("caret-layer", null);
    boolean visible;
    boolean blinkVisible;
    boolean selectionVisible;
    protected EventListenerList listenerList = new EventListenerList();
    protected Timer flasher;
    String type;
    boolean italic;
    private int[] xPoints = new int[4];
    private int[] yPoints = new int[4];
    private Action selectWordAction;
    private Action selectLineAction;
    protected ChangeEvent changeEvent;
    private static char[] emptyDotChar = new char[]{' '};
    protected char[] dotChar = emptyDotChar;
    private boolean overwriteMode;
    private BaseDocument listenDoc;
    protected Font afterCaretFont;
    protected Font beforeCaretFont;
    protected Color textForeColor;
    protected Color textBackColor;
    private transient FocusListener focusListener;
    private transient boolean nextPaintUpdate;
    private transient Rectangle nextPaintScrollRect;
    private transient int nextPaintScrollPolicy;
    private transient boolean inAtomicLock;
    private transient boolean modified;
    private transient int undoOffset = -1;
    private boolean jdk14;
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    static final long serialVersionUID = -9113841520331402768L;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public BaseCaret() {
        Settings.addSettingsChangeListener(this);
        String specVer = System.getProperty("java.specification.version");
        this.jdk14 = specVer != null && specVer.startsWith("1.4");
    }

    public void settingsChange(SettingsChangeEvent evt) {
        if (evt != null && "caret-blink-rate".equals(evt.getSettingName())) {
            JTextComponent c = this.component;
            if (c == null) {
                return;
            }
            if (evt.getKitClass() != Utilities.getKitClass(c)) {
                return;
            }
            Object value = evt.getNewValue();
            if (value instanceof Integer) {
                this.setBlinkRate((Integer)value);
            }
        }
        this.updateType();
    }

    void updateType() {
        JTextComponent c = this.component;
        if (c != null) {
            Color caretColor;
            boolean newItalic;
            String newType;
            Class kitClass = Utilities.getKitClass(c);
            if (kitClass == null) {
                return;
            }
            if (this.overwriteMode) {
                newType = SettingsUtil.getString(kitClass, "caret-type-overwrite-mode", LINE_CARET);
                newItalic = SettingsUtil.getBoolean(kitClass, "caret-italic-overwrite-mode", false);
                caretColor = BaseCaret.getColor(kitClass, "caret-color-overwrite-mode", SettingsDefaults.defaultCaretColorOvwerwriteMode);
            } else {
                newType = SettingsUtil.getString(kitClass, "caret-type-insert-mode", LINE_CARET);
                newItalic = SettingsUtil.getBoolean(kitClass, "caret-italic-insert-mode", false);
                caretColor = BaseCaret.getColor(kitClass, "caret-color-insert-mode", SettingsDefaults.defaultCaretColorInsertMode);
            }
            this.type = newType;
            this.italic = newItalic;
            c.setCaretColor(caretColor);
            if (debugCaretFocusExtra) {
                System.err.println("Updating caret color:" + caretColor);
            }
            this.dispatchUpdate();
        }
    }

    private static Color getColor(Class kitClass, String settingName, Color defaultValue) {
        Object value = Settings.getValue(kitClass, settingName);
        return value instanceof Color ? (Color)value : defaultValue;
    }

    public void install(JTextComponent c) {
        BaseDocument doc;
        this.component = c;
        this.blinkVisible = true;
        this.component.addPropertyChangeListener(this);
        this.focusListener = new FocusHandler(this);
        this.component.addFocusListener(this.focusListener);
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
        EditorUI editorUI = Utilities.getEditorUI(this.component);
        editorUI.addLayer(new DrawLayerFactory.CaretLayer(), 10000);
        this.caretMark.setEditorUI(editorUI);
        this.selectionMark.setEditorUI(editorUI);
        editorUI.addPropertyChangeListener(this);
        FoldHierarchy hierarchy = FoldHierarchy.get(c);
        if (hierarchy != null) {
            hierarchy.addFoldHierarchyListener(this);
        }
        if ((doc = Utilities.getDocument(c)) != null) {
            this.modelChanged(null, doc);
        }
        if (this.component.hasFocus()) {
            this.focusGained(null);
            if (debugCaretFocus || debugCaretFocusExtra) {
                System.err.println("Component has focus, calling focusGained() on doc=" + this.component.getDocument().getProperty("title"));
            }
        }
    }

    public void deinstall(JTextComponent c) {
        this.component = null;
        if (this.flasher != null) {
            this.setBlinkRate(0);
        }
        Utilities.getEditorUI(c).removeLayer("caret-layer");
        c.removeMouseMotionListener(this);
        c.removeMouseListener(this);
        if (this.focusListener != null) {
            c.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        c.removePropertyChangeListener(this);
        FoldHierarchy hierarchy = FoldHierarchy.get(c);
        if (hierarchy != null) {
            hierarchy.removeFoldHierarchyListener(this);
        }
        this.modelChanged(this.listenDoc, null);
    }

    protected void modelChanged(BaseDocument oldDoc, BaseDocument newDoc) {
        if (oldDoc != null && this.listenDoc == oldDoc) {
            block9: {
                oldDoc.removeDocumentListener(this);
                oldDoc.removeAtomicLockListener(this);
                try {
                    this.caretMark.remove();
                    this.selectionMark.remove();
                }
                catch (InvalidMarkException e) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block9;
                    e.printStackTrace();
                }
            }
            this.listenDoc = null;
        }
        if (newDoc != null) {
            block10: {
                if (this.listenDoc != null) {
                    this.modelChanged(this.listenDoc, null);
                }
                newDoc.addDocumentListener(this);
                this.listenDoc = newDoc;
                newDoc.addAtomicLockListener(this);
                try {
                    Utilities.insertMark(newDoc, this.caretMark, 0);
                    Utilities.insertMark(newDoc, this.selectionMark, 0);
                }
                catch (InvalidMarkException e) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        e.printStackTrace();
                    }
                }
                catch (BadLocationException e) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block10;
                    e.printStackTrace();
                }
            }
            this.settingsChange(null);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BaseCaret.this.updateType();
                }
            });
        }
    }

    public void paint(Graphics g) {
        JTextComponent c = this.component;
        if (c == null) {
            return;
        }
        EditorUI editorUI = Utilities.getEditorUI(c);
        if (this.nextPaintUpdate && editorUI.isFontsInited()) {
            this.nextPaintUpdate = false;
            this.update(this.nextPaintScrollRect, this.nextPaintScrollPolicy);
            this.nextPaintScrollRect = null;
        }
        if (this.visible && this.blinkVisible) {
            this.paintCustomCaret(g);
        }
    }

    protected void paintCustomCaret(Graphics g) {
        JTextComponent c = this.component;
        if (c != null) {
            EditorUI editorUI = Utilities.getEditorUI(c);
            if (THIN_LINE_CARET.equals(this.type)) {
                g.setColor(c.getCaretColor());
                int upperX = this.x;
                if (this.beforeCaretFont != null && this.beforeCaretFont.isItalic() && this.italic) {
                    upperX = (int)((double)upperX + Math.tan(this.beforeCaretFont.getItalicAngle()) * (double)this.height);
                }
                g.drawLine(upperX, this.y, this.x, this.y + this.height - 1);
            } else if (BLOCK_CARET.equals(this.type)) {
                g.setColor(c.getCaretColor());
                if (this.afterCaretFont != null) {
                    g.setFont(this.afterCaretFont);
                }
                if (this.afterCaretFont != null && this.afterCaretFont.isItalic() && this.italic) {
                    int upperX;
                    this.xPoints[0] = upperX = (int)((double)this.x + Math.tan(this.afterCaretFont.getItalicAngle()) * (double)this.height);
                    this.yPoints[0] = this.y;
                    this.xPoints[1] = upperX + this.width;
                    this.yPoints[1] = this.y;
                    this.xPoints[2] = this.x + this.width;
                    this.yPoints[2] = this.y + this.height - 1;
                    this.xPoints[3] = this.x;
                    this.yPoints[3] = this.y + this.height - 1;
                    g.fillPolygon(this.xPoints, this.yPoints, 4);
                } else {
                    g.fillRect(this.x, this.y, this.width, this.height);
                }
                if (!Character.isWhitespace(this.dotChar[0])) {
                    g.setColor(Color.white);
                    g.drawChars(this.dotChar, 0, 1, this.x, this.y + editorUI.getLineAscent());
                }
            } else {
                g.setColor(c.getCaretColor());
                int blkWidth = 2;
                if (this.beforeCaretFont != null && this.beforeCaretFont.isItalic() && this.italic) {
                    int upperX;
                    this.xPoints[0] = upperX = (int)((double)this.x + Math.tan(this.beforeCaretFont.getItalicAngle()) * (double)this.height);
                    this.yPoints[0] = this.y;
                    this.xPoints[1] = upperX + blkWidth;
                    this.yPoints[1] = this.y;
                    this.xPoints[2] = this.x + blkWidth;
                    this.yPoints[2] = this.y + this.height - 1;
                    this.xPoints[3] = this.x;
                    this.yPoints[3] = this.y + this.height - 1;
                    g.fillPolygon(this.xPoints, this.yPoints, 4);
                } else {
                    g.fillRect(this.x, this.y, blkWidth, this.height - 1);
                }
            }
        }
    }

    void dispatchUpdate() {
        this.dispatchUpdate(null, 1);
    }

    void dispatchUpdate(final Rectangle scrollRect, final int scrollPolicy) {
        JTextComponent c = this.component;
        if (c == null) {
            return;
        }
        EditorUI editorUI = Utilities.getEditorUI(c);
        if (!editorUI.isFontsInited()) {
            if (scrollRect != null) {
                this.nextPaintScrollRect = scrollRect;
            }
            this.nextPaintScrollPolicy = scrollPolicy;
            this.nextPaintUpdate = true;
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BaseDocument doc;
                JTextComponent c2 = BaseCaret.this.component;
                if (c2 != null && (doc = Utilities.getDocument(c2)) != null) {
                    doc.readLock();
                    try {
                        BaseCaret.this.update(scrollRect, scrollPolicy);
                    }
                    finally {
                        doc.readUnlock();
                    }
                }
            }
        });
    }

    protected void update(Rectangle scrollRect, int scrollPolicy) {
        JTextComponent c = this.component;
        if (c != null) {
            BaseTextUI ui = (BaseTextUI)c.getUI();
            EditorUI editorUI = ui.getEditorUI();
            BaseDocument doc = Utilities.getDocument(c);
            if (doc != null) {
                Rectangle oldCaretRect;
                block8: {
                    oldCaretRect = new Rectangle(this);
                    if (this.italic) {
                        oldCaretRect.width += oldCaretRect.height;
                    }
                    int dot = this.getDot();
                    try {
                        Rectangle r = this.component.getUI().modelToView(this.component, dot, Position.Bias.Forward);
                        if (r != null) {
                            if (this.isVisible()) {
                                c.repaint(new Rectangle(this));
                            }
                            this.x = r.x;
                            this.y = r.y;
                            this.width = r.width;
                            this.height = r.height;
                        }
                    }
                    catch (BadLocationException e) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block8;
                        e.printStackTrace();
                    }
                }
                this.resetBlink();
                if (scrollRect == null || !editorUI.scrollRectToVisibleFragile(scrollRect, scrollPolicy)) {
                    oldCaretRect.add(this);
                    c.repaint(oldCaretRect);
                }
            }
        }
    }

    private void updateSystemSelection() {
        Clipboard clip;
        if (!this.jdk14) {
            return;
        }
        if (this.getDot() != this.getMark() && this.component != null && (clip = this.getSystemSelection()) != null) {
            clip.setContents(new StringSelection(this.component.getSelectedText()), null);
        }
    }

    private Clipboard getSystemSelection() {
        if (!this.jdk14) {
            return null;
        }
        try {
            Method m = this.component.getToolkit().getClass().getMethod("getSystemSelection", EMPTY_CLASS_ARRAY);
            return (Clipboard)m.invoke((Object)this.component.getToolkit(), EMPTY_OBJECT_ARRAY);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = BaseCaret.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = BaseCaret.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    protected void fireStateChanged() {
        Utilities.runInEventDispatchThread(new Runnable(){

            public void run() {
                Object[] listeners = BaseCaret.this.listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? BaseCaret.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
                    if (BaseCaret.this.changeEvent == null) {
                        BaseCaret.this.changeEvent = new ChangeEvent(BaseCaret.this);
                    }
                    ((ChangeListener)listeners[i + 1]).stateChanged(BaseCaret.this.changeEvent);
                }
            }
        });
        this.updateSystemSelection();
    }

    public final boolean isVisible() {
        return this.visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVisibleImpl(boolean v) {
        BaseCaret baseCaret = this;
        synchronized (baseCaret) {
            Timer t = this.flasher;
            if (t != null) {
                if (this.visible) {
                    t.stop();
                }
                if (v) {
                    if (debugCaretFocusExtra) {
                        System.err.println("starting the caret blinking timer: visible=" + this.visible + ", blinkVisible=" + this.blinkVisible);
                    }
                    t.start();
                } else {
                    if (debugCaretFocusExtra) {
                        System.err.println("stopping the caret blinking timer");
                    }
                    t.stop();
                }
            }
            this.visible = v;
        }
        JTextComponent c = this.component;
        if (c != null) {
            Rectangle repaintRect = this;
            if (this.italic) {
                repaintRect = new Rectangle(this);
                repaintRect.width += repaintRect.height;
            }
            c.repaint(repaintRect);
        }
    }

    synchronized void resetBlink() {
        Timer t = this.flasher;
        if (t != null) {
            t.stop();
            this.blinkVisible = true;
            if (this.isVisible()) {
                if (debugCaretFocusExtra) {
                    System.err.println("Reset blinking (caret already visible) - starting the caret blinking timer: visible=" + this.visible + ", blinkVisible=" + this.blinkVisible);
                }
                t.start();
            } else if (debugCaretFocusExtra) {
                System.err.println("Reset blinking (caret not visible) - caret blinking timer couldn't be started: visible=" + this.visible + ", blinkVisible=" + this.blinkVisible);
            }
        }
    }

    public void setVisible(final boolean v) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BaseCaret.this.setVisibleImpl(v);
            }
        });
    }

    public final boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    public void setSelectionVisible(boolean v) {
        block8: {
            if (this.selectionVisible == v) {
                return;
            }
            JTextComponent c = this.component;
            if (c != null) {
                this.selectionVisible = v;
                if (this.selectionVisible) {
                    boolean selMarkFirst;
                    int caretPos = this.getDot();
                    int selPos = this.getMark();
                    this.selectionMark.activateLayer = selMarkFirst = selPos < caretPos;
                    this.caretMark.activateLayer = !selMarkFirst && selPos != caretPos;
                } else {
                    this.caretMark.activateLayer = false;
                    this.selectionMark.activateLayer = false;
                }
                BaseTextUI ui = (BaseTextUI)c.getUI();
                try {
                    ui.getEditorUI().repaintBlock(this.caretMark.getOffset(), this.selectionMark.getOffset());
                }
                catch (BadLocationException e) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        e.printStackTrace();
                    }
                }
                catch (InvalidMarkException e) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block8;
                    e.printStackTrace();
                }
            }
        }
    }

    public void setMagicCaretPosition(Point p) {
        this.magicCaretPosition = p;
    }

    public final Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    public synchronized void setBlinkRate(int rate) {
        if (this.flasher == null && rate > 0) {
            this.flasher = new Timer(rate, new WeakTimerListener(this));
        }
        if (this.flasher != null) {
            if (rate > 0) {
                if (this.flasher.getDelay() != rate) {
                    if (debugCaretFocusExtra) {
                        System.err.println("blink rate:" + rate);
                    }
                    this.flasher.setDelay(rate);
                }
            } else {
                if (debugCaretFocusExtra) {
                    System.err.println("zero rate - don't blink");
                    System.err.println("setting blinkVisible to true and disabling timer");
                }
                this.flasher.stop();
                this.flasher.removeActionListener(this);
                this.flasher = null;
                this.blinkVisible = true;
            }
        }
    }

    public synchronized int getBlinkRate() {
        return this.flasher != null ? this.flasher.getDelay() : 0;
    }

    public int getDot() {
        if (this.component != null) {
            try {
                return this.caretMark.getOffset();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
        }
        return 0;
    }

    public int getMark() {
        if (this.component != null) {
            if (this.selectionVisible) {
                try {
                    return this.selectionMark.getOffset();
                }
                catch (InvalidMarkException invalidMarkException) {
                }
            } else {
                return this.getDot();
            }
        }
        return 0;
    }

    public void setDot(int offset) {
        this.setDot(offset, this, 0);
    }

    public void setDot(int offset, boolean expandFold) {
        this.setDot(offset, this, 0, expandFold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDot(int offset, Rectangle scrollRect, int scrollPolicy, boolean expandFold) {
        JTextComponent c = this.component;
        if (c != null) {
            boolean dotChanged;
            block12: {
                this.setSelectionVisible(false);
                BaseDocument doc = (BaseDocument)c.getDocument();
                dotChanged = false;
                doc.readLock();
                try {
                    if (doc == null || offset < 0 || offset > doc.getLength()) break block12;
                    dotChanged = true;
                    try {
                        Utilities.moveMark(doc, this.caretMark, offset);
                        FoldHierarchy hierarchy = FoldHierarchy.get(c);
                        hierarchy.lock();
                        try {
                            Fold collapsed;
                            FoldHierarchyIterator it = hierarchy.collapsedFoldIterator(offset, offset);
                            Fold fold = collapsed = it.hasNext() ? (Fold)it.next() : null;
                            if (expandFold && collapsed != null && collapsed.getStartOffset() < offset && collapsed.getEndOffset() > offset) {
                                hierarchy.expand(collapsed);
                            }
                        }
                        finally {
                            hierarchy.unlock();
                        }
                    }
                    catch (BadLocationException e) {
                        throw new IllegalStateException(e.toString());
                    }
                    catch (InvalidMarkException e) {
                        throw new IllegalStateException(e.toString());
                    }
                }
                finally {
                    doc.readUnlock();
                }
            }
            if (dotChanged) {
                this.fireStateChanged();
                this.dispatchUpdate(scrollRect, scrollPolicy);
            }
        }
    }

    public void setDot(int offset, Rectangle scrollRect, int scrollPolicy) {
        this.setDot(offset, scrollRect, scrollPolicy, true);
    }

    public void moveDot(int offset) {
        this.moveDot(offset, this, 1);
    }

    public void moveDot(int offset, Rectangle scrollRect, int scrollPolicy) {
        JTextComponent c = this.component;
        if (c != null) {
            BaseDocument doc = (BaseDocument)c.getDocument();
            if (doc != null && offset >= 0 && offset <= doc.getLength()) {
                try {
                    int selPos;
                    int oldCaretPos = this.getDot();
                    if (offset == oldCaretPos) {
                        return;
                    }
                    if (this.selectionVisible) {
                        selPos = this.selectionMark.getOffset();
                    } else {
                        Utilities.moveMark(doc, this.selectionMark, oldCaretPos);
                        selPos = oldCaretPos;
                    }
                    Utilities.moveMark(doc, this.caretMark, offset);
                    if (this.selectionVisible) {
                        boolean selMarkFirst;
                        this.selectionMark.activateLayer = selMarkFirst = selPos < offset;
                        this.caretMark.activateLayer = !selMarkFirst && selPos != offset;
                        Utilities.getEditorUI(c).repaintBlock(oldCaretPos, offset);
                        if (selPos == offset) {
                            this.setSelectionVisible(false);
                        }
                    } else {
                        this.setSelectionVisible(true);
                    }
                }
                catch (BadLocationException e) {
                    throw new IllegalStateException(e.toString());
                }
                catch (InvalidMarkException e) {
                    throw new IllegalStateException(e.toString());
                }
            }
            this.fireStateChanged();
            this.dispatchUpdate(scrollRect, scrollPolicy);
        }
    }

    public void insertUpdate(DocumentEvent evt) {
        JTextComponent c = this.component;
        if (c != null) {
            BaseDocument doc = (BaseDocument)this.component.getDocument();
            BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
            this.undoOffset = (bevt.isInUndo() || bevt.isInRedo()) && this.component == Utilities.getLastActiveComponent() ? evt.getOffset() + evt.getLength() : -1;
            this.modified = true;
            this.modifiedUpdate();
        }
    }

    public void removeUpdate(DocumentEvent evt) {
        JTextComponent c = this.component;
        if (c != null) {
            BaseDocumentEvent bevt;
            BaseDocument doc = (BaseDocument)c.getDocument();
            if (this.selectionVisible && this.getDot() == this.getMark()) {
                this.setSelectionVisible(false);
            }
            this.undoOffset = ((bevt = (BaseDocumentEvent)evt).isInUndo() || bevt.isInRedo()) && c == Utilities.getLastActiveComponent() ? evt.getOffset() : -1;
            this.modified = true;
            this.modifiedUpdate();
        }
    }

    private void modifiedUpdate() {
        if (!this.inAtomicLock) {
            JTextComponent c = this.component;
            if (this.modified && c != null) {
                if (this.undoOffset >= 0) {
                    this.setDot(this.undoOffset);
                } else {
                    this.fireStateChanged();
                    this.dispatchUpdate(c.hasFocus() ? this : null, 1);
                }
            }
        }
    }

    public void atomicLock(AtomicLockEvent evt) {
        this.inAtomicLock = true;
    }

    public void atomicUnlock(AtomicLockEvent evt) {
        this.inAtomicLock = false;
        this.modifiedUpdate();
    }

    public void changedUpdate(DocumentEvent evt) {
        this.dispatchUpdate();
    }

    public void focusGained(FocusEvent evt) {
        JTextComponent c;
        if (debugCaretFocusExtra) {
            System.err.println("");
        }
        if (debugCaretFocus || debugCaretFocusExtra) {
            System.err.println("BaseCaret.focusGained() in doc=" + this.component.getDocument().getProperty("title"));
        }
        if ((c = this.component) != null) {
            this.updateType();
            if (debugCaretFocusExtra) {
                System.err.println("going to set caret visible to: " + c.isEnabled());
            }
            this.setVisible(c.isEnabled());
        } else if (debugCaretFocusExtra) {
            System.err.println("component is null, caret will not be dislayed");
        }
    }

    public void focusLost(FocusEvent evt) {
        if (debugCaretFocusExtra) {
            System.err.println("");
        }
        if (debugCaretFocus || debugCaretFocusExtra) {
            System.err.println("BaseCaret.focusLost() in doc=" + this.component.getDocument().getProperty("title"));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Window window;
                JTextComponent c = BaseCaret.this.component;
                if (c != null && (window = SwingUtilities.windowForComponent(c)) != null && window.getFocusOwner() == c) {
                    if (debugCaretFocusExtra) {
                        System.err.println("caret will remain visible, windowForComponent(c).getFocusOwner is the same as the c");
                        System.err.println("window.getFocusOwner:" + window.getFocusOwner());
                        System.err.println("component:" + c);
                    }
                    return;
                }
                if (debugCaretFocusExtra) {
                    System.err.println("going to set caret visible to: false");
                }
                BaseCaret.this.setVisible(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(MouseEvent evt) {
        JTextComponent c = this.component;
        if (c != null) {
            if (SwingUtilities.isLeftMouseButton(evt)) {
                if (evt.getClickCount() == 2) {
                    BaseTextUI ui = (BaseTextUI)c.getUI();
                    int offset = ui.viewToModel(c, evt.getX(), evt.getY());
                    FoldHierarchy hierarchy = FoldHierarchy.get(c);
                    Document doc = c.getDocument();
                    if (doc instanceof AbstractDocument) {
                        AbstractDocument adoc = (AbstractDocument)doc;
                        adoc.readLock();
                        try {
                            hierarchy.lock();
                            try {
                                Fold collapsed;
                                FoldHierarchyIterator it = hierarchy.collapsedFoldIterator(offset, offset);
                                Fold fold = collapsed = it.hasNext() ? (Fold)it.next() : null;
                                if (collapsed != null && collapsed.getStartOffset() <= offset && collapsed.getEndOffset() >= offset) {
                                    hierarchy.expand(collapsed);
                                }
                                if (this.selectWordAction == null) {
                                    this.selectWordAction = ((BaseKit)ui.getEditorKit(c)).getActionByName("select-word");
                                }
                                this.selectWordAction.actionPerformed(null);
                            }
                            finally {
                                hierarchy.unlock();
                            }
                        }
                        finally {
                            adoc.readUnlock();
                        }
                    }
                } else if (evt.getClickCount() == 3) {
                    if (this.selectLineAction == null) {
                        BaseTextUI ui = (BaseTextUI)c.getUI();
                        this.selectLineAction = ((BaseKit)ui.getEditorKit(c)).getActionByName("select-line");
                    }
                    this.selectLineAction.actionPerformed(null);
                }
            } else if (SwingUtilities.isMiddleMouseButton(evt) && evt.getClickCount() == 1) {
                if (c == null) {
                    return;
                }
                Toolkit tk = c.getToolkit();
                Clipboard buffer = this.getSystemSelection();
                if (buffer == null) {
                    return;
                }
                Transferable trans = buffer.getContents(null);
                if (trans == null) {
                    return;
                }
                BaseDocument doc = (BaseDocument)c.getDocument();
                if (doc == null) {
                    return;
                }
                int offset = ((BaseTextUI)c.getUI()).viewToModel(c, evt.getX(), evt.getY());
                try {
                    String pastingString = (String)trans.getTransferData(DataFlavor.stringFlavor);
                    if (pastingString == null) {
                        return;
                    }
                    try {
                        doc.atomicLock();
                        try {
                            doc.insertString(offset, pastingString, null);
                            this.setDot(offset + pastingString.length());
                        }
                        finally {
                            doc.atomicUnlock();
                        }
                    }
                    catch (BadLocationException exc) {}
                }
                catch (UnsupportedFlavorException ufe) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    public void mousePressed(MouseEvent evt) {
        JTextComponent c = this.component;
        if (c != null) {
            Utilities.getEditorUI(c).getWordMatch().clear();
            if (SwingUtilities.isLeftMouseButton(evt) && (evt.getModifiers() & 0xC) == 0 || !this.isSelectionVisible()) {
                int offset = ((BaseTextUI)c.getUI()).viewToModel(c, evt.getX(), evt.getY());
                if (offset >= 0) {
                    if ((evt.getModifiers() & 1) != 0) {
                        this.moveDot(offset);
                    } else {
                        this.setDot(offset);
                    }
                    this.setMagicCaretPosition(null);
                }
                if (c.isEnabled()) {
                    c.requestFocus();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        JTextComponent c = this.component;
        if (SwingUtilities.isLeftMouseButton(evt) && c != null) {
            int offset = ((BaseTextUI)c.getUI()).viewToModel(c, evt.getX(), evt.getY());
            if (offset == -1) {
                offset = 0;
            }
            if (offset >= 0 && (evt.getModifiers() & 1) == 0) {
                this.moveDot(offset);
            }
        }
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("document".equals(propName)) {
            BaseDocument oldDoc = evt.getOldValue() instanceof BaseDocument ? (BaseDocument)evt.getOldValue() : null;
            BaseDocument newDoc = evt.getNewValue() instanceof BaseDocument ? (BaseDocument)evt.getNewValue() : null;
            this.modelChanged(oldDoc, newDoc);
        } else if ("overwriteMode".equals(propName)) {
            Boolean b = (Boolean)evt.getNewValue();
            this.overwriteMode = b != null ? b : false;
            this.updateType();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        JTextComponent c = this.component;
        if (c != null) {
            this.blinkVisible = !this.blinkVisible;
            Rectangle repaintRect = this;
            if (this.italic) {
                repaintRect = new Rectangle(this);
                repaintRect.width += repaintRect.height;
            }
            c.repaint(repaintRect);
        }
    }

    public void foldHierarchyChanged(FoldHierarchyEvent evt) {
        this.foldHierarchyUpdate((FoldHierarchy)evt.getSource());
    }

    private void foldHierarchyUpdate(FoldHierarchy hierarchy) {
        Fold collapsed;
        int caretOffset = this.getDot();
        FoldHierarchyIterator foldIterator = hierarchy.collapsedFoldIterator(caretOffset, caretOffset);
        Fold fold = collapsed = foldIterator.hasNext() ? (Fold)foldIterator.next() : null;
        if (collapsed != null && collapsed.getStartOffset() < caretOffset) {
            this.setDot(collapsed.getStartOffset(), false);
        }
        this.dispatchUpdate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FocusHandler
    implements FocusListener {
        private transient FocusListener fl;

        FocusHandler(FocusListener fl) {
            this.fl = fl;
        }

        public void focusGained(FocusEvent e) {
            this.fl.focusGained(e);
        }

        public void focusLost(FocusEvent e) {
            this.fl.focusLost(e);
        }
    }
}

