/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.ActionFactory;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;

public class BaseKit
extends DefaultEditorKit {
    public static final String splitLineAction = "split-line";
    public static final String annotationsCyclingAction = "annotations-cycling";
    public static final String collapseFoldAction = "collapse-fold";
    public static final String expandFoldAction = "expand-fold";
    public static final String collapseAllFoldsAction = "collapse-all-folds";
    public static final String expandAllFoldsAction = "expand-all-folds";
    public static final String selectionPageUpAction = "selection-page-up";
    public static final String selectionPageDownAction = "selection-page-down";
    public static final String removeTabAction = "remove-tab";
    public static final String removeSelectionAction = "remove-selection";
    public static final String toggleBookmarkAction = "bookmark-toggle";
    public static final String gotoNextBookmarkAction = "bookmark-next";
    public static final String abbrevExpandAction = "abbrev-expand";
    public static final String abbrevResetAction = "abbrev-reset";
    public static final String removeWordAction = "remove-word";
    public static final String removeLineBeginAction = "remove-line-begin";
    public static final String removeLineAction = "remove-line";
    public static final String toggleTypingModeAction = "toggle-typing-mode";
    public static final String toUpperCaseAction = "to-upper-case";
    public static final String toLowerCaseAction = "to-lower-case";
    public static final String switchCaseAction = "switch-case";
    public static final String findNextAction = "find-next";
    public static final String findPreviousAction = "find-previous";
    public static final String toggleHighlightSearchAction = "toggle-highlight-search";
    public static final String findSelectionAction = "find-selection";
    public static final String undoAction = "undo";
    public static final String redoAction = "redo";
    public static final String wordMatchNextAction = "word-match-next";
    public static final String wordMatchPrevAction = "word-match-prev";
    public static final String shiftLineRightAction = "shift-line-right";
    public static final String shiftLineLeftAction = "shift-line-left";
    public static final String adjustWindowCenterAction = "adjust-window-center";
    public static final String adjustWindowTopAction = "adjust-window-top";
    public static final String adjustWindowBottomAction = "adjust-window-bottom";
    public static final String adjustCaretCenterAction = "adjust-caret-center";
    public static final String adjustCaretTopAction = "adjust-caret-top";
    public static final String adjustCaretBottomAction = "adjust-caret-bottom";
    public static final String formatAction = "format";
    public static final String firstNonWhiteAction = "first-non-white";
    public static final String lastNonWhiteAction = "last-non-white";
    public static final String selectionFirstNonWhiteAction = "selection-first-non-white";
    public static final String selectionLastNonWhiteAction = "selection-last-non-white";
    public static final String selectIdentifierAction = "select-identifier";
    public static final String selectNextParameterAction = "select-next-parameter";
    public static final String jumpListNextAction = "jump-list-next";
    public static final String jumpListPrevAction = "jump-list-prev";
    public static final String jumpListNextComponentAction = "jump-list-next-component";
    public static final String jumpListPrevComponentAction = "jump-list-prev-component";
    public static final String scrollUpAction = "scroll-up";
    public static final String scrollDownAction = "scroll-down";
    public static final String macroActionPrefix = "macro-";
    public static final String startMacroRecordingAction = "start-macro-recording";
    public static final String stopMacroRecordingAction = "stop-macro-recording";
    public static final String lineFirstColumnAction = "caret-line-first-column";
    public static final String insertDateTimeAction = "insert-date-time";
    public static final String selectionLineFirstColumnAction = "selection-line-first-column";
    public static final String generateGutterPopupAction = "generate-gutter-popup";
    public static final String toggleLineNumbersAction = "toggle-line-numbers";
    public static final String pasteFormatedAction = "paste-formated";
    private static final int KIT_CNT_PREALLOC = 57;
    static final long serialVersionUID = -8570495408376659348L;
    static Map kits = new HashMap(57);
    static Map kitKeymaps = new HashMap(57);
    static Map kitActions = new HashMap(57);
    static Map kitActionMaps = new HashMap(57);
    private CopyAction copyActionDef = new CopyAction();
    private CutAction cutActionDef = new CutAction();
    private PasteAction pasteActionDef = new PasteAction(false);
    static SettingsChangeListener settingsListener = new SettingsChangeListener(){

        public void settingsChange(SettingsChangeEvent evt) {
            boolean clearActions;
            String settingName = evt != null ? evt.getSettingName() : null;
            boolean bl = clearActions = settingName == null || "custom-action-list".equals(settingName) || "macro-map".equals(settingName);
            if (clearActions || "key-bindings".equals(settingName)) {
                kitKeymaps.clear();
            }
            if (clearActions) {
                kitActions.clear();
                kitActionMaps.clear();
            } else {
                Iterator i = kitActions.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry me = i.next();
                    BaseKit.updateActionSettings((Action[])me.getValue(), evt, (Class)me.getKey());
                }
            }
        }
    };
    static /* synthetic */ Class class$org$netbeans$editor$Settings;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit$CutAction;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit$CopyAction;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit$PasteAction;

    private static void updateActionSettings(Action[] actions, SettingsChangeEvent evt, Class kitClass) {
        for (int i = 0; i < actions.length; ++i) {
            if (!(actions[i] instanceof BaseAction)) continue;
            ((BaseAction)actions[i]).settingsChange(evt, kitClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseKit getKit(Class kitClass) {
        Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = BaseKit.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
        synchronized (clazz) {
            BaseKit kit;
            if (kitClass == null) {
                Class clazz2 = kitClass = class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = BaseKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit;
            }
            if ((kit = (BaseKit)kits.get(kitClass)) == null) {
                block9: {
                    try {
                        kit = (BaseKit)kitClass.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                            e.printStackTrace();
                        }
                    }
                    catch (InstantiationException e) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block9;
                        e.printStackTrace();
                    }
                }
                kits.put(kitClass, kit);
            }
            return kit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseKit() {
        Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = BaseKit.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
        synchronized (clazz) {
            if (kits.get(this.getClass()) == null) {
                kits.put(this.getClass(), this);
            }
        }
    }

    public Object clone() {
        return this;
    }

    public ViewFactory getViewFactory() {
        return null;
    }

    public Caret createCaret() {
        return new BaseCaret();
    }

    public Document createDefaultDocument() {
        return new BaseDocument(this.getClass(), true);
    }

    public Syntax createSyntax(Document doc) {
        return new Syntax();
    }

    public Syntax createFormatSyntax(Document doc) {
        return this.createSyntax(doc);
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        return new SyntaxSupport(doc);
    }

    public Formatter createFormatter() {
        return new Formatter(this.getClass());
    }

    protected BaseTextUI createTextUI() {
        return new BaseTextUI();
    }

    protected EditorUI createEditorUI() {
        return new EditorUI();
    }

    protected EditorUI createPrintEditorUI(BaseDocument doc) {
        return new EditorUI(doc);
    }

    protected EditorUI createPrintEditorUI(BaseDocument doc, boolean usePrintColoringMap, boolean lineNumberEnabled) {
        return new EditorUI(doc, usePrintColoringMap, lineNumberEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiKeymap getKeymap() {
        Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = BaseKit.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
        synchronized (clazz) {
            MultiKeymap km = (MultiKeymap)kitKeymaps.get(this.getClass());
            if (km == null) {
                km = new MultiKeymap("Keymap for " + this.getClass());
                Settings.KitAndValue[] kv = Settings.getValueHierarchy(this.getClass(), "key-bindings");
                for (int i = kv.length - 1; i >= 0; --i) {
                    List keyList = (List)kv[i].value;
                    JTextComponent.KeyBinding[] keys = new JTextComponent.KeyBinding[keyList.size()];
                    keyList.toArray(keys);
                    km.load(keys, this.getActionMap());
                }
                kitKeymaps.put(this.getClass(), km);
            }
            return km;
        }
    }

    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).read(in, pos);
        } else {
            super.read(in, doc, pos);
        }
    }

    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).write(out, pos, len);
        } else {
            super.write(out, doc, pos, len);
        }
    }

    public static Map actionsToMap(Action[] actions) {
        HashMap<String, Action> map = new HashMap<String, Action>();
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            String name = (String)a.getValue("Name");
            map.put(name != null ? name : "", a);
        }
        return map;
    }

    public static Action[] mapToActions(Map map) {
        Action[] actions = new Action[map.size()];
        int i = 0;
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            actions[i++] = (Action)iter.next();
        }
        return actions;
    }

    public void install(JEditorPane c) {
        BaseTextUI ui = this.createTextUI();
        c.setUI(ui);
        String propName = "netbeans.editor.noinputmethods";
        String noInputMethods = System.getProperty(propName);
        boolean enableIM = noInputMethods != null ? !Boolean.getBoolean(propName) : SettingsUtil.getBoolean(this.getClass(), "input-methods-enabled", true);
        c.enableInputMethods(enableIM);
        this.executeInstallActions(c);
    }

    protected void executeInstallActions(JEditorPane c) {
        Settings.KitAndValue[] kv = Settings.getValueHierarchy(this.getClass(), "kit-install-action-name-list");
        for (int i = kv.length - 1; i >= 0; --i) {
            List actList = (List)kv[i].value;
            if ((actList = this.translateActionNameList(actList)) == null) continue;
            Iterator iter = actList.iterator();
            while (iter.hasNext()) {
                Action a = (Action)iter.next();
                a.actionPerformed(new ActionEvent(c, 1001, ""));
            }
        }
    }

    public void deinstall(JEditorPane c) {
        this.executeDeinstallActions(c);
        c.updateUI();
    }

    protected void executeDeinstallActions(JEditorPane c) {
        Settings.KitAndValue[] kv = Settings.getValueHierarchy(this.getClass(), "kit-deinstall-action-name-list");
        for (int i = kv.length - 1; i >= 0; --i) {
            List actList = (List)kv[i].value;
            if ((actList = this.translateActionNameList(actList)) == null) continue;
            Iterator iter = actList.iterator();
            while (iter.hasNext()) {
                Action a = (Action)iter.next();
                a.actionPerformed(new ActionEvent(c, 1001, ""));
            }
        }
    }

    protected void initDocument(BaseDocument doc) {
    }

    protected Action[] createActions() {
        return new Action[]{new DefaultKeyTypedAction(), new InsertContentAction(), new InsertBreakAction(), new SplitLineAction(), new InsertTabAction(), new DeleteCharAction("delete-previous", false), new DeleteCharAction("delete-next", true), new ReadOnlyAction(), new WritableAction(), this.cutActionDef, this.copyActionDef, this.pasteActionDef, new PasteAction(true), new BeepAction(), new UpAction("caret-up", false), new UpAction("selection-up", true), new PageUpAction("page-up", false), new PageUpAction(selectionPageUpAction, true), new DownAction("caret-down", false), new DownAction("selection-down", true), new PageDownAction(selectionPageDownAction, true), new PageDownAction("page-down", false), new ForwardAction("caret-forward", false), new ForwardAction("selection-forward", true), new BackwardAction("caret-backward", false), new BackwardAction("selection-backward", true), new BeginLineAction(lineFirstColumnAction, false, true), new BeginLineAction(selectionLineFirstColumnAction, true, true), new BeginLineAction("caret-begin-line", false), new BeginLineAction("selection-begin-line", true), new EndLineAction("caret-end-line", false), new EndLineAction("selection-end-line", true), new BeginAction("caret-begin", false), new BeginAction("selection-begin", true), new EndAction("caret-end", false), new EndAction("selection-end", true), new NextWordAction("caret-next-word", false), new NextWordAction("selection-next-word", true), new PreviousWordAction("caret-previous-word", false), new PreviousWordAction("selection-previous-word", true), new BeginWordAction("caret-begin-word", false), new BeginWordAction("selection-begin-word", true), new EndWordAction("caret-end-word", false), new EndWordAction("selection-end-word", true), new SelectWordAction(), new SelectLineAction(), new SelectAllAction(), new ActionFactory.RemoveTabAction(), new ActionFactory.RemoveWordAction(), new ActionFactory.RemoveLineBeginAction(), new ActionFactory.RemoveLineAction(), new ActionFactory.RemoveSelectionAction(), new ActionFactory.ToggleTypingModeAction(), new ActionFactory.ToggleBookmarkAction(), new ActionFactory.GotoNextBookmarkAction(gotoNextBookmarkAction, false), new ActionFactory.AbbrevExpandAction(), new ActionFactory.AbbrevResetAction(), new ActionFactory.ChangeCaseAction(toUpperCaseAction, 0), new ActionFactory.ChangeCaseAction(toLowerCaseAction, 1), new ActionFactory.ChangeCaseAction(switchCaseAction, 2), new ActionFactory.FindNextAction(), new ActionFactory.FindPreviousAction(), new ActionFactory.FindSelectionAction(), new ActionFactory.ToggleHighlightSearchAction(), new ActionFactory.UndoAction(), new ActionFactory.RedoAction(), new ActionFactory.WordMatchAction(wordMatchNextAction, true), new ActionFactory.WordMatchAction(wordMatchPrevAction, false), new ActionFactory.ShiftLineAction(shiftLineLeftAction, false), new ActionFactory.ShiftLineAction(shiftLineRightAction, true), new ActionFactory.AdjustWindowAction(adjustWindowTopAction, 0), new ActionFactory.AdjustWindowAction(adjustWindowCenterAction, 50), new ActionFactory.AdjustWindowAction(adjustWindowBottomAction, 100), new ActionFactory.AdjustCaretAction(adjustCaretTopAction, 0), new ActionFactory.AdjustCaretAction(adjustCaretCenterAction, 50), new ActionFactory.AdjustCaretAction(adjustCaretBottomAction, 100), new ActionFactory.FormatAction(), new ActionFactory.FirstNonWhiteAction(firstNonWhiteAction, false), new ActionFactory.FirstNonWhiteAction(selectionFirstNonWhiteAction, true), new ActionFactory.LastNonWhiteAction(lastNonWhiteAction, false), new ActionFactory.LastNonWhiteAction(selectionLastNonWhiteAction, true), new ActionFactory.SelectIdentifierAction(), new ActionFactory.SelectNextParameterAction(), new ActionFactory.JumpListPrevAction(), new ActionFactory.JumpListNextAction(), new ActionFactory.JumpListPrevComponentAction(), new ActionFactory.JumpListNextComponentAction(), new ActionFactory.ScrollUpAction(), new ActionFactory.ScrollDownAction(), new ActionFactory.StartMacroRecordingAction(), new ActionFactory.StopMacroRecordingAction(), new ActionFactory.InsertDateTimeAction(), new ActionFactory.GenerateGutterPopupAction(), new ActionFactory.ToggleLineNumbersAction(), new ActionFactory.AnnotationsCyclingAction(), new ActionFactory.CollapseFold(), new ActionFactory.ExpandFold(), new ActionFactory.CollapseAllFolds(), new ActionFactory.ExpandAllFolds(), new ActionFactory.DumpViewHierarchyAction()};
    }

    protected Action[] getCustomActions() {
        Settings.KitAndValue[] kv = Settings.getValueHierarchy(this.getClass(), "custom-action-list");
        if (kv.length == 0) {
            return null;
        }
        if (kv.length == 1) {
            List l = (List)kv[0].value;
            return l.toArray(new Action[l.size()]);
        }
        ArrayList l = new ArrayList();
        for (int i = kv.length - 1; i >= 0; --i) {
            l.addAll((List)kv[i].value);
        }
        return l.toArray(new Action[l.size()]);
    }

    protected Action[] getMacroActions() {
        Class<?> kitClass = this.getClass();
        Map macroMap = (Map)Settings.getValue(kitClass, "macro-map");
        if (macroMap == null) {
            return null;
        }
        ArrayList<ActionFactory.RunMacroAction> actions = new ArrayList<ActionFactory.RunMacroAction>();
        Iterator it = macroMap.keySet().iterator();
        while (it.hasNext()) {
            String macroName = (String)it.next();
            actions.add(new ActionFactory.RunMacroAction(macroName));
        }
        return actions.toArray(new Action[actions.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Action[] getActions() {
        Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = BaseKit.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
        synchronized (clazz) {
            Class<?> thisClass = this.getClass();
            Action[] actions = (Action[])kitActions.get(thisClass);
            if (actions == null) {
                Action[] macroActions;
                Action[] createdActions = this.createActions();
                BaseKit.updateActionSettings(createdActions, null, thisClass);
                Map actionMap = BaseKit.actionsToMap(createdActions);
                Action[] customActions = this.getCustomActions();
                if (customActions != null) {
                    BaseKit.updateActionSettings(customActions, null, thisClass);
                    actionMap.putAll(BaseKit.actionsToMap(customActions));
                }
                if ((macroActions = this.getMacroActions()) != null) {
                    BaseKit.updateActionSettings(macroActions, null, thisClass);
                    actionMap.putAll(BaseKit.actionsToMap(macroActions));
                }
                kitActionMaps.put(thisClass, actionMap);
                actions = BaseKit.mapToActions(actionMap);
                kitActions.put(thisClass, actions);
                this.updateActions();
            }
            return actions;
        }
    }

    Map getActionMap() {
        Map actionMap = (Map)kitActionMaps.get(this.getClass());
        if (actionMap == null) {
            this.getActions();
            actionMap = (Map)kitActionMaps.get(this.getClass());
            if (actionMap == null) {
                actionMap = Collections.EMPTY_MAP;
            }
        }
        return actionMap;
    }

    protected void updateActions() {
    }

    public Action getActionByName(String name) {
        return name != null ? (Action)this.getActionMap().get(name) : null;
    }

    public List translateActionNameList(List actionNameList) {
        ArrayList<Action> ret = new ArrayList<Action>();
        if (actionNameList != null) {
            Iterator i = actionNameList.iterator();
            while (i.hasNext()) {
                Action a = this.getActionByName((String)i.next());
                if (a == null) continue;
                ret.add(a);
            }
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Settings.addSettingsChangeListener(settingsListener);
    }

    public static class SelectAllAction
    extends KitCompoundAction {
        static final long serialVersionUID = -3502499718130556524L;

        public SelectAllAction() {
            super("select-all", new String[]{"caret-begin", "selection-end"});
        }
    }

    public static class SelectLineAction
    extends KitCompoundAction {
        static final long serialVersionUID = -7407681863035740281L;

        public SelectLineAction() {
            super("select-line", new String[]{BaseKit.lineFirstColumnAction, "selection-end-line", "selection-forward"});
        }
    }

    public static class SelectWordAction
    extends KitCompoundAction {
        static final long serialVersionUID = 7678848538073016357L;

        public SelectWordAction() {
            super("select-word", new String[]{"caret-begin-word", "selection-end-word"});
        }
    }

    public static class EndWordAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 3812523676620144633L;

        public EndWordAction(String nm, boolean select) {
            super(nm, 62);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int dot = Utilities.getWordEnd(target, caret.getDot());
                    if (this.select) {
                        caret.moveDot(dot);
                    } else {
                        caret.setDot(dot);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class BeginWordAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 3991338381212491110L;

        public BeginWordAction(String nm, boolean select) {
            super(nm, 62);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int dot = Utilities.getWordStart(target, caret.getDot());
                    if (this.select) {
                        caret.moveDot(dot);
                    } else {
                        caret.setDot(dot);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class PreviousWordAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -5465143382669785799L;

        public PreviousWordAction(String nm, boolean select) {
            super(nm, 62);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int dot = Utilities.getPreviousWord(target, caret.getDot());
                    if (caret instanceof BaseCaret) {
                        BaseCaret bCaret = (BaseCaret)caret;
                        if (this.select) {
                            bCaret.moveDot(dot);
                        } else {
                            bCaret.setDot(dot, false);
                        }
                    } else if (this.select) {
                        caret.moveDot(dot);
                    } else {
                        caret.setDot(dot);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class NextWordAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -5909906947175434032L;

        public NextWordAction(String nm, boolean select) {
            super(nm, 62);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int dotPos = caret.getDot();
                    dotPos = Utilities.getNextWord(target, dotPos);
                    if (caret instanceof BaseCaret) {
                        BaseCaret bCaret = (BaseCaret)caret;
                        if (this.select) {
                            bCaret.moveDot(dotPos);
                        } else {
                            bCaret.setDot(dotPos, false);
                        }
                    } else if (this.select) {
                        caret.moveDot(dotPos);
                    } else {
                        caret.setDot(dotPos);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class EndAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 8547506353130203657L;

        public EndAction(String nm, boolean select) {
            super(nm, 190);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                int dot = target.getDocument().getLength();
                if (this.select) {
                    caret.moveDot(dot);
                } else {
                    caret.setDot(dot);
                }
            }
        }
    }

    public static class BeginAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 3463563396210234361L;

        public BeginAction(String nm, boolean select) {
            super(nm, 190);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                int dot = 0;
                if (this.select) {
                    caret.moveDot(dot);
                } else {
                    caret.setDot(dot);
                }
            }
        }
    }

    public static class EndLineAction
    extends BaseAction {
        protected boolean select;
        static final long serialVersionUID = 5216077634055190170L;

        public EndLineAction(String nm, boolean select) {
            super(nm, 62);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int dot = javax.swing.text.Utilities.getRowEnd(target, caret.getDot());
                    if (this.select) {
                        caret.moveDot(dot);
                    } else {
                        caret.setDot(dot);
                    }
                    Rectangle r = target.modelToView(dot);
                    if (r != null) {
                        Point p = new Point(32766, r.y);
                        caret.setMagicCaretPosition(p);
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class BeginLineAction
    extends BaseAction {
        protected boolean select;
        boolean homeKeyColumnOne;
        static final long serialVersionUID = 3269462923524077779L;

        public BeginLineAction(String nm, boolean select) {
            super(nm, 62);
            this.select = select;
            this.homeKeyColumnOne = false;
        }

        public BeginLineAction(String nm, boolean select, boolean columnOne) {
            this(nm, select);
            this.homeKeyColumnOne = columnOne;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                try {
                    int dot = caret.getDot();
                    int lineStartPos = javax.swing.text.Utilities.getRowStart(target, dot);
                    if (this.homeKeyColumnOne) {
                        dot = lineStartPos;
                    } else {
                        int textStartPos = Utilities.getRowFirstNonWhite(doc, lineStartPos);
                        if (textStartPos < 0) {
                            textStartPos = javax.swing.text.Utilities.getRowEnd(target, lineStartPos);
                        }
                        dot = dot == lineStartPos ? textStartPos : (dot <= textStartPos ? lineStartPos : textStartPos);
                    }
                    if (this.select) {
                        caret.moveDot(dot);
                    } else {
                        caret.setDot(dot);
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class BackwardAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -3048379822817847356L;

        public BackwardAction(String nm, boolean select) {
            super(nm, 62);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int pos;
                    if (!this.select && caret.isSelectionVisible()) {
                        pos = target.getSelectionStart();
                        if (pos != caret.getDot()) {
                            ++pos;
                        }
                    } else {
                        pos = caret.getDot();
                    }
                    int dot = target.getUI().getNextVisualPositionFrom(target, pos, null, 7, null);
                    if (this.select) {
                        caret.moveDot(dot);
                    } else if (caret instanceof BaseCaret) {
                        BaseCaret bCaret = (BaseCaret)caret;
                        bCaret.setDot(dot, bCaret, 1, false);
                    } else {
                        caret.setDot(dot);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class PageDownAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 8942534850985048862L;

        public PageDownAction(String nm, boolean select) {
            super(nm, 60);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    int dot = caret.getDot();
                    Rectangle tgtRect = ((BaseTextUI)target.getUI()).modelToView(target, dot);
                    Point p = caret.getMagicCaretPosition();
                    if (p == null && tgtRect != null) {
                        p = new Point(tgtRect.x, tgtRect.y);
                        caret.setMagicCaretPosition(p);
                    } else {
                        p.y = tgtRect.y;
                    }
                    EditorUI editorUI = ((BaseTextUI)target.getUI()).getEditorUI();
                    Rectangle bounds = editorUI.getExtentBounds();
                    int trHeight = Math.max(tgtRect.height, 1);
                    int baseY = bounds.y / trHeight * trHeight;
                    int lines = bounds.height / trHeight;
                    int baseHeight = lines * trHeight;
                    tgtRect.y = Math.max(baseY + baseHeight, 0);
                    tgtRect.height = bounds.height;
                    p.y = Math.max(p.y + baseHeight, 0);
                    int newDot = target.viewToModel(p);
                    editorUI.scrollRectToVisible(tgtRect, 0);
                    if (this.select) {
                        caret.moveDot(newDot);
                    } else if (caret instanceof BaseCaret) {
                        BaseCaret bCaret = (BaseCaret)caret;
                        bCaret.setDot(newDot, bCaret, 1);
                    } else {
                        caret.setDot(newDot);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class ForwardAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 8007293230193334414L;

        public ForwardAction(String nm, boolean select) {
            super(nm, 62);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int pos;
                    if (!this.select && caret.isSelectionVisible()) {
                        pos = target.getSelectionEnd();
                        if (pos != caret.getDot()) {
                            --pos;
                        }
                    } else {
                        pos = caret.getDot();
                    }
                    int dot = target.getUI().getNextVisualPositionFrom(target, pos, null, 3, null);
                    if (this.select) {
                        caret.moveDot(dot);
                    } else {
                        caret.setDot(dot);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class PageUpAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -3107382148581661079L;

        public PageUpAction(String nm, boolean select) {
            super(nm, 60);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    int dot = caret.getDot();
                    Rectangle tgtRect = ((BaseTextUI)target.getUI()).modelToView(target, dot);
                    Point p = caret.getMagicCaretPosition();
                    if (p == null && tgtRect != null) {
                        p = new Point(tgtRect.x, tgtRect.y);
                        caret.setMagicCaretPosition(p);
                    } else {
                        p.y = tgtRect.y;
                    }
                    EditorUI editorUI = ((BaseTextUI)target.getUI()).getEditorUI();
                    Rectangle bounds = editorUI.getExtentBounds();
                    int trHeight = Math.max(tgtRect.height, 1);
                    int baseY = (bounds.y + trHeight - 1) / trHeight * trHeight;
                    int lines = bounds.height / trHeight;
                    int baseHeight = lines * trHeight;
                    tgtRect.y = Math.max(baseY - baseHeight, 0);
                    tgtRect.height = bounds.height;
                    p.y = Math.max(p.y - baseHeight, 0);
                    int newDot = target.viewToModel(p);
                    editorUI.scrollRectToVisible(tgtRect, 0);
                    if (this.select) {
                        caret.moveDot(newDot);
                    } else {
                        caret.setDot(newDot);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class DownAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -5635702355125266822L;

        public DownAction(String nm, boolean select) {
            super(nm, 60);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block10: {
                if (target != null) {
                    try {
                        Caret caret = target.getCaret();
                        int dot = caret.getDot();
                        Point p = caret.getMagicCaretPosition();
                        if (p == null) {
                            Rectangle r = target.modelToView(dot);
                            if (r != null) {
                                p = new Point(r.x, r.y);
                                caret.setMagicCaretPosition(p);
                            } else {
                                return;
                            }
                        }
                        try {
                            dot = Utilities.getPositionBelow(target, dot, p.x);
                            if (this.select) {
                                caret.moveDot(dot);
                                break block10;
                            }
                            if (caret instanceof BaseCaret) {
                                BaseCaret bCaret = (BaseCaret)caret;
                                bCaret.setDot(dot, bCaret, 1, false);
                                break block10;
                            }
                            caret.setDot(dot);
                        }
                        catch (BadLocationException e) {}
                    }
                    catch (BadLocationException ex) {
                        target.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class UpAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 4621760742646981563L;

        public UpAction(String nm, boolean select) {
            super(nm, 60);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block10: {
                if (target != null) {
                    try {
                        Caret caret = target.getCaret();
                        int dot = caret.getDot();
                        Point p = caret.getMagicCaretPosition();
                        if (p == null) {
                            Rectangle r = target.modelToView(dot);
                            if (r != null) {
                                p = new Point(r.x, r.y);
                                caret.setMagicCaretPosition(p);
                            } else {
                                return;
                            }
                        }
                        try {
                            dot = Utilities.getPositionAbove(target, dot, p.x);
                            if (this.select) {
                                caret.moveDot(dot);
                                break block10;
                            }
                            if (caret instanceof BaseCaret) {
                                BaseCaret bCaret = (BaseCaret)caret;
                                bCaret.setDot(dot, bCaret, 1, false);
                                break block10;
                            }
                            caret.setDot(dot);
                        }
                        catch (BadLocationException e) {}
                    }
                    catch (BadLocationException ex) {
                        target.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class BeepAction
    extends BaseAction {
        static final long serialVersionUID = -4474054576633223968L;

        public BeepAction() {
            super("beep");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                target.getToolkit().beep();
            }
        }
    }

    public static class PasteAction
    extends BaseAction {
        static final long serialVersionUID = 5839791453996432149L;
        private boolean formated;

        public PasteAction(boolean formated) {
            super(formated ? BaseKit.pasteFormatedAction : "paste-from-clipboard", 28);
            this.putValue("helpID", (class$org$netbeans$editor$BaseKit$PasteAction == null ? (class$org$netbeans$editor$BaseKit$PasteAction = BaseKit.class$("org.netbeans.editor.BaseKit$PasteAction")) : class$org$netbeans$editor$BaseKit$PasteAction).getName());
            this.formated = formated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                BaseDocument doc = Utilities.getDocument(target);
                if (doc == null) {
                    return;
                }
                doc.atomicLock();
                try {
                    if (this.formated) {
                        Caret caret = target.getCaret();
                        int prevPos = target.getSelectionStart();
                        target.paste();
                        int postPos = caret.getDot();
                        PasteAction.indentBlock(doc, prevPos, postPos);
                    } else {
                        target.paste();
                    }
                }
                catch (Exception e) {
                    target.getToolkit().beep();
                }
                finally {
                    doc.atomicUnlock();
                }
            }
        }

        public static void indentBlock(BaseDocument doc, int startOffset, int endOffset) throws BadLocationException {
            char[] text = doc.getChars(startOffset, endOffset - startOffset);
            String[] lines = PasteAction.toLines(new String(text));
            doc.remove(startOffset, endOffset - startOffset);
            int offset = startOffset;
            for (int i = 0; i < lines.length - 1; ++i) {
                String indent = PasteAction.getIndentString(doc, offset, lines[i]);
                String fragment = indent + lines[i].trim() + '\n';
                doc.insertString(offset, fragment, null);
                offset += fragment.length();
            }
            doc.insertString(offset, lines[lines.length - 1], null);
        }

        private static String[] toLines(String str) {
            Vector<String> v = new Vector<String>();
            int p0 = 0;
            for (int p = 0; p < str.length(); ++p) {
                if (str.charAt(p) != '\n') continue;
                v.add(str.substring(p0, p + 1));
                p0 = p + 1;
            }
            if (p0 < str.length()) {
                v.add(str.substring(p0, str.length()));
            } else {
                v.add("");
            }
            return v.toArray(new String[0]);
        }

        private static String getIndentString(BaseDocument doc, int startOffset, String str) {
            try {
                int i;
                Formatter f = doc.getFormatter();
                CharArrayWriter cw = new CharArrayWriter();
                Writer w = f.createWriter(doc, startOffset, cw);
                w.write(str, 0, str.length());
                w.close();
                String out = new String(cw.toCharArray());
                for (i = 0; i < out.length() && (out.charAt(i) == ' ' || out.charAt(i) == '\t'); ++i) {
                }
                return out.substring(0, i);
            }
            catch (IOException e) {
                return "";
            }
        }
    }

    public static class CopyAction
    extends BaseAction {
        static final long serialVersionUID = -5119779005431986964L;

        public CopyAction() {
            super("copy-to-clipboard", 28);
            this.setEnabled(false);
            this.putValue("helpID", (class$org$netbeans$editor$BaseKit$CopyAction == null ? (class$org$netbeans$editor$BaseKit$CopyAction = BaseKit.class$("org.netbeans.editor.BaseKit$CopyAction")) : class$org$netbeans$editor$BaseKit$CopyAction).getName());
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                target.copy();
            }
        }
    }

    public static class CutAction
    extends BaseAction {
        static final long serialVersionUID = 6377157040901778853L;

        public CutAction() {
            super("cut-to-clipboard", 28);
            this.setEnabled(false);
            this.putValue("helpID", (class$org$netbeans$editor$BaseKit$CutAction == null ? (class$org$netbeans$editor$BaseKit$CutAction = BaseKit.class$("org.netbeans.editor.BaseKit$CutAction")) : class$org$netbeans$editor$BaseKit$CutAction).getName());
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                target.cut();
            }
        }
    }

    public static class WritableAction
    extends BaseAction {
        static final long serialVersionUID = -5982547952800937954L;

        public WritableAction() {
            super("set-writable");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                target.setEditable(true);
            }
        }
    }

    public static class ReadOnlyAction
    extends BaseAction {
        static final long serialVersionUID = 9204335480208463193L;

        public ReadOnlyAction() {
            super("set-read-only");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                target.setEditable(false);
            }
        }
    }

    public static class DeleteCharAction
    extends BaseAction {
        protected boolean nextChar;
        static final long serialVersionUID = -4321971925753148556L;

        public DeleteCharAction(String nm, boolean nextChar) {
            super(nm, 22);
            this.nextChar = nextChar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block9: {
                if (target != null) {
                    if (!target.isEditable() || !target.isEnabled()) {
                        target.getToolkit().beep();
                        return;
                    }
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    Caret caret = target.getCaret();
                    int dot = caret.getDot();
                    int mark = caret.getMark();
                    try {
                        if (dot != mark) {
                            doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
                            break block9;
                        }
                        if (this.nextChar) {
                            doc.remove(dot, 1);
                            break block9;
                        }
                        doc.atomicLock();
                        try {
                            char ch = doc.getChars(dot - 1, 1)[0];
                            doc.remove(dot - 1, 1);
                            this.charBackspaced(doc, dot - 1, caret, ch);
                        }
                        finally {
                            doc.atomicUnlock();
                        }
                    }
                    catch (BadLocationException e) {
                        target.getToolkit().beep();
                    }
                }
            }
        }

        protected void charBackspaced(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
        }
    }

    public static class InsertStringAction
    extends BaseAction {
        String text;
        static final long serialVersionUID = -2755852016584693328L;

        public InsertStringAction(String nm, String text) {
            super(nm, 22);
            this.text = text;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                target.replaceSelection(this.text);
            }
        }
    }

    public static class InsertContentAction
    extends BaseAction {
        static final long serialVersionUID = 5647751370952797218L;

        public InsertContentAction() {
            super("insert-content", 22);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null && evt != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                String content = evt.getActionCommand();
                if (content != null) {
                    target.replaceSelection(content);
                } else {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class KitCompoundAction
    extends BaseAction {
        private String[] actionNames;
        static final long serialVersionUID = 8415246475764264835L;

        public KitCompoundAction(String nm, String[] actionNames) {
            this(nm, 0, actionNames);
        }

        public KitCompoundAction(String nm, int resetMask, String[] actionNames) {
            super(nm, resetMask);
            this.actionNames = actionNames;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            BaseKit kit;
            if (target != null && (kit = Utilities.getKit(target)) != null) {
                for (int i = 0; i < this.actionNames.length; ++i) {
                    Action a = kit.getActionByName(this.actionNames[i]);
                    if (a == null) continue;
                    if (a instanceof BaseAction) {
                        ((BaseAction)a).actionPerformed(evt, target);
                        continue;
                    }
                    a.actionPerformed(evt);
                }
            }
        }
    }

    public static class CompoundAction
    extends BaseAction {
        Action[] actions;
        static final long serialVersionUID = 1649688300969753758L;

        public CompoundAction(String nm, Action[] actions) {
            this(nm, 0, actions);
        }

        public CompoundAction(String nm, int resetMask, Action[] actions) {
            super(nm, resetMask);
            this.actions = actions;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                for (int i = 0; i < this.actions.length; ++i) {
                    Action a = this.actions[i];
                    if (a instanceof BaseAction) {
                        ((BaseAction)a).actionPerformed(evt, target);
                        continue;
                    }
                    a.actionPerformed(evt);
                }
            }
        }
    }

    public static class InsertTabAction
    extends BaseAction {
        static final long serialVersionUID = -3379768531715989243L;

        public InsertTabAction() {
            super("insert-tab", 22);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                if (caret.isSelectionVisible()) {
                    try {
                        doc.getFormatter().changeBlockIndent(doc, target.getSelectionStart(), target.getSelectionEnd(), 1);
                    }
                    catch (GuardedException e) {
                        target.getToolkit().beep();
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                } else {
                    int caretCol;
                    int dotPos = caret.getDot();
                    try {
                        caretCol = doc.getVisColFromPos(dotPos);
                    }
                    catch (BadLocationException e) {
                        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                            e.printStackTrace();
                        }
                        caretCol = 0;
                    }
                    try {
                        int indent;
                        int upperCol = Utilities.getRowIndent(doc, dotPos, false);
                        if (upperCol == -1) {
                            upperCol = 0;
                        }
                        if ((indent = Utilities.getRowIndent(doc, dotPos)) == -1) {
                            indent = upperCol > caretCol ? upperCol : Utilities.getNextTabColumn(doc, dotPos);
                            int rowStart = Utilities.getRowStart(doc, dotPos);
                            doc.getFormatter().changeRowIndent(doc, dotPos, indent);
                            int newDotPos = doc.getOffsetFromVisCol(indent, rowStart);
                            if (newDotPos >= 0) {
                                caret.setDot(newDotPos);
                            }
                        } else {
                            doc.getFormatter().insertTabString(doc, dotPos);
                        }
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class SplitLineAction
    extends BaseAction {
        static final long serialVersionUID = 7966576342334158659L;

        public SplitLineAction() {
            super(BaseKit.splitLineAction, 22);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                BaseDocument doc = (BaseDocument)target.getDocument();
                Caret caret = target.getCaret();
                int dotPos = caret.getDot();
                doc.atomicLock();
                try {
                    target.replaceSelection("");
                    int newDotPos = dotPos;
                    doc.getFormatter().indentNewLine(doc, dotPos);
                    caret.setDot(newDotPos);
                }
                finally {
                    doc.atomicUnlock();
                }
            }
        }
    }

    public static class InsertBreakAction
    extends BaseAction {
        static final long serialVersionUID = 7966576342334158659L;

        public InsertBreakAction() {
            super("insert-break", 22);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                target.replaceSelection("");
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                doc.atomicLock();
                try {
                    Object cookie = this.beforeBreak(target, doc, caret);
                    int dotPos = caret.getDot();
                    int newDotPos = doc.getFormatter().indentNewLine(doc, dotPos);
                    caret.setDot(newDotPos);
                    this.afterBreak(target, doc, caret, cookie);
                }
                finally {
                    doc.atomicUnlock();
                }
            }
        }

        protected Object beforeBreak(JTextComponent target, BaseDocument doc, Caret caret) {
            return null;
        }

        protected void afterBreak(JTextComponent target, BaseDocument doc, Caret caret, Object data) {
        }
    }

    public static class DefaultKeyTypedAction
    extends BaseAction {
        static final long serialVersionUID = 3069164318144463899L;

        public DefaultKeyTypedAction() {
            super("default-typed", 162);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null && evt != null) {
                boolean alt;
                int mod = evt.getModifiers();
                boolean ctrl = (mod & 2) != 0;
                boolean bl = alt = (mod & 8) != 0;
                if (alt && !ctrl || ctrl && !alt) {
                    return;
                }
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                EditorUI editorUI = Utilities.getEditorUI(target);
                String cmd = evt.getActionCommand();
                if (cmd != null && cmd.length() == 1) {
                    block12: {
                        char ch = cmd.charAt(0);
                        if (ch >= ' ' && ch != '\u007f') {
                            editorUI.getWordMatch().clear();
                            try {
                                boolean doInsert = editorUI.getAbbrev().checkAndExpand(ch, evt);
                                if (!doInsert) break block12;
                                if (caret.isSelectionVisible()) {
                                    target.replaceSelection(cmd);
                                    break block12;
                                }
                                int dotPos = caret.getDot();
                                Boolean overwriteMode = (Boolean)editorUI.getProperty("overwriteMode");
                                if (overwriteMode != null && overwriteMode.booleanValue() && dotPos < doc.getLength() && doc.getChars(dotPos, 1)[0] != '\n') {
                                    doc.atomicLock();
                                    try {
                                        this.insertString(doc, dotPos, caret, cmd, true);
                                        break block12;
                                    }
                                    finally {
                                        doc.atomicUnlock();
                                    }
                                }
                                this.insertString(doc, dotPos, caret, cmd, false);
                            }
                            catch (BadLocationException e) {
                                target.getToolkit().beep();
                            }
                        }
                    }
                    this.checkIndent(target, cmd);
                }
            }
        }

        protected void insertString(BaseDocument doc, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            if (overwrite) {
                doc.remove(dotPos, 1);
            }
            doc.insertString(dotPos, str, null);
        }

        protected void checkIndent(JTextComponent target, String typedText) {
        }
    }
}

