/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawEngineLineView;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.fold.api.Fold;
import org.netbeans.editor.fold.api.FoldHierarchy;
import org.netbeans.editor.fold.api.FoldHierarchyEvent;
import org.netbeans.editor.fold.api.FoldHierarchyIterator;
import org.netbeans.editor.fold.api.FoldHierarchyListener;
import org.netbeans.editor.fold.api.FoldUtilities;

public class CodeFoldingSideBar
extends JComponent
implements SettingsChangeListener {
    protected JTextComponent component;
    protected Font font;
    protected Color foreColor;
    protected Color backColor;
    private boolean enabled;
    protected List visibleMarks = new ArrayList();
    public static final int PAINT_NOOP = 0;
    public static final int PAINT_MARK = 1;
    public static final int PAINT_LINE = 2;
    public static final int PAINT_END_MARK = 3;

    public CodeFoldingSideBar() {
    }

    public CodeFoldingSideBar(JTextComponent component) {
        this.component = component;
        this.enabled = (Boolean)Settings.getValue(Utilities.getKitClass(component), "code-folding-enable");
        this.enableSideBarComponent(this.enabled);
        Settings.addSettingsChangeListener(this);
        this.addMouseListener(new FoldingMouseListener());
        FoldHierarchy foldHierarchy = FoldHierarchy.get(component);
        foldHierarchy.addFoldHierarchyListener(new SideBarFoldHierarchyListener());
        Document doc = this.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent evt) {
                if (!(evt instanceof BaseDocumentEvent)) {
                    return;
                }
                BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
                if (bevt.getLFCount() > 0) {
                    CodeFoldingSideBar.this.repaint();
                }
            }

            public void removeUpdate(DocumentEvent evt) {
                if (!(evt instanceof BaseDocumentEvent)) {
                    return;
                }
                BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
                if (bevt.getLFCount() > 0) {
                    CodeFoldingSideBar.this.repaint();
                }
            }

            public void changedUpdate(DocumentEvent evt) {
            }
        });
    }

    private void enableSideBarComponent(boolean enable) {
        if (enable) {
            this.setPreferredSize(new Dimension(this.getColoringFont().getSize(), this.component.getHeight()));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
    }

    private Font getDefaultColoringFont() {
        Coloring defaultColoring = this.getEditorUI().getDefaultColoring();
        if (defaultColoring != null && defaultColoring.getFont() != null) {
            return defaultColoring.getFont();
        }
        return SettingsDefaults.defaultFont;
    }

    protected Font getColoringFont() {
        if (this.font != null) {
            return this.font;
        }
        Coloring foldColoring = this.getEditorUI().getColoring("code-folding");
        if (foldColoring != null && foldColoring.getFont() != null) {
            this.font = foldColoring.getFont();
            return this.font;
        }
        this.font = this.getDefaultColoringFont();
        return this.font;
    }

    protected Color getForeColor() {
        if (this.foreColor != null) {
            return this.foreColor;
        }
        Coloring foldColoring = this.getEditorUI().getColoring("code-folding");
        if (foldColoring != null && foldColoring.getForeColor() != null) {
            this.foreColor = foldColoring.getForeColor();
            return this.foreColor;
        }
        this.foreColor = this.getDefaultForeColor();
        return this.foreColor;
    }

    private Color getDefaultForeColor() {
        Coloring defaultColoring = this.getEditorUI().getDefaultColoring();
        if (defaultColoring != null && defaultColoring.getForeColor() != null) {
            return defaultColoring.getForeColor();
        }
        return SettingsDefaults.defaultForeColor;
    }

    private Color getDefaultBackColor() {
        Coloring defaultColoring = this.getEditorUI().getDefaultColoring();
        if (defaultColoring != null) {
            return defaultColoring.getBackColor();
        }
        return SettingsDefaults.defaultBackColor;
    }

    protected Color getBackColor() {
        if (this.backColor != null) {
            return this.backColor;
        }
        Coloring foldColoring = this.getEditorUI().getColoring("code-folding");
        if (foldColoring != null && foldColoring.getBackColor() != null) {
            this.backColor = foldColoring.getBackColor();
            return this.backColor;
        }
        this.backColor = this.getDefaultBackColor();
        return this.backColor;
    }

    public void settingsChange(SettingsChangeEvent evt) {
        if (evt == null || Utilities.getKitClass(this.component) != evt.getKitClass()) {
            return;
        }
        if ("code-folding-enable".equals(evt.getSettingName())) {
            this.enabled = (Boolean)Settings.getValue(evt.getKitClass(), "code-folding-enable");
            this.enableSideBarComponent(this.enabled);
            this.revalidate();
        }
        String defaultColoringName = "default-coloring";
        String foldingColoringName = "code-folding-coloring";
        Coloring foldingColoring = this.getEditorUI().getColoring("code-folding");
        Coloring defaultColoring = this.getEditorUI().getDefaultColoring();
        Font foldingFont = null;
        Color foldingForeColor = null;
        Color foldingBackColor = null;
        if (foldingColoring != null) {
            foldingFont = foldingColoring.getFont();
            foldingForeColor = foldingColoring.getForeColor();
            foldingBackColor = foldingColoring.getBackColor();
        }
        if (defaultColoringName.equals(evt.getSettingName())) {
            Font tempFont;
            Color tempColor;
            if (foldingForeColor == null && !(tempColor = this.getDefaultForeColor()).equals(this.foreColor)) {
                this.foreColor = tempColor;
            }
            if (foldingBackColor == null && !(tempColor = this.getDefaultBackColor()).equals(this.backColor)) {
                this.backColor = tempColor;
            }
            if (!(tempFont = this.getDefaultColoringFont()).equals(this.font) && foldingFont == null) {
                this.font = tempFont;
                if (this.enabled) {
                    this.setPreferredSize(new Dimension(this.font.getSize(), this.component.getHeight()));
                }
            }
            this.repaint();
        } else if (foldingColoringName.equals(evt.getSettingName())) {
            if (foldingColoring == null) {
                return;
            }
            Color tempColor = foldingColoring.getForeColor();
            this.foreColor = tempColor != null ? tempColor : this.getDefaultForeColor();
            tempColor = foldingColoring.getBackColor();
            Color color = this.backColor = tempColor != null ? tempColor : this.getDefaultBackColor();
            if (foldingFont == null) {
                Font tempFont = this.getDefaultColoringFont();
                if (!tempFont.equals(this.font)) {
                    this.font = tempFont;
                    if (this.enabled) {
                        this.setPreferredSize(new Dimension(this.font.getSize(), this.component.getHeight()));
                    }
                }
            } else if (!foldingFont.equals(this.font)) {
                this.font = foldingFont;
                if (this.enabled) {
                    this.setPreferredSize(new Dimension(this.font.getSize(), this.component.getHeight()));
                }
            }
            this.repaint();
        }
    }

    protected void collectPaintInfos(Fold fold, Map map, int level, int startIndex, int endIndex) {
        View rootView = Utilities.getDocumentView(this.component);
        if (rootView == null) {
            return;
        }
        for (int i = 0; i < fold.getFoldCount(); ++i) {
            int startViewIndex = rootView.getViewIndex(fold.getFold(i).getStartOffset(), Position.Bias.Forward);
            int endViewIndex = rootView.getViewIndex(fold.getFold(i).getEndOffset(), Position.Bias.Forward);
            if (endViewIndex < startIndex || startViewIndex > endIndex) continue;
            this.collectPaintInfos(fold.getFold(i), map, level + 1, startIndex, endIndex);
        }
        int foldStartOffset = fold.getStartOffset();
        int foldEndOffset = fold.getEndOffset();
        int startViewIndex = rootView.getViewIndex(foldStartOffset, Position.Bias.Forward);
        int endViewIndex = rootView.getViewIndex(foldEndOffset, Position.Bias.Forward);
        try {
            Rectangle viewRect;
            View view;
            Rectangle viewShape;
            BaseTextUI textUI = (BaseTextUI)this.component.getUI();
            int markY = -1;
            int y = -1;
            if (startIndex <= startViewIndex && (viewShape = textUI.modelToView(this.component, (view = rootView.getView(startViewIndex)).getStartOffset())) != null) {
                viewRect = viewShape.getBounds();
                y = viewRect.y + viewRect.height;
                if (fold.isCollapsed()) {
                    map.put(new Integer(viewRect.y), new PaintInfo(1, level, viewRect.y, viewRect.height, fold.isCollapsed()));
                    return;
                }
                markY = viewRect.y;
                map.put(new Integer(viewRect.y), new PaintInfo(1, level, viewRect.y, viewRect.height, fold.isCollapsed()));
            }
            if (level == 0) {
                int loopStart = startViewIndex < startIndex ? startIndex : startViewIndex + 1;
                int loopEnd = endViewIndex > endIndex ? endIndex : endViewIndex;
                viewRect = null;
                for (int i = loopStart; i <= loopEnd; ++i) {
                    view = rootView.getView(i);
                    if (view instanceof DrawEngineLineView && y > -1) {
                        int h = (int)((DrawEngineLineView)view).getLayoutMajorAxisPreferredSpan();
                        viewRect = new Rectangle(0, y, 0, h);
                        if (i < loopEnd) {
                            y += h;
                        }
                    } else {
                        viewShape = textUI.modelToView(this.component, view.getStartOffset());
                        if (viewShape != null) {
                            viewRect = viewShape.getBounds();
                            y = viewRect.y + viewRect.height;
                        }
                    }
                    if (viewRect == null || map.containsKey(new Integer(viewRect.y))) continue;
                    map.put(new Integer(viewRect.y), new PaintInfo(2, level, viewRect.y, viewRect.height));
                }
            }
            if (endViewIndex <= endIndex) {
                view = rootView.getView(endViewIndex);
                viewRect = null;
                if (view instanceof DrawEngineLineView && y > -1 && level == 0) {
                    int h = (int)((DrawEngineLineView)view).getLayoutMajorAxisPreferredSpan();
                    viewRect = new Rectangle(0, y, 0, h);
                    y += h;
                } else {
                    viewShape = textUI.modelToView(this.component, view.getStartOffset());
                    if (viewShape != null) {
                        viewRect = viewShape.getBounds();
                        y = viewRect.y + viewRect.height;
                    }
                }
                if (viewRect != null && markY != viewRect.y) {
                    map.put(new Integer(viewRect.y), new PaintInfo(3, level, viewRect.y, viewRect.height));
                }
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    protected List getPaintInfo(int startPos, int endPos) {
        ArrayList ret = new ArrayList();
        List foldList = this.getFoldList(startPos, endPos);
        if (foldList.size() == 0) {
            return ret;
        }
        BaseTextUI textUI = (BaseTextUI)this.component.getUI();
        Element rootElem = textUI.getRootView(this.component).getElement();
        View rootView = Utilities.getDocumentView(this.component);
        if (rootView == null) {
            return ret;
        }
        int startViewIndex = rootView.getViewIndex(startPos, Position.Bias.Forward);
        int endViewIndex = rootView.getViewIndex(endPos, Position.Bias.Forward);
        HashMap map = new HashMap();
        for (int i = 0; i < foldList.size(); ++i) {
            Fold fold = (Fold)foldList.get(i);
            this.collectPaintInfos(fold, map, 0, startViewIndex, endViewIndex);
        }
        return new ArrayList(map.values());
    }

    protected EditorUI getEditorUI() {
        return Utilities.getEditorUI(this.component);
    }

    protected Document getDocument() {
        return this.component.getDocument();
    }

    protected void performAction(Mark mark) {
        BaseTextUI textUI = (BaseTextUI)this.component.getUI();
        Element rootElem = textUI.getRootView(this.component).getElement();
        View rootView = Utilities.getDocumentView(this.component);
        if (rootView == null) {
            return;
        }
        try {
            int startViewIndex = rootView.getViewIndex(textUI.getPosFromY(mark.y + mark.size / 2), Position.Bias.Forward);
            View view = rootView.getView(startViewIndex);
            FoldHierarchy foldHierarchy = FoldHierarchy.get(this.component);
            Fold clickedFold = FoldUtilities.findNearestFold(foldHierarchy, view.getStartOffset());
            if (clickedFold != null && clickedFold.getStartOffset() < view.getEndOffset()) {
                foldHierarchy.toggle(clickedFold);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    protected int getMarkSize(Graphics g) {
        FontMetrics fm;
        if (g != null && (fm = g.getFontMetrics(this.getColoringFont())) != null) {
            int ret = fm.getAscent() - fm.getDescent();
            return ret - ret % 2;
        }
        return -1;
    }

    protected void paintComponent(Graphics g) {
        if (!this.enabled) {
            return;
        }
        super.paintComponent(g);
        Rectangle clip = this.getVisibleRect();
        this.visibleMarks.clear();
        g.setColor(this.getBackColor());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(this.getForeColor());
        TextUI ui = this.component.getUI();
        if (!(ui instanceof BaseTextUI)) {
            return;
        }
        BaseTextUI textUI = (BaseTextUI)ui;
        try {
            int startPos = textUI.getPosFromY(clip.y);
            int endPos = textUI.viewToModel(this.component, 16383, clip.y + clip.height);
            List ps = this.getPaintInfo(startPos, endPos);
            Font defFont = this.getColoringFont();
            for (int i = 0; i < ps.size(); ++i) {
                PaintInfo paintInfo = (PaintInfo)ps.get(i);
                if (paintInfo.getPaintOperation() == 0 && paintInfo.getInnerLevel() == 0) continue;
                boolean isFolded = paintInfo.isCollapsed();
                int y = paintInfo.getPaintY();
                int height = paintInfo.getPaintHeight();
                int markSize = this.getMarkSize(g);
                int halfMarkSize = markSize / 2;
                int markX = (defFont.getSize() - markSize) / 2;
                int markY = y + g.getFontMetrics(defFont).getDescent();
                int plusGap = (int)Math.round((double)markSize / 3.8);
                int lineX = markX + halfMarkSize;
                if (paintInfo.getPaintOperation() == 1) {
                    g.drawRect(markX, markY, markSize, markSize);
                    g.drawLine(plusGap + markX, markY + halfMarkSize, markSize + markX - plusGap, markY + halfMarkSize);
                    if (isFolded) {
                        g.drawLine(lineX, markY + plusGap, lineX, markY + markSize - plusGap);
                    } else {
                        g.drawLine(lineX, markY + markSize, lineX, y + height);
                    }
                    if (paintInfo.getInnerLevel() > 0) {
                        g.drawLine(lineX, y, lineX, markY);
                        if (isFolded) {
                            g.drawLine(lineX, markY + markSize, lineX, y + height);
                        }
                    }
                    this.visibleMarks.add(new Mark(markX, markY, markSize, isFolded));
                    continue;
                }
                if (paintInfo.getPaintOperation() == 2) {
                    g.drawLine(lineX, y, lineX, y + height);
                    continue;
                }
                if (paintInfo.getPaintOperation() != 3) continue;
                g.drawLine(lineX, y, lineX, y + height / 2);
                g.drawLine(lineX, y + height / 2, lineX + halfMarkSize, y + height / 2);
                if (paintInfo.getInnerLevel() <= 0) continue;
                g.drawLine(lineX, y + height / 2, lineX, y + height);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getFoldList(int start, int end) {
        FoldHierarchy hierarchy = FoldHierarchy.get(this.component);
        hierarchy.lock();
        try {
            ArrayList<Fold> ret = new ArrayList<Fold>();
            FoldHierarchyIterator it = hierarchy.foldIterator(start, end);
            while (it.hasNext()) {
                Fold f = (Fold)it.next();
                if (f.getStartOffset() > end || f.getEndOffset() < start) continue;
                ret.add(f);
            }
            ArrayList<Fold> arrayList = ret;
            return arrayList;
        }
        finally {
            hierarchy.unlock();
        }
    }

    class SideBarFoldHierarchyListener
    implements FoldHierarchyListener {
        public void foldHierarchyChanged(FoldHierarchyEvent evt) {
            CodeFoldingSideBar.this.repaint();
        }
    }

    class FoldingMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e == null || !SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            int x = e.getX();
            int y = e.getY();
            for (int i = 0; i < CodeFoldingSideBar.this.visibleMarks.size(); ++i) {
                Mark mark = (Mark)CodeFoldingSideBar.this.visibleMarks.get(i);
                if (x < mark.x || x > mark.x + mark.size || y < mark.y || y > mark.y + mark.size) continue;
                CodeFoldingSideBar.this.performAction(mark);
            }
        }
    }

    public class Mark {
        public int x;
        public int y;
        public int size;
        public boolean isFolded;

        public Mark(int x, int y, int size, boolean isFolded) {
            this.x = x;
            this.y = y;
            this.size = size;
            this.isFolded = isFolded;
        }
    }

    public class PaintInfo {
        int paintOperation;
        int innerLevel;
        int paintY;
        int paintHeight;
        boolean isCollapsed;

        public PaintInfo(int paintOperation, int innerLevel, int paintY, int paintHeight, boolean isCollapsed) {
            this.paintOperation = paintOperation;
            this.innerLevel = innerLevel;
            this.paintY = paintY;
            this.paintHeight = paintHeight;
            this.isCollapsed = isCollapsed;
        }

        public PaintInfo(int paintOperation, int innerLevel, int paintY, int paintHeight) {
            this(paintOperation, innerLevel, paintY, paintHeight, false);
        }

        public int getPaintOperation() {
            return this.paintOperation;
        }

        public int getInnerLevel() {
            return this.innerLevel;
        }

        public int getPaintY() {
            return this.paintY;
        }

        public int getPaintHeight() {
            return this.paintHeight;
        }

        public boolean isCollapsed() {
            return this.isCollapsed;
        }

        public void setPaintOperation(int paintOperation) {
            this.paintOperation = paintOperation;
        }

        public void setInnerLevel(int innerLevel) {
            this.innerLevel = innerLevel;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            if (this.paintOperation == 0) {
                sb.append("PAINT_NOOP\n");
            } else if (this.paintOperation == 1) {
                sb.append("PAINT_MARK\n");
            } else if (this.paintOperation == 2) {
                sb.append("PAINT_LINE\n");
            } else if (this.paintOperation == 3) {
                sb.append("PAINT_END_MARK\n");
            }
            sb.append("level:" + this.innerLevel);
            sb.append("\ncollapsedFold:" + this.isCollapsed);
            return sb.toString();
        }
    }
}

