/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawEngine;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.view.spi.EstimatedSpanView;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.editor.view.spi.ViewLayoutState;

class DrawEngineLineView
extends View
implements ViewLayoutState,
EstimatedSpanView {
    private static final int X_MAJOR_AXIS_BIT = 1;
    private static final int MAJOR_AXIS_PREFERENCE_CHANGED_BIT = 2;
    private static final int MINOR_AXIS_PREFERENCE_CHANGED_BIT = 4;
    private static final int VIEW_SIZE_INVALID_BIT = 8;
    private static final int UPDATE_LAYOUT_PENDING_BIT = 16;
    private static final int ESTIMATED_SPAN_BIT = 32;
    protected static final int LAST_USED_BIT = 32;
    private static final int ANY_INVALID = 14;
    private int statusBits;
    private int viewRawIndex;
    private double layoutMajorAxisRawOffset;
    private float layoutMajorAxisPreferredSpan;
    private float layoutMinorAxisPreferredSpan;
    ModelToViewDG modelToViewDG;
    ViewToModelDG viewToModelDG;
    static /* synthetic */ Class class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine;

    public DrawEngineLineView(Element elem) {
        super(elem);
    }

    private int getBaseX(int orig) {
        return orig + this.getEditorUI().getTextMargin().left;
    }

    private JTextComponent getComponent() {
        return (JTextComponent)this.getContainer();
    }

    private BaseTextUI getBaseTextUI() {
        return (BaseTextUI)this.getComponent().getUI();
    }

    private EditorUI getEditorUI() {
        return this.getBaseTextUI().getEditorUI();
    }

    private ModelToViewDG getModelToViewDG() {
        if (this.modelToViewDG == null) {
            this.modelToViewDG = new ModelToViewDG();
        }
        return this.modelToViewDG;
    }

    private ViewToModelDG getViewToModelDG() {
        if (this.viewToModelDG == null) {
            this.viewToModelDG = new ViewToModelDG();
        }
        return this.viewToModelDG;
    }

    public boolean isEstimatedSpan() {
        return this.isStatusBitsNonZero(32);
    }

    public void setEstimatedSpan(boolean estimatedSpan) {
        if (this.isEstimatedSpan() != estimatedSpan) {
            if (estimatedSpan) {
                this.setStatusBits(32);
            } else {
                this.clearStatusBits(32);
                this.getParent().preferenceChanged(this, true, true);
            }
        }
    }

    protected boolean isFragment() {
        return false;
    }

    private int getEOLffset() {
        return super.getEndOffset() - 1;
    }

    private int getAdjustedEOLOffset() {
        return Math.min(this.getEndOffset(), this.getEOLffset());
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.preferenceChanged(this, true, false);
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.preferenceChanged(this, true, false);
    }

    public float getAlignment(int axis) {
        return 0.0f;
    }

    public void paint(Graphics g, Shape a) {
        this.setEstimatedSpan(false);
        Rectangle allocReadOnly = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        int startOffset = this.getStartOffset();
        int endOffset = this.getAdjustedEOLOffset();
        try {
            if (this.isFragment()) {
                Rectangle oldClipRect = g.getClipBounds();
                Rectangle newClip = new Rectangle(oldClipRect);
                Rectangle startOffsetClip = this.modelToView(startOffset, a, Position.Bias.Forward).getBounds();
                Rectangle endOffsetClip = this.modelToView(endOffset, a, Position.Bias.Forward).getBounds();
                newClip.width = Math.min(oldClipRect.width, endOffsetClip.x);
                if (newClip.width + newClip.x > endOffsetClip.x) {
                    newClip.width -= newClip.width + newClip.x - endOffsetClip.x;
                }
                g.setClip(newClip);
                int shift = startOffsetClip.x - this.getEditorUI().getTextMargin().left - allocReadOnly.x;
                g.translate(-shift, 0);
                DrawEngine.getDrawEngine().draw(this, new DrawGraphics.GraphicsDG(g), this.getEditorUI(), startOffset, endOffset, this.getBaseX(allocReadOnly.x), allocReadOnly.y, Integer.MAX_VALUE);
                g.translate(shift, 0);
                g.setClip(oldClipRect);
            } else {
                JTextComponent component = this.getComponent();
                if (component != null) {
                    DrawEngine drawEngine = (DrawEngine)component.getClientProperty(class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine == null ? (class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine = DrawEngineLineView.class$("org.netbeans.editor.DrawEngine$PreinitializedDrawEngine")) : class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine);
                    if (drawEngine != null) {
                        drawEngine.draw(this, new DrawGraphics.GraphicsDG(g), this.getEditorUI(), startOffset, endOffset, this.getBaseX(allocReadOnly.x), allocReadOnly.y, Integer.MAX_VALUE);
                    } else {
                        DrawEngine.getDrawEngine().draw(this, new DrawGraphics.GraphicsDG(g), this.getEditorUI(), startOffset, endOffset, this.getBaseX(allocReadOnly.x), allocReadOnly.y, Integer.MAX_VALUE);
                    }
                }
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public float getPreferredSpan(int axis) {
        switch (axis) {
            case 1: {
                return this.getEditorUI().getLineHeight();
            }
            case 0: {
                try {
                    int offset = Math.max(0, this.getEndOffset() - 1);
                    Shape retShape = this.modelToView(offset, new Rectangle(), Position.Bias.Forward);
                    int ret = retShape.getBounds().x + retShape.getBounds().width;
                    return Math.max((float)ret, 1.0f);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }
        return 1.0f;
    }

    private Rectangle getModel2ViewRect(int startOffset, int endOffset, int startX, int startY, int targetOffset) {
        Rectangle ret;
        block5: {
            ret = new Rectangle();
            ret.y = startY;
            if (this.isEstimatedSpan()) {
                ret.height = this.getEditorUI().getLineHeight();
                ret.x = startX;
                ret.width = 1;
            } else {
                try {
                    ModelToViewDG modelToViewDG = this.getModelToViewDG();
                    modelToViewDG.r = ret;
                    DrawEngine.getDrawEngine().draw(this, modelToViewDG, this.getEditorUI(), startOffset, endOffset, startX, startY, targetOffset);
                    LockView lv = LockView.get(this);
                    if (lv != null && lv.getLockThread() != Thread.currentThread()) {
                        throw new IllegalStateException("View access without view lock");
                    }
                    modelToViewDG.r = null;
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block5;
                    ble.printStackTrace();
                }
            }
        }
        return ret;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        BaseDocument doc = (BaseDocument)this.getDocument();
        if (pos < 0 || pos > doc.getLength()) {
            throw new BadLocationException("Invalid offset=" + pos, pos);
        }
        Rectangle allocReadOnly = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        Rectangle ret = this.getModel2ViewRect(this.getStartOffset(), this.getAdjustedEOLOffset(), this.getBaseX(allocReadOnly.x), allocReadOnly.y, pos);
        return ret;
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        if (this.isEstimatedSpan()) {
            return this.getStartOffset();
        }
        int intX = (int)x;
        int intY = (int)y;
        if (biasReturn != null) {
            biasReturn[0] = Position.Bias.Forward;
        }
        int pos = this.getStartOffset();
        Rectangle shapeRect = a != null ? a.getBounds() : new Rectangle();
        try {
            int eolPos = this.getAdjustedEOLOffset();
            ViewToModelDG viewToModelDG = this.getViewToModelDG();
            viewToModelDG.setTargetX(intX);
            viewToModelDG.setEOLOffset(eolPos);
            DrawEngine.getDrawEngine().draw(this, viewToModelDG, this.getEditorUI(), this.getStartOffset(), eolPos, this.getBaseX(0) + shapeRect.x, shapeRect.y, -1);
            pos = viewToModelDG.getOffset();
            return pos;
        }
        catch (BadLocationException e) {
            return pos;
        }
    }

    public View createFragment(int p0, int p1) {
        Element elem = this.getElement();
        return p0 >= 0 && p0 >= elem.getStartOffset() && p0 < elem.getEndOffset() && p1 > 0 && p1 <= elem.getEndOffset() && p1 > elem.getStartOffset() && (p0 != elem.getStartOffset() || p1 != elem.getEndOffset()) ? new FragmentView(this.getElement(), p0 - elem.getStartOffset(), p1 - p0) : this;
    }

    public double getLayoutMajorAxisPreferredSpan() {
        return this.layoutMajorAxisPreferredSpan;
    }

    public float getLayoutMajorAxisPreferredSpanFloat() {
        return this.layoutMajorAxisPreferredSpan;
    }

    protected void setLayoutMajorAxisPreferredSpan(float layoutMajorAxisPreferredSpan) {
        this.layoutMajorAxisPreferredSpan = layoutMajorAxisPreferredSpan;
    }

    public double getLayoutMajorAxisRawOffset() {
        return this.layoutMajorAxisRawOffset;
    }

    public void setLayoutMajorAxisRawOffset(double layoutMajorAxisRawOffset) {
        this.layoutMajorAxisRawOffset = layoutMajorAxisRawOffset;
    }

    public float getLayoutMinorAxisAlignment() {
        return this.getAlignment(this.getMinorAxis());
    }

    public float getLayoutMinorAxisMaximumSpan() {
        return this.getLayoutMinorAxisPreferredSpan();
    }

    public float getLayoutMinorAxisMinimumSpan() {
        return this.getLayoutMinorAxisPreferredSpan();
    }

    public float getLayoutMinorAxisPreferredSpan() {
        return this.layoutMinorAxisPreferredSpan;
    }

    protected void setLayoutMinorAxisPreferredSpan(float layoutMinorAxisPreferredSpan) {
        this.layoutMinorAxisPreferredSpan = layoutMinorAxisPreferredSpan;
    }

    public View getView() {
        return this;
    }

    public int getViewRawIndex() {
        return this.viewRawIndex;
    }

    public void setViewRawIndex(int viewRawIndex) {
        this.viewRawIndex = viewRawIndex;
    }

    public boolean isFlyweight() {
        return false;
    }

    public ViewLayoutState selectLayoutMajorAxis(int majorAxis) {
        if (majorAxis == 0) {
            this.setStatusBits(1);
        } else {
            this.clearStatusBits(1);
        }
        return this;
    }

    protected final ViewLayoutState.Parent getLayoutStateParent() {
        View parent = this.getView().getParent();
        return parent instanceof ViewLayoutState.Parent ? (ViewLayoutState.Parent)((Object)parent) : null;
    }

    public void updateLayout() {
        if (this.isLayoutValid()) {
            return;
        }
        ViewLayoutState.Parent lsParent = this.getLayoutStateParent();
        if (lsParent == null) {
            return;
        }
        if (this.isStatusBitsNonZero(4)) {
            this.clearStatusBits(4);
            int minorAxis = this.getMinorAxis();
            if (this.minorAxisUpdateLayout(minorAxis)) {
                lsParent.minorAxisPreferenceChanged(this);
            }
        }
        if (this.isStatusBitsNonZero(2)) {
            this.clearStatusBits(2);
            float oldSpan = this.getLayoutMajorAxisPreferredSpanFloat();
            float newSpan = this.getPreferredSpan(this.getMajorAxis());
            this.setLayoutMajorAxisPreferredSpan(newSpan);
            double majorAxisSpanDelta = newSpan - oldSpan;
            if (majorAxisSpanDelta != 0.0) {
                lsParent.majorAxisPreferenceChanged(this, majorAxisSpanDelta);
            }
        }
        if (this.isStatusBitsNonZero(8)) {
            float height;
            float width;
            this.clearStatusBits(8);
            float majorAxisSpan = (float)this.getLayoutMajorAxisPreferredSpan();
            float minorAxisSpan = lsParent.getMinorAxisSpan(this);
            if (this.isXMajorAxis()) {
                width = majorAxisSpan;
                height = minorAxisSpan;
            } else {
                width = minorAxisSpan;
                height = majorAxisSpan;
            }
            this.setSize(width, height);
        }
        this.updateLayout();
    }

    protected boolean minorAxisUpdateLayout(int minorAxis) {
        boolean minorAxisPreferenceChanged = false;
        float val = this.getPreferredSpan(minorAxis);
        if (val != this.getLayoutMinorAxisPreferredSpan()) {
            this.setLayoutMinorAxisPreferredSpan(val);
            minorAxisPreferenceChanged = true;
        }
        return minorAxisPreferenceChanged;
    }

    public void viewPreferenceChanged(boolean width, boolean height) {
        if (this.isXMajorAxis()) {
            if (width) {
                this.setStatusBits(2);
            }
            if (height) {
                this.setStatusBits(4);
            }
        } else {
            if (width) {
                this.setStatusBits(4);
            }
            if (height) {
                this.setStatusBits(2);
            }
        }
        this.setStatusBits(8);
    }

    public void markViewSizeInvalid() {
        this.setStatusBits(8);
    }

    public boolean isLayoutValid() {
        return !this.isStatusBitsNonZero(14);
    }

    protected final boolean isXMajorAxis() {
        return this.isStatusBitsNonZero(1);
    }

    protected final int getMajorAxis() {
        return this.isXMajorAxis() ? 0 : 1;
    }

    protected final int getMinorAxis() {
        return this.isXMajorAxis() ? 1 : 0;
    }

    protected final int getStatusBits(int bits) {
        return this.statusBits & bits;
    }

    protected final boolean isStatusBitsNonZero(int bits) {
        return this.getStatusBits(bits) != 0;
    }

    protected final void setStatusBits(int bits) {
        this.statusBits |= bits;
    }

    protected final void clearStatusBits(int bits) {
        this.statusBits &= ~bits;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class FragmentView
    extends DrawEngineLineView {
        private int offset;
        private int length;

        public FragmentView(Element elem, int offset, int length) {
            super(elem);
            this.offset = offset;
            this.length = length;
        }

        protected boolean isFragment() {
            return true;
        }

        public int getStartOffset() {
            return super.getStartOffset() + this.offset;
        }

        public int getEndOffset() {
            return this.getStartOffset() + this.length;
        }
    }

    final class ModelToViewDG
    extends DrawGraphics.SimpleDG {
        Rectangle r;

        ModelToViewDG() {
        }

        public boolean targetOffsetReached(int pos, char ch, int x, int charWidth, DrawContext ctx) {
            this.r.x = x;
            this.r.y = this.getY();
            this.r.width = charWidth;
            this.r.height = DrawEngineLineView.this.getEditorUI().getLineHeight();
            return false;
        }
    }

    final class ViewToModelDG
    extends DrawGraphics.SimpleDG {
        int targetX;
        int offset;
        int eolOffset;

        ViewToModelDG() {
        }

        void setTargetX(int targetX) {
            this.targetX = targetX;
        }

        void setEOLOffset(int eolOffset) {
            this.eolOffset = eolOffset;
            this.offset = eolOffset;
        }

        int getOffset() {
            return this.offset;
        }

        public boolean targetOffsetReached(int offset, char ch, int x, int charWidth, DrawContext ctx) {
            if (offset <= this.eolOffset) {
                if (x + charWidth < this.targetX) {
                    this.offset = offset;
                    return true;
                }
                this.offset = offset;
                if (this.targetX > x + charWidth / 2) {
                    Document doc = DrawEngineLineView.this.getDocument();
                    if (ch != '\n' && doc != null && offset < doc.getLength()) {
                        ++this.offset;
                    }
                }
                return false;
            }
            return false;
        }
    }
}

